/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.webservices.client.core.http;

import com.mathworks.webservices.client.core.MathWorksClientException;
import com.mathworks.webservices.client.core.http.HttpMethodName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpRequest {
    private HttpMethodBase method;
    private HttpMethodName httpMethodName;
    private String endpoint;
    private String resourcePath;
    private Map<String, String> headers = new HashMap<String, String>();
    private Map<String, String> parameters = new HashMap<String, String>();
    private String clientString;
    private String locale;

    public HttpRequest(HttpMethodName httpMethodName, String endpoint, String resourcePath) {
        this.httpMethodName = httpMethodName;
        this.endpoint = endpoint;
        this.resourcePath = resourcePath;
    }

    public String getSignature() {
        return this.headers.get("x-mw-request-signature");
    }

    public void setSignature(String signature) {
        if (null != signature && !"".equals(signature)) {
            this.headers.put("x-mw-request-signature", signature);
        }
    }

    public String getSalt() {
        return this.headers.get("x-mw-request-salt");
    }

    public void setSalt(String salt) {
        if (null != salt && !"".equals(salt)) {
            this.headers.put("x-mw-request-salt", salt);
        }
    }

    public String getLocale() {
        if (this.locale == null || "".equals(this.locale)) {
            this.locale = "en_US";
        }
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public String getClientString() {
        if (this.clientString == null) {
            this.clientString = "";
        }
        return this.clientString;
    }

    public void setClientString(String clientString) {
        this.clientString = clientString;
    }

    public HttpMethodName getHttpMethodName() {
        return this.httpMethodName;
    }

    public void setHttpMethodName(HttpMethodName httpMethodName) {
        this.httpMethodName = httpMethodName;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void addHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public void addParameter(String name, String value) {
        this.parameters.put(name, value);
    }

    public HttpRequest withParameter(String name, String value) {
        this.addParameter(name, value);
        return this;
    }

    public HttpMethodBase getRequest() {
        return this.getRequest(false);
    }

    public HttpMethodBase getRequest(boolean refresh) {
        if (!refresh && null != this.method) {
            return this.method;
        }
        String localEndpoint = this.endpoint;
        if (this.resourcePath != null && this.resourcePath.length() > 0) {
            if (!this.endpoint.endsWith("/") && !this.resourcePath.startsWith("/")) {
                localEndpoint = localEndpoint + "/";
            } else if (this.endpoint.endsWith("/") && this.resourcePath.startsWith("/")) {
                this.resourcePath = this.resourcePath.substring(1);
            }
            localEndpoint = localEndpoint + this.resourcePath;
        }
        ArrayList<NameValuePair> pairs = new ArrayList<NameValuePair>();
        pairs.add(new NameValuePair("locale", this.getLocale()));
        pairs.add(new NameValuePair("clientString", this.getClientString()));
        if (this.parameters.size() > 0) {
            for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
                pairs.add(new NameValuePair(entry.getKey(), entry.getValue()));
            }
        }
        NameValuePair[] nameValuePairs = pairs.toArray(new NameValuePair[pairs.size()]);
        if (this.httpMethodName == HttpMethodName.GET) {
            GetMethod getMethod = new GetMethod(localEndpoint);
            if (nameValuePairs != null) {
                getMethod.setQueryString(nameValuePairs);
            }
            this.method = getMethod;
        } else if (this.httpMethodName == HttpMethodName.POST) {
            PostMethod postMethod = new PostMethod(localEndpoint);
            if (nameValuePairs != null) {
                postMethod.addParameters(nameValuePairs);
            }
            this.method = postMethod;
        } else if (this.httpMethodName == HttpMethodName.PUT) {
            PutMethod putMethod = new PutMethod(localEndpoint);
            if (nameValuePairs != null) {
                putMethod.setQueryString(nameValuePairs);
            }
            this.method = putMethod;
        } else if (this.httpMethodName == HttpMethodName.DELETE) {
            DeleteMethod deleteMethod = new DeleteMethod(localEndpoint);
            if (nameValuePairs != null) {
                deleteMethod.setQueryString(nameValuePairs);
            }
            this.method = deleteMethod;
        } else if (this.httpMethodName == HttpMethodName.HEAD) {
            HeadMethod headMethod = new HeadMethod(localEndpoint);
            if (nameValuePairs != null) {
                headMethod.setQueryString(nameValuePairs);
            }
            this.method = headMethod;
        } else {
            throw new MathWorksClientException("You did not provide a support HTTP method name: " + (Object)((Object)this.httpMethodName));
        }
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            this.method.addRequestHeader(entry.getKey(), entry.getValue());
        }
        return this.method;
    }
}

