/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.webservices.client.core.http;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpHeader {
    private Map<String, String> headerAttrs;

    public HttpHeader() {
        this.headerAttrs = new HashMap<String, String>();
    }

    public HttpHeader(Map<String, String> headerAttrs) {
        this.headerAttrs = headerAttrs;
    }

    public String getAttr(String key) {
        return this.headerAttrs.get(key);
    }

    public void setAttr(String key, String value) {
        this.headerAttrs.put(key, value);
    }

    public Map<String, String> getAllAttrs() {
        return this.headerAttrs;
    }

    public String getRequestId() {
        try {
            String requestId = this.getAttr("x-mw-request-id");
            if (requestId == null) {
                requestId = "";
            }
            return requestId;
        }
        catch (Exception e) {
            return "";
        }
    }

    public void setRequestId(String requestId) {
        this.setAttr("x-mw-request-id", requestId);
    }

    public String getSignature() {
        try {
            return this.getAttr("x-mw-request-signature");
        }
        catch (Exception e) {
            return "";
        }
    }

    public void setSignature(String signature) {
        this.setAttr("x-mw-request-signature", signature);
    }

    public long getContentLength() {
        try {
            return Long.parseLong(this.getAttr("Content-Length"));
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public void setContentLength(int contentLength) {
        this.setAttr("Content-Length", Long.toString(contentLength));
    }

    public String getContentType() {
        try {
            return this.getAttr("Content-Type");
        }
        catch (Exception e) {
            return "";
        }
    }

    public void setContentType(String contentType) {
        this.setAttr("Content-Type", contentType);
    }
}

