/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.regexp;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.regexp.GlobData;
import org.mozilla.javascript.regexp.NativeRegExp;
import org.mozilla.javascript.regexp.RegExpImpl;
import org.mozilla.javascript.regexp.SubString;

class ReplaceData
extends GlobData {
    static SubString dollarStr = new SubString("$");
    Function lambda;
    char[] repstr;
    int dollar = -1;
    char[] charArray;
    int length;
    int index;
    int leftIndex;

    ReplaceData() {
    }

    void doGlobal(Context context, Scriptable scriptable, int n, RegExpImpl regExpImpl) throws JavaScriptException {
        char[] cArray;
        ReplaceData replaceData = this;
        SubString subString = regExpImpl.leftContext;
        char[] cArray2 = subString.charArray;
        int n2 = replaceData.leftIndex;
        int n3 = regExpImpl.lastMatch.index - n2;
        replaceData.leftIndex = regExpImpl.lastMatch.index + regExpImpl.lastMatch.length;
        int n4 = this.findReplen(context, regExpImpl);
        int n5 = n3 + n4;
        if (replaceData.charArray != null) {
            cArray = new char[replaceData.length + n5];
            System.arraycopy(replaceData.charArray, 0, cArray, 0, replaceData.length);
        } else {
            cArray = new char[n5];
        }
        replaceData.charArray = cArray;
        replaceData.length += n5;
        int n6 = replaceData.index;
        replaceData.index += n5;
        System.arraycopy(cArray2, n2, cArray, n6, n3);
        this.doReplace(context, regExpImpl, cArray, n6 += n3);
    }

    static SubString interpretDollar(Context context, RegExpImpl regExpImpl, char[] cArray, int n, int n2, int[] nArray) {
        if (cArray[n] != '$') {
            throw new RuntimeException();
        }
        if (context.getLanguageVersion() != 0 && context.getLanguageVersion() <= 140 && n > n2 && cArray[n - 1] == '\\') {
            return null;
        }
        if (n + 1 >= cArray.length) {
            return null;
        }
        char c = cArray[n + 1];
        if (NativeRegExp.isDigit(c)) {
            int n3;
            int n4;
            int n5;
            if (context.getLanguageVersion() != 0 && context.getLanguageVersion() <= 140) {
                if (c == '0') {
                    return null;
                }
                n5 = 0;
                char[] cArray2 = cArray;
                n4 = n;
                while (++n4 < cArray2.length && NativeRegExp.isDigit(c = cArray2[n4])) {
                    n3 = 10 * n5 + NativeRegExp.unDigit(c);
                    if (n3 >= n5) {
                        n5 = n3;
                        continue;
                    }
                    break;
                }
            } else {
                int n6 = regExpImpl.parens.size();
                n5 = NativeRegExp.unDigit(c);
                if (n5 > n6) {
                    return null;
                }
                n4 = n + 2;
                if (n + 2 < cArray.length && NativeRegExp.isDigit(c = cArray[n + 2]) && (n3 = 10 * n5 + NativeRegExp.unDigit(c)) <= n6) {
                    ++n4;
                    n5 = n3;
                }
                if (n5 == 0) {
                    return null;
                }
            }
            nArray[0] = n4 - n;
            return regExpImpl.getParenSubString(--n5);
        }
        nArray[0] = 2;
        switch (c) {
            case '$': {
                return dollarStr;
            }
            case '&': {
                return regExpImpl.lastMatch;
            }
            case '+': {
                return regExpImpl.lastParen;
            }
            case '`': {
                if (context.getLanguageVersion() == 120) {
                    regExpImpl.leftContext.index = 0;
                    regExpImpl.leftContext.length = regExpImpl.lastMatch.index;
                }
                return regExpImpl.leftContext;
            }
            case '\'': {
                return regExpImpl.rightContext;
            }
        }
        return null;
    }

    int findReplen(Context context, RegExpImpl regExpImpl) throws JavaScriptException {
        if (this.lambda != null) {
            Object object;
            ObjArray objArray = regExpImpl.parens;
            int n = objArray.size();
            Object[] objectArray = new Object[n + 3];
            objectArray[0] = regExpImpl.lastMatch.toString();
            int n2 = 0;
            while (n2 < n) {
                object = (SubString)objArray.get(n2);
                objectArray[n2 + 1] = ((SubString)object).toString();
                ++n2;
            }
            objectArray[n + 1] = new Integer(regExpImpl.leftContext.length);
            objectArray[n + 2] = this.str;
            object = this.lambda.getParentScope();
            Object object2 = this.lambda.call(context, (Scriptable)object, (Scriptable)object, objectArray);
            this.repstr = ScriptRuntime.toString(object2).toCharArray();
            return this.repstr.length;
        }
        int n = this.repstr.length;
        if (this.dollar == -1) {
            return n;
        }
        int n3 = 0;
        int n4 = this.dollar;
        while (n4 < this.repstr.length) {
            char c = this.repstr[n4];
            if (c != '$') {
                ++n4;
                continue;
            }
            int[] nArray = new int[]{0};
            SubString subString = ReplaceData.interpretDollar(context, regExpImpl, this.repstr, n4, n3, nArray);
            if (subString != null) {
                n += subString.length - nArray[0];
                n4 += nArray[0];
                continue;
            }
            ++n4;
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    void doReplace(Context var1_1, RegExpImpl var2_2, char[] var3_3, int var4_4) {
        block6: {
            var5_5 = 0;
            var6_6 = this.repstr;
            var7_7 = this.dollar;
            var8_8 = var5_5;
            if (var7_7 == -1) break block6;
            block0: while (true) {
                var9_9 = var7_7 - var5_5;
                System.arraycopy(this.repstr, var5_5, var3_3, var4_4, var9_9);
                var4_4 += var9_9;
                var5_5 = var7_7;
                var10_10 = new int[]{0};
                var11_11 = ReplaceData.interpretDollar(var1_1, var2_2, var6_6, var7_7, var8_8, var10_10);
                if (var11_11 != null) {
                    var9_9 = var11_11.length;
                    if (var9_9 > 0) {
                        System.arraycopy(var11_11.charArray, var11_11.index, var3_3, var4_4, var9_9);
                    }
                    var4_4 += var9_9;
                    var5_5 += var10_10[0];
                    var7_7 += var10_10[0];
                } else {
                    ++var7_7;
                }
                if (var7_7 < this.repstr.length) ** GOTO lbl-1000
                break;
                while (++var7_7 < this.repstr.length) lbl-1000:
                // 2 sources

                {
                    if (this.repstr[var7_7] != '$') continue;
                    continue block0;
                }
                break;
            }
        }
        if (this.repstr.length > var5_5) {
            System.arraycopy(this.repstr, var5_5, var3_3, var4_4, this.repstr.length - var5_5);
        }
    }
}

