/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.mozilla.javascript.Context;

class UintMap
implements Serializable {
    static final long serialVersionUID = -6916326879143724506L;
    private transient int[] OEAB;
    private transient Object[] arraycopy;
    private int power;
    private int keyCount;
    private transient int codeBug;
    private transient int defaultReadObject;

    public UintMap() {
        this(4);
    }

    public UintMap(int n) {
        if (n < 0) {
            Context.codeBug();
        }
        int n2 = n * 4 / 3;
        int n3 = 2;
        while (1 << n3 < n2) {
            ++n3;
        }
        this.power = n3;
    }

    public boolean isEmpty() {
        return this.keyCount == 0;
    }

    public int size() {
        return this.keyCount;
    }

    public boolean has(int n) {
        if (n < 0) {
            Context.codeBug();
        }
        return 0 <= this.arraycopy(n);
    }

    public Object getObject(int n) {
        int n2;
        if (n < 0) {
            Context.codeBug();
        }
        if (this.arraycopy != null && 0 <= (n2 = this.arraycopy(n))) {
            return this.arraycopy[n2];
        }
        return null;
    }

    public int getInt(int n, int n2) {
        int n3;
        if (n < 0) {
            Context.codeBug();
        }
        if (0 <= (n3 = this.arraycopy(n))) {
            if (this.defaultReadObject != 0) {
                return this.OEAB[this.defaultReadObject + n3];
            }
            return 0;
        }
        return n2;
    }

    public int getExistingInt(int n) {
        int n2;
        if (n < 0) {
            Context.codeBug();
        }
        if (0 <= (n2 = this.arraycopy(n))) {
            if (this.defaultReadObject != 0) {
                return this.OEAB[this.defaultReadObject + n2];
            }
            return 0;
        }
        Context.codeBug();
        return 0;
    }

    public void put(int n, Object object) {
        if (n < 0) {
            Context.codeBug();
        }
        int n2 = this.defaultWriteObject(n, false);
        if (this.arraycopy == null) {
            this.arraycopy = new Object[1 << this.power];
        }
        this.arraycopy[n2] = object;
    }

    public void put(int n, int n2) {
        if (n < 0) {
            Context.codeBug();
        }
        int n3 = this.defaultWriteObject(n, true);
        if (this.defaultReadObject == 0) {
            int n4 = 1 << this.power;
            if (this.OEAB.length != n4 * 2) {
                int[] nArray = new int[n4 * 2];
                System.arraycopy(this.OEAB, 0, nArray, 0, n4);
                this.OEAB = nArray;
            }
            this.defaultReadObject = n4;
        }
        this.OEAB[this.defaultReadObject + n3] = n2;
    }

    public void remove(int n) {
        int n2;
        if (n < 0) {
            Context.codeBug();
        }
        if (0 <= (n2 = this.arraycopy(n))) {
            this.OEAB[n2] = -2;
            --this.keyCount;
            if (this.arraycopy != null) {
                this.arraycopy[n2] = null;
            }
            if (this.defaultReadObject != 0) {
                this.OEAB[this.defaultReadObject + n2] = 0;
            }
        }
    }

    public void clear() {
        int n = 1 << this.power;
        if (this.OEAB != null) {
            int n2 = 0;
            while (n2 != n) {
                this.OEAB[n2] = -1;
                ++n2;
            }
            if (this.arraycopy != null) {
                int n3 = 0;
                while (n3 != n) {
                    this.arraycopy[n3] = null;
                    ++n3;
                }
            }
        }
        this.defaultReadObject = 0;
        this.keyCount = 0;
        this.codeBug = 0;
    }

    public int[] getKeys() {
        int[] nArray = this.OEAB;
        int n = this.keyCount;
        int[] nArray2 = new int[n];
        int n2 = 0;
        while (n != 0) {
            int n3 = nArray[n2];
            if (n3 != -1 && n3 != -2) {
                nArray2[--n] = n3;
            }
            ++n2;
        }
        return nArray2;
    }

    private static int OEAB(int n, int n2, int n3) {
        int n4 = 32 - 2 * n3;
        if (n4 >= 0) {
            return n >>> n4 & n2 | 1;
        }
        return n & n2 >>> -n4 | 1;
    }

    private int arraycopy(int n) {
        int[] nArray = this.OEAB;
        if (nArray != null) {
            int n2 = n * -1640531527;
            int n3 = n2 >>> 32 - this.power;
            int n4 = nArray[n3];
            if (n4 == n) {
                return n3;
            }
            if (n4 != -1) {
                int n5 = (1 << this.power) - 1;
                int n6 = UintMap.OEAB(n2, n5, this.power);
                boolean bl = false;
                do {
                    if ((n4 = nArray[n3 = n3 + n6 & n5]) != n) continue;
                    return n3;
                } while (n4 != -1);
            }
        }
        return -1;
    }

    private int codeBug(int n) {
        int[] nArray = this.OEAB;
        int n2 = n * -1640531527;
        int n3 = n2 >>> 32 - this.power;
        if (nArray[n3] != -1) {
            int n4 = (1 << this.power) - 1;
            int n5 = UintMap.OEAB(n2, n4, this.power);
            int n6 = n3;
            while (nArray[n3 = n3 + n5 & n4] != -1) {
            }
        }
        nArray[n3] = n;
        ++this.codeBug;
        ++this.keyCount;
        return n3;
    }

    private void defaultReadObject(boolean bl) {
        if (this.OEAB != null && this.keyCount * 2 >= this.codeBug) {
            ++this.power;
        }
        int n = 1 << this.power;
        int[] nArray = this.OEAB;
        int n2 = this.defaultReadObject;
        if (n2 == 0 && !bl) {
            this.OEAB = new int[n];
        } else {
            this.defaultReadObject = n;
            this.OEAB = new int[n * 2];
        }
        int n3 = 0;
        while (n3 != n) {
            this.OEAB[n3] = -1;
            ++n3;
        }
        Object[] objectArray = this.arraycopy;
        if (objectArray != null) {
            this.arraycopy = new Object[n];
        }
        int n4 = this.keyCount;
        this.codeBug = 0;
        if (n4 != 0) {
            this.keyCount = 0;
            int n5 = 0;
            int n6 = n4;
            while (n6 != 0) {
                int n7 = nArray[n5];
                if (n7 != -1 && n7 != -2) {
                    int n8 = this.codeBug(n7);
                    if (objectArray != null) {
                        this.arraycopy[n8] = objectArray[n5];
                    }
                    if (n2 != 0) {
                        this.OEAB[this.defaultReadObject + n8] = nArray[n2 + n5];
                    }
                    --n6;
                }
                ++n5;
            }
        }
    }

    private int defaultWriteObject(int n, boolean bl) {
        int n2 = -1;
        int n3 = -1;
        int[] nArray = this.OEAB;
        if (nArray != null) {
            int n4 = n * -1640531527;
            n2 = n4 >>> 32 - this.power;
            int n5 = nArray[n2];
            if (n5 == n) {
                return n2;
            }
            if (n5 != -1) {
                if (n5 == -2) {
                    n3 = n2;
                }
                int n6 = (1 << this.power) - 1;
                int n7 = UintMap.OEAB(n4, n6, this.power);
                boolean bl2 = false;
                do {
                    if ((n5 = nArray[n2 = n2 + n7 & n6]) == n) {
                        return n2;
                    }
                    if (n5 != -2 || n3 >= 0) continue;
                    n3 = n2;
                } while (n5 != -1);
            }
        }
        if (n3 >= 0) {
            n2 = n3;
        } else {
            if (nArray == null || this.codeBug * 4 >= (1 << this.power) * 3) {
                this.defaultReadObject(bl);
                nArray = this.OEAB;
                return this.codeBug(n);
            }
            ++this.codeBug;
        }
        nArray[n2] = n;
        ++this.keyCount;
        return n2;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        int n = this.keyCount;
        if (n != 0) {
            boolean bl = this.defaultReadObject != 0;
            boolean bl2 = this.arraycopy != null;
            objectOutputStream.writeBoolean(bl);
            objectOutputStream.writeBoolean(bl2);
            int n2 = 0;
            while (n != 0) {
                int n3 = this.OEAB[n2];
                if (n3 != -1 && n3 != -2) {
                    --n;
                    objectOutputStream.writeInt(n3);
                    if (bl) {
                        objectOutputStream.writeInt(this.OEAB[this.defaultReadObject + n2]);
                    }
                    if (bl2) {
                        objectOutputStream.writeObject(this.arraycopy[n2]);
                    }
                }
                ++n2;
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = this.keyCount;
        if (n != 0) {
            this.keyCount = 0;
            boolean bl = objectInputStream.readBoolean();
            boolean bl2 = objectInputStream.readBoolean();
            int n2 = 1 << this.power;
            if (bl) {
                this.OEAB = new int[2 * n2];
                this.defaultReadObject = n2;
            } else {
                this.OEAB = new int[n2];
            }
            int n3 = 0;
            while (n3 != n2) {
                this.OEAB[n3] = -1;
                ++n3;
            }
            if (bl2) {
                this.arraycopy = new Object[n2];
            }
            int n4 = 0;
            while (n4 != n) {
                int n5 = objectInputStream.readInt();
                int n6 = this.codeBug(n5);
                if (bl) {
                    int n7;
                    this.OEAB[this.defaultReadObject + n6] = n7 = objectInputStream.readInt();
                }
                if (bl2) {
                    this.arraycopy[n6] = objectInputStream.readObject();
                }
                ++n4;
            }
        }
    }
}

