/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.IdFunction;
import org.mozilla.javascript.IdScriptable;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.PropertyException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public class NativeObject
extends IdScriptable {
    private boolean prototypeFlag;

    public static void init(Context context, Scriptable scriptable, boolean bl) {
        NativeObject nativeObject = new NativeObject();
        nativeObject.prototypeFlag = true;
        nativeObject.addAsPrototype(7, context, scriptable, bl);
    }

    public String getClassName() {
        return "Object";
    }

    public int methodArity(int n) {
        if (this.prototypeFlag) {
            switch (n) {
                case 1: {
                    return 1;
                }
                case 2: {
                    return 0;
                }
                case 3: {
                    return 0;
                }
                case 4: {
                    return 0;
                }
                case 5: {
                    return 1;
                }
                case 6: {
                    return 1;
                }
                case 7: {
                    return 1;
                }
            }
        }
        return super.methodArity(n);
    }

    public Object execMethod(int n, IdFunction idFunction, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        if (this.prototypeFlag) {
            switch (n) {
                case 1: {
                    return NativeObject.jsConstructor(context, objectArray, idFunction, scriptable2 == null);
                }
                case 2: {
                    return NativeObject.FALSE(context, scriptable2);
                }
                case 3: {
                    return NativeObject.OEAB(context, scriptable2);
                }
                case 4: {
                    return NativeObject.TRUE(scriptable2);
                }
                case 5: {
                    return NativeObject.addAsPrototype(scriptable2, objectArray);
                }
                case 6: {
                    return NativeObject.append(context, scriptable2, objectArray);
                }
                case 7: {
                    return NativeObject.charAt(context, scriptable2, objectArray);
                }
            }
        }
        return super.execMethod(n, idFunction, context, scriptable, scriptable2, objectArray);
    }

    private static Object jsConstructor(Context context, Object[] objectArray, Function function, boolean bl) throws JavaScriptException {
        if (!bl) {
            return function.construct(context, function.getParentScope(), objectArray);
        }
        if (objectArray.length == 0 || objectArray[0] == null || objectArray[0] == Undefined.instance) {
            return new NativeObject();
        }
        return ScriptRuntime.toObject(context, function.getParentScope(), objectArray[0]);
    }

    public String toString() {
        Context context = Context.getCurrentContext();
        if (context != null) {
            return NativeObject.FALSE(context, this);
        }
        return "[object " + this.getClassName() + "]";
    }

    private static String FALSE(Context context, Scriptable scriptable) {
        if (context.hasFeature(4)) {
            return NativeObject.toSource(context, scriptable);
        }
        return "[object " + scriptable.getClassName() + "]";
    }

    private static String OEAB(Context context, Scriptable scriptable) {
        return NativeObject.FALSE(context, scriptable);
    }

    private static String toSource(Context context, Scriptable scriptable) {
        boolean bl;
        boolean bl2;
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append('{');
        if (context.iterating == null) {
            bl2 = true;
            bl = false;
            context.iterating = new ObjToIntMap(31);
        } else {
            bl2 = false;
            bl = context.iterating.has(scriptable);
        }
        try {
            if (!bl) {
                context.iterating.put(scriptable, 0);
                Object[] objectArray = scriptable.getIds();
                int n = 0;
                while (n < objectArray.length) {
                    Object object;
                    if (n > 0) {
                        stringBuffer.append(", ");
                    }
                    Object object2 = objectArray[n];
                    stringBuffer.append(object2);
                    stringBuffer.append(':');
                    Object object3 = object = object2 instanceof String ? scriptable.get((String)object2, scriptable) : scriptable.get((Integer)object2, scriptable);
                    if (object instanceof String) {
                        stringBuffer.append('\"');
                        stringBuffer.append(ScriptRuntime.escapeString((String)object));
                        stringBuffer.append('\"');
                    } else {
                        stringBuffer.append(ScriptRuntime.toString(object));
                    }
                    ++n;
                }
            }
            Object var10_9 = null;
            if (bl2) {
                context.iterating = null;
            }
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (bl2) {
                context.iterating = null;
            }
            throw throwable;
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    private static Object TRUE(Scriptable scriptable) {
        return scriptable;
    }

    private static Object addAsPrototype(Scriptable scriptable, Object[] objectArray) {
        if (objectArray.length != 0 && scriptable.has(ScriptRuntime.toString(objectArray[0]), scriptable)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private static Object append(Context context, Scriptable scriptable, Object[] objectArray) {
        try {
            int n;
            String string;
            if (objectArray.length != 0 && scriptable.has(string = ScriptRuntime.toString(objectArray[0]), scriptable) && ((n = ((ScriptableObject)scriptable).getAttributes(string, scriptable)) & 2) == 0) {
                return Boolean.TRUE;
            }
        }
        catch (PropertyException propertyException) {
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return Boolean.FALSE;
    }

    private static Object charAt(Context context, Scriptable scriptable, Object[] objectArray) {
        if (objectArray.length != 0 && objectArray[0] instanceof Scriptable) {
            Scriptable scriptable2 = (Scriptable)objectArray[0];
            do {
                if ((scriptable2 = scriptable2.getPrototype()) != scriptable) continue;
                return Boolean.TRUE;
            } while (scriptable2 != null);
        }
        return Boolean.FALSE;
    }

    protected String getIdName(int n) {
        if (this.prototypeFlag) {
            switch (n) {
                case 1: {
                    return "constructor";
                }
                case 2: {
                    return "toString";
                }
                case 3: {
                    return "toLocaleString";
                }
                case 4: {
                    return "valueOf";
                }
                case 5: {
                    return "hasOwnProperty";
                }
                case 6: {
                    return "propertyIsEnumerable";
                }
                case 7: {
                    return "isPrototypeOf";
                }
            }
        }
        return null;
    }

    protected int mapNameToId(String string) {
        if (!this.prototypeFlag) {
            return 0;
        }
        int n = 0;
        String string2 = null;
        switch (string.length()) {
            case 7: {
                string2 = "valueOf";
                n = 4;
                break;
            }
            case 8: {
                string2 = "toString";
                n = 2;
                break;
            }
            case 11: {
                string2 = "constructor";
                n = 1;
                break;
            }
            case 13: {
                string2 = "isPrototypeOf";
                n = 7;
                break;
            }
            case 14: {
                char c = string.charAt(0);
                if (c == 'h') {
                    string2 = "hasOwnProperty";
                    n = 5;
                    break;
                }
                if (c != 't') break;
                string2 = "toLocaleString";
                n = 3;
                break;
            }
            case 20: {
                string2 = "propertyIsEnumerable";
                n = 6;
            }
        }
        if (string2 != null && string2 != string && !string2.equals(string)) {
            n = 0;
        }
        return n;
    }
}

