/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunction;
import org.mozilla.javascript.IdScriptable;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;

final class NativeBoolean
extends IdScriptable {
    private boolean booleanValue;
    private boolean prototypeFlag;

    static void init(Context context, Scriptable scriptable, boolean bl) {
        NativeBoolean nativeBoolean = new NativeBoolean(false);
        nativeBoolean.prototypeFlag = true;
        nativeBoolean.addAsPrototype(3, context, scriptable, bl);
    }

    private NativeBoolean(boolean bl) {
        this.booleanValue = bl;
    }

    public String getClassName() {
        return "Boolean";
    }

    public Object getDefaultValue(Class clazz) {
        if (clazz == ScriptRuntime.BooleanClass) {
            return this.wrap_boolean(this.booleanValue);
        }
        return super.getDefaultValue(clazz);
    }

    public int methodArity(int n) {
        if (this.prototypeFlag) {
            if (n == 1) {
                return 1;
            }
            if (n == 2) {
                return 0;
            }
            if (n == 3) {
                return 0;
            }
        }
        return super.methodArity(n);
    }

    public Object execMethod(int n, IdFunction idFunction, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        if (this.prototypeFlag) {
            if (n == 1) {
                boolean bl = ScriptRuntime.toBoolean(objectArray, 0);
                if (scriptable2 == null) {
                    return new NativeBoolean(bl);
                }
                return this.wrap_boolean(bl);
            }
            if (n == 2) {
                return this.BooleanClass((Scriptable)scriptable2, (IdFunction)idFunction).booleanValue ? "true" : "false";
            }
            if (n == 3) {
                return this.wrap_boolean(this.BooleanClass((Scriptable)scriptable2, (IdFunction)idFunction).booleanValue);
            }
        }
        return super.execMethod(n, idFunction, context, scriptable, scriptable2, objectArray);
    }

    private NativeBoolean BooleanClass(Scriptable scriptable, IdFunction idFunction) {
        while (!(scriptable instanceof NativeBoolean)) {
            scriptable = this.nextInstanceCheck(scriptable, idFunction, true);
        }
        return (NativeBoolean)scriptable;
    }

    protected String getIdName(int n) {
        if (this.prototypeFlag) {
            if (n == 1) {
                return "constructor";
            }
            if (n == 2) {
                return "toString";
            }
            if (n == 3) {
                return "valueOf";
            }
        }
        return null;
    }

    protected int mapNameToId(String string) {
        if (!this.prototypeFlag) {
            return 0;
        }
        int n = 0;
        String string2 = null;
        int n2 = string.length();
        if (n2 == 7) {
            string2 = "valueOf";
            n = 3;
        } else if (n2 == 8) {
            string2 = "toString";
            n = 2;
        } else if (n2 == 11) {
            string2 = "constructor";
            n = 1;
        }
        if (string2 != null && string2 != string && !string2.equals(string)) {
            n = 0;
        }
        return n;
    }
}

