/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.Reader;
import org.mozilla.javascript.Context;

final class LineBuffer {
    static final int BUFLEN = 256;
    private Reader OEAB;
    private char[] append = null;
    private char[] arraycopy = null;
    private int codeBug = 0;
    private int getType = 0;
    private int read;
    private int toString;
    private int I = 0;
    private int Z = 0;
    private int C = 0;
    private boolean B = false;
    private boolean D = false;

    LineBuffer(Reader reader, int n) {
        this.OEAB = reader;
        this.toString = n;
    }

    int read() throws IOException {
        char c;
        do {
            if (this.getType == this.codeBug && !this.append()) {
                return -1;
            }
            c = this.arraycopy[this.codeBug];
            ++this.codeBug;
            if ((c & 0xDFD0) != 0) continue;
            switch (c) {
                case '\r': {
                    if (this.codeBug != this.getType) {
                        if (this.arraycopy[this.codeBug] == '\n') {
                            ++this.codeBug;
                        }
                    } else {
                        this.B = true;
                    }
                }
                case '\n': 
                case '\u2028': 
                case '\u2029': {
                    this.C = this.I;
                    this.I = this.codeBug;
                    ++this.toString;
                    return 10;
                }
            }
        } while (c >= '\u0080' && LineBuffer.arraycopy(c));
        return c;
    }

    void unread() {
        if (this.codeBug == 0 && !this.D) {
            Context.codeBug();
        }
        if (this.codeBug == 0) {
            return;
        }
        --this.codeBug;
        char c = this.arraycopy[this.codeBug];
        if ((c & 0xDFD0) == 0 && LineBuffer.codeBug(c)) {
            this.I = this.C;
            --this.toString;
        }
    }

    private void OEAB() {
        if (!LineBuffer.arraycopy(this.arraycopy[this.codeBug])) {
            Context.codeBug();
        }
        if (this.codeBug != 0) {
            char c = this.arraycopy[this.codeBug];
            this.arraycopy[this.codeBug] = this.arraycopy[this.codeBug - 1];
            this.arraycopy[this.codeBug - 1] = c;
        } else if (this.read != 0) {
            char c = this.arraycopy[this.codeBug];
            this.arraycopy[this.codeBug] = this.append[this.read - 1];
            this.append[this.read - 1] = c;
        }
        ++this.codeBug;
    }

    int peek() throws IOException {
        while (this.getType != this.codeBug || this.append()) {
            char c = this.arraycopy[this.codeBug];
            if ((c & 0xDFD0) == 0 && LineBuffer.codeBug(c)) {
                return 10;
            }
            if (c < '\u0080' || !LineBuffer.arraycopy(c)) {
                return c;
            }
            this.OEAB();
        }
        return -1;
    }

    boolean match(int n) throws IOException {
        if ((n & 0xDFD0) == 0 && LineBuffer.codeBug(n)) {
            Context.codeBug();
        }
        if (n >= 128 && LineBuffer.arraycopy(n)) {
            Context.codeBug();
        }
        while (this.getType != this.codeBug || this.append()) {
            char c = this.arraycopy[this.codeBug];
            if (n == c) {
                ++this.codeBug;
                return true;
            }
            if (c < '\u0080' || !LineBuffer.arraycopy(c)) {
                return false;
            }
            this.OEAB();
        }
        return false;
    }

    String getLine() {
        int n;
        int n2 = this.codeBug;
        while (true) {
            if (n2 == this.getType) {
                if (this.getType == this.arraycopy.length) {
                    char[] cArray = new char[this.arraycopy.length * 2];
                    System.arraycopy(this.arraycopy, 0, cArray, 0, this.getType);
                    this.arraycopy = cArray;
                }
                n = 0;
                try {
                    n = this.OEAB.read(this.arraycopy, this.getType, this.arraycopy.length - this.getType);
                }
                catch (IOException iOException) {
                    break;
                }
                if (n < 0) break;
                this.getType += n;
            }
            if (((n = this.arraycopy[n2]) & 0xDFD0) == 0 && LineBuffer.codeBug(n)) break;
            ++n2;
        }
        n = this.I;
        if (this.I < 0) {
            StringBuffer stringBuffer = new StringBuffer(this.read - this.Z + n2);
            stringBuffer.append(this.append, this.Z, this.read - this.Z);
            stringBuffer.append(this.arraycopy, 0, n2);
            return stringBuffer.toString();
        }
        return new String(this.arraycopy, this.I, n2 - this.I);
    }

    int getOffset() {
        if (this.I < 0) {
            return this.codeBug + (this.read - this.Z);
        }
        return this.codeBug - this.I;
    }

    private boolean append() throws IOException {
        if (this.getType != this.codeBug) {
            Context.codeBug();
        }
        char[] cArray = this.arraycopy;
        this.arraycopy = this.append;
        this.append = cArray;
        if (this.arraycopy == null) {
            this.arraycopy = new char[256];
        }
        this.Z = this.I >= 0 ? this.I : 0;
        this.read = this.getType;
        this.I = this.append == null ? 0 : -1;
        this.C = this.I;
        this.codeBug = 0;
        this.getType = this.OEAB.read(this.arraycopy, 0, this.arraycopy.length);
        if (this.getType < 0) {
            this.getType = 0;
            this.D = true;
            return false;
        }
        if (this.B) {
            if (this.arraycopy[0] == '\n') {
                ++this.codeBug;
                if (this.getType == 1) {
                    return this.append();
                }
            }
            this.I = this.codeBug;
            this.B = false;
        }
        return true;
    }

    int getLineno() {
        return this.toString;
    }

    boolean eof() {
        return this.D;
    }

    private static boolean arraycopy(int n) {
        return Character.getType((char)n) == 16;
    }

    private static boolean codeBug(int n) {
        return n == 13 || n == 10 || n == 8232 || n == 8233;
    }
}

