/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.plaf;

import com.google.common.collect.ImmutableList;
import com.mathworks.mwswing.FontUtils;
import com.mathworks.toolstrip.components.ButtonOrientation;
import com.mathworks.toolstrip.components.LayoutMode;
import com.mathworks.toolstrip.components.SplitButtonModel;
import com.mathworks.toolstrip.components.TSButton;
import com.mathworks.toolstrip.components.TSComponent;
import com.mathworks.toolstrip.components.TSSplitButton;
import com.mathworks.toolstrip.components.TSUtil;
import com.mathworks.toolstrip.plaf.LAFUtil;
import com.mathworks.toolstrip.plaf.ToolstripButtonUI;
import com.mathworks.util.StringUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.ChangeEvent;

public class SplitButtonUI
extends ToolstripButtonUI {
    private static final SplitButtonUI sSplitButtonUI = new SplitButtonUI();

    public static SplitButtonUI createUI(JComponent jComponent) {
        return sSplitButtonUI;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        TSSplitButton tSSplitButton = (TSSplitButton)((Object)jComponent);
        SplitButtonModel splitButtonModel = tSSplitButton.getModel();
        Shape shape = graphics2D.getClip();
        TSUtil.setDefaultRenderingHints(graphics2D);
        Layout layout = this.layout(tSSplitButton);
        if (splitButtonModel.isPressed()) {
            this.paintPressed(graphics2D, layout);
        } else if (splitButtonModel.isDropDownPressed() || splitButtonModel.isSelected()) {
            this.paintDropDownPressed(graphics2D, layout);
        } else if (splitButtonModel.isDropDownArmed()) {
            this.paintDropDownArmed(graphics2D, layout);
        } else if (splitButtonModel.isArmed() || tSSplitButton.isFocusPainted() && tSSplitButton.hasFocus()) {
            this.paintArmed(graphics2D, layout);
        } else {
            this.paintUnArmed(graphics2D, layout);
        }
        if (shape != null) {
            graphics2D.setClip(shape);
        }
        this.paintContent(graphics2D, layout);
    }

    protected void paintPressed(Graphics2D graphics2D, Layout layout) {
        Rectangle rectangle = layout.workArea;
        RectangularShape rectangularShape = LAFUtil.getButtonRect(rectangle);
        Shape shape = graphics2D.getClip();
        if (layout.vertical) {
            graphics2D.clip(new Rectangle(rectangle.x, rectangle.y, rectangle.width, layout.sepOrg.y - rectangle.y));
        } else {
            LAFUtil.drawbuttonHorizontalRight(graphics2D, new Rectangle(layout.sepOrg.x, layout.sepOrg.y, rectangle.width - layout.sepOrg.x, rectangle.height), this.fTheme);
            graphics2D.clip(new Rectangle(rectangle.x, rectangle.y, layout.sepOrg.x - rectangle.x, rectangle.height));
        }
        LAFUtil.drawRoundButtonPressedRect(graphics2D, rectangularShape, this.fTheme);
        graphics2D.setClip(shape);
    }

    protected void paintDropDownPressed(Graphics2D graphics2D, Layout layout) {
        RectangularShape rectangularShape = this.paintDropDownPressedUpper(graphics2D, layout);
        Rectangle rectangle = layout.workArea;
        Shape shape = graphics2D.getClip();
        int n = (int)rectangularShape.getX();
        int n2 = (int)rectangularShape.getY();
        int n3 = (int)rectangularShape.getWidth();
        int n4 = (int)rectangularShape.getHeight();
        if (layout.vertical) {
            Area area = new Area(rectangularShape);
            Area area2 = new Area(new Rectangle(rectangle.x, rectangle.y, rectangle.width, layout.sepOrg.y - rectangle.y + 1));
            area.subtract(area2);
            graphics2D.clip(area);
            RoundRectangle2D.Float float_ = new RoundRectangle2D.Float(n + 1, n2, n3 - 2, n4 - 1, 8.0f, 8.0f);
            Area area3 = new Area(float_);
            area3.subtract(area2);
            RoundRectangle2D.Float float_2 = new RoundRectangle2D.Float(n + 2, n2, n3 - 4, n4 - 1, 8.0f, 8.0f);
            Area area4 = new Area(float_2);
            Area area5 = new Area(new Rectangle(rectangle.x, rectangle.y, rectangle.width, layout.sepOrg.y - rectangle.y + 2));
            area4.subtract(area5);
            LAFUtil.drawButtonPressedRect(graphics2D, area, area3, area4, this.fTheme);
        } else {
            int n5 = layout.sepOrg.x;
            Area area = new Area(rectangularShape);
            Area area6 = new Area(new Rectangle(rectangle.x, rectangle.y, n5 - rectangle.x + 1, rectangle.height));
            area.subtract(area6);
            graphics2D.clip(area);
            RoundRectangle2D.Float float_ = new RoundRectangle2D.Float(n, n2 + 1, n3 - 1, n4 - 2, 8.0f, 8.0f);
            Area area7 = new Area(float_);
            area7.subtract(area6);
            RoundRectangle2D.Float float_3 = new RoundRectangle2D.Float(n, n2 + 2, n3 - 1, n4 - 4, 8.0f, 8.0f);
            Area area8 = new Area(float_3);
            Area area9 = new Area(new Rectangle(rectangle.x, rectangle.y, n5 - rectangle.x + 2, rectangle.height));
            area8.subtract(area9);
            LAFUtil.drawButtonPressedRect(graphics2D, area, area7, area8, this.fTheme);
        }
        graphics2D.setClip(shape);
    }

    protected RectangularShape paintDropDownArmed(Graphics2D graphics2D, Layout layout) {
        if (layout.vertical) {
            return this.paintArmed(graphics2D, layout, new Rectangle(layout.workArea.x, layout.sepOrg.y, layout.workArea.width, layout.workArea.y + layout.workArea.height - layout.sepOrg.y));
        }
        return this.paintArmed(graphics2D, layout, new Rectangle(layout.sepOrg.x, layout.sepOrg.y, layout.workArea.width, layout.workArea.y + layout.workArea.height - layout.sepOrg.y));
    }

    protected RectangularShape paintDropDownPressedUpper(Graphics2D graphics2D, Layout layout) {
        if (layout.vertical) {
            return this.paintArmedDropDown(graphics2D, layout, new Rectangle(layout.workArea.x, layout.sepOrg.y, layout.workArea.width, layout.workArea.y + layout.workArea.height - layout.sepOrg.y));
        }
        return this.paintArmedHorizontalDropDown(graphics2D, layout, new Rectangle(layout.workArea.x, layout.sepOrg.y, layout.workArea.x + layout.sepOrg.x, layout.workArea.height));
    }

    protected RectangularShape paintArmedHorizontalDropDown(Graphics2D graphics2D, Layout layout, Rectangle rectangle) {
        Shape shape = graphics2D.getClip();
        graphics2D.clip(rectangle);
        RectangularShape rectangularShape = this.paintArmedDropDownHorizontal(graphics2D, layout);
        graphics2D.setClip(shape);
        graphics2D.draw(rectangularShape);
        Color color = LAFUtil.composeWithAlpha(Color.white, 69);
        Color color2 = graphics2D.getColor();
        Rectangle rectangle2 = layout.workArea;
        int n = layout.sepOrg.x;
        graphics2D.drawLine(n, rectangle2.y + 1, n, rectangle2.y + rectangle2.height - 2);
        graphics2D.setColor(color2);
        graphics2D.drawLine(n + 1, rectangle2.y + 1, n + 1, rectangle2.y + rectangle2.height - 2);
        return rectangularShape;
    }

    protected RectangularShape paintArmedDropDown(Graphics2D graphics2D, Layout layout, Rectangle rectangle) {
        Shape shape = graphics2D.getClip();
        graphics2D.clip(rectangle);
        RectangularShape rectangularShape = this.paintArmedDropDown(graphics2D, layout);
        graphics2D.setClip(shape);
        graphics2D.draw(rectangularShape);
        Color color = LAFUtil.composeWithAlpha(Color.white, 69);
        Color color2 = graphics2D.getColor();
        Rectangle rectangle2 = layout.workArea;
        if (layout.vertical) {
            int n = layout.sepOrg.y;
            graphics2D.drawLine(rectangle2.x + 1, n, rectangle2.x + rectangle2.width - 2, n);
            graphics2D.setColor(color);
            graphics2D.drawLine(rectangle2.x + 1, n + 1, rectangle2.x + rectangle2.width - 2, n + 1);
        } else {
            int n = layout.sepOrg.x;
            graphics2D.drawLine(n, rectangle2.y + 1, n, rectangle2.y + rectangle2.height - 2);
            graphics2D.setColor(color2);
            graphics2D.drawLine(n + 1, rectangle2.y + 1, n + 1, rectangle2.y + rectangle2.height - 2);
        }
        return rectangularShape;
    }

    protected void paintUnArmed(Graphics2D graphics2D, Layout layout) {
    }

    protected RectangularShape paintArmed(Graphics2D graphics2D, Layout layout) {
        Rectangle rectangle = layout.workArea;
        if (layout.vertical) {
            return this.paintArmed(graphics2D, layout, new Rectangle(rectangle.x, rectangle.y, rectangle.width, layout.sepOrg.y - rectangle.y));
        }
        return this.paintArmed(graphics2D, layout, new Rectangle(rectangle.x, rectangle.y, rectangle.x + layout.sepOrg.x, rectangle.height));
    }

    protected RectangularShape paintArmed(Graphics2D graphics2D, Layout layout, Rectangle rectangle) {
        Shape shape = graphics2D.getClip();
        graphics2D.clip(rectangle);
        RectangularShape rectangularShape = this.paintArmedRect(graphics2D, layout);
        graphics2D.setClip(shape);
        graphics2D.draw(rectangularShape);
        Color color = LAFUtil.composeWithAlpha(Color.white, 69);
        Color color2 = LAFUtil.composeWithAlpha(new Color(0, 0, 0), 32);
        Rectangle rectangle2 = layout.workArea;
        if (layout.vertical) {
            int n = layout.sepOrg.y;
            graphics2D.drawLine(rectangle2.x + 1, n, rectangle2.x + rectangle2.width - 2, n);
            graphics2D.setColor(color);
            graphics2D.drawLine(rectangle2.x + 1, n + 1, rectangle2.x + rectangle2.width - 2, n + 1);
            graphics2D.drawLine(rectangle2.x + 1, rectangle2.y + 1, rectangle2.x + rectangle2.width - 2, rectangle2.y + 1);
        } else {
            int n = layout.sepOrg.x;
            graphics2D.setColor(color2);
            graphics2D.drawLine(n, rectangle2.y + 1, n, rectangle2.y + rectangle2.height - 2);
            graphics2D.setColor(color2);
            graphics2D.drawLine(n + 1, rectangle2.y + 1, n + 1, rectangle2.y + rectangle2.height - 2);
            graphics2D.setColor(color);
            graphics2D.drawLine(rectangle2.x + 1, rectangle2.y + 1, layout.sepOrg.x - 1, rectangle2.y + 1);
        }
        return rectangularShape;
    }

    private RectangularShape paintArmedRect(Graphics2D graphics2D, Layout layout) {
        return LAFUtil.drawButtonArmedRect(graphics2D, layout.workArea, this.fTheme);
    }

    private RectangularShape paintArmedDropDown(Graphics2D graphics2D, Layout layout) {
        return LAFUtil.drawbuttonArmedDropDownRect(graphics2D, layout.workArea, this.fTheme);
    }

    private RectangularShape paintArmedDropDownHorizontal(Graphics2D graphics2D, Layout layout) {
        return LAFUtil.drawbuttonArmedDropDownRectHorizontalLeft(graphics2D, layout.workArea, this.fTheme);
    }

    private Layout layout(TSButton tSButton) {
        Layout layout = new Layout(tSButton);
        Rectangle rectangle = layout.workArea;
        if (layout.vertical) {
            FontMetrics fontMetrics = FontUtils.getFontMetrics((Font)tSButton.getFont());
            List list = layout.strings = StringUtils.split((String)layout.text, (String)"\n");
            if (layout.icon != null) {
                layout.iconOrg = new Point(rectangle.x + (rectangle.width - layout.icon.getIconWidth()) / 2, rectangle.y + 5);
            }
            this.layoutLines(rectangle, fontMetrics, list, layout);
        } else {
            int n;
            int n2 = 4;
            if (layout.icon != null) {
                layout.iconOrg = new Point(rectangle.x + n2, rectangle.y + (rectangle.height - layout.icon.getIconHeight()) / 2);
                n2 += layout.icon.getIconWidth() + (layout.no_labels ? 0 : 4);
            }
            FontMetrics fontMetrics = FontUtils.getFontMetrics((Font)tSButton.getFont());
            int n3 = n = layout.no_labels ? 0 : fontMetrics.stringWidth(layout.text);
            if (layout.icon == null) {
                n2 = (rectangle.width - n - 6 - 7 - 2 - 3 - 2) / 2;
            }
            Point point = new Point(rectangle.x + n2, rectangle.y + (rectangle.height - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent());
            layout.sepOrg = new Point(rectangle.x + n2 + n + 6, rectangle.y);
            n2 = layout.sepOrg.x + 2 + 3;
            layout.triOrg = new Point(n2, rectangle.y + (rectangle.height - 4) / 2);
            layout.textOrgs = new Point[]{point};
            layout.strings = ImmutableList.of((Object)layout.text);
        }
        return layout;
    }

    private void layoutLines(Rectangle rectangle, FontMetrics fontMetrics, List<String> list, Layout layout) {
        int n = rectangle.y + rectangle.height - 5 - fontMetrics.getHeight() * (layout.bigIcon ? 1 : 2);
        layout.sepOrg = new Point(rectangle.x, n - 4);
        int n2 = list.size();
        layout.textOrgs = new Point[list.size()];
        for (int i = 0; i < n2; ++i) {
            String string = list.get(i);
            int n3 = fontMetrics.stringWidth(string);
            boolean bl = n2 > 1 && i == n2 - 1 || n2 == 1 && layout.bigIcon;
            int n4 = rectangle.x + (rectangle.width - (n3 + (bl ? 13 : 0))) / 2;
            layout.textOrgs[i] = new Point(n4, n + fontMetrics.getAscent());
            if (bl) {
                layout.triOrg = new Point(n4 + n3 + 6, n + (fontMetrics.getHeight() - 4) / 2);
            }
            n += fontMetrics.getHeight();
        }
        if (n2 == 1 && !layout.bigIcon) {
            layout.triOrg = new Point(rectangle.x + (rectangle.width - 7) / 2, n + (fontMetrics.getHeight() - 4) / 2);
        }
    }

    protected void paintContent(Graphics2D graphics2D, Layout layout) {
        Icon icon = layout.icon;
        TSButton tSButton = layout.button;
        if (icon != null) {
            SplitButtonUI.drawIconWithShadow(graphics2D, (AbstractButton)((Object)tSButton), icon, layout.iconOrg.x, layout.iconOrg.y);
        }
        if (!layout.no_labels) {
            graphics2D.setFont(tSButton.getFont());
            graphics2D.setColor(tSButton.isEnabled() ? tSButton.getForeground() : this.fTheme.getButtonDisabledTextColor());
            for (int i = 0; i < layout.textOrgs.length; ++i) {
                Point point = layout.textOrgs[i];
                LAFUtil.drawString(graphics2D, layout.strings.get(i), point.x, point.y);
            }
        }
        LAFUtil.paintDarkTriangle(graphics2D, layout.triOrg.x, layout.triOrg.y);
    }

    @Override
    public int getPreferredWidth(TSComponent tSComponent, LayoutMode layoutMode) {
        return this.getPreferredSize((TSSplitButton)((TSSplitButton)tSComponent), (LayoutMode)layoutMode).width;
    }

    public Dimension getPreferredSize(TSSplitButton tSSplitButton, LayoutMode layoutMode) {
        Layout layout = new Layout(tSSplitButton);
        boolean bl = layout.no_labels;
        boolean bl2 = layout.vertical;
        Icon icon = layout.icon;
        String string = tSSplitButton.getText();
        if (string == null) {
            string = "";
        }
        int n = 0;
        int n2 = 0;
        if (bl2) {
            int n3 = icon != null ? 12 + icon.getIconWidth() : 0;
            FontMetrics fontMetrics = FontUtils.getFontMetrics((Font)tSSplitButton.getFont());
            int n4 = 0;
            List list = StringUtils.split((String)string, (String)"\n");
            int n5 = list.size();
            for (int i = 0; i < n5; ++i) {
                String string2 = (String)list.get(i);
                int n6 = fontMetrics.stringWidth(string2);
                if (n5 > 1 && i == n5 - 1 || n5 == 1 && layout.bigIcon) {
                    n6 += 13;
                }
                n4 = Math.max(n4, n6);
            }
            n = Math.max(8 + n4, n3);
            n2 = this.fTheme.getToolstripControlContentHeight();
        } else {
            int n7;
            n2 += 6;
            n += 8;
            int n8 = n7 = icon != null ? icon.getIconHeight() : 16;
            n += icon != null ? icon.getIconWidth() + (bl ? 0 : 4) : 0;
            if (!bl) {
                FontMetrics fontMetrics = FontUtils.getFontMetrics((Font)tSSplitButton.getFont());
                n += fontMetrics.stringWidth(string);
                n7 = Math.max(n7, fontMetrics.getHeight());
            }
            n += 20;
            n2 += n7;
        }
        return new Dimension(n, n2);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        return this.getPreferredSize((TSSplitButton)((Object)jComponent), LAFUtil.getLayoutMode(jComponent));
    }

    @Override
    protected ToolstripButtonUI.ToolstripButtonListener newToolstripButtonListener(AbstractButton abstractButton) {
        return new MyToolstripButtonListener(abstractButton);
    }

    protected boolean isInsideDropDown(TSSplitButton tSSplitButton, MouseEvent mouseEvent) {
        Layout layout = this.layout(tSSplitButton);
        if (layout.vertical) {
            Rectangle rectangle = new Rectangle(layout.workArea.x, layout.sepOrg.y, layout.workArea.width, tSSplitButton.getHeight() - layout.sepOrg.y);
            return rectangle.contains(mouseEvent.getX(), mouseEvent.getY());
        }
        Rectangle rectangle = new Rectangle(layout.sepOrg.x, layout.workArea.y, tSSplitButton.getWidth() - layout.sepOrg.x, layout.workArea.height);
        return rectangle.contains(mouseEvent.getX(), mouseEvent.getY());
    }

    class MyToolstripButtonListener
    extends ToolstripButtonUI.ToolstripButtonListener
    implements ActionListener {
        private long lastPressedTimestamp;
        private boolean shouldDiscardRelease;

        MyToolstripButtonListener(AbstractButton abstractButton) {
            super(abstractButton);
            abstractButton.addActionListener(this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.fButton.revalidate();
            this.fButton.repaint();
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.fButton.revalidate();
            this.fButton.repaint();
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            this.fButton.repaint();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            this.fButton.repaint();
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            ((SplitButtonModel)this.fButton.getModel()).setDropDownArmed(SplitButtonUI.this.isInsideDropDown((TSSplitButton)((Object)this.fButton), mouseEvent));
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            TSSplitButton tSSplitButton;
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && (tSSplitButton = (TSSplitButton)((Object)this.fButton)).contains(mouseEvent.getX(), mouseEvent.getY())) {
                long l = tSSplitButton.getMultiClickThreshhold();
                long l2 = this.lastPressedTimestamp;
                long l3 = this.lastPressedTimestamp = mouseEvent.getWhen();
                if (l2 != -1L && l3 - l2 < l) {
                    this.shouldDiscardRelease = true;
                    return;
                }
                SplitButtonModel splitButtonModel = tSSplitButton.getModel();
                if (!splitButtonModel.isEnabled()) {
                    return;
                }
                splitButtonModel.setArmed(true);
                splitButtonModel.setDropDownArmed(SplitButtonUI.this.isInsideDropDown(tSSplitButton, mouseEvent));
                if (splitButtonModel.isDropDownArmed()) {
                    splitButtonModel.setDropDownPressed(true);
                } else {
                    splitButtonModel.setPressed(true);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                if (this.shouldDiscardRelease) {
                    this.shouldDiscardRelease = false;
                    return;
                }
                SplitButtonModel splitButtonModel = ((TSSplitButton)((Object)this.fButton)).getModel();
                splitButtonModel.setPressed(false);
                splitButtonModel.setDropDownPressed(false);
            }
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            this.handleSelectionChange(itemEvent);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            SplitButtonModel splitButtonModel = ((TSSplitButton)((Object)this.fButton)).getModel();
            splitButtonModel.setArmed(true);
            splitButtonModel.setDropDownArmed(SplitButtonUI.this.isInsideDropDown((TSSplitButton)((Object)this.fButton), mouseEvent));
            if (splitButtonModel.isPressed()) {
                splitButtonModel.setArmed(true);
            }
            if (splitButtonModel.isDropDownPressed()) {
                splitButtonModel.setDropDownArmed(true);
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.unArmModel();
        }

        private void unArmModel() {
            SplitButtonModel splitButtonModel = ((TSSplitButton)((Object)this.fButton)).getModel();
            splitButtonModel.setArmed(false);
            splitButtonModel.setDropDownArmed(false);
        }

        @Override
        public void ancestorAdded(AncestorEvent ancestorEvent) {
            this.unArmModel();
        }

        @Override
        public void ancestorRemoved(AncestorEvent ancestorEvent) {
            this.unArmModel();
        }

        @Override
        public void ancestorMoved(AncestorEvent ancestorEvent) {
            this.unArmModel();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TSUtil.toolstripActionProcessed(this.fButton);
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            if (keyEvent.getKeyChar() == '\n') {
                ((TSSplitButton)((Object)this.fButton)).doDropDownClick();
            }
        }
    }

    private class Layout {
        TSButton button;
        String text;
        Icon icon;
        Point iconOrg;
        Point sepOrg;
        Point triOrg;
        Rectangle workArea;
        List<String> strings;
        Point[] textOrgs;
        boolean no_labels;
        boolean vertical;
        boolean bigIcon;

        private Layout(TSButton tSButton) {
            this.button = tSButton;
            this.text = tSButton.getText();
            if (this.text == null) {
                this.text = "";
            }
            this.workArea = LAFUtil.getWorkArea((JComponent)((Object)tSButton));
            LayoutMode layoutMode = LAFUtil.getLayoutMode((JComponent)((Object)tSButton));
            this.no_labels = layoutMode.hasProperty(LayoutMode.Property.NO_LABEL);
            this.vertical = layoutMode.hasProperty(LayoutMode.Property.VERTICAL);
            ButtonOrientation buttonOrientation = tSButton.getOrientation();
            if (buttonOrientation != ButtonOrientation.AUTO) {
                this.vertical = buttonOrientation == ButtonOrientation.VERTICAL;
            }
            this.icon = ToolstripButtonUI.getIcon((AbstractButton)((Object)tSButton), this.vertical);
            if (StringUtils.isEmpty((String)this.text)) {
                this.no_labels = true;
            }
            if (this.vertical || this.icon == null) {
                this.no_labels = false;
            }
            boolean bl = this.bigIcon = this.icon != null && this.icon.getIconHeight() > 30;
            if (!this.vertical && this.bigIcon && buttonOrientation == ButtonOrientation.AUTO) {
                this.vertical = true;
            }
        }
    }
}

