/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.factory;

import com.mathworks.toolstrip.components.gallery.model.Category;
import com.mathworks.toolstrip.components.gallery.model.GalleryModel;
import com.mathworks.toolstrip.components.gallery.model.Item;
import com.mathworks.toolstrip.components.gallery.model.WrappedGalleryModel;
import com.mathworks.toolstrip.factory.TSToolSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import org.jetbrains.annotations.NotNull;

public class TargetedGalleryModel
extends WrappedGalleryModel {
    private final Map<String, TSToolSet> fToolSetMap;

    public TargetedGalleryModel(@NotNull GalleryModel galleryModel, Map<String, TSToolSet> map) {
        super(galleryModel);
        this.fToolSetMap = map;
    }

    @Override
    public List<Item> getItems(Category category) {
        List<Item> list = super.getItems(category);
        ArrayList<Item> arrayList = new ArrayList<Item>(list.size());
        for (Item item : list) {
            arrayList.add(this.createSubstituteItem(item));
        }
        return arrayList;
    }

    @Override
    public boolean isFavorite(Item item) {
        return super.isFavorite(this.getParentItem(item));
    }

    @Override
    public Item getItem(String string) {
        Item item = super.getItem(string);
        return item == null ? null : this.createSubstituteItem(item);
    }

    @Override
    public void removeItem(Category category, Item item) {
        super.removeItem(category, this.getParentItem(item));
    }

    @Override
    public void moveItem(Category category, Item item, int n) {
        super.moveItem(category, this.getParentItem(item), n);
    }

    @Override
    public void moveItem(Category category, Category category2, Item item) {
        super.moveItem(category, category2, this.getParentItem(item));
    }

    @Override
    public void addToFavorites(Item item) {
        super.addToFavorites(this.getParentItem(item));
    }

    @Override
    public void removeFromFavorites(Item item) {
        super.removeFromFavorites(this.getParentItem(item));
    }

    private Item getParentItem(Item item) {
        return this.fParentModel.getItem(item.getName());
    }

    private Item createSubstituteItem(Item item) {
        String string = item.getName();
        int n = string.indexOf(58);
        assert (n > 0 && n < string.length());
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1, string.length());
        TSToolSet tSToolSet = this.fToolSetMap.get(string2);
        assert (tSToolSet != null);
        Action action = tSToolSet.getAction(string3);
        assert (action != null);
        if (action.getValue("tool path") == null) {
            Action action2 = item.getAction();
            assert (action2 != null);
            action.putValue("tool path", action2.getValue("tool path"));
        }
        return new Item(string, action, item.getKeyWords());
    }
}

