/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.factory;

import com.mathworks.mwswing.SimpleElement;
import com.mathworks.mwswing.SimpleNodeList;
import com.mathworks.toolstrip.ToolstripSection;
import com.mathworks.toolstrip.components.ButtonOrientation;
import com.mathworks.toolstrip.components.TSPriority;
import com.mathworks.toolstrip.factory.XMLUtils;
import com.mathworks.util.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.zip.DataFormatException;
import org.jetbrains.annotations.NotNull;

public class TSTabConfiguration {
    public static final String HIDDEN_SECTON_NAME = "hidden";
    private final String fContextName;
    private final String fName;
    private String fContributeToName;
    private String fDefaultToolSetName;
    private String fLabel;
    private ResourceBundle fResourceBundle;
    private final List<Section> fSectionList = new ArrayList<Section>();
    private static final String TAB_TAG = "tab";
    private static final String SECTION_TAG = "section";
    private static final String TOOL_TAG = "tool";
    private static final String SEPARATOR_TAG = "separator";
    private static final String CONTEXT_ATTRIBUTE = "context_id";
    private static final String TOOLSET_ID_ATTRIBUTE = "toolset_id";
    private static final String LAYOUT_ATTRIBUTE = "layout";
    private static final String FIXED_LAYOUT_VALUE = "fixed";
    private static final String FLOW_LAYOUT_VALUE = "flow";
    private static final String ORIENTATION_ATTRIBUTE = "orientation";
    private static final String HORIZONTAL_VALUE = "horizontal";
    private static final String VERTICAL_VALUE = "vertical";
    private static final String AUTO_ORIENTATION_VALUE = "auto";
    private static final String PRIORITY_ATTRIBUTE = "priority";
    private static final String HIGH_PRIORITY_VALUE = "high";
    private static final String MEDIUM_PRIORITY_VALUE = "medium";
    private static final String LOW_PRIORITY_VALUE = "low";
    private static final String HALIGNMENT_ATTRIBUTE = "horizontal_align";
    private static final String VALIGNMENT_ATTRIBUTE = "vertical_align";
    private static final String LEFT_ALIGN_VALUE = "left";
    private static final String CENTER_ALIGN_VALUE = "center";
    private static final String RIGHT_ALIGN_VALUE = "right";
    private static final String TOP_ALIGN_VALUE = "top";
    private static final String BOTTOM_ALIGN_VALUE = "bottom";
    private static final String VISIBLE_ATTRIBUTE = "visible";
    private static final String OPTIONAL_ATTRIBUTE = "optional";

    public TSTabConfiguration(@NotNull String string, String string2) {
        this(null, string, string2, null, null);
    }

    public TSTabConfiguration(@NotNull String string, ResourceBundle resourceBundle) {
        this(null, string, null, resourceBundle, null);
    }

    public TSTabConfiguration(@NotNull String string, ResourceBundle resourceBundle, String string2) {
        this(null, string, null, resourceBundle, string2);
    }

    public TSTabConfiguration(String string, @NotNull String string2, String string3) {
        this(string, string2, string3, null, null);
    }

    public TSTabConfiguration(String string, @NotNull String string2, ResourceBundle resourceBundle) {
        this(string, string2, null, resourceBundle, null);
    }

    public TSTabConfiguration(String string, @NotNull String string2, String string3, ResourceBundle resourceBundle, String string4) {
        this.fContextName = string;
        this.fName = string2;
        this.fLabel = string3;
        this.fResourceBundle = resourceBundle;
        this.fDefaultToolSetName = string4;
    }

    public String getContextName() {
        return this.fContextName;
    }

    @NotNull
    public String getName() {
        return this.fName;
    }

    @NotNull
    public String getLabel() {
        String string = this.fLabel;
        if (string == null && this.fResourceBundle != null) {
            string = XMLUtils.getString(this.fResourceBundle, "Tab", this.fName, "Label");
        }
        assert (string != null) : "Missing label for tab " + this.fName;
        return string;
    }

    public ResourceBundle getResourceBundle() {
        return this.fResourceBundle;
    }

    public void setContributeToName(String string) {
        this.fContributeToName = string;
    }

    public String getContributeToName() {
        return this.fContributeToName;
    }

    public List<Section> getSections() {
        return Collections.unmodifiableList(this.fSectionList);
    }

    public Section addSection(String string) {
        return this.addSection(string, null);
    }

    public Section addSection(String string, String string2) {
        return this.addSection(string, string2, SectionLayoutType.FLOW);
    }

    public Section addSection(String string, String string2, SectionLayoutType sectionLayoutType) {
        return this.addSection(string, string2, sectionLayoutType, (Integer)ToolstripSection.PRIORITY.getDefault());
    }

    public Section addSection(String string, String string2, SectionLayoutType sectionLayoutType, int n) {
        Section section = new Section(string, string2, sectionLayoutType, n);
        int n2 = this.fSectionList.indexOf(section);
        if (n2 != -1) {
            return this.fSectionList.get(n2);
        }
        this.fSectionList.add(section);
        return section;
    }

    public Section getSection(String string) {
        for (Section section : this.fSectionList) {
            if (!string.equals(section.getName())) continue;
            return section;
        }
        return null;
    }

    public Section removeSection(String string) {
        Iterator<Section> iterator = this.fSectionList.iterator();
        while (iterator.hasNext()) {
            Section section = iterator.next();
            if (!string.equals(section.getName())) continue;
            iterator.remove();
            return section;
        }
        return null;
    }

    public Tool addTool(String string, ToolParameters toolParameters) {
        return this.addTool(string, toolParameters.iName, toolParameters.iToolSetName == null ? this.fDefaultToolSetName : toolParameters.iToolSetName, toolParameters.iPriority, toolParameters.iOrientation, toolParameters.iHorizontalAlignment, toolParameters.iVerticalAlignment, toolParameters.iIsVisible, toolParameters.iIsOptional);
    }

    private Tool addTool(String string, String string2, String string3, TSPriority tSPriority, ButtonOrientation buttonOrientation, int n, int n2, boolean bl, boolean bl2) {
        Section section = this.addSection(string);
        if (section.iToolList == null) {
            section.iToolList = new ArrayList();
        }
        Tool tool = new Tool(string2, string3, tSPriority, buttonOrientation, n, n2, bl, bl2);
        assert (string2 == null || section.iToolList.indexOf(tool) == -1) : "Attempting to add duplicate control";
        section.iToolList.add(tool);
        return tool;
    }

    public void addSeparator(String string) {
        Section section = this.addSection(string);
        if (section == null) {
            Log.log((String)("Attempting to add separator to empty section " + string + " on tab " + this.fName));
        } else {
            this.addTool(string, new ToolParameters(null, null));
        }
    }

    public void insertBefore(String string, String string2, String string3, ToolParameters toolParameters) {
        for (Section section : this.fSectionList) {
            if (section.iToolList == null || !string.equals(section.getName())) continue;
            for (int i = section.iToolList.size() - 1; i >= 0; --i) {
                if (!string2.equals(((Tool)section.iToolList.get(i)).getName()) || !string3.equals(((Tool)section.iToolList.get(i)).getToolSetName())) continue;
                Tool tool = new Tool(toolParameters.iName, toolParameters.iToolSetName, toolParameters.iPriority, toolParameters.iOrientation, toolParameters.iHorizontalAlignment, toolParameters.iVerticalAlignment, toolParameters.iIsVisible, toolParameters.iIsOptional);
                section.iToolList.add(i, tool);
            }
        }
    }

    public Tool removeTool(String string, String string2, String string3) {
        for (Section section : this.fSectionList) {
            if (section.iToolList == null || !string.equals(section.getName())) continue;
            Iterator iterator = section.iToolList.iterator();
            while (iterator.hasNext()) {
                Tool tool = (Tool)iterator.next();
                if (!string2.equals(tool.getName()) || !string3.equals(tool.getToolSetName())) continue;
                iterator.remove();
                if (section.iToolList.isEmpty()) {
                    this.fSectionList.remove(section);
                }
                return tool;
            }
        }
        return null;
    }

    public Tool findTool(String string, String string2, String string3) {
        Section section = new Section(string, null, null, 0);
        int n = this.fSectionList.indexOf(section);
        if (n >= 0) {
            Section section2 = this.fSectionList.get(n);
            ToolParameters toolParameters = new ToolParameters(string2, string3);
            Tool tool = new Tool(string2, string3, toolParameters.iPriority, toolParameters.iOrientation, toolParameters.iHorizontalAlignment, toolParameters.iVerticalAlignment, toolParameters.iIsVisible, toolParameters.iIsOptional);
            int n2 = section2.getTools().indexOf(tool);
            if (n2 >= 0) {
                return section2.getTools().get(n2);
            }
        }
        return null;
    }

    public TSTabConfiguration(SimpleElement simpleElement) throws DataFormatException {
        assert (TAB_TAG.equals(simpleElement.getTagName()));
        this.fContextName = simpleElement.getAttribute(CONTEXT_ATTRIBUTE);
        this.fName = XMLUtils.readIdAttribute(simpleElement, TAB_TAG);
        if (simpleElement.hasAttribute(TOOLSET_ID_ATTRIBUTE)) {
            this.fDefaultToolSetName = simpleElement.getAttribute(TOOLSET_ID_ATTRIBUTE);
        }
        this.fResourceBundle = XMLUtils.readResourceBundleAttribute(simpleElement);
        SimpleNodeList simpleNodeList = simpleElement.getChildrenByTagName(SECTION_TAG);
        int n = simpleNodeList.getLength();
        for (int i = 0; i < n; ++i) {
            SimpleElement simpleElement2 = (SimpleElement)simpleNodeList.item(i);
            String string = XMLUtils.readIdAttribute(simpleElement2, SECTION_TAG);
            SectionLayoutType sectionLayoutType = TSTabConfiguration.readLayoutAtttribute(simpleElement2, SectionLayoutType.FLOW);
            int n2 = XMLUtils.readIntegerAttribute(simpleElement2, PRIORITY_ATTRIBUTE, (Integer)ToolstripSection.PRIORITY.getDefault());
            this.addSection(string, null, sectionLayoutType, n2);
            SimpleNodeList simpleNodeList2 = simpleElement2.getChildElements();
            int n3 = simpleNodeList2.getLength();
            for (int j = 0; j < n3; ++j) {
                SimpleElement simpleElement3 = (SimpleElement)simpleNodeList2.item(j);
                if (TOOL_TAG.equals(simpleElement3.getTagName())) {
                    String string2 = XMLUtils.readIdAttribute(simpleElement3, TOOL_TAG);
                    String string3 = simpleElement3.hasAttribute(TOOLSET_ID_ATTRIBUTE) ? simpleElement3.getAttribute(TOOLSET_ID_ATTRIBUTE) : this.fDefaultToolSetName;
                    ToolParameters toolParameters = new ToolParameters(string2, string3);
                    toolParameters.iPriority = TSTabConfiguration.readPriorityAttribute(simpleElement3, toolParameters.iPriority);
                    toolParameters.iOrientation = TSTabConfiguration.readOrientationAttribute(simpleElement3, toolParameters.iOrientation);
                    toolParameters.iIsVisible = XMLUtils.readBooleanAttribute(simpleElement3, VISIBLE_ATTRIBUTE, toolParameters.iIsVisible);
                    toolParameters.iIsOptional = XMLUtils.readBooleanAttribute(simpleElement3, OPTIONAL_ATTRIBUTE, toolParameters.iIsOptional);
                    toolParameters.iHorizontalAlignment = TSTabConfiguration.readHorizontalAlignmentAttribute(simpleElement3, toolParameters.iHorizontalAlignment);
                    toolParameters.iVerticalAlignment = TSTabConfiguration.readVerticalAlignmentAttribute(simpleElement3, toolParameters.iVerticalAlignment);
                    this.addTool(string, toolParameters);
                    continue;
                }
                if (!SEPARATOR_TAG.equals(simpleElement3.getTagName())) continue;
                this.addSeparator(string);
            }
        }
    }

    private static SectionLayoutType readLayoutAtttribute(SimpleElement simpleElement, SectionLayoutType sectionLayoutType) throws DataFormatException {
        SectionLayoutType sectionLayoutType2 = sectionLayoutType;
        if (simpleElement.hasAttribute(LAYOUT_ATTRIBUTE)) {
            String string = simpleElement.getAttribute(LAYOUT_ATTRIBUTE);
            if (FIXED_LAYOUT_VALUE.equals(string)) {
                sectionLayoutType2 = SectionLayoutType.FIXED;
            } else if (FLOW_LAYOUT_VALUE.equals(string)) {
                sectionLayoutType2 = SectionLayoutType.FLOW;
            } else {
                throw new DataFormatException("Invalid attibute section:layout=" + string);
            }
        }
        return sectionLayoutType2;
    }

    private static TSPriority readPriorityAttribute(SimpleElement simpleElement, TSPriority tSPriority) throws DataFormatException {
        TSPriority tSPriority2 = tSPriority;
        if (simpleElement.hasAttribute(PRIORITY_ATTRIBUTE)) {
            String string = simpleElement.getAttribute(PRIORITY_ATTRIBUTE);
            if (HIGH_PRIORITY_VALUE.equals(string)) {
                tSPriority2 = TSPriority.TOP;
            } else if (MEDIUM_PRIORITY_VALUE.equals(string)) {
                tSPriority2 = TSPriority.NORMAL;
            } else if (LOW_PRIORITY_VALUE.equals(string)) {
                tSPriority2 = TSPriority.LOW;
            } else {
                throw new DataFormatException("Invalid attibute tool:priority=" + string);
            }
        }
        return tSPriority2;
    }

    private static ButtonOrientation readOrientationAttribute(SimpleElement simpleElement, ButtonOrientation buttonOrientation) throws DataFormatException {
        ButtonOrientation buttonOrientation2 = buttonOrientation;
        if (simpleElement.hasAttribute(ORIENTATION_ATTRIBUTE)) {
            String string = simpleElement.getAttribute(ORIENTATION_ATTRIBUTE);
            if (HORIZONTAL_VALUE.equals(string)) {
                buttonOrientation2 = ButtonOrientation.HORIZONTAL;
            } else if (VERTICAL_VALUE.equals(string)) {
                buttonOrientation2 = ButtonOrientation.VERTICAL;
            } else if (AUTO_ORIENTATION_VALUE.equals(string)) {
                buttonOrientation2 = ButtonOrientation.AUTO;
            } else {
                throw new DataFormatException("Invalid attribute tool:orientation=" + string);
            }
        }
        return buttonOrientation2;
    }

    private static int readHorizontalAlignmentAttribute(SimpleElement simpleElement, int n) throws DataFormatException {
        int n2 = n;
        if (simpleElement.hasAttribute(HALIGNMENT_ATTRIBUTE)) {
            String string = simpleElement.getAttribute(HALIGNMENT_ATTRIBUTE);
            if (LEFT_ALIGN_VALUE.equals(string)) {
                n2 = 10;
            } else if (CENTER_ALIGN_VALUE.equals(string)) {
                n2 = 0;
            } else if (RIGHT_ALIGN_VALUE.equals(string)) {
                n2 = 4;
            } else {
                throw new DataFormatException("Invalid attribute tool:horizontal_align=" + string);
            }
        }
        return n2;
    }

    private static int readVerticalAlignmentAttribute(SimpleElement simpleElement, int n) throws DataFormatException {
        int n2 = n;
        if (simpleElement.hasAttribute(VALIGNMENT_ATTRIBUTE)) {
            String string = simpleElement.getAttribute(VALIGNMENT_ATTRIBUTE);
            if (TOP_ALIGN_VALUE.equals(string)) {
                n2 = 1;
            } else if (CENTER_ALIGN_VALUE.equals(string)) {
                n2 = 0;
            } else if (BOTTOM_ALIGN_VALUE.equals(string)) {
                n2 = 3;
            } else {
                throw new DataFormatException("Invalid attribute tool:vertical_align=" + string);
            }
        }
        return n2;
    }

    public static class ToolParameters {
        private final String iName;
        private final String iToolSetName;
        private TSPriority iPriority = TSPriority.NORMAL;
        private ButtonOrientation iOrientation = ButtonOrientation.AUTO;
        private int iHorizontalAlignment = 10;
        private int iVerticalAlignment = 0;
        private boolean iIsVisible = true;
        private boolean iIsOptional;

        public ToolParameters(String string) {
            this.iName = string;
            this.iToolSetName = null;
        }

        public ToolParameters(String string, String string2) {
            this.iName = string;
            this.iToolSetName = string2;
        }

        public ToolParameters setPriority(TSPriority tSPriority) {
            this.iPriority = tSPriority;
            return this;
        }

        public ToolParameters setOrientation(ButtonOrientation buttonOrientation) {
            this.iOrientation = buttonOrientation;
            return this;
        }

        public ToolParameters setHorizontalAlignment(int n) {
            this.iHorizontalAlignment = n;
            return this;
        }

        public ToolParameters setVerticalAlignment(int n) {
            this.iVerticalAlignment = n;
            return this;
        }

        public ToolParameters setVisible(boolean bl) {
            this.iIsVisible = bl;
            return this;
        }

        public ToolParameters setOptional(boolean bl) {
            this.iIsOptional = bl;
            return this;
        }
    }

    public class Section {
        private final String iName;
        private final String iLabel;
        private final SectionLayoutType iLayoutType;
        private final int iPriority;
        private boolean iIsVisible = true;
        private List<Tool> iToolList;

        public String getName() {
            return this.iName;
        }

        public String getLabel() {
            String string = this.iLabel;
            if (string == null && TSTabConfiguration.this.fResourceBundle != null) {
                string = XMLUtils.getString(TSTabConfiguration.this.fResourceBundle, "Tab", TSTabConfiguration.this.fName, "Section", this.iName, "Label");
            }
            assert (string != null) : "Missing label for tab " + TSTabConfiguration.access$100(TSTabConfiguration.this) + ", section " + this.iName;
            return string;
        }

        public SectionLayoutType getLayoutType() {
            return this.iLayoutType;
        }

        public int getPriority() {
            return this.iPriority;
        }

        public boolean isVisible() {
            return this.iIsVisible;
        }

        public void setVisible(boolean bl) {
            this.iIsVisible = bl;
        }

        public List<Tool> getTools() {
            return this.iToolList == null ? new ArrayList() : Collections.unmodifiableList(this.iToolList);
        }

        public boolean isEmpty() {
            return this.iToolList == null || this.iToolList.isEmpty();
        }

        private Section(String string, String string2, SectionLayoutType sectionLayoutType, int n) {
            this.iName = string;
            this.iLabel = string2;
            this.iLayoutType = sectionLayoutType;
            this.iPriority = n;
        }

        public boolean equals(Object object) {
            return object instanceof Section && this.iName.equals(((Section)object).iName);
        }

        public int hashCode() {
            return this.iName.hashCode();
        }
    }

    public static class Tool {
        private final String iName;
        private final String iToolSetName;
        private final TSPriority iPriority;
        private final ButtonOrientation iOrientation;
        private final int iHorizontalAlignment;
        private final int iVerticalAlignment;
        private boolean iIsVisible;
        private final boolean iIsOptional;

        public String getName() {
            return this.iName;
        }

        public String getToolSetName() {
            return this.iToolSetName;
        }

        public TSPriority getPriority() {
            return this.iPriority;
        }

        public ButtonOrientation getOrientation() {
            return this.iOrientation;
        }

        public int getHorizontalAlignment() {
            return this.iHorizontalAlignment;
        }

        public int getVerticalAlignment() {
            return this.iVerticalAlignment;
        }

        public boolean isVisible() {
            return this.iIsVisible;
        }

        public void setVisible(boolean bl) {
            this.iIsVisible = bl;
        }

        public boolean isOptional() {
            return this.iIsOptional;
        }

        public boolean isSeparator() {
            return this.iName == null;
        }

        private Tool(String string, String string2, TSPriority tSPriority, ButtonOrientation buttonOrientation, int n, int n2, boolean bl, boolean bl2) {
            this.iName = string;
            this.iToolSetName = string2;
            this.iPriority = tSPriority;
            this.iOrientation = buttonOrientation;
            this.iHorizontalAlignment = n;
            this.iVerticalAlignment = n2;
            this.iIsVisible = bl;
            this.iIsOptional = bl2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Tool)) {
                return false;
            }
            Tool tool = (Tool)object;
            return this.iName.equals(tool.iName) && this.iToolSetName.equals(tool.iToolSetName);
        }

        public int hashCode() {
            return this.iName.hashCode() * 31 + this.iToolSetName.hashCode();
        }
    }

    public static enum SectionLayoutType {
        FIXED,
        FLOW;

    }
}

