/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.components.gallery.popupview;

import com.mathworks.mwswing.MJPanel;
import com.mathworks.util.Log;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;

class SearchFieldProxy {
    private Object fSearchTextField;
    private Class<?> fSearchTextFieldClass;
    private Class<?> fListenerClass;
    private Map<Listener, Object> fListenerProxyMap = new HashMap<Listener, Object>();

    SearchFieldProxy(String string) {
        try {
            this.fSearchTextFieldClass = Class.forName("com.mathworks.widgets.SearchTextField");
            this.fListenerClass = Class.forName("com.mathworks.widgets.SearchTextField$Listener");
            Constructor<?> constructor = this.fSearchTextFieldClass.getConstructor(String.class);
            this.fSearchTextField = constructor.newInstance(string);
        }
        catch (Exception exception) {
            Log.logException((Exception)exception);
        }
    }

    JComponent getComponent() {
        try {
            Method method = this.fSearchTextFieldClass.getMethod("getComponent", new Class[0]);
            return (JComponent)method.invoke(this.fSearchTextField, new Object[0]);
        }
        catch (Exception exception) {
            Log.logException((Exception)exception);
            return new MJPanel();
        }
    }

    void enableFocusRelinquishing() {
        try {
            Method method = this.fSearchTextFieldClass.getMethod("enableFocusRelinquishing", new Class[0]);
            method.invoke(this.fSearchTextField, new Object[0]);
        }
        catch (Exception exception) {
            Log.logException((Exception)exception);
        }
    }

    void addSearchTextFieldListener(Listener listener) {
        if (this.fListenerClass == null) {
            return;
        }
        Object object = Proxy.newProxyInstance(SearchFieldProxy.class.getClassLoader(), new Class[]{this.fListenerClass}, (InvocationHandler)new ListenerDelegator(listener));
        if (!this.fListenerProxyMap.containsKey(listener)) {
            this.fListenerProxyMap.put(listener, object);
            try {
                Method method = this.fSearchTextFieldClass.getMethod("addSearchTextFieldListener", this.fListenerClass);
                method.invoke(this.fSearchTextField, object);
            }
            catch (Exception exception) {
                Log.logException((Exception)exception);
            }
        }
    }

    void removeSearchTextFieldListener(Listener listener) {
        Object object = this.fListenerProxyMap.remove(listener);
        if (object != null) {
            try {
                Method method = this.fSearchTextFieldClass.getMethod("removeSearchTextFieldListener", this.fListenerClass);
                method.invoke(this.fSearchTextField, object);
            }
            catch (Exception exception) {
                Log.logException((Exception)exception);
            }
        }
    }

    private static class ListenerDelegator
    implements InvocationHandler {
        private final Listener iListener;

        ListenerDelegator(Listener listener) {
            this.iListener = listener;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            String string = method.getName();
            if ("search".equals(string)) {
                this.iListener.search((String)objectArray[0]);
            } else if ("searchTextChanged".equals(string)) {
                this.iListener.searchTextChanged((String)objectArray[0]);
            } else if ("searchCleared".equals(string)) {
                this.iListener.searchCleared();
            }
            return null;
        }
    }

    public static interface Listener {
        public void search(String var1);

        public void searchTextChanged(String var1);

        public void searchCleared();
    }
}

