/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.components.gallery;

import com.google.common.base.Preconditions;
import java.util.EnumSet;

public class GalleryOptions {
    private int fRowCount = 1;
    private int fLabelLineCount = 0;
    private float fColumnWidth = 1.0f;
    private int fMinColumnCount = 1;
    private int fMaxColumnCount = Integer.MAX_VALUE;
    private EnumSet<PopupViewType> fPopupViews = EnumSet.of(PopupViewType.ICON, PopupViewType.LIST);
    private PopupViewType fInitialPopupView = PopupViewType.ICON;
    private boolean fEnableSearch = true;
    private boolean fMultiSelectPopup;
    private boolean fShowOnlyFavoritesOnToolstrip;
    private boolean fShareModel;
    private boolean fSupportFavorites = true;
    private boolean fShowSelection;

    public GalleryOptions setRowCount(int n) {
        Preconditions.checkArgument((n > 0 ? 1 : 0) != 0, (String)"A gallery must display at least one row, requested %d", (Object[])new Object[]{n});
        Preconditions.checkArgument((n <= 2 ? 1 : 0) != 0, (String)"A gallery cannot display more than two rows, requested %d", (Object[])new Object[]{n});
        this.fRowCount = n;
        return this;
    }

    public GalleryOptions setLabelLineCount(int n) {
        Preconditions.checkArgument((n <= 2 ? 1 : 0) != 0, (String)"A gallery cannot display more than two label lines, requested %d", (Object[])new Object[]{n});
        this.fLabelLineCount = n;
        return this;
    }

    public GalleryOptions setColumnWidth(float f) {
        this.fColumnWidth = f;
        return this;
    }

    public GalleryOptions setMinColumnCount(int n) {
        Preconditions.checkArgument((n > 0 ? 1 : 0) != 0, (String)"A gallery must display at least one column, specified %d", (Object[])new Object[]{n});
        this.fMinColumnCount = n;
        return this;
    }

    public GalleryOptions setMaxColumnCount(int n) {
        Preconditions.checkArgument((n > 0 ? 1 : 0) != 0, (String)"A gallery must display at least one column, specified %d", (Object[])new Object[]{n});
        this.fMaxColumnCount = n;
        return this;
    }

    public GalleryOptions setPopupViews(EnumSet<PopupViewType> enumSet) {
        this.fPopupViews = enumSet;
        return this;
    }

    public GalleryOptions setInitialPopupView(PopupViewType popupViewType) {
        this.fInitialPopupView = popupViewType;
        return this;
    }

    public GalleryOptions setEnableSearch(boolean bl) {
        this.fEnableSearch = bl;
        return this;
    }

    public GalleryOptions setMultiSelectPopup(boolean bl) {
        this.fMultiSelectPopup = bl;
        return this;
    }

    public GalleryOptions setShowOnlyFavoritesOnToolstrip(boolean bl) {
        this.fShowOnlyFavoritesOnToolstrip = bl;
        return this;
    }

    public GalleryOptions setShareModel(boolean bl) {
        this.fShareModel = bl;
        return this;
    }

    public GalleryOptions setSupportFavorites(boolean bl) {
        this.fSupportFavorites = bl;
        return this;
    }

    public GalleryOptions setShowSelection(boolean bl) {
        this.fShowSelection = bl;
        return this;
    }

    public int getRowCount() {
        return this.fRowCount;
    }

    public int getLabelLineCount() {
        return this.fLabelLineCount;
    }

    public float getColumnWidth() {
        return this.fColumnWidth;
    }

    public int getMinColumnCount() {
        return this.fMinColumnCount;
    }

    public int getMaxColumnCount() {
        return this.fMaxColumnCount;
    }

    public EnumSet<PopupViewType> getPopupViews() {
        return this.fPopupViews;
    }

    public PopupViewType getInitialPopupView() {
        return this.fInitialPopupView;
    }

    public boolean getEnableSearch() {
        return this.fEnableSearch;
    }

    public boolean getMultiSelectPopup() {
        return this.fMultiSelectPopup;
    }

    public boolean showOnlyFavoritesOnToolstrip() {
        return this.fShowOnlyFavoritesOnToolstrip;
    }

    public boolean shareModel() {
        return this.fShareModel;
    }

    public boolean supportFavorites() {
        return this.fSupportFavorites;
    }

    public boolean showSelection() {
        return this.fShowSelection;
    }

    public static enum PopupViewType {
        LIST,
        ICON,
        NONE;

    }
}

