/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.components;

import com.mathworks.desktop.mnemonics.HasMnemonic;
import com.mathworks.desktop.mnemonics.Mnemonic;
import com.mathworks.desktop.mnemonics.MnemonicsProvider;
import com.mathworks.mwswing.MJRadioButton;
import com.mathworks.toolstrip.components.LayoutMode;
import com.mathworks.toolstrip.components.TSComponent;
import com.mathworks.toolstrip.components.TSUtil;
import com.mathworks.toolstrip.plaf.ComponentMnemonicsProvider;
import com.mathworks.toolstrip.plaf.LAFUtil;
import com.mathworks.toolstrip.plaf.ToolstripRadioButtonUI;
import java.awt.Point;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class TSRadioButton
extends MJRadioButton
implements TSComponent,
HasMnemonic {
    private String fMnemonic;

    public TSRadioButton() {
    }

    public TSRadioButton(Action action) {
        super(action);
    }

    public TSRadioButton(Icon icon) {
        super(icon);
    }

    public TSRadioButton(Icon icon, boolean bl) {
        super(icon, bl);
    }

    public TSRadioButton(String string) {
        super(string);
    }

    public TSRadioButton(String string, boolean bl) {
        super(string, bl);
    }

    public TSRadioButton(String string, Icon icon) {
        super(string, icon);
    }

    public TSRadioButton(String string, Icon icon, boolean bl) {
        super(string, icon, bl);
    }

    public void setText(String string) {
        if (this.isAutoMnemonicEnabled()) {
            String[] stringArray = LAFUtil.parseMnemonic(string);
            super.setText(stringArray[0]);
            this.fMnemonic = stringArray[1];
        } else {
            super.setText(string);
        }
        this.fOriginalString = string;
    }

    public String getButtonMnemonic() {
        return this.fMnemonic;
    }

    public void setButtonMnemonic(String string) {
        this.fMnemonic = string;
    }

    public Mnemonic getComponentMnemonic() {
        return this.fMnemonic == null ? null : new Mnemonic(){

            @NotNull
            public String getMnemonic() {
                return TSRadioButton.this.fMnemonic;
            }

            @NotNull
            public Point getLocationOnComponent() {
                return TSUtil.getMnemonicLocation((AbstractButton)((Object)TSRadioButton.this));
            }

            @NotNull
            public JComponent getComponent() {
                return TSRadioButton.this;
            }
        };
    }

    public MnemonicsProvider getMnemonicsProvider() {
        return this.fMnemonic == null ? null : this.createProvider();
    }

    protected ButtonMnemonicsProvider createProvider() {
        return new ButtonMnemonicsProvider();
    }

    @Override
    @NotNull
    public LayoutMode getSupportedLayoutMode() {
        return LayoutMode.HORIZONTAL_ONLY_CAPABILITIES;
    }

    @Override
    public int getPreferredWidth(@NotNull LayoutMode layoutMode, int n) {
        return this.getPreferredSize().width;
    }

    @Override
    public boolean canBeGroupedWith(@NotNull TSComponent tSComponent) {
        return tSComponent instanceof AbstractButton;
    }

    public ToolstripRadioButtonUI getUI() {
        return (ToolstripRadioButtonUI)this.ui;
    }

    public String getUIClassID() {
        return "Toolstrip.RadioButtonUI";
    }

    public String toString() {
        return LAFUtil.getComponentDescription(this, this.getText());
    }

    public class ButtonMnemonicsProvider
    extends ComponentMnemonicsProvider {
        public ButtonMnemonicsProvider() {
            super((JComponent)((Object)TSRadioButton.this));
        }

        @Override
        protected void execute() {
            TSUtil.clickButton((AbstractButton)((Object)TSRadioButton.this));
        }
    }
}

