/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.components;

import com.mathworks.desktop.mnemonics.MnemonicPath;
import com.mathworks.desktop.overlay.Overlay;
import com.mathworks.toolstrip.components.DropDownButtonModel;
import com.mathworks.toolstrip.components.PopupListener;
import com.mathworks.toolstrip.components.TSButton;
import com.mathworks.toolstrip.plaf.ToolstripButtonUI;
import com.mathworks.util.Disposable;
import com.mathworks.util.Disposer;
import com.mathworks.util.async.Status;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class TSDropDownButton
extends TSButton {
    public static final String POPUP_LISTENER_KEY = "PopupListener";
    public static final String POPUP_COMPONENT_KEY = "PopupComponent";
    private PopupListener fPopupListenerFromAction;

    public TSDropDownButton() {
    }

    public TSDropDownButton(Action action) {
        super(action);
        this.init();
    }

    public TSDropDownButton(Icon icon) {
        super(icon);
        this.init();
    }

    public TSDropDownButton(String string) {
        super(string);
        this.init();
    }

    public TSDropDownButton(String string, Icon icon) {
        super(string, icon);
        this.init();
    }

    private void init() {
        PopupComponentMouseListener popupComponentMouseListener = new PopupComponentMouseListener(this);
        this.addMouseMotionListener(popupComponentMouseListener);
        this.addMouseListener(popupComponentMouseListener);
    }

    public PopupListener getPopupListener() {
        return this.getModel().getPopupListener();
    }

    public TSDropDownButton setPopupListener(PopupListener popupListener) {
        this.getModel().setPopupListener(popupListener);
        return this;
    }

    @Override
    protected TSButton.ButtonMnemonicsProvider createProvider() {
        return new DropDownButtonMnemonicsProvider();
    }

    public void setModel(ButtonModel buttonModel) {
        if (buttonModel.getClass() != DropDownButtonModel.class) {
            buttonModel = new DropDownButtonModel();
        }
        this.superSetModel(buttonModel);
    }

    protected void superSetModel(ButtonModel buttonModel) {
        super.setModel(buttonModel);
    }

    public DropDownButtonModel getModel() {
        return (DropDownButtonModel)super.getModel();
    }

    @Override
    public ToolstripButtonUI getUI() {
        return (ToolstripButtonUI)this.ui;
    }

    @Override
    public String getUIClassID() {
        return "Toolstrip.DropDownButtonUI";
    }

    public void setAction(Action action) {
        super.setAction(action);
        if (this.fPopupListenerFromAction != null) {
            this.setPopupListener(null);
            this.fPopupListenerFromAction = null;
        }
        if (action != null) {
            this.fPopupListenerFromAction = (PopupListener)action.getValue(POPUP_LISTENER_KEY);
            if (this.fPopupListenerFromAction != null) {
                this.setPopupListener(this.fPopupListenerFromAction);
            }
        }
    }

    private class PopupComponentMouseListener
    implements MouseMotionListener,
    MouseListener {
        private TSDropDownButton fTSDB;

        private PopupComponentMouseListener(TSDropDownButton tSDropDownButton2) {
            this.fTSDB = tSDropDownButton2;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.dispatchEvent(mouseEvent);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            this.dispatchEvent(mouseEvent);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        private void dispatchEvent(MouseEvent mouseEvent) {
            MouseEvent mouseEvent2;
            Object object = TSDropDownButton.this.getClientProperty(TSDropDownButton.POPUP_COMPONENT_KEY);
            if (object instanceof JComponent && ((JComponent)object).contains((mouseEvent2 = SwingUtilities.convertMouseEvent((Component)((Object)this.fTSDB), mouseEvent, (JComponent)object)).getPoint())) {
                ((JComponent)object).dispatchEvent(mouseEvent2);
            }
        }
    }

    public class DropDownButtonMnemonicsProvider
    extends TSButton.ButtonMnemonicsProvider {
        @Override
        @NotNull
        public Status<Component> select(@NotNull MnemonicPath mnemonicPath) {
            this.execute();
            return TSDropDownButton.this.getPopupListener() != null ? new Status.Success() : new Status.Fail();
        }

        @Override
        public Status<Component> cancel(@NotNull MnemonicPath mnemonicPath) {
            Overlay overlay = (Overlay)TSDropDownButton.this.getClientProperty("popup.overlay");
            if (overlay != null) {
                Disposer.dispose((Disposable)overlay);
            }
            return new Status.Success();
        }
    }
}

