/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.appmanagement;

import com.mathworks.appmanagement.AppFileDetails;
import com.mathworks.appmanagement.AppFileDetailsPanelProvider;
import com.mathworks.appmanagement.AppGalleryPathConfiguration;
import com.mathworks.appmanagement.AppManagementApi;
import com.mathworks.appmanagement.AppMetadata;
import com.mathworks.appmanagement.RunAppAction;
import com.mathworks.appmanagement.resources.ResourceKey;
import com.mathworks.mlservices.MatlabDesktopServices;
import com.mathworks.mwswing.IconSet;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.toolstrip.accessories.TSContextMenuContributor;
import com.mathworks.toolstrip.accessories.ToolTipContentProvider;
import com.mathworks.toolstrip.factory.TSRegistry;
import com.mathworks.toolstrip.factory.TSToolSet;
import com.mathworks.toolstrip.factory.TSToolSetContents;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class UserAppToolSetFactory {
    public static final int DEFAULT_SCREENSHOT_WIDTH = 300;
    private static final String APPS_TOOL_SET_NAME = "apps_toolset";
    private static final String MY_APPS_NAME = "my_apps";
    private static AppGalleryPathConfiguration appGalleryPathConfiguration = null;
    private final TSToolSet toolSet;

    UserAppToolSetFactory(TSToolSet tSToolSet) {
        this.toolSet = tSToolSet;
    }

    void addApps(AppManagementApi appManagementApi, AppMetadata[] appMetadataArray) throws InvocationTargetException, InterruptedException {
        for (AppMetadata appMetadata : appMetadataArray) {
            this.addApp(appManagementApi, appMetadata);
        }
    }

    void addApp(AppManagementApi appManagementApi, AppMetadata appMetadata) throws InvocationTargetException, InterruptedException {
        this.doOnEDTinvokeLater(new AddApps(appMetadata, appManagementApi));
    }

    private void doOnEDTinvokeLater(Runnable runnable) throws InterruptedException, InvocationTargetException {
        SwingUtilities.invokeLater(runnable);
    }

    void removeApp(AppMetadata appMetadata) throws InvocationTargetException, InterruptedException {
        String string = appMetadata.getGuid();
        this.removeAppSpecifiedByGuid(string);
    }

    void removeAppSpecifiedByGuid(String string) throws InterruptedException, InvocationTargetException {
        this.doOnEDTinvokeLater(new RemoveApp(string));
    }

    static AppGalleryPathConfiguration getAppGalleryPathConfiguration() {
        return appGalleryPathConfiguration;
    }

    public static void setAppGalleryPathConfiguration(AppGalleryPathConfiguration appGalleryPathConfiguration) {
        UserAppToolSetFactory.appGalleryPathConfiguration = appGalleryPathConfiguration;
    }

    void clearMyAppsGallery() throws InvocationTargetException, InterruptedException {
        TSRegistry tSRegistry = MatlabDesktopServices.getDesktop().getToolstripRegistry();
        TSToolSetContents.Tool tool = tSRegistry.getToolSetContents(APPS_TOOL_SET_NAME).getTool(MY_APPS_NAME);
        for (TSToolSetContents.Tool tool2 : tool.getChildren()) {
            String string = tool2.getName();
            String string2 = string.substring(string.indexOf(58) + 1);
            this.removeAppSpecifiedByGuid(string2);
        }
    }

    static JComponent getScaledImage(ImageIcon imageIcon) {
        int n = imageIcon.getIconWidth();
        int n2 = imageIcon.getIconHeight();
        if (n <= 0 || n2 <= 0) {
            return new MJLabel((Icon)imageIcon);
        }
        Dimension dimension = n > 300 ? new Dimension(300, (int)((double)n2 * (300.0 / (double)n))) : new Dimension(n, n2);
        BufferedImage bufferedImage = new BufferedImage(dimension.width, dimension.height, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(imageIcon.getImage(), 0, 0, dimension.width, dimension.height, null);
        graphics2D.dispose();
        ImageIcon imageIcon2 = new ImageIcon(bufferedImage);
        return new MJLabel((Icon)imageIcon2);
    }

    private class RemoveApp
    implements Runnable {
        private final String guid;

        RemoveApp(String string) {
            this.guid = string;
        }

        @Override
        public void run() {
            UserAppToolSetFactory.this.toolSet.getContents().removeTool(this.guid, new TSToolSetContents.Dependency[]{new TSToolSetContents.Dependency(UserAppToolSetFactory.MY_APPS_NAME, UserAppToolSetFactory.APPS_TOOL_SET_NAME)});
            UserAppToolSetFactory.this.toolSet.removeAction(this.guid);
        }
    }

    private static class AppToolTip
    implements ToolTipContentProvider {
        private final AppManagementApi appManagementApi;
        private final AppMetadata appMetadata;

        AppToolTip(AppManagementApi appManagementApi, AppMetadata appMetadata) {
            this.appManagementApi = appManagementApi;
            this.appMetadata = appMetadata;
        }

        public JComponent getToolTipContent() {
            int n;
            int n2;
            AppFileDetails appFileDetails = new AppFileDetails(this.appMetadata, true);
            AppFileDetailsPanelProvider appFileDetailsPanelProvider = appFileDetails.getPanelProvider();
            JComponent jComponent = appFileDetailsPanelProvider.getComponent();
            int n3 = this.getScreenshotWidth(this.appMetadata.getScreenShot());
            try {
                File file = this.appManagementApi.getAppInstallFolder(this.appMetadata.getGuid());
                n2 = jComponent.getFontMetrics(jComponent.getFont()).stringWidth(file.getAbsolutePath());
                n = n2 > n3 ? n2 : n3;
            }
            catch (Exception exception) {
                n = n3;
            }
            jComponent.setBorder(BorderFactory.createEmptyBorder(4, 6, 4, 6));
            n2 = 12 + appFileDetailsPanelProvider.getTotalHorizontalInsets();
            Dimension dimension = new Dimension(n + n2, 400);
            jComponent.setPreferredSize(dimension);
            return jComponent;
        }

        private int getScreenshotWidth(ImageIcon imageIcon) {
            return UserAppToolSetFactory.getScaledImage((ImageIcon)imageIcon).getPreferredSize().width;
        }
    }

    private class AddApps
    implements Runnable {
        private final AppMetadata appMetadata;
        private final AppManagementApi appManagementApi;

        AddApps(AppMetadata appMetadata, AppManagementApi appManagementApi) {
            this.appMetadata = appMetadata;
            this.appManagementApi = appManagementApi;
        }

        @Override
        public void run() {
            String string;
            TSToolSetContents tSToolSetContents = UserAppToolSetFactory.this.toolSet.getContents();
            if (tSToolSetContents.getTool(string = this.appMetadata.getGuid()) == null) {
                String string2 = this.appMetadata.getName();
                tSToolSetContents.addTool(new TSToolSetContents.ToolParameters(string).setLabel(string2).setIcon((Icon)new IconSet(new Icon[]{this.appMetadata.getIcon(), this.appMetadata.getScaledIcon(2)})).setDescription(this.appMetadata.getDescription()), new TSToolSetContents.Dependency[]{new TSToolSetContents.Dependency(UserAppToolSetFactory.MY_APPS_NAME, UserAppToolSetFactory.APPS_TOOL_SET_NAME)});
                RunAppAction runAppAction = new RunAppAction(this.appManagementApi, this.appMetadata);
                final JPopupMenu.Separator separator = new JPopupMenu.Separator();
                runAppAction.putValue("toolstrip-context-menu-contributor", new TSContextMenuContributor(){

                    public void contributeToToolsripContextMenu(JPopupMenu jPopupMenu, MouseEvent mouseEvent) {
                        jPopupMenu.add(separator);
                        jPopupMenu.add((Action)new MJAbstractAction(ResourceKey.UNINSTALL.getString(new Object[0])){

                            public void actionPerformed(ActionEvent actionEvent) {
                                AddApps.this.appManagementApi.uninstallAsynchronously(string);
                            }
                        });
                    }
                });
                runAppAction.putValue("tool-tip-content-provider", new AppToolTip(this.appManagementApi, this.appMetadata));
                UserAppToolSetFactory.this.toolSet.configureAndAdd(string, (Action)((Object)runAppAction));
            }
        }
    }
}

