/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.appmanagement;

import com.mathworks.appmanagement.AppPrefKey;
import com.mathworks.mvm.MVM;
import com.mathworks.mvm.context.MvmContext;
import com.mathworks.services.settings.Setting;
import com.mathworks.services.settings.SettingException;
import com.mathworks.services.settings.SettingLevel;
import com.mathworks.services.settings.SettingNotFoundException;
import com.mathworks.services.settings.SettingPath;
import com.mathworks.services.settings.SettingTypeException;

class SettingsUtility {
    private SettingsUtility() {
    }

    static synchronized void setStringSetting(AppPrefKey appPrefKey, String string) throws SettingException {
        Setting<String> setting = SettingsUtility.createSetting(appPrefKey);
        setting.set((Object)string);
    }

    static synchronized String getStringSetting(AppPrefKey appPrefKey) throws SettingException {
        return (String)SettingsUtility.getSetting(appPrefKey).get();
    }

    static synchronized Boolean isStringSettingSet(AppPrefKey appPrefKey) throws SettingException {
        boolean bl;
        try {
            Setting<String> setting = SettingsUtility.getSetting(appPrefKey);
            bl = setting.isSet(SettingLevel.USER);
            if (!bl) {
                return bl;
            }
            String string = (String)setting.get(SettingLevel.USER);
            if (string.isEmpty()) {
                bl = false;
            }
        }
        catch (SettingNotFoundException settingNotFoundException) {
            return false;
        }
        return bl;
    }

    static synchronized void unsetSetting(AppPrefKey appPrefKey) throws SettingException {
        SettingsUtility.getSetting(appPrefKey).unset(SettingLevel.USER);
    }

    private static Setting<String> getSetting(AppPrefKey appPrefKey) throws SettingNotFoundException, SettingTypeException, IllegalStateException {
        return new Setting(SettingsUtility.getSettingPath(), String.class, appPrefKey.get());
    }

    private static SettingPath getSettingPath() throws SettingNotFoundException, IllegalStateException {
        MVM mVM = MvmContext.get();
        SettingPath settingPath = new SettingPath(mVM);
        return new SettingPath(settingPath, new String[]{"matlab", "apps"});
    }

    private static Setting<String> createSetting(AppPrefKey appPrefKey) throws SettingException, IllegalStateException {
        Setting setting;
        try {
            setting = SettingsUtility.getSetting(appPrefKey);
        }
        catch (SettingNotFoundException settingNotFoundException) {
            setting = SettingsUtility.getSettingPath().addSetting(appPrefKey.get(), (Object)"");
        }
        return setting;
    }
}

