/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.appmanagement;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.mathworks.appmanagement.AppFileData;
import com.mathworks.appmanagement.AppFileDetailsPanelProvider;
import com.mathworks.appmanagement.AppManagementApiBuilder;
import com.mathworks.appmanagement.AppMetadata;
import com.mathworks.appmanagement.ProductDependency;
import com.mathworks.appmanagement.ScrollablePanel;
import com.mathworks.appmanagement.UserAppToolSetFactory;
import com.mathworks.common.icons.DocumentIcon;
import com.mathworks.desktop.overlay.OverlayManager;
import com.mathworks.desktop.overlay.OverlayManagers;
import com.mathworks.jmi.MLFileUtils;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabListener;
import com.mathworks.jmi.MatlabPath;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.mlservices.MatlabDesktopServices;
import com.mathworks.mwswing.IconUtils;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJTextArea;
import com.mathworks.services.ColorPrefs;
import com.mathworks.toolstrip.accessories.CalloutToolTipManager;
import com.mathworks.util.StringUtils;
import com.mathworks.widgets.HyperlinkTextLabel;
import com.mathworks.widgets.desk.DTFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.UIManager;

public final class AppFileDetails {
    private static final int HGAP = 5;
    private JScrollPane fScrollPane;
    private JComponent fCollapsedPanel;
    private JComponent fExpandedPanel;
    private boolean fArrowDown = false;
    private boolean fIsTip = false;
    private AppFileData fData;
    private File fLoc = null;
    private ScrollablePanel fPanel;
    private Object fCollapsedPanelConstraints;

    public AppFileDetails(String string, boolean bl) {
        try {
            this.fData = new AppFileData(string);
            this.fIsTip = bl;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public AppFileDetails(AppMetadata appMetadata, boolean bl) {
        try {
            this.fData = new AppFileData(appMetadata);
            this.fIsTip = bl;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    AppFileDetailsPanelProvider getPanelProvider() {
        Dimension dimension;
        Insets insets;
        if (this.fScrollPane == null) {
            this.fScrollPane = this.createScrollPane();
        }
        if (this.fScrollPane == null) {
            insets = new Insets(0, 0, 0, 0);
            dimension = new Dimension(0, 0);
        } else {
            insets = this.fScrollPane.getInsets();
            dimension = this.fScrollPane.getVerticalScrollBar().getPreferredSize();
        }
        return new AppFileDetailsPanelProviderImpl(this.fScrollPane, insets.left + insets.right + 10 + dimension.width);
    }

    private JScrollPane createScrollPane() {
        if (this.fData != null) {
            this.fPanel = new ScrollablePanel();
            this.fPanel.setLayout(new GridBagLayout());
            MJLabel mJLabel = new MJLabel(this.fData.getIcon());
            JComponent jComponent = this.createNameComponent();
            JComponent jComponent2 = this.createAuthorComponent();
            JComponent jComponent3 = this.createSummaryComponent();
            JComponent jComponent4 = this.createImageComponent();
            JComponent jComponent5 = this.createVersionComponent();
            JComponent jComponent6 = this.createRequirementsComponent();
            this.fCollapsedPanel = this.createCollapsedFilePanel();
            this.fExpandedPanel = this.createExpandedFilePanel();
            JComponent jComponent7 = this.createFileLocationComponent();
            JComponent jComponent8 = AppFileDetails.createDescriptionHeaderComponent();
            JComponent jComponent9 = this.createDescriptionComponent();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints.gridheight = 2;
            this.fPanel.add((Component)mJLabel, gridBagConstraints);
            gridBagConstraints.gridheight = 1;
            ++gridBagConstraints.gridx;
            gridBagConstraints.weightx = 1.0;
            this.fPanel.add(jComponent, gridBagConstraints);
            ++gridBagConstraints.gridy;
            this.fPanel.add(jComponent2, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 2;
            ++gridBagConstraints.gridy;
            this.fPanel.add(jComponent3, gridBagConstraints);
            ++gridBagConstraints.gridy;
            this.fPanel.add(jComponent4, gridBagConstraints);
            ++gridBagConstraints.gridy;
            this.fPanel.add(jComponent5, gridBagConstraints);
            ++gridBagConstraints.gridy;
            this.fPanel.add(jComponent6, gridBagConstraints);
            ++gridBagConstraints.gridy;
            this.fPanel.add(jComponent7, gridBagConstraints);
            ++gridBagConstraints.gridy;
            this.fCollapsedPanelConstraints = gridBagConstraints.clone();
            this.fPanel.add(this.fCollapsedPanel, gridBagConstraints);
            ++gridBagConstraints.gridy;
            this.fPanel.add(jComponent8, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.weighty = 1.0;
            this.fPanel.add(jComponent9, gridBagConstraints);
            MJScrollPane mJScrollPane = new MJScrollPane((Component)((Object)this.fPanel));
            mJScrollPane.getVerticalScrollBar().setName("app-file-details-scrollbar");
            if (this.fIsTip) {
                mJScrollPane.setBackground(UIManager.getColor("ToolTip.background"));
            }
            AppFileDetails.configureOpacity(new JComponent[]{mJScrollPane.getViewport(), this.fCollapsedPanel, this.fExpandedPanel, this.fPanel});
            ComponentAdapter componentAdapter = new ComponentAdapter((JScrollPane)mJScrollPane){
                final /* synthetic */ JScrollPane val$scrollPane;
                {
                    this.val$scrollPane = jScrollPane;
                }

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    this.val$scrollPane.getVerticalScrollBar().setValue(0);
                    this.val$scrollPane.removeComponentListener(this);
                }
            };
            mJScrollPane.addComponentListener(componentAdapter);
            return mJScrollPane;
        }
        return null;
    }

    private JComponent createExpandedFilePanel() {
        if (this.fIsTip) {
            return this.createExpandedTipFilePanel();
        }
        return this.createExpandedNonTipFilePanel();
    }

    private JComponent createImageComponent() {
        ImageIcon imageIcon = this.fData.getScreenShot();
        Object object = imageIcon.getIconHeight() > 0 && imageIcon.getIconWidth() > 0 ? UserAppToolSetFactory.getScaledImage(imageIcon) : new MJLabel();
        return object;
    }

    private JComponent createFileLocationComponent() {
        if (this.fIsTip) {
            try {
                this.fLoc = AppManagementApiBuilder.getAppManagementApi().getAppInstallFolder(this.fData.getGuid());
                HyperlinkTextLabel hyperlinkTextLabel = new HyperlinkTextLabel("<b>" + AppFileDetails.getResourceBundle().getString("details.location") + ": </b> " + "<a href=\\>" + this.fLoc.getAbsolutePath() + "</a>", new HyperlinkTextLabel.HyperlinkHandler(){

                    public void processHyperlink(String string) {
                        MatlabPath.setCurrentDirectory((File)AppFileDetails.this.fLoc);
                        AppFileDetails.removePopups();
                        CalloutToolTipManager.getInstance().clear();
                        MatlabDesktopServices.showFileBrowser();
                    }
                });
                return hyperlinkTextLabel.getHTMLPane();
            }
            catch (Exception exception) {
                return new MJLabel();
            }
        }
        return new MJLabel();
    }

    private JComponent createNameComponent() {
        HyperlinkTextLabel hyperlinkTextLabel = new HyperlinkTextLabel("<b>" + this.fData.getName() + "</b>", null);
        return hyperlinkTextLabel.getHTMLPane();
    }

    private JComponent createAuthorComponent() {
        String string = this.fData.getAuthorName();
        HyperlinkTextLabel hyperlinkTextLabel = string != null && !string.isEmpty() ? new HyperlinkTextLabel(AppFileDetails.getResourceBundle().getString("details.author.by") + ": " + string) : new HyperlinkTextLabel(" ");
        return hyperlinkTextLabel.getHTMLPane();
    }

    private JComponent createDescriptionComponent() {
        String string = this.fData.getDescription() == null ? "" : this.fData.getDescription();
        HyperlinkTextLabel hyperlinkTextLabel = new HyperlinkTextLabel(string, new HyperlinkTextLabel.HyperlinkHandler(){

            public void processHyperlink(String string) {
                String string2 = "web('" + string + "')";
                new Matlab().eval(string2, (MatlabListener)null);
            }
        });
        hyperlinkTextLabel.getHTMLPane().setName("description_detail_label");
        return hyperlinkTextLabel.getHTMLPane();
    }

    private static JComponent createDescriptionHeaderComponent() {
        HyperlinkTextLabel hyperlinkTextLabel = new HyperlinkTextLabel("<b>" + AppFileDetails.getResourceBundle().getString("details.description") + ": </b>");
        return hyperlinkTextLabel.getHTMLPane();
    }

    private JComponent createRequirementsComponent() {
        StringBuilder stringBuilder;
        String string;
        ProductDependency[] productDependencyArray = this.fData.getRequiredProducts();
        if (productDependencyArray.length == 0) {
            string = AppFileDetails.getResourceBundle().getString("details.norequirements");
        } else {
            stringBuilder = new StringBuilder();
            for (int i = 0; i < productDependencyArray.length; ++i) {
                stringBuilder.append(productDependencyArray[i].getName());
                if (i == productDependencyArray.length - 1) continue;
                stringBuilder.append(", ");
            }
            string = stringBuilder.toString();
        }
        stringBuilder = new HyperlinkTextLabel("<b>" + AppFileDetails.getResourceBundle().getString("details.requirements") + ": </b> " + string, new HyperlinkTextLabel.HyperlinkHandler(){

            public void processHyperlink(String string) {
            }
        });
        stringBuilder.getHTMLPane().setName("requirements_detail_label");
        return stringBuilder.getHTMLPane();
    }

    private JComponent createSummaryComponent() {
        String string = this.fData.getSummary();
        String string2 = string != null && !string.isEmpty() ? string : "";
        HyperlinkTextLabel hyperlinkTextLabel = new HyperlinkTextLabel(string2, new HyperlinkTextLabel.HyperlinkHandler(){

            public void processHyperlink(String string) {
                String string2 = "web('" + string + "')";
                new Matlab().eval(string2, (MatlabListener)null);
            }
        });
        return hyperlinkTextLabel.getHTMLPane();
    }

    private JComponent createVersionComponent() {
        String string = this.fData.getVersion() == null ? "" : this.fData.getVersion();
        HyperlinkTextLabel hyperlinkTextLabel = new HyperlinkTextLabel("<b>" + AppFileDetails.getResourceBundle().getString("details.version") + ": </b> " + string, new HyperlinkTextLabel.HyperlinkHandler(){

            public void processHyperlink(String string) {
            }
        });
        hyperlinkTextLabel.getHTMLPane().setName("version_detail_label");
        return hyperlinkTextLabel.getHTMLPane();
    }

    private static void configureOpacity(JComponent ... jComponentArray) {
        for (JComponent jComponent : jComponentArray) {
            jComponent.setOpaque(false);
        }
    }

    private static void removePopups() {
        OverlayManager overlayManager;
        DTFrame dTFrame = MatlabDesktopServices.getDesktop().getMainFrame();
        if (dTFrame != null && (overlayManager = OverlayManagers.get((Component)dTFrame)) != null) {
            overlayManager.removePopups();
        }
    }

    private JComponent createExpandedTipFilePanel() {
        String[] stringArray = this.fData.getAppEntries();
        int n = stringArray.length;
        CellConstraints cellConstraints = new CellConstraints();
        FormLayout formLayout = new FormLayout("p:grow", "p:grow");
        for (int i = 1; i <= n; ++i) {
            formLayout.appendRow(RowSpec.decode((String)"p:grow"));
        }
        MJPanel mJPanel = new MJPanel((LayoutManager)formLayout);
        AppFileDetails.configureOpacity(new JComponent[]{mJPanel});
        HyperlinkTextLabel.HyperlinkHandler hyperlinkHandler = new HyperlinkTextLabel.HyperlinkHandler(){

            public void processHyperlink(String string) {
                FileLocation fileLocation = new FileLocation(AppFileDetails.this.fLoc.toString());
                FileLocation fileLocation2 = new FileLocation(fileLocation, string);
                String string2 = "uiopen('" + StringUtils.quoteSingleQuotes((String)fileLocation2.toString()) + "',1)";
                new Matlab().evalNoOutput(string2);
                AppFileDetails.removePopups();
                CalloutToolTipManager.getInstance().clear();
            }
        };
        mJPanel.add((Component)new HyperlinkTextLabel("<b>" + AppFileDetails.getResourceBundle().getString("details.viewfilelist") + "</b>", null).getHTMLPane(), (Object)cellConstraints.xy(1, 1));
        for (int i = 0; i < n; ++i) {
            if (MLFileUtils.isMFile((String)stringArray[i])) {
                mJPanel.add((Component)new HyperlinkTextLabel("<a href='" + stringArray[i] + "'>" + stringArray[i] + "</a>", hyperlinkHandler).getHTMLPane(), (Object)cellConstraints.xy(1, i + 2));
                continue;
            }
            mJPanel.add((Component)new HyperlinkTextLabel(stringArray[i], hyperlinkHandler).getHTMLPane(), (Object)cellConstraints.xy(1, i + 2));
        }
        MJPanel mJPanel2 = new MJPanel((LayoutManager)new FormLayout("8dlu,0dlu,p", "p,p"));
        MJButton mJButton = this.createButton(AppFileDetails.getDownArrow(!this.fIsTip));
        mJPanel2.add((Component)mJButton, (Object)cellConstraints.xy(1, 1, CellConstraints.CENTER, CellConstraints.TOP));
        mJPanel2.add((Component)mJPanel, (Object)cellConstraints.xy(3, 1));
        return mJPanel2;
    }

    private JComponent createExpandedNonTipFilePanel() {
        String[] stringArray = this.fData.getAppEntries();
        int n = stringArray.length;
        MJTextArea mJTextArea = new MJTextArea(n + 1, 1);
        mJTextArea.setEditable(false);
        mJTextArea.append(AppFileDetails.getResourceBundle().getString("details.viewfilelist"));
        mJTextArea.append("\n");
        for (int i = 0; i < n; ++i) {
            mJTextArea.append(stringArray[i]);
            if (i == n - 1) continue;
            mJTextArea.append("\n");
        }
        CellConstraints cellConstraints = new CellConstraints();
        MJPanel mJPanel = new MJPanel((LayoutManager)new FormLayout("8dlu,0dlu,p", "p,p"));
        MJButton mJButton = this.createButton(AppFileDetails.getDownArrow(!this.fIsTip));
        mJPanel.add((Component)mJButton, (Object)cellConstraints.xy(1, 1, CellConstraints.CENTER, CellConstraints.TOP));
        mJPanel.add((Component)mJTextArea, (Object)cellConstraints.xy(3, 1));
        return mJPanel;
    }

    private JComponent createCollapsedFilePanel() {
        MJTextArea mJTextArea = new MJTextArea(1, 1);
        mJTextArea.setEditable(false);
        mJTextArea.append(AppFileDetails.getResourceBundle().getString("details.viewfilelist"));
        AppFileDetails.configureOpacity(new JComponent[]{mJTextArea});
        CellConstraints cellConstraints = new CellConstraints();
        MJPanel mJPanel = new MJPanel((LayoutManager)new FormLayout("8dlu,0dlu,p", "p,p"));
        MJButton mJButton = this.createButton(AppFileDetails.getRightArrow(!this.fIsTip));
        mJPanel.add((Component)mJButton, (Object)cellConstraints.xy(1, 1, CellConstraints.CENTER, CellConstraints.TOP));
        mJPanel.add((Component)mJTextArea, (Object)cellConstraints.xy(3, 1));
        return mJPanel;
    }

    private MJButton createButton(Icon icon) {
        MJButton mJButton = new MJButton(icon);
        mJButton.setBorderPainted(false);
        mJButton.setContentAreaFilled(false);
        mJButton.setFocusPainted(false);
        mJButton.setOpaque(false);
        mJButton.setSize(icon.getIconWidth(), icon.getIconHeight());
        mJButton.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (AppFileDetails.this.fArrowDown) {
                    AppFileDetails.this.fArrowDown = false;
                    this.swap(AppFileDetails.this.fExpandedPanel, AppFileDetails.this.fCollapsedPanel);
                } else {
                    AppFileDetails.this.fArrowDown = true;
                    this.swap(AppFileDetails.this.fCollapsedPanel, AppFileDetails.this.fExpandedPanel);
                }
            }

            private void swap(JComponent jComponent, JComponent jComponent2) {
                AppFileDetails.this.fPanel.remove(jComponent);
                AppFileDetails.this.fPanel.add(jComponent2, AppFileDetails.this.fCollapsedPanelConstraints);
                jComponent2.revalidate();
                jComponent2.repaint();
            }
        });
        mJButton.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    // empty if block
                }
            }
        });
        return mJButton;
    }

    static Icon getRightArrow(boolean bl) {
        if (ColorPrefs.getBackgroundColor().getRGB() == Color.BLACK.getRGB() && bl) {
            return IconUtils.changeIconColor((ImageIcon)DocumentIcon.BLACK_RIGHT_ARROW.getIcon(), (Color)Color.WHITE);
        }
        return DocumentIcon.BLACK_RIGHT_ARROW.getIcon();
    }

    static Icon getDownArrow(boolean bl) {
        if (ColorPrefs.getBackgroundColor().getRGB() == Color.BLACK.getRGB() && bl) {
            return IconUtils.changeIconColor((ImageIcon)DocumentIcon.BLACK_DOWN_ARROW.getIcon(), (Color)Color.WHITE);
        }
        return DocumentIcon.BLACK_DOWN_ARROW.getIcon();
    }

    private static ResourceBundle getResourceBundle() {
        return ResourceBundle.getBundle("com.mathworks.appmanagement.resources.RES_Appmanagement");
    }

    private static class AppFileDetailsPanelProviderImpl
    implements AppFileDetailsPanelProvider {
        private final JComponent fComponent;
        private final int fTotalHorizontalInsets;

        AppFileDetailsPanelProviderImpl(JComponent jComponent, int n) {
            this.fComponent = jComponent;
            this.fTotalHorizontalInsets = n;
        }

        @Override
        public JComponent getComponent() {
            return this.fComponent;
        }

        @Override
        public int getTotalHorizontalInsets() {
            return this.fTotalHorizontalInsets;
        }
    }
}

