/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.marker;

import com.jidesoft.filter.AbstractFilter;
import com.jidesoft.icons.IconsFactory;
import com.jidesoft.marker.DefaultMarkerStripePainter;
import com.jidesoft.marker.MarkerArea;
import com.jidesoft.marker.MarkerEye;
import com.jidesoft.marker.MarkerEyePainter;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.ImageIcon;

public class DefaultMarkerEyePainter
implements MarkerEyePainter {
    public void paint(MarkerArea markerArea, Graphics graphics, Rectangle rectangle) {
        ImageIcon imageIcon;
        int n2 = MarkerArea.d;
        Color color = graphics.getColor();
        int n3 = markerArea.getMode();
        if (n2 == 0) {
            switch (n3) {
                case 0: {
                    graphics.setColor(MarkerArea.DEFAULT_FINE_COLOR);
                    if (n2 == 0) break;
                    AbstractFilter.f = !AbstractFilter.f;
                }
                case 100: {
                    graphics.setColor(MarkerArea.DEFAULT_WARNING_COLOR);
                    if (n2 == 0) break;
                }
                case 200: {
                    graphics.setColor(MarkerArea.DEFAULT_ERROR_COLOR);
                }
            }
            ((Graphics2D)graphics).setPaint(new GradientPaint(rectangle.x, rectangle.y, graphics.getColor(), rectangle.width - 1, rectangle.height - 1, graphics.getColor().darker()));
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setColor(Color.DARK_GRAY);
            graphics.drawLine(rectangle.x, rectangle.y, 0, rectangle.height);
            graphics.drawLine(rectangle.x, rectangle.y, rectangle.width, 0);
            graphics.setColor(Color.WHITE);
            graphics.drawLine(0, rectangle.height - 1, rectangle.width - 1, rectangle.height - 1);
            graphics.drawLine(rectangle.width - 1, 0, rectangle.width - 1, rectangle.height - 1);
            graphics.setColor(color);
            n3 = markerArea.isInspecting() ? 1 : 0;
        }
        if (n3 != 0 && (imageIcon = IconsFactory.getImageIcon(DefaultMarkerStripePainter.class, "icons/inspecting.png")) != null) {
            MarkerEye markerEye = markerArea.getMarkerEye();
            imageIcon.paintIcon(markerEye, graphics, (markerEye.getWidth() - imageIcon.getIconWidth()) / 2, (markerEye.getHeight() - imageIcon.getIconHeight()) / 2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getToolTipText(MarkerArea markerArea) {
        MarkerArea markerArea2;
        int n2 = MarkerArea.d;
        int n3 = markerArea.isInspecting();
        if (n2 == 0) {
            if (n3 != 0) {
                return markerArea.getResourceString("MarkerEye.inspecting");
            }
            markerArea2 = markerArea;
            if (n2 != 0) return markerArea2.getResourceString("MarkerEye.noError");
            n3 = markerArea2.getMode();
        }
        switch (n3) {
            case 0: {
                markerArea2 = markerArea;
                return markerArea2.getResourceString("MarkerEye.noError");
            }
            case 100: {
                return markerArea.getResourceString("MarkerEye.warning");
            }
            case 200: {
                return markerArea.getResourceString("MarkerEye.error");
            }
        }
        return null;
    }
}

