/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.status;

import com.google.inject.Inject;
import com.mathworks.install.status.InstallStatusObserverAdapter;
import com.mathworks.instutil.logging.AppLogger;
import java.text.MessageFormat;

public final class LoggingInstallStatusObserver
extends InstallStatusObserverAdapter {
    private final AppLogger appLogger;

    @Inject
    public LoggingInstallStatusObserver(AppLogger appLogger) {
        this.appLogger = appLogger;
    }

    @Override
    public void downloadingProduct(String string, long l) {
        this.appLogger.logMsg(MessageFormat.format("Starting Download: {0} : {1} bytes", string, l));
    }

    @Override
    public void addProduct(String string) {
        this.appLogger.logMsg("Installing Product: " + string);
    }

    @Override
    public void removeProduct(String string) {
        this.appLogger.logMsg("Uninstalling Product: " + string);
    }

    @Override
    public void addComponent(String string) {
        this.appLogger.debugMsg("Installing Component: " + string);
    }

    @Override
    public void removeComponent(String string) {
        this.appLogger.debugMsg("Uninstalling Component: " + string);
    }
}

