/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.input;

import com.mathworks.install.ComponentData;
import com.mathworks.install.input.ComponentSource;
import com.mathworks.install.input.ComponentSourceFactory;
import com.mathworks.install.input.ComponentSourceProvider;
import com.mathworks.install.input.ComponentURLProvider;
import com.mathworks.install.input.DownloadLocationUtility;
import com.mathworks.install.input.InvalidFileSizeException;
import com.mathworks.instutil.Downloader;
import com.mathworks.instutil.IO;
import com.mathworks.instutil.IOObserver;
import com.mathworks.webproxy.ProxyConfiguration;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public final class ComponentDownloader
implements ComponentSourceProvider {
    private final ComponentURLProvider componentURLProvider;
    private final Downloader downloader;
    private final IO io;
    private final ProxyConfiguration proxyConfiguration;
    private final ComponentSourceFactory componentSourceFactory;

    public ComponentDownloader(ComponentURLProvider componentURLProvider, Downloader downloader, IO iO, ProxyConfiguration proxyConfiguration, ComponentSourceFactory componentSourceFactory) {
        this.componentURLProvider = componentURLProvider;
        this.downloader = downloader;
        this.io = iO;
        this.proxyConfiguration = proxyConfiguration;
        this.componentSourceFactory = componentSourceFactory;
    }

    @Override
    public void download(File file, String string, ComponentData componentData, long l, String string2, IOObserver iOObserver) throws IOException, InterruptedException {
        long l2;
        File file2 = this.getTargetFile(file, string, componentData);
        URL uRL = this.getURL(componentData);
        try {
            l2 = this.downloader.download(this.proxyConfiguration, uRL, file2, new IOObserver[]{iOObserver});
        }
        catch (IOException iOException) {
            this.io.logDownloadError(uRL, iOException.getMessage());
            throw iOException;
        }
        if (l2 != l) {
            InvalidFileSizeException invalidFileSizeException = new InvalidFileSizeException(l2, l);
            this.io.logDownloadError(uRL, invalidFileSizeException.getMessage());
            throw invalidFileSizeException;
        }
        this.io.writeStringToFile(string2, this.getTargetFile(file, FilenameUtils.removeExtension((String)string).concat(".xml"), componentData), 0L, 420, new IOObserver[0]);
    }

    private File getTargetFile(File file, String string, ComponentData componentData) {
        File file2 = DownloadLocationUtility.getLocationForComponentArchives(file, componentData);
        return new File(file2, string);
    }

    @Override
    public long getDownloadSize(long l) {
        return l;
    }

    @Override
    public void addComponent(String string) {
        String[] stringArray = string.split(" ");
        this.componentURLProvider.add(stringArray[0], stringArray[1]);
    }

    private URL getURL(ComponentData componentData) throws MalformedURLException {
        return new URL(this.componentURLProvider.getURL(componentData.getName(), componentData.getVersion()));
    }

    @Override
    public void open() throws IOException {
    }

    @Override
    public ComponentSource getComponentSource(File file, String string, ComponentData componentData) throws IOException {
        return this.componentSourceFactory.createArchiveComponentSource(FileUtils.openInputStream((File)this.getTargetFile(file, string, componentData)));
    }

    @Override
    public void close() {
    }
}

