/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.command.doc;

import com.mathworks.install.command.doc.DocSetItemList;
import com.mathworks.install.command.doc.DocSetItemType;
import com.mathworks.install.command.doc.InstalledDocSetItem;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

class DocSetDocumentBuilder {
    private final Document document;

    DocSetDocumentBuilder(DocSetItemList docSetItemList) {
        this.document = DocSetDocumentBuilder.buildDocSetXmlDocument(docSetItemList);
    }

    private static Document buildDocSetXmlDocument(DocSetItemList docSetItemList) {
        Element element = new Element("documentation-set");
        Element element2 = new Element("format");
        element2.setText("doccenter");
        element.addContent((Content)element2);
        for (DocSetItemType docSetItemType : DocSetItemType.values()) {
            List<InstalledDocSetItem> list = docSetItemList.getInstalledDocSetItems(EnumSet.of(docSetItemType));
            if (docSetItemType != DocSetItemType.PRODUCT && (list == null || list.isEmpty())) continue;
            String string = docSetItemType.name().toLowerCase(Locale.ENGLISH);
            Element element3 = new Element(string + "-list");
            for (InstalledDocSetItem installedDocSetItem : list) {
                Element element4 = DocSetDocumentBuilder.buildElement(installedDocSetItem, string);
                element3.addContent((Content)element4);
            }
            element.addContent((Content)element3);
        }
        return new Document(element);
    }

    private static Element buildElement(InstalledDocSetItem installedDocSetItem, String string) {
        Element element = new Element(string);
        Element element2 = new Element("display-name");
        element2.setText(installedDocSetItem.getDisplayName());
        element.addContent((Content)element2);
        Element element3 = new Element("help-location");
        element3.setText(installedDocSetItem.getHelpLoc());
        element.addContent((Content)element3);
        Element element4 = new Element("short-name");
        element4.setText(installedDocSetItem.getShortName());
        element.addContent((Content)element4);
        String string2 = installedDocSetItem.getBaseProductShortName();
        if (string2 != null && !string2.isEmpty()) {
            Element element5 = new Element("base-short-name");
            element5.setText(string2);
            element.addContent((Content)element5);
        }
        return element;
    }

    Document getDocument() {
        return this.document;
    }
}

