/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.command;

import com.mathworks.install.InstallFlowControlHandler;
import com.mathworks.install.command.Command;
import com.mathworks.instutil.Registry;
import com.mathworks.instutil.logging.AppLogger;
import java.io.File;
import java.io.IOException;

final class RegisterAssemblyFolderCommand
implements Command {
    static final String ASSEMBLY_FOLDERS_SUBKEY = "SOFTWARE\\Microsoft\\.NETFramework\\AssemblyFolders\\";
    private final Registry registry;
    private final String keyLocation;
    private final String folderPath;
    private final AppLogger appLogger;

    RegisterAssemblyFolderCommand(Registry registry, String string, String string2, AppLogger appLogger) {
        this.registry = registry;
        this.keyLocation = string;
        this.folderPath = string2;
        this.appLogger = appLogger;
    }

    @Override
    public void execute(String string, File file, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
        String string2 = this.getAssemblyFoldersKey();
        String string3 = this.getFullPathToAssemblyFolder(file);
        this.appLogger.logMsg("setting HKEY_LOCAL_MACHINE\\" + string2 + " to " + string3);
        this.registry.setRegKeyValue("HKEY_LOCAL_MACHINE", string2, "", string3);
    }

    private String getFullPathToAssemblyFolder(File file) {
        return new File(file, this.folderPath).getAbsolutePath();
    }

    @Override
    public void undo(String string, File file, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
        String string2 = this.getAssemblyFoldersKey();
        String string3 = this.getFullPathToAssemblyFolder(file);
        this.appLogger.debugMsg("deleting HKEY_LOCAL_MACHINE\\" + string2);
        this.registry.deleteRegKeyIfValueMatches("HKEY_LOCAL_MACHINE", string2, "", string3);
    }

    private String getAssemblyFoldersKey() {
        return ASSEMBLY_FOLDERS_SUBKEY + this.keyLocation;
    }
}

