/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.command;

import com.mathworks.install.InstallFlowControlHandler;
import com.mathworks.install.command.Command;
import com.mathworks.install.command.ServiceProcessor;
import com.mathworks.install.service.Service;
import com.mathworks.install.service.ServiceException;
import java.io.File;
import java.io.IOException;

final class ProcessServicesCommand
implements Command {
    private final ServiceProcessor processor;
    private final Service[] svcs;

    ProcessServicesCommand(ServiceProcessor serviceProcessor, Service ... serviceArray) {
        this.processor = serviceProcessor;
        this.svcs = (Service[])serviceArray.clone();
    }

    @Override
    public void execute(String string, File file, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
        this.processServices(file, installFlowControlHandler);
    }

    @Override
    public void undo(String string, File file, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
        this.undoProcessServices(file, installFlowControlHandler);
    }

    private void processServices(File file, InstallFlowControlHandler installFlowControlHandler) throws ServiceException {
        for (Service service : this.svcs) {
            this.processor.processService(service, file, installFlowControlHandler);
        }
    }

    private void undoProcessServices(File file, InstallFlowControlHandler installFlowControlHandler) throws ServiceException {
        for (Service service : this.svcs) {
            this.processor.undoProcessService(service, file, installFlowControlHandler);
        }
    }
}

