/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install;

import com.google.inject.Inject;
import com.mathworks.install.Archive;
import com.mathworks.install.InstallerDownloadInfoContainer;
import com.mathworks.install.generated.ArchiveType;
import com.mathworks.install.generated.DownloadDataType;
import com.mathworks.install.generated.ObjectFactory;
import com.mathworks.instutil.InstallerDownloadURLInfo;
import com.mathworks.instutil.Platform;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

final class InstallerDownloadInfoContainerImpl
implements InstallerDownloadInfoContainer {
    private static final String ROOT = "root";
    private Collection<ArchiveType> archiveTypeCollection;
    private Collection<Archive> archiveCollection;
    private Platform platform;

    @Inject
    public InstallerDownloadInfoContainerImpl(Platform platform) {
        this.platform = platform;
    }

    @Override
    public void readInDefinition(InputStream inputStream) throws JAXBException {
        JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
        Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
        JAXBElement jAXBElement = (JAXBElement)unmarshaller.unmarshal(inputStream);
        if (jAXBElement.getValue() != null && ((DownloadDataType)jAXBElement.getValue()).getProductData() != null && ((DownloadDataType)jAXBElement.getValue()).getProductData().getProduct() != null && ((DownloadDataType)jAXBElement.getValue()).getProductData().getProduct().iterator().next().getArchive() != null) {
            this.archiveTypeCollection = ((DownloadDataType)jAXBElement.getValue()).getProductData().getProduct().iterator().next().getArchive();
        }
    }

    @Override
    public long getBytesRequired(File file, String[] stringArray) {
        long l = 0L;
        for (String string : stringArray) {
            for (Archive archive : this.archiveCollection) {
                if (!archive.getPlatform().equals(string) || new File(file, archive.getName()).exists()) continue;
                l += archive.getSize() + archive.getUncompressedSize();
            }
        }
        return l;
    }

    @Override
    public long getDownloadSize(File file, String[] stringArray) {
        long l = 0L;
        for (String string : stringArray) {
            for (Archive archive : this.archiveCollection) {
                if (!archive.getPlatform().equals(string) || new File(file, archive.getName()).exists()) continue;
                l += archive.getSize();
            }
        }
        return l;
    }

    @Override
    public Collection<Archive> getArchiveCollection() {
        return this.archiveCollection;
    }

    @Override
    public void matchURL(InstallerDownloadURLInfo[] installerDownloadURLInfoArray) {
        this.archiveCollection = new ArrayList<Archive>(6);
        for (InstallerDownloadURLInfo installerDownloadURLInfo : installerDownloadURLInfoArray) {
            for (ArchiveType archiveType : this.archiveTypeCollection) {
                if (!archiveType.getName().equals(installerDownloadURLInfo.getInstallerName())) continue;
                this.archiveCollection.add(new Archive(archiveType, installerDownloadURLInfo.getUrl()));
            }
        }
    }

    @Override
    public boolean checkIfInstallingOverSelfOnWindows(Properties properties, File file, String string) throws IOException {
        return this.platform.isWindows() && Files.isSameFile(new File(properties.getProperty(ROOT)).toPath(), file.toPath()) && this.platform.getArchString().equalsIgnoreCase(string);
    }

    @Override
    public String[] getAllInstallerNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ArchiveType archiveType : this.archiveTypeCollection) {
            arrayList.add(archiveType.getName());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

