/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.mathworks.install.InstallConfiguration;
import com.mathworks.install.InstallConfigurationPersistence;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.commons.io.IOUtils;

public final class InstallConfigurationPersistenceImpl
implements InstallConfigurationPersistence {
    private static final String INSTALL_CONFIGURATION_KEY = "installConfiguration";

    @Override
    public void write(InstallConfiguration installConfiguration, File file) throws IOException {
        Properties properties = InstallConfigurationPersistenceImpl.createPropertiesWithInstallConfigurationClassName(installConfiguration);
        InstallConfigurationPersistenceImpl.storeProperties(properties, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeProperties(Properties properties, File file) throws IOException {
        File file2 = InstallConfigurationPersistenceImpl.getBootstrapPropertiesFolder(file);
        File file3 = InstallConfigurationPersistenceImpl.getBootstrapPropertiesFile(file2);
        file2.mkdirs();
        FileOutputStream fileOutputStream = null;
        try {
            file3.setWritable(true);
            fileOutputStream = new FileOutputStream(file3);
            properties.store(fileOutputStream, null);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileOutputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)fileOutputStream);
    }

    private static Properties createPropertiesWithInstallConfigurationClassName(InstallConfiguration installConfiguration) {
        Properties properties = InstallConfigurationPersistenceImpl.createProperties();
        properties.setProperty(INSTALL_CONFIGURATION_KEY, installConfiguration.getClass().getName());
        return properties;
    }

    private static File getBootstrapPropertiesFile(File file) {
        return new File(file, "bootstrap.properties");
    }

    private static Properties createProperties() {
        return new Properties();
    }

    @Override
    public InstallConfiguration load(File file) throws IOException, ClassNotFoundException {
        Properties properties = InstallConfigurationPersistenceImpl.createProperties();
        InstallConfigurationPersistenceImpl.loadProperties(properties, file);
        String string = InstallConfigurationPersistenceImpl.getInstallConfigurationClassName(properties);
        return InstallConfigurationPersistenceImpl.createInstallConfigurationFromClassName(string);
    }

    @Override
    public InstallConfiguration load(String string) throws ClassNotFoundException {
        return InstallConfigurationPersistenceImpl.createInstallConfigurationFromClassName(string);
    }

    private static InstallConfiguration createInstallConfigurationFromClassName(String string) throws ClassNotFoundException {
        final Class<InstallConfiguration> clazz = Class.forName(string).asSubclass(InstallConfiguration.class);
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(InstallConfiguration.class).to(clazz);
            }
        }});
        return (InstallConfiguration)injector.getInstance(InstallConfiguration.class);
    }

    private static String getInstallConfigurationClassName(Properties properties) {
        return properties.getProperty(INSTALL_CONFIGURATION_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadProperties(Properties properties, File file) throws IOException {
        File file2 = InstallConfigurationPersistenceImpl.getBootstrapPropertiesFile(InstallConfigurationPersistenceImpl.getBootstrapPropertiesFolder(file));
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file2);
            properties.load(fileInputStream);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)fileInputStream);
    }

    private static File getBootstrapPropertiesFolder(File file) {
        return new File(file, "uninstall");
    }
}

