/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install;

import com.mathworks.install.Archive;
import com.mathworks.install.AvailableProduct;
import com.mathworks.install.AvailableProductImpl;
import com.mathworks.install.ComponentContainer;
import com.mathworks.install.ComponentSizeAggregator;
import com.mathworks.install.Downloader;
import com.mathworks.install.InstallFlowControlHandler;
import com.mathworks.install.InstallableProduct;
import com.mathworks.install.InstallerDownloadInfoContainer;
import com.mathworks.install.Product;
import com.mathworks.install.ProductComparator;
import com.mathworks.install.ProductContainer;
import com.mathworks.install.ProductDownloader;
import com.mathworks.install.archive.ArchiveInputStreamExtractor;
import com.mathworks.install.status.InstallStatusObserver;
import com.mathworks.instutil.IOObserver;
import com.mathworks.instutil.InstutilResourceKeys;
import com.mathworks.instutil.logging.AppLogger;
import com.mathworks.webproxy.ProxyConfiguration;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;

public class DownloaderImpl
implements Downloader {
    private final String[] archStrings;
    private final AppLogger appLogger;
    private final com.mathworks.instutil.Downloader downloader;
    private final ProxyConfiguration proxyConfiguration;
    private final ArchiveInputStreamExtractor archiveInputStreamExtractor;
    private final InstallerDownloadInfoContainer installerDownloadInfoContainer;
    private final Map<AvailableProduct, InstallableProduct> availableProductMap = new LinkedHashMap<AvailableProduct, InstallableProduct>();
    private final ProductContainer theProductContainer;
    private final Collection<InstallableProduct> nonCustomerFacingProducts = new ArrayList<InstallableProduct>();
    private final ProductDownloader productDownloader;
    private final ComponentContainer componentContainer;
    private final Properties properties;

    DownloaderImpl(String[] stringArray, InstallableProduct[] installableProductArray, ProductContainer productContainer, AppLogger appLogger, ComponentContainer componentContainer, com.mathworks.instutil.Downloader downloader, ProxyConfiguration proxyConfiguration, ArchiveInputStreamExtractor archiveInputStreamExtractor, ProductDownloader productDownloader, Properties properties, InstallerDownloadInfoContainer installerDownloadInfoContainer) {
        InstallableProduct[] installableProductArray2;
        this.archStrings = stringArray;
        this.theProductContainer = productContainer;
        this.appLogger = appLogger;
        this.downloader = downloader;
        this.proxyConfiguration = proxyConfiguration;
        this.archiveInputStreamExtractor = archiveInputStreamExtractor;
        this.installerDownloadInfoContainer = installerDownloadInfoContainer;
        for (InstallableProduct installableProduct : installableProductArray2 = (InstallableProduct[])installableProductArray.clone()) {
            this.addProduct(installableProduct.getProductData());
        }
        this.productDownloader = productDownloader;
        this.componentContainer = componentContainer;
        this.properties = properties;
    }

    @Override
    public long getBytesRequired(File file) {
        if (this.getSelectedAvailableProducts().length == 0) {
            return 0L;
        }
        ComponentSizeAggregator componentSizeAggregator = this.calculateSpaceRequired(this.getAllProductsToBeDownloaded(), file);
        return componentSizeAggregator.getTotalDownloadSize() + this.installerDownloadInfoContainer.getBytesRequired(file, this.archStrings);
    }

    @Override
    public long getDownloadSize(File file) {
        if (this.getSelectedAvailableProducts().length == 0) {
            return 0L;
        }
        return this.calculateSpaceRequired(this.getAllProductsToBeDownloaded(), file).getTotalDownloadSize() + this.installerDownloadInfoContainer.getDownloadSize(file, this.archStrings);
    }

    @Override
    public boolean folderContainsNewerVersion(AvailableProduct availableProduct, File file) {
        return false;
    }

    @Override
    public void addProduct(Product product) {
        InstallableProduct installableProduct = this.theProductContainer.getInstallableProduct(product);
        if (installableProduct.getReleaseFamily().equalsIgnoreCase(InstutilResourceKeys.RELEASE.getString(new Object[0]))) {
            if (installableProduct.isCustomerFacing()) {
                this.availableProductMap.put(new AvailableProductImpl(installableProduct), installableProduct);
            } else {
                this.nonCustomerFacingProducts.add(installableProduct);
            }
        } else {
            this.appLogger.logMsg("Found unsupported release " + installableProduct.getReleaseFamily() + " for product: " + installableProduct.getProductData().getNameVersionReleaseAndReleaseDescription());
        }
    }

    @Override
    public AvailableProduct[] getAvailableProducts() {
        AvailableProduct[] availableProductArray = this.availableProductMap.keySet().toArray(new AvailableProduct[this.availableProductMap.size()]);
        Arrays.sort(availableProductArray, new ProductComparator());
        return availableProductArray;
    }

    @Override
    public AvailableProduct[] getSelectedAvailableProducts() {
        ArrayList<AvailableProduct> arrayList = new ArrayList<AvailableProduct>();
        for (AvailableProduct availableProduct : this.getAvailableProducts()) {
            if (!availableProduct.canInstall()) continue;
            arrayList.add(availableProduct);
        }
        return arrayList.toArray(new AvailableProduct[arrayList.size()]);
    }

    private InstallableProduct[] getAllProductsToBeDownloaded() {
        ArrayList<InstallableProduct> arrayList = new ArrayList<InstallableProduct>();
        ArrayList<InstallableProduct> arrayList2 = new ArrayList<InstallableProduct>();
        for (AvailableProduct availableProduct : this.getSelectedAvailableProducts()) {
            arrayList2.add(this.availableProductMap.get(availableProduct));
        }
        arrayList.addAll(Arrays.asList(arrayList2.toArray(new InstallableProduct[arrayList2.size()])));
        arrayList.addAll(this.nonCustomerFacingProducts);
        return arrayList.toArray(new InstallableProduct[arrayList.size()]);
    }

    private ComponentSizeAggregator calculateSpaceRequired(InstallableProduct[] installableProductArray, File file) {
        ComponentSizeAggregator componentSizeAggregator = new ComponentSizeAggregator();
        this.productDownloader.calculateSpaceRequired(this.archStrings, file, installableProductArray, componentSizeAggregator, this.theProductContainer, this.componentContainer);
        return componentSizeAggregator;
    }

    @Override
    public AvailableProduct[] getIncompatibleProducts(File file) {
        return new AvailableProduct[0];
    }

    @Override
    public boolean isAnyControllingProductSelected() {
        return true;
    }

    @Override
    public void download(File file, InstallFlowControlHandler installFlowControlHandler, InstallStatusObserver ... installStatusObserverArray) throws IOException, InterruptedException {
        InstallableProduct[] installableProductArray = this.getAllProductsToBeDownloaded();
        this.productDownloader.downloadProducts(this.archStrings, file, installableProductArray, installFlowControlHandler, this.componentContainer, this.theProductContainer, installStatusObserverArray);
        this.downloadingInstallerIfNecessary(file, installFlowControlHandler, installStatusObserverArray);
        for (InstallStatusObserver installStatusObserver : installStatusObserverArray) {
            installStatusObserver.finished();
        }
    }

    private void downloadingInstallerIfNecessary(File file, final InstallFlowControlHandler installFlowControlHandler, final InstallStatusObserver[] installStatusObserverArray) throws InterruptedException, IOException {
        for (Archive archive : this.installerDownloadInfoContainer.getArchiveCollection()) {
            File file2 = new File(file, archive.getName());
            if (file2.exists()) continue;
            this.appLogger.logMsg("Starting Download: Installer " + file2.getAbsolutePath());
            this.downloader.download(this.proxyConfiguration, archive.getArchiveDownloadUrl(), file2, new IOObserver[]{new IOObserver(){

                public boolean updateBytes(long l) throws InterruptedException {
                    for (InstallStatusObserver installStatusObserver : installStatusObserverArray) {
                        installStatusObserver.downloadingInstaller(l);
                    }
                    return installFlowControlHandler.checkTaskState();
                }
            }});
            if (this.installerDownloadInfoContainer.checkIfInstallingOverSelfOnWindows(this.properties, file, archive.getPlatform())) continue;
            this.archiveInputStreamExtractor.extract(FileUtils.openInputStream((File)file2), file, installFlowControlHandler, installStatusObserverArray);
        }
    }

    @Override
    public Product[] getDependencies() {
        HashMap<Integer, Product> hashMap = new HashMap<Integer, Product>();
        for (InstallableProduct installableProduct : this.getAllProductsToBeDownloaded()) {
            for (Product product : installableProduct.getRequiredProducts()) {
                hashMap.put(product.getProductNumber(), product);
            }
        }
        return hashMap.values().toArray(new Product[hashMap.size()]);
    }

    @Override
    public Product[] getDependencySatisfiers(File file) {
        HashSet<Product> hashSet = new HashSet<Product>();
        hashSet.addAll(Arrays.asList(this.getAllProductsAlreadyDownloaded()));
        hashSet.addAll(Arrays.asList(this.getAllSelectedProducts()));
        return hashSet.toArray(new Product[hashSet.size()]);
    }

    private Product[] getAllSelectedProducts() {
        return DownloaderImpl.getProducts(this.getAllProductsToBeDownloaded());
    }

    private Product[] getAllProductsAlreadyDownloaded() {
        HashSet<AvailableProduct> hashSet = new HashSet<AvailableProduct>();
        for (AvailableProduct availableProduct : this.availableProductMap.keySet()) {
            if (availableProduct.getDownloadSize() != 0L) continue;
            hashSet.add(availableProduct);
        }
        return hashSet.toArray(new Product[hashSet.size()]);
    }

    private static Product[] getProducts(InstallableProduct[] installableProductArray) {
        ArrayList<Product> arrayList = new ArrayList<Product>();
        for (InstallableProduct installableProduct : installableProductArray) {
            arrayList.add(installableProduct.getProductData());
        }
        return arrayList.toArray(new Product[arrayList.size()]);
    }
}

