/*
 * Decompiled with CFR 0.152.
 */
package net.jini.jeri.ssl;

import com.sun.jini.action.GetLongAction;
import com.sun.jini.jeri.internal.connection.BasicServerConnManager;
import com.sun.jini.jeri.internal.connection.ServerConnManager;
import com.sun.jini.jeri.internal.runtime.Util;
import com.sun.jini.logging.Levels;
import com.sun.jini.thread.Executor;
import com.sun.jini.thread.GetThreadPoolAction;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.Permission;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.security.auth.Subject;
import javax.security.auth.x500.X500Principal;
import javax.security.auth.x500.X500PrivateCredential;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.io.UnsupportedConstraintException;
import net.jini.jeri.Endpoint;
import net.jini.jeri.RequestDispatcher;
import net.jini.jeri.ServerEndpoint;
import net.jini.jeri.connection.InboundRequestHandle;
import net.jini.jeri.connection.ServerConnection;
import net.jini.jeri.ssl.ConnectionContext;
import net.jini.jeri.ssl.ServerAuthManager;
import net.jini.jeri.ssl.SslEndpoint;
import net.jini.jeri.ssl.SslServerEndpoint;
import net.jini.jeri.ssl.SubjectCredentials;
import net.jini.jeri.ssl.Utilities;
import net.jini.security.AuthenticationPermission;
import net.jini.security.Security;
import net.jini.security.SecurityContext;

class SslServerEndpointImpl
extends Utilities {
    static final Logger logger;
    static long maxServerSessionDuration;
    static final Executor systemExecutor;
    private static final ServerConnManager defaultServerConnectionManager;
    final ServerEndpoint serverEndpoint;
    final Subject serverSubject;
    final Set serverPrincipals;
    final String serverHost;
    final int port;
    final SocketFactory socketFactory;
    final ServerSocketFactory serverSocketFactory;
    Permission[] listenPermissions;
    private final ServerEndpoint.ListenEndpoint listenEndpoint;
    private SSLSocketFactory sslSocketFactory;
    private ServerAuthManager authManager;
    ServerConnManager serverConnectionManager = defaultServerConnectionManager;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$javax$security$auth$x500$X500Principal;
    static /* synthetic */ Class class$java$security$cert$CertPath;
    static /* synthetic */ Class class$net$jini$jeri$ssl$SslServerEndpointImpl$SslListenHandle;
    static /* synthetic */ Class class$net$jini$jeri$ssl$SslServerEndpointImpl$SslServerConnection;

    SslServerEndpointImpl(ServerEndpoint serverEndpoint, Subject subject, X500Principal[] x500PrincipalArray, String string, int n, SocketFactory socketFactory, ServerSocketFactory serverSocketFactory) {
        boolean bl;
        this.serverEndpoint = serverEndpoint;
        boolean bl2 = bl = subject == null;
        if (bl) {
            final AccessControlContext accessControlContext = AccessController.getContext();
            subject = (Subject)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Subject.getSubject(accessControlContext);
                }
            });
        }
        Set set = this.serverPrincipals = x500PrincipalArray == null ? SslServerEndpointImpl.computePrincipals(subject) : SslServerEndpointImpl.checkPrincipals(x500PrincipalArray);
        if (this.serverPrincipals == null) {
            this.listenPermissions = null;
        } else {
            this.listenPermissions = new AuthenticationPermission[this.serverPrincipals.size()];
            int n2 = 0;
            Iterator iterator = this.serverPrincipals.iterator();
            while (iterator.hasNext()) {
                Principal principal = (Principal)iterator.next();
                this.listenPermissions[n2] = new AuthenticationPermission(Collections.singleton(principal), null, "listen");
                ++n2;
            }
        }
        if (this.serverPrincipals == null || bl && x500PrincipalArray != null && !this.hasListenPermissions()) {
            this.serverSubject = null;
            this.listenPermissions = null;
        } else {
            this.serverSubject = subject;
        }
        this.serverHost = string;
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("Invalid port: " + n);
        }
        this.port = n;
        this.socketFactory = socketFactory;
        this.serverSocketFactory = serverSocketFactory;
        this.listenEndpoint = this.createListenEndpoint();
    }

    private static Set computePrincipals(Subject subject) {
        if (subject == null) {
            return null;
        }
        X500PrivateCredential[] x500PrivateCredentialArray = (X500PrivateCredential[])AccessController.doPrivileged(new SubjectCredentials.GetAllPrivateCredentialsAction(subject));
        Set set = SubjectCredentials.getPrincipals(subject, -1, x500PrivateCredentialArray);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Principal principal = (Principal)iterator.next();
                try {
                    securityManager.checkPermission(new AuthenticationPermission(Collections.singleton(principal), null, "listen"));
                }
                catch (SecurityException securityException) {
                    logger.log(Levels.HANDLED, "compute principals for server endpoint caught exception", securityException);
                    iterator.remove();
                }
            }
        }
        return set.isEmpty() ? null : set;
    }

    private boolean hasListenPermissions() {
        try {
            this.checkListenPermissions(false);
            return true;
        }
        catch (SecurityException securityException) {
            logger.log(Levels.HANDLED, "check listen permissions for server endpoint caught exception", securityException);
            return false;
        }
    }

    private static Set checkPrincipals(X500Principal[] x500PrincipalArray) {
        if (x500PrincipalArray.length == 0) {
            return null;
        }
        HashSet<X500Principal> hashSet = new HashSet<X500Principal>(x500PrincipalArray.length);
        int n = x500PrincipalArray.length;
        while (--n >= 0) {
            X500Principal x500Principal = x500PrincipalArray[n];
            if (x500Principal == null) {
                throw new NullPointerException("Server principal cannot be null");
            }
            hashSet.add(x500Principal);
        }
        return hashSet;
    }

    private void sslInit() {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        Utilities.SSLContextInfo sSLContextInfo = SslServerEndpointImpl.getServerSSLContextInfo(this.serverSubject, this.serverPrincipals);
        this.sslSocketFactory = sSLContextInfo.sslContext.getSocketFactory();
        this.authManager = (ServerAuthManager)sSLContextInfo.authManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final SSLSocketFactory getSSLSocketFactory() {
        SslServerEndpointImpl sslServerEndpointImpl = this;
        synchronized (sslServerEndpointImpl) {
            if (this.sslSocketFactory == null) {
                this.sslInit();
            }
        }
        return this.sslSocketFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ServerAuthManager getAuthManager() {
        SslServerEndpointImpl sslServerEndpointImpl = this;
        synchronized (sslServerEndpointImpl) {
            if (this.authManager == null) {
                this.sslInit();
            }
        }
        return this.authManager;
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ System.identityHashCode(this.serverSubject) ^ (this.serverPrincipals == null ? 0 : this.serverPrincipals.hashCode()) ^ (this.serverHost == null ? 0 : this.serverHost.hashCode()) ^ this.port ^ (this.socketFactory != null ? this.socketFactory.hashCode() : 0) ^ (this.serverSocketFactory != null ? this.serverSocketFactory.hashCode() : 0);
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        SslServerEndpointImpl sslServerEndpointImpl = (SslServerEndpointImpl)object;
        return this.serverSubject == sslServerEndpointImpl.serverSubject && SslServerEndpointImpl.safeEquals(this.serverPrincipals, sslServerEndpointImpl.serverPrincipals) && SslServerEndpointImpl.safeEquals(this.serverHost, sslServerEndpointImpl.serverHost) && this.port == sslServerEndpointImpl.port && Util.sameClassAndEquals(this.socketFactory, sslServerEndpointImpl.socketFactory) && Util.sameClassAndEquals(this.serverSocketFactory, sslServerEndpointImpl.serverSocketFactory);
    }

    public String toString() {
        return SslServerEndpointImpl.getClassName(this) + this.fieldsToString();
    }

    final String fieldsToString() {
        return "[" + (this.serverPrincipals == null ? "" : this.serverPrincipals.toString() + ", ") + (this.serverHost == null ? "" : this.serverHost + ":") + this.port + (this.serverSocketFactory != null ? ", " + this.serverSocketFactory : "") + (this.socketFactory != null ? ", " + this.socketFactory : "") + "]";
    }

    final InvocationConstraints checkConstraints(InvocationConstraints invocationConstraints) throws UnsupportedConstraintException {
        Collection<String> collection;
        Object object;
        Object object2;
        try {
            this.checkListenPermissions(false);
        }
        catch (SecurityException securityException) {
            if (logger.isLoggable(Levels.FAILED)) {
                SslServerEndpointImpl.logThrow(logger, Levels.FAILED, SslServerEndpoint.class, "checkConstraints", "check constraints for {0}\nwith {1}\nthrows", new Object[]{this, invocationConstraints}, securityException);
            }
            throw securityException;
        }
        Set<Principal> set = SslServerEndpointImpl.getClientPrincipals(invocationConstraints);
        if (set == null) {
            set = Collections.singleton(UNKNOWN_PRINCIPAL);
        }
        HashMap<Object, ArrayList<String>> hashMap = new HashMap<Object, ArrayList<String>>();
        List list = SubjectCredentials.getCertificateChains(this.serverSubject);
        if (list != null) {
            int n = list.size();
            while (--n >= 0) {
                CertPath certPath = (CertPath)list.get(n);
                object2 = SubjectCredentials.firstX509Cert(certPath);
                object = SubjectCredentials.getPrincipal(this.serverSubject, (X509Certificate)object2);
                if (object == null) continue;
                collection = (Collection)hashMap.get(object);
                if (collection == null) {
                    collection = new ArrayList<String>(1);
                    hashMap.put(object, (ArrayList<String>)collection);
                }
                collection.add(((Certificate)object2).getPublicKey().getAlgorithm());
            }
        }
        String[] stringArray = SslServerEndpointImpl.getSupportedCipherSuites();
        int n = stringArray.length;
        while (--n >= 0) {
            X500Principal x500Principal;
            object2 = stringArray[n];
            object = SslServerEndpointImpl.getKeyAlgorithm((String)object2);
            collection = (this.serverPrincipals == null ? Collections.EMPTY_SET : this.serverPrincipals).iterator();
            do {
                Principal principal;
                Object object3;
                if (collection.hasNext()) {
                    x500Principal = (X500Principal)collection.next();
                    if (!$assertionsDisabled && x500Principal == null) {
                        throw new AssertionError();
                    }
                    object3 = (Collection)hashMap.get(x500Principal);
                    if (object3 == null || !object3.contains(object)) {
                        continue;
                    }
                } else {
                    x500Principal = null;
                }
                object3 = set.iterator();
                do {
                    InvocationConstraints invocationConstraints2;
                    if (object3.hasNext()) {
                        principal = object3.next();
                        if (!$assertionsDisabled && principal == null) {
                            throw new AssertionError();
                        }
                    } else {
                        principal = null;
                    }
                    if ((invocationConstraints2 = SslServerEndpointImpl.getUnfulfilledConstraints((String)object2, principal, x500Principal, invocationConstraints)) == null) continue;
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "check constraints for {0}\nwith {1}\nreturns {2}", new Object[]{this.serverEndpoint, invocationConstraints, invocationConstraints2});
                    }
                    return invocationConstraints2;
                } while (principal != null);
            } while (x500Principal != null);
        }
        UnsupportedConstraintException unsupportedConstraintException = new UnsupportedConstraintException("Constraints are not supported: " + invocationConstraints);
        if (logger.isLoggable(Levels.FAILED)) {
            SslServerEndpointImpl.logThrow(logger, Levels.FAILED, SslServerEndpoint.class, "checkConstraints", "check constraints for {0}\nwith {1}\nthrows", new Object[]{this.serverEndpoint, invocationConstraints}, unsupportedConstraintException);
        }
        throw unsupportedConstraintException;
    }

    static InvocationConstraints getUnfulfilledConstraints(String string, Principal principal, Principal principal2, InvocationConstraints invocationConstraints) {
        boolean bl = false;
        int n = 2;
        while (--n >= 0) {
            boolean bl2 = n == 0;
            ConnectionContext connectionContext = ConnectionContext.getInstance(string, principal, principal2, bl2, false, invocationConstraints);
            if (connectionContext == null) continue;
            if (connectionContext.getIntegrityRequired()) {
                return INTEGRITY_REQUIRED;
            }
            if (connectionContext.getIntegrityPreferred()) {
                return INTEGRITY_PREFERRED;
            }
            bl = true;
        }
        return bl ? InvocationConstraints.EMPTY : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Endpoint enumerateListenEndpoints(ServerEndpoint.ListenContext listenContext) throws IOException {
        Object object;
        block9: {
            Exception exception = null;
            try {
                Object object2;
                String string = this.serverHost;
                if (string == null) {
                    try {
                        object2 = (InetAddress)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws UnknownHostException {
                                return InetAddress.getLocalHost();
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        exception = (Exception)privilegedActionException.getCause();
                        throw (UnknownHostException)exception;
                    }
                    object = System.getSecurityManager();
                    if (object != null) {
                        try {
                            ((SecurityManager)object).checkConnect(((InetAddress)object2).getHostName(), -1);
                        }
                        catch (SecurityException securityException) {
                            exception = securityException;
                            throw new SecurityException("Access to resolve local host denied");
                        }
                    }
                    string = ((InetAddress)object2).getHostAddress();
                }
                object2 = this.createEndpoint(string, this.checkCookie(listenContext.addListenEndpoint(this.listenEndpoint)));
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "enumerate listen endpoints for {0}\nreturns {1}", new Object[]{this, object2});
                }
                object = object2;
                Object var8_8 = null;
                if (exception == null || !logger.isLoggable(Levels.FAILED)) break block9;
                SslServerEndpointImpl.logThrow(logger, Levels.FAILED, SslServerEndpointImpl.class, "enumerateListenEndpoints", "enumerate listen endpoints for {0}\nthrows", new Object[]{this}, exception);
            }
            catch (Throwable throwable) {
                block10: {
                    Object var8_9 = null;
                    if (exception == null || !logger.isLoggable(Levels.FAILED)) break block10;
                    SslServerEndpointImpl.logThrow(logger, Levels.FAILED, SslServerEndpointImpl.class, "enumerateListenEndpoints", "enumerate listen endpoints for {0}\nthrows", new Object[]{this}, exception);
                }
                throw throwable;
            }
        }
        return object;
    }

    ServerEndpoint.ListenEndpoint createListenEndpoint() {
        return new SslListenEndpoint();
    }

    Endpoint createEndpoint(String string, SslListenCookie sslListenCookie) {
        return SslEndpoint.getInstance(string, sslListenCookie.getPort(), this.socketFactory);
    }

    private SslListenCookie checkCookie(ServerEndpoint.ListenCookie listenCookie) {
        if (!(listenCookie instanceof SslListenCookie)) {
            throw new IllegalArgumentException("Cookie must be of type SslListenCookie: " + listenCookie);
        }
        SslListenCookie sslListenCookie = (SslListenCookie)listenCookie;
        ServerEndpoint serverEndpoint = sslListenCookie.getServerEndpoint();
        if (!this.serverEndpoint.equals(serverEndpoint)) {
            throw new IllegalArgumentException("Cookie has wrong server endpoint: found " + serverEndpoint + ", expected " + this.serverEndpoint);
        }
        return sslListenCookie;
    }

    final void checkListenPermissions(boolean bl) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (bl) {
                securityManager.checkListen(this.port);
            }
            if (this.listenPermissions != null) {
                int n = this.listenPermissions.length;
                while (--n >= 0) {
                    securityManager.checkPermission(this.listenPermissions[n]);
                }
            }
        }
    }

    static {
        $assertionsDisabled = !SslServerEndpointImpl.class.desiredAssertionStatus();
        logger = serverLogger;
        maxServerSessionDuration = (Long)Security.doPrivileged(new GetLongAction("com.sun.jini.jeri.ssl.maxServerSessionDuration", 86400000L));
        systemExecutor = (Executor)Security.doPrivileged(new GetThreadPoolAction(false));
        defaultServerConnectionManager = new BasicServerConnManager();
    }

    class SslServerConnection
    extends Utilities
    implements ServerConnection {
        private final SslListenHandle listenHandle;
        final SSLSocket sslSocket;
        private final InboundRequestHandle requestHandle = new InboundRequestHandle(){};
        private SSLSession session;
        private Subject clientSubject;
        private X500Principal clientPrincipal;
        private X500Principal serverPrincipal;
        private AuthenticationPermission authPermission;
        private String cipherSuite;
        boolean closed;

        SslServerConnection(SslListenHandle sslListenHandle, Socket socket) throws IOException {
            this.listenHandle = sslListenHandle;
            this.sslSocket = (SSLSocket)SslServerEndpointImpl.this.getSSLSocketFactory().createSocket(socket, socket.getInetAddress().getHostName(), socket.getPort(), true);
            this.sslSocket.setEnabledCipherSuites(SslServerConnection.getSupportedCipherSuites());
            this.sslSocket.setUseClientMode(false);
            this.sslSocket.setWantClientAuth(true);
            logger.log(Level.FINE, "created {0}", this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            String string;
            SslServerConnection sslServerConnection = this;
            synchronized (sslServerConnection) {
                string = this.session == null ? "" : this.session + ", ";
            }
            return SslServerConnection.getClassName(this) + "[" + string + SslServerEndpointImpl.this.serverHost + ":" + this.sslSocket.getLocalPort() + "<=" + this.sslSocket.getInetAddress().getHostName() + ":" + this.sslSocket.getPort() + "]";
        }

        public InputStream getInputStream() throws IOException {
            return this.sslSocket.getInputStream();
        }

        public OutputStream getOutputStream() throws IOException {
            return this.sslSocket.getOutputStream();
        }

        public SocketChannel getChannel() {
            return null;
        }

        public InboundRequestHandle processRequestData(InputStream inputStream, OutputStream outputStream) {
            SecurityException securityException;
            if (inputStream == null || outputStream == null) {
                throw new NullPointerException("Arguments cannot be null");
            }
            try {
                long l = System.currentTimeMillis();
                this.decacheSession();
                long l2 = this.session.getCreationTime();
                long l3 = l2 + maxServerSessionDuration;
                if (l3 < l2) {
                    l3 = Long.MAX_VALUE;
                }
                if (l3 < l) {
                    this.session.invalidate();
                    throw new SecurityException("Session has expired");
                }
                if (this.serverPrincipal != null) {
                    SslServerEndpointImpl.this.getAuthManager().checkCredentials(this.session, this.clientSubject);
                }
                return this.requestHandle;
            }
            catch (SecurityException securityException2) {
                securityException = securityException2;
            }
            catch (GeneralSecurityException generalSecurityException) {
                securityException = new SecurityException(generalSecurityException.getMessage());
                securityException.initCause(generalSecurityException);
            }
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (logger.isLoggable(Levels.FAILED)) {
                SslServerConnection.logThrow(logger, Levels.FAILED, class$net$jini$jeri$ssl$SslServerEndpointImpl$SslServerConnection == null ? (class$net$jini$jeri$ssl$SslServerEndpointImpl$SslServerConnection = SslServerEndpointImpl.class$("net.jini.jeri.ssl.SslServerEndpointImpl$SslServerConnection")) : class$net$jini$jeri$ssl$SslServerEndpointImpl$SslServerConnection, "processRequestData", "process request data for session {0}\nclient {1}\nthrows", new Object[]{this.session, SslServerConnection.subjectString(this.clientSubject)}, securityException);
            }
            throw securityException;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void decacheSession() {
            SslServerConnection sslServerConnection = this;
            synchronized (sslServerConnection) {
                SSLSession sSLSession = this.sslSocket.getSession();
                if (this.session == sSLSession) {
                    return;
                }
                if (this.session != null) {
                    throw new SecurityException("New handshake occurred on socket");
                }
                this.session = sSLSession;
                this.sslSocket.setEnableSessionCreation(false);
                this.cipherSuite = this.session.getCipherSuite();
                if ("NULL".equals(SslServerConnection.getKeyExchangeAlgorithm(this.cipherSuite))) {
                    throw new SecurityException("Handshake failed");
                }
                this.clientSubject = this.getClientSubject(this.sslSocket);
                this.clientPrincipal = this.clientSubject != null ? (X500Principal)this.clientSubject.getPrincipals().iterator().next() : null;
                X509Certificate x509Certificate = SslServerEndpointImpl.this.getAuthManager().getServerCertificate(this.session);
                X500Principal x500Principal = this.serverPrincipal = x509Certificate != null ? x509Certificate.getSubjectX500Principal() : null;
                if (this.serverPrincipal != null) {
                    this.authPermission = new AuthenticationPermission(Collections.singleton(this.serverPrincipal), this.clientPrincipal != null ? Collections.singleton(this.clientPrincipal) : null, "accept");
                }
            }
        }

        private Subject getClientSubject(SSLSocket sSLSocket) {
            SSLSession sSLSession = sSLSocket.getSession();
            try {
                Certificate[] certificateArray = sSLSession.getPeerCertificates();
                if (certificateArray != null && certificateArray.length > 0 && certificateArray[0] instanceof X509Certificate) {
                    X509Certificate x509Certificate = (X509Certificate)certificateArray[0];
                    return new Subject(true, Collections.singleton(x509Certificate.getSubjectX500Principal()), Collections.singleton(SslServerConnection.getCertFactory().generateCertPath(Arrays.asList(certificateArray))), Collections.EMPTY_SET);
                }
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            }
            catch (CertificateException certificateException) {
                logger.log(Levels.HANDLED, "get client subject caught exception", certificateException);
            }
            return null;
        }

        public void checkPermissions(InboundRequestHandle inboundRequestHandle) {
            this.check(inboundRequestHandle);
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                try {
                    securityManager.checkAccept(this.sslSocket.getInetAddress().getHostName(), this.sslSocket.getPort());
                    if (this.authPermission != null) {
                        securityManager.checkPermission(this.authPermission);
                    }
                }
                catch (SecurityException securityException) {
                    if (logger.isLoggable(Levels.FAILED)) {
                        SslServerConnection.logThrow(logger, Levels.FAILED, class$net$jini$jeri$ssl$SslServerEndpointImpl$SslServerConnection == null ? (class$net$jini$jeri$ssl$SslServerEndpointImpl$SslServerConnection = SslServerEndpointImpl.class$("net.jini.jeri.ssl.SslServerEndpointImpl$SslServerConnection")) : class$net$jini$jeri$ssl$SslServerEndpointImpl$SslServerConnection, "checkPermissions", "check permissions for {0} throws", new Object[]{this}, securityException);
                    }
                    throw securityException;
                }
            }
        }

        private void check(InboundRequestHandle inboundRequestHandle) {
            if (inboundRequestHandle == null) {
                throw new NullPointerException("Request handle cannot be null");
            }
            if (inboundRequestHandle != this.requestHandle) {
                throw new IllegalArgumentException("Wrong request handle: found " + inboundRequestHandle + ", expected " + this.requestHandle);
            }
        }

        public InvocationConstraints checkConstraints(InboundRequestHandle inboundRequestHandle, InvocationConstraints invocationConstraints) throws UnsupportedConstraintException {
            this.check(inboundRequestHandle);
            if (invocationConstraints == null) {
                throw new NullPointerException("Constraints cannot be null");
            }
            InvocationConstraints invocationConstraints2 = SslServerEndpointImpl.getUnfulfilledConstraints(this.cipherSuite, this.clientPrincipal, this.serverPrincipal, invocationConstraints);
            if (invocationConstraints2 == null) {
                UnsupportedConstraintException unsupportedConstraintException = new UnsupportedConstraintException("Constraints are not supported: " + invocationConstraints);
                if (logger.isLoggable(Levels.FAILED)) {
                    SslServerConnection.logThrow(logger, Levels.FAILED, class$net$jini$jeri$ssl$SslServerEndpointImpl$SslServerConnection == null ? (class$net$jini$jeri$ssl$SslServerEndpointImpl$SslServerConnection = SslServerEndpointImpl.class$("net.jini.jeri.ssl.SslServerEndpointImpl$SslServerConnection")) : class$net$jini$jeri$ssl$SslServerEndpointImpl$SslServerConnection, "checkConstraints", "check constraints for {0}\nwith {1}\nthrows", new Object[]{this, invocationConstraints}, unsupportedConstraintException);
                }
                throw unsupportedConstraintException;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "check constraints for {0}\nwith {1}\nreturns {2}", new Object[]{this, invocationConstraints, invocationConstraints2});
            }
            return invocationConstraints2;
        }

        public void populateContext(InboundRequestHandle inboundRequestHandle, Collection collection) {
            this.check(inboundRequestHandle);
            Util.populateContext(collection, this.sslSocket.getInetAddress());
            Util.populateContext(collection, this.clientSubject);
        }

        public void close() throws IOException {
            this.closeInternal(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void closeInternal(boolean bl) throws IOException {
            SslServerConnection sslServerConnection = this;
            synchronized (sslServerConnection) {
                if (this.closed) {
                    return;
                }
                logger.log(Level.FINE, "closing {0}", this);
                this.closed = true;
                this.sslSocket.close();
            }
            if (bl) {
                this.listenHandle.noteConnectionClosed(this);
            }
        }
    }

    final class SslListenCookie
    implements ServerEndpoint.ListenCookie {
        private final int port;

        SslListenCookie(int n) {
            this.port = n;
        }

        final int getPort() {
            return this.port;
        }

        final ServerEndpoint getServerEndpoint() {
            return SslServerEndpointImpl.this.serverEndpoint;
        }
    }

    class SslListenHandle
    extends Utilities
    implements ServerEndpoint.ListenHandle {
        private final RequestDispatcher requestDispatcher;
        final ServerSocket serverSocket;
        private final SecurityContext securityContext;
        private boolean closed = false;
        private final Set connections = new HashSet();
        private long acceptFailureTime = 0L;
        private int acceptFailureCount;

        SslListenHandle(RequestDispatcher requestDispatcher, ServerSocket serverSocket) throws IOException {
            this.requestDispatcher = requestDispatcher;
            this.serverSocket = serverSocket;
            this.securityContext = Security.getContext();
            systemExecutor.execute(new Runnable(){

                public void run() {
                    SslListenHandle.this.acceptLoop();
                }
            }, this.toString());
            logger.log(Level.FINE, "created {0}", this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void acceptLoop() {
            block23: {
                Throwable throwable;
                while (true) {
                    boolean bl;
                    Socket socket = null;
                    SslServerConnection sslServerConnection = null;
                    try {
                        socket = this.serverSocket.accept();
                        try {
                            socket.setTcpNoDelay(true);
                        }
                        catch (SocketException socketException) {
                            // empty catch block
                        }
                        try {
                            socket.setKeepAlive(true);
                        }
                        catch (SocketException socketException) {
                            // empty catch block
                        }
                        sslServerConnection = this.serverConnection(socket);
                        Utilities utilities = this;
                        synchronized (utilities) {
                            if (this.closed) {
                                try {
                                    sslServerConnection.closeInternal(false);
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                                break block23;
                            }
                            this.connections.add(sslServerConnection);
                        }
                        utilities = sslServerConnection;
                        AccessController.doPrivileged(this.securityContext.wrap(new PrivilegedAction((SslServerConnection)utilities){
                            private final /* synthetic */ SslServerConnection val$finalConnection;
                            {
                                this.val$finalConnection = sslServerConnection;
                            }

                            public Object run() {
                                SslListenHandle.this.handleConnection(this.val$finalConnection, SslListenHandle.this.requestDispatcher);
                                return null;
                            }
                        }), this.securityContext.getAccessControlContext());
                        continue;
                    }
                    catch (Exception exception) {
                        throwable = exception;
                    }
                    catch (Error error) {
                        throwable = error;
                    }
                    Object object = this;
                    synchronized (object) {
                        bl = this.closed;
                    }
                    if (!bl && logger.isLoggable(Level.INFO)) {
                        object = "handling connection {0} throws";
                        Utilities utilities = sslServerConnection;
                        if (sslServerConnection == null) {
                            object = "accepting connection on {0} throws";
                            utilities = this;
                        }
                        SslListenHandle.logThrow(logger, Level.INFO, class$net$jini$jeri$ssl$SslServerEndpointImpl$SslListenHandle == null ? SslServerEndpointImpl.class$("net.jini.jeri.ssl.SslServerEndpointImpl$SslListenHandle") : class$net$jini$jeri$ssl$SslServerEndpointImpl$SslListenHandle, "acceptLoop", (String)object, new Object[]{utilities}, throwable);
                    }
                    if (socket != null) {
                        try {
                            socket.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (bl) break block23;
                    boolean bl2 = (throwable instanceof Exception || throwable instanceof OutOfMemoryError || throwable instanceof NoClassDefFoundError) && this.continueAfterAcceptFailure(throwable);
                    if (!bl2) break;
                }
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                return;
            }
        }

        private boolean continueAfterAcceptFailure(Throwable throwable) {
            long l = System.currentTimeMillis();
            if (this.acceptFailureTime == 0L || l - this.acceptFailureTime > 5000L) {
                this.acceptFailureTime = l;
                this.acceptFailureCount = 0;
            } else {
                ++this.acceptFailureCount;
                if (this.acceptFailureCount >= 10) {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            return true;
        }

        public String toString() {
            return SslListenHandle.getClassName(this) + "[" + SslServerEndpointImpl.this.serverHost + ":" + this.getPort() + "]";
        }

        SslServerConnection serverConnection(Socket socket) throws IOException {
            return new SslServerConnection(this, socket);
        }

        void handleConnection(SslServerConnection sslServerConnection, RequestDispatcher requestDispatcher) {
            SslServerEndpointImpl.this.serverConnectionManager.handleConnection(sslServerConnection, requestDispatcher);
        }

        private int getPort() {
            return this.serverSocket.getLocalPort();
        }

        public synchronized void close() {
            if (!this.closed) {
                logger.log(Level.FINE, "closing {0}", this);
                this.closed = true;
                try {
                    this.serverSocket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                Iterator iterator = this.connections.iterator();
                while (iterator.hasNext()) {
                    SslServerConnection sslServerConnection = (SslServerConnection)iterator.next();
                    try {
                        sslServerConnection.closeInternal(false);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    iterator.remove();
                }
            }
        }

        synchronized void noteConnectionClosed(SslServerConnection sslServerConnection) {
            this.connections.remove(sslServerConnection);
        }

        public ServerEndpoint.ListenCookie getCookie() {
            return new SslListenCookie(this.getPort());
        }
    }

    class SslListenEndpoint
    extends Utilities
    implements ServerEndpoint.ListenEndpoint {
        SslListenEndpoint() {
        }

        public void checkPermissions() {
            SslServerEndpointImpl.this.checkListenPermissions(true);
        }

        public ServerEndpoint.ListenHandle listen(RequestDispatcher requestDispatcher) throws IOException {
            if (requestDispatcher == null) {
                throw new NullPointerException("Request dispatcher cannot be null");
            }
            this.checkCredentials();
            ServerSocket serverSocket = SslServerEndpointImpl.this.serverSocketFactory != null ? SslServerEndpointImpl.this.serverSocketFactory.createServerSocket(SslServerEndpointImpl.this.port) : new ServerSocket(SslServerEndpointImpl.this.port);
            return this.createListenHandle(requestDispatcher, serverSocket);
        }

        private void checkCredentials() throws UnsupportedConstraintException {
            CertPath certPath;
            Object object;
            if (SslServerEndpointImpl.this.serverSubject == null) {
                return;
            }
            SslServerEndpointImpl.this.checkListenPermissions(false);
            Set<Principal> set = SslServerEndpointImpl.this.serverSubject.getPrincipals();
            HashMap<X500Principal, Serializable> hashMap = new HashMap<X500Principal, Serializable>(SslServerEndpointImpl.this.serverPrincipals.size());
            X500PrivateCredential[] x500PrivateCredentialArray = SslServerEndpointImpl.this.serverPrincipals.iterator();
            while (x500PrivateCredentialArray.hasNext()) {
                object = (X500Principal)x500PrivateCredentialArray.next();
                if (!set.contains(object)) {
                    throw new UnsupportedConstraintException("Missing principal: " + object);
                }
                hashMap.put((X500Principal)object, class$javax$security$auth$x500$X500Principal == null ? SslServerEndpointImpl.class$("javax.security.auth.x500.X500Principal") : class$javax$security$auth$x500$X500Principal);
            }
            x500PrivateCredentialArray = (X500PrivateCredential[])AccessController.doPrivileged(new SubjectCredentials.GetAllPrivateCredentialsAction(SslServerEndpointImpl.this.serverSubject));
            object = SubjectCredentials.getCertificateChains(SslServerEndpointImpl.this.serverSubject);
            if (object != null) {
                int n = object.size();
                block3: while (--n >= 0) {
                    certPath = (CertPath)object.get(n);
                    X509Certificate x509Certificate = SslListenEndpoint.firstX509Cert(certPath);
                    X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
                    if (!hashMap.containsKey(x500Principal)) continue;
                    try {
                        SslListenEndpoint.checkValidity(certPath, null);
                    }
                    catch (CertificateException certificateException) {
                        hashMap.put(x500Principal, certificateException);
                        continue;
                    }
                    hashMap.put(x500Principal, class$java$security$cert$CertPath == null ? SslServerEndpointImpl.class$("java.security.cert.CertPath") : class$java$security$cert$CertPath);
                    int n2 = x500PrivateCredentialArray.length;
                    while (--n2 >= 0) {
                        X509Certificate x509Certificate2 = x500PrivateCredentialArray[n2].getCertificate();
                        if (!x509Certificate.equals(x509Certificate2)) continue;
                        hashMap.remove(x500Principal);
                        continue block3;
                    }
                }
            }
            if (!hashMap.isEmpty()) {
                X500Principal x500Principal = (X500Principal)hashMap.keySet().iterator().next();
                certPath = hashMap.get(x500Principal);
                if (certPath == (class$javax$security$auth$x500$X500Principal == null ? (class$javax$security$auth$x500$X500Principal = SslServerEndpointImpl.class$("javax.security.auth.x500.X500Principal")) : class$javax$security$auth$x500$X500Principal)) {
                    throw new UnsupportedConstraintException("Missing public credentials: " + x500Principal);
                }
                if (certPath == (class$java$security$cert$CertPath == null ? (class$java$security$cert$CertPath = SslServerEndpointImpl.class$("java.security.cert.CertPath")) : class$java$security$cert$CertPath)) {
                    throw new UnsupportedConstraintException("Missing private credentials: " + x500Principal);
                }
                throw new UnsupportedConstraintException("Problem with certificates: " + x500Principal + "\n" + certPath, (CertificateException)((Object)certPath));
            }
        }

        ServerEndpoint.ListenHandle createListenHandle(RequestDispatcher requestDispatcher, ServerSocket serverSocket) throws IOException {
            return new SslListenHandle(requestDispatcher, serverSocket);
        }

        public int hashCode() {
            return this.getClass().hashCode() ^ System.identityHashCode(SslServerEndpointImpl.this.serverSubject) ^ (SslServerEndpointImpl.this.serverPrincipals == null ? 0 : SslServerEndpointImpl.this.serverPrincipals.hashCode()) ^ SslServerEndpointImpl.this.port ^ (SslServerEndpointImpl.this.serverSocketFactory != null ? SslServerEndpointImpl.this.serverSocketFactory.hashCode() : 0);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            SslServerEndpointImpl sslServerEndpointImpl = ((SslListenEndpoint)object).getImpl();
            return SslServerEndpointImpl.this.serverSubject == sslServerEndpointImpl.serverSubject && SslListenEndpoint.safeEquals(SslServerEndpointImpl.this.serverPrincipals, sslServerEndpointImpl.serverPrincipals) && SslServerEndpointImpl.this.port == sslServerEndpointImpl.port && Util.sameClassAndEquals(SslServerEndpointImpl.this.serverSocketFactory, sslServerEndpointImpl.serverSocketFactory);
        }

        private SslServerEndpointImpl getImpl() {
            return SslServerEndpointImpl.this;
        }
    }
}

