/*
 * Decompiled with CFR 0.152.
 */
package net.jini.jeri.ssl;

import java.security.Principal;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import net.jini.core.constraint.ClientAuthentication;
import net.jini.core.constraint.ClientMaxPrincipal;
import net.jini.core.constraint.ClientMaxPrincipalType;
import net.jini.core.constraint.ClientMinPrincipal;
import net.jini.core.constraint.ClientMinPrincipalType;
import net.jini.core.constraint.Confidentiality;
import net.jini.core.constraint.ConnectionAbsoluteTime;
import net.jini.core.constraint.ConnectionRelativeTime;
import net.jini.core.constraint.ConstraintAlternatives;
import net.jini.core.constraint.Delegation;
import net.jini.core.constraint.DelegationAbsoluteTime;
import net.jini.core.constraint.DelegationRelativeTime;
import net.jini.core.constraint.Integrity;
import net.jini.core.constraint.InvocationConstraint;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.core.constraint.ServerAuthentication;
import net.jini.core.constraint.ServerMinPrincipal;
import net.jini.jeri.ssl.ConfidentialityStrength;
import net.jini.jeri.ssl.Utilities;

final class ConnectionContext
extends Utilities {
    private static final long OK = Long.MAX_VALUE;
    private static final long INTEGRITY = -3L;
    private static final long NOT_SUPPORTED = -4L;
    private static final ClientMinPrincipalType clientMinPrincipalType = new ClientMinPrincipalType(X500Principal.class);
    final String cipherSuite;
    final Principal client;
    final Principal server;
    private final boolean integrity;
    private final boolean clientSide;
    private boolean notSupported;
    private boolean integrityRequired;
    private boolean integrityPreferred;
    private long connectionTime = Long.MAX_VALUE;
    private int preferences;

    static ConnectionContext getInstance(String string, Principal principal, Principal principal2, boolean bl, boolean bl2, InvocationConstraints invocationConstraints) {
        ConnectionContext connectionContext = new ConnectionContext(string, principal, principal2, bl, bl2);
        return connectionContext.supported(invocationConstraints) ? connectionContext : null;
    }

    private ConnectionContext(String string, Principal principal, Principal principal2, boolean bl, boolean bl2) {
        this.cipherSuite = string;
        this.client = principal;
        this.server = principal2;
        this.integrity = bl;
        this.clientSide = bl2;
        boolean bl3 = ConnectionContext.doesServerAuthentication(string);
        if (bl3 != (principal2 != null) || principal != null && principal2 == null) {
            this.notSupported = true;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("ConnectionContext[");
        this.fieldsToString(stringBuffer);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    void fieldsToString(StringBuffer stringBuffer) {
        stringBuffer.append(this.cipherSuite);
        if (this.client != null) {
            stringBuffer.append(", client: ").append(this.client);
        }
        if (this.server != null) {
            stringBuffer.append(", server: ").append(this.server);
        }
        if (this.integrityRequired) {
            stringBuffer.append(", integrity: required");
        } else if (this.integrityPreferred) {
            stringBuffer.append(", integrity: preferred");
        }
        if (this.connectionTime != Long.MAX_VALUE) {
            stringBuffer.append(", connectionTime = ").append(this.connectionTime);
        }
        stringBuffer.append(", preferences: ").append(this.preferences);
    }

    boolean getIntegrityRequired() {
        return this.integrityRequired;
    }

    boolean getIntegrityPreferred() {
        return this.integrityPreferred;
    }

    long getConnectionTime() {
        return this.connectionTime;
    }

    int getPreferences() {
        return this.preferences;
    }

    private boolean supported(InvocationConstraints invocationConstraints) {
        long l;
        if (this.notSupported) {
            return false;
        }
        Iterator iterator = invocationConstraints.requirements().iterator();
        while (iterator.hasNext()) {
            l = this.supported((InvocationConstraint)iterator.next());
            if (l == -4L) {
                return false;
            }
            if (l == -3L) {
                this.integrityRequired = true;
                continue;
            }
            if (this.connectionTime <= l) continue;
            this.connectionTime = l;
        }
        iterator = invocationConstraints.preferences().iterator();
        while (iterator.hasNext()) {
            l = this.supported((InvocationConstraint)iterator.next());
            if (l == -4L) continue;
            ++this.preferences;
            if (l == -3L) {
                if (this.integrityRequired) continue;
                this.integrityPreferred = true;
                continue;
            }
            if (this.connectionTime <= l) continue;
            this.connectionTime = l;
        }
        return !this.integrity || this.integrityRequired || this.integrityPreferred;
    }

    private long supported(InvocationConstraint invocationConstraint) {
        if (invocationConstraint instanceof ConstraintAlternatives) {
            return this.supported((ConstraintAlternatives)invocationConstraint);
        }
        if (invocationConstraint instanceof Integrity) {
            return this.integrity && invocationConstraint == Integrity.YES ? -3L : -4L;
        }
        if (invocationConstraint instanceof Confidentiality) {
            return ConnectionContext.ok(ConnectionContext.doesEncryption(this.cipherSuite) == (invocationConstraint == Confidentiality.YES));
        }
        if (invocationConstraint instanceof ConfidentialityStrength) {
            return ConnectionContext.ok(!ConnectionContext.doesEncryption(this.cipherSuite) || ConnectionContext.hasStrongCipherAlgorithm(this.cipherSuite) == (invocationConstraint == ConfidentialityStrength.STRONG));
        }
        if (invocationConstraint instanceof ClientAuthentication) {
            return ConnectionContext.ok(this.client == null == (invocationConstraint == ClientAuthentication.NO));
        }
        if (invocationConstraint instanceof ClientMinPrincipalType) {
            return ConnectionContext.ok(this.client == null || invocationConstraint.equals(clientMinPrincipalType));
        }
        if (invocationConstraint instanceof ClientMaxPrincipalType) {
            return ConnectionContext.ok(this.client == null || ((ClientMaxPrincipalType)invocationConstraint).elements().contains(X500Principal.class));
        }
        if (invocationConstraint instanceof ClientMinPrincipal) {
            if (this.client == null) {
                return Long.MAX_VALUE;
            }
            Set set = ((ClientMinPrincipal)invocationConstraint).elements();
            return ConnectionContext.ok(set.size() == 1 && set.contains(this.client));
        }
        if (invocationConstraint instanceof ClientMaxPrincipal) {
            return ConnectionContext.ok(this.client == null || ((ClientMaxPrincipal)invocationConstraint).elements().contains(this.client));
        }
        if (invocationConstraint instanceof Delegation) {
            return ConnectionContext.ok(this.client == null || invocationConstraint == Delegation.NO);
        }
        if (invocationConstraint instanceof DelegationAbsoluteTime) {
            return Long.MAX_VALUE;
        }
        if (invocationConstraint instanceof DelegationRelativeTime) {
            return ConnectionContext.ok(!this.clientSide);
        }
        if (invocationConstraint instanceof ServerAuthentication) {
            return ConnectionContext.ok(this.server == null == (invocationConstraint == ServerAuthentication.NO));
        }
        if (invocationConstraint instanceof ServerMinPrincipal) {
            if (this.server == null) {
                return Long.MAX_VALUE;
            }
            Set set = ((ServerMinPrincipal)invocationConstraint).elements();
            return ConnectionContext.ok(set.size() == 1 && set.contains(this.server));
        }
        if (invocationConstraint instanceof ConnectionAbsoluteTime) {
            return Math.max(((ConnectionAbsoluteTime)invocationConstraint).getTime(), 0L);
        }
        if (invocationConstraint instanceof ConnectionRelativeTime) {
            return ConnectionContext.ok(!this.clientSide);
        }
        return -4L;
    }

    private static long ok(boolean bl) {
        return bl ? Long.MAX_VALUE : -4L;
    }

    private long supported(ConstraintAlternatives constraintAlternatives) {
        Set set = constraintAlternatives.elements();
        long l = -1L;
        Class<?> clazz = null;
        boolean bl = false;
        boolean bl2 = false;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            long l2;
            InvocationConstraint invocationConstraint = (InvocationConstraint)iterator.next();
            if (clazz == null) {
                clazz = invocationConstraint.getClass();
            } else if (clazz != invocationConstraint.getClass()) {
                return -4L;
            }
            if ((l2 = this.supported(invocationConstraint)) == -4L) continue;
            bl = true;
            if (l2 == -3L) {
                bl2 = true;
                continue;
            }
            if (l2 <= l) continue;
            l = l2;
        }
        if (!bl) {
            return -4L;
        }
        if (bl2) {
            return -3L;
        }
        if (l >= 0L) {
            return l;
        }
        return Long.MAX_VALUE;
    }
}

