/*
 * Decompiled with CFR 0.152.
 */
package net.jini.discovery;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import net.jini.core.lookup.ServiceID;

public class IncomingMulticastRequest {
    protected InetAddress addr;
    protected int port;
    protected ServiceID[] serviceIDs;
    protected String[] groups;
    protected final int protoVersion = 1;

    public IncomingMulticastRequest(DatagramPacket datagramPacket) throws IOException {
        int n;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(datagramPacket.getData());
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        int n2 = dataInputStream.readInt();
        if (n2 != 1) {
            throw new IOException("unsupported protocol version: " + n2);
        }
        this.port = dataInputStream.readInt();
        if (this.port <= 0 || this.port >= 65536) {
            throw new IOException("port number out of range: " + this.port);
        }
        int n3 = dataInputStream.readInt();
        if (n3 < 0 || n3 > byteArrayInputStream.available() / 8) {
            throw new IOException("service ID count invalid: " + n3);
        }
        this.serviceIDs = new ServiceID[n3];
        for (n = 0; n < this.serviceIDs.length; ++n) {
            this.serviceIDs[n] = new ServiceID(dataInputStream);
        }
        n = dataInputStream.readInt();
        if (n < 0 || n > byteArrayInputStream.available() / 2) {
            throw new IOException("group count invalid: " + n);
        }
        this.groups = new String[n];
        for (int i = 0; i < this.groups.length; ++i) {
            this.groups[i] = dataInputStream.readUTF();
        }
        this.addr = datagramPacket.getAddress();
    }

    public InetAddress getAddress() {
        return this.addr;
    }

    public int getPort() {
        return this.port;
    }

    public String[] getGroups() {
        return this.groups;
    }

    public ServiceID[] getServiceIDs() {
        return this.serviceIDs;
    }

    public int hashCode() {
        int n;
        byte[] byArray = this.addr.getAddress();
        int n2 = byArray[0] << 3 ^ byArray[1] << 7 ^ byArray[2] << 5 ^ byArray[3] << 1 ^ ~this.port;
        for (n = 0; n < this.groups.length; ++n) {
            n2 ^= this.groups[n].hashCode() << n;
        }
        for (n = 0; n < this.serviceIDs.length; ++n) {
            n2 ^= this.serviceIDs[n].hashCode() << n;
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (object instanceof IncomingMulticastRequest) {
            IncomingMulticastRequest incomingMulticastRequest = (IncomingMulticastRequest)object;
            if (incomingMulticastRequest.addr.equals(this.addr) && incomingMulticastRequest.port == this.port && incomingMulticastRequest.groups.length == this.groups.length && incomingMulticastRequest.serviceIDs.length == this.serviceIDs.length) {
                int n;
                for (n = 0; n < this.groups.length; ++n) {
                    if (this.groups[n].equals(incomingMulticastRequest.groups[n])) continue;
                    return false;
                }
                for (n = 0; n < this.serviceIDs.length; ++n) {
                    if (this.serviceIDs[n].equals(incomingMulticastRequest.serviceIDs[n])) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }
}

