/*
 * Decompiled with CFR 0.152.
 */
package net.jini.constraint;

import java.rmi.RemoteException;
import java.security.Principal;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.x500.X500Principal;
import net.jini.constraint.BasicMethodConstraints;
import net.jini.core.constraint.ClientAuthentication;
import net.jini.core.constraint.ClientMaxPrincipal;
import net.jini.core.constraint.ClientMaxPrincipalType;
import net.jini.core.constraint.ClientMinPrincipal;
import net.jini.core.constraint.ClientMinPrincipalType;
import net.jini.core.constraint.Confidentiality;
import net.jini.core.constraint.ConstraintAlternatives;
import net.jini.core.constraint.Delegation;
import net.jini.core.constraint.DelegationAbsoluteTime;
import net.jini.core.constraint.DelegationRelativeTime;
import net.jini.core.constraint.Integrity;
import net.jini.core.constraint.InvocationConstraint;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.core.constraint.ServerAuthentication;
import net.jini.core.constraint.ServerMinPrincipal;
import net.jini.security.TrustVerifier;

public class ConstraintTrustVerifier
implements TrustVerifier {
    public boolean isTrustedObject(Object object, TrustVerifier.Context context) throws RemoteException {
        if (object == null || context == null) {
            throw new NullPointerException();
        }
        if (object instanceof InvocationConstraint) {
            Class<?> clazz = object.getClass();
            if (clazz == ServerAuthentication.class || clazz == ClientAuthentication.class || clazz == Confidentiality.class || clazz == Integrity.class || clazz == ClientMinPrincipalType.class || clazz == ClientMaxPrincipalType.class || clazz == Delegation.class || clazz == DelegationRelativeTime.class || clazz == DelegationAbsoluteTime.class) {
                return true;
            }
            if (clazz == ServerMinPrincipal.class) {
                return ConstraintTrustVerifier.trusted(((ServerMinPrincipal)object).elements(), context);
            }
            if (clazz == ClientMinPrincipal.class) {
                return ConstraintTrustVerifier.trusted(((ClientMinPrincipal)object).elements(), context);
            }
            if (clazz == ClientMaxPrincipal.class) {
                return ConstraintTrustVerifier.trusted(((ClientMaxPrincipal)object).elements(), context);
            }
            if (clazz == ConstraintAlternatives.class) {
                return ConstraintTrustVerifier.trusted(((ConstraintAlternatives)object).elements(), context);
            }
            return false;
        }
        if (object instanceof BasicMethodConstraints) {
            return ConstraintTrustVerifier.trusted(((BasicMethodConstraints)object).possibleConstraints(), context);
        }
        if (object instanceof InvocationConstraints) {
            InvocationConstraints invocationConstraints = (InvocationConstraints)object;
            return ConstraintTrustVerifier.trusted(invocationConstraints.requirements(), context) && ConstraintTrustVerifier.trusted(invocationConstraints.preferences(), context);
        }
        if (object instanceof Principal) {
            Class<?> clazz = object.getClass();
            return clazz == X500Principal.class || clazz == KerberosPrincipal.class;
        }
        return false;
    }

    private static boolean trusted(Set set, TrustVerifier.Context context) throws RemoteException {
        return ConstraintTrustVerifier.trusted(set.iterator(), context);
    }

    private static boolean trusted(Iterator iterator, TrustVerifier.Context context) throws RemoteException {
        while (iterator.hasNext()) {
            if (context.isTrustedObject(iterator.next())) continue;
            return false;
        }
        return true;
    }
}

