/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.discovery.internal;

import com.sun.jini.discovery.ClientSubjectChecker;
import com.sun.jini.discovery.DatagramBufferFactory;
import com.sun.jini.discovery.DiscoveryProtocolException;
import com.sun.jini.discovery.MulticastAnnouncement;
import com.sun.jini.discovery.MulticastAnnouncementEncoder;
import com.sun.jini.discovery.MulticastRequest;
import com.sun.jini.discovery.MulticastRequestDecoder;
import com.sun.jini.discovery.internal.Plaintext;
import com.sun.jini.discovery.internal.X500Constraints;
import com.sun.jini.discovery.internal.X500Provider;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.logging.Level;
import javax.security.auth.Subject;
import javax.security.auth.x500.X500Principal;
import javax.security.auth.x500.X500PrivateCredential;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.io.UnsupportedConstraintException;

public class X500Server
extends X500Provider
implements MulticastRequestDecoder,
MulticastAnnouncementEncoder {
    protected X500Server(String string, String string2, int n, String string3, String string4) throws NoSuchAlgorithmException {
        super(string, string2, n, string3, string4);
    }

    public MulticastRequest decodeMulticastRequest(ByteBuffer byteBuffer, InvocationConstraints invocationConstraints, ClientSubjectChecker clientSubjectChecker) throws IOException {
        try {
            ByteBuffer byteBuffer2;
            X500Constraints x500Constraints = X500Constraints.process(invocationConstraints, true);
            int n = byteBuffer.getInt();
            ByteBuffer byteBuffer3 = byteBuffer.duplicate();
            byteBuffer3.limit(byteBuffer3.position() + n);
            byteBuffer.position(byteBuffer3.limit());
            X500Principal x500Principal = new X500Principal(Plaintext.getUtf(byteBuffer));
            if (x500Constraints.checkClientPrincipal(x500Principal) < 0) {
                throw new UnsupportedConstraintException("principal not allowed: " + x500Principal);
            }
            Certificate certificate = this.getCertificate(x500Principal);
            if (certificate == null) {
                throw new DiscoveryProtocolException("unknown principal: " + x500Principal);
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "mapped principal {0} to {1}", new Object[]{x500Principal, certificate});
            }
            if (!this.verify(byteBuffer2 = (ByteBuffer)byteBuffer3.duplicate().position(0), byteBuffer, certificate.getPublicKey())) {
                throw new DiscoveryProtocolException("signature verification failed: " + x500Principal);
            }
            if (clientSubjectChecker != null) {
                clientSubjectChecker.checkClientSubject(new Subject(true, Collections.singleton(x500Principal), Collections.singleton(certificate), Collections.EMPTY_SET));
            }
            return Plaintext.decodeMulticastRequest(byteBuffer3);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        catch (Exception exception) {
            throw new DiscoveryProtocolException(null, exception);
        }
    }

    public void encodeMulticastAnnouncement(MulticastAnnouncement multicastAnnouncement, DatagramBufferFactory datagramBufferFactory, InvocationConstraints invocationConstraints) throws IOException {
        if (multicastAnnouncement == null || datagramBufferFactory == null) {
            throw new NullPointerException();
        }
        try {
            X500Constraints x500Constraints = X500Constraints.process(invocationConstraints, false);
            X500PrivateCredential[] x500PrivateCredentialArray = this.getPrivateCredentials();
            X500PrivateCredential x500PrivateCredential = null;
            int n = -1;
            for (int i = 0; i < x500PrivateCredentialArray.length; ++i) {
                X500PrivateCredential x500PrivateCredential2 = x500PrivateCredentialArray[i];
                X500Principal x500Principal = x500PrivateCredential2.getCertificate().getSubjectX500Principal();
                int n2 = x500Constraints.checkServerPrincipal(x500Principal);
                if (n2 < 0) {
                    if (!logger.isLoggable(Level.FINEST)) continue;
                    logger.log(Level.FINEST, "skipping disallowed principal {0}", new Object[]{x500Principal});
                    continue;
                }
                try {
                    this.checkAuthenticationPermission(x500Principal, "accept");
                }
                catch (SecurityException securityException) {
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.log(Level.FINE, "not authorized to use principal {0}", new Object[]{x500Principal});
                    continue;
                }
                if (n2 <= n) continue;
                x500PrivateCredential = x500PrivateCredential2;
                n = n2;
            }
            if (x500PrivateCredential == null) {
                throw new UnsupportedConstraintException("unsupported constraints: " + invocationConstraints);
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "using principal {0}", new Object[]{x500PrivateCredential});
            }
            X500Provider.SigningBufferFactory signingBufferFactory = new X500Provider.SigningBufferFactory(datagramBufferFactory, x500PrivateCredential);
            Plaintext.encodeMulticastAnnouncement(multicastAnnouncement, signingBufferFactory);
            signingBufferFactory.sign();
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        catch (Exception exception) {
            throw new DiscoveryProtocolException(null, exception);
        }
    }
}

