/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jcp.utils;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.SwingUtilities;
import sun.misc.BASE64Encoder;

public class MouseUtils {
    private static final String[] CURSOR_MAP = new String[14];

    public static void moved(Component component, int x, int y, int modifiers) {
        MouseUtils.dispatchMouseEvent(component, 503, x, y, modifiers, 0, 0, false);
    }

    public static void scrolled(Component component, int x, int y, int zoom) {
        MouseUtils.dispatchMouseEvent(component, 507, x, y, 0, 0, zoom, false);
    }

    public static void dragged(Component component, int x, int y, int modifiers, int buttons) {
        MouseUtils.dispatchMouseEvent(component, 506, x, y, modifiers, buttons, 0, false);
    }

    public static void pressed(Component component, int x, int y, int modifiers, int buttons, int count) {
        MouseUtils.dispatchMouseEvent(component, 501, x, y, modifiers, buttons, count, MouseUtils.shouldTriggerPopup(buttons));
    }

    public static void released(Component component, int x, int y, int modifiers, int buttons, int count) {
        MouseUtils.dispatchMouseEvent(component, 502, x, y, modifiers, buttons, count, MouseUtils.shouldTriggerPopup(buttons));
    }

    public static void clicked(Component component, int x, int y, int modifiers, int buttons, int count) {
        MouseUtils.dispatchMouseEvent(component, 500, x, y, modifiers, buttons, count, MouseUtils.shouldTriggerPopup(buttons));
    }

    public static void mouseEntered(Component component) {
        Rectangle r = component.getBounds();
        MouseUtils.dispatchMouseEvent(component, 504, r.x + r.width / 2, r.y + r.height / 2, 0, 0, 0, false);
    }

    public static void mouseExited(Component component) {
        Rectangle r = component.getBounds();
        MouseUtils.dispatchMouseEvent(component, 505, r.x + r.width / 2, r.y + r.height / 2, 0, 0, 0, false);
    }

    private static void dispatchMouseEvent(final Component component, final int type, final int x, final int y, final int modifiers, final int buttons, final int count, final boolean popup) {
        if (SwingUtilities.isEventDispatchThread()) {
            MouseUtils.doDispatchMouseEvent(component, type, x, y, modifiers, buttons, count, popup);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        MouseUtils.doDispatchMouseEvent(component, type, x, y, modifiers, buttons, count, popup);
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void doDispatchMouseEvent(Component component, int type, int x, int y, int modifiers, int buttons, int count, boolean popup) {
        Component target = MouseUtils.getChildComponentAt(component, x, y);
        Point targetPoint = SwingUtilities.convertPoint(component, x, y, target);
        if (type == 507) {
            MouseWheelEvent event = new MouseWheelEvent(target, type, new Date().getTime(), modifiers | buttons, targetPoint.x, targetPoint.y, 0, popup, 0, count, count);
            target.dispatchEvent(event);
        } else {
            MouseEvent event = new MouseEvent(target, type, new Date().getTime(), modifiers | buttons, targetPoint.x, targetPoint.y, count, popup, MouseUtils.getButton(buttons));
            target.dispatchEvent(event);
        }
    }

    private static boolean shouldTriggerPopup(int buttons) {
        return (buttons & 4 | buttons & 0x1000) > 0;
    }

    private static Component getChildComponentAt(Component component, int x, int y) {
        Object target = null;
        return target == null ? component : target;
    }

    private static int getButton(int buttons) {
        if ((buttons & 0x10 | buttons & 0x400) > 0) {
            return 1;
        }
        if ((buttons & 8 | buttons & 0x800) > 0) {
            return 2;
        }
        if ((buttons & 4 | buttons & 0x1000) > 0) {
            return 3;
        }
        return 0;
    }

    public static void performClick(Component component, int x, int y, int modifiers, int buttons, int clickCount) {
        for (int i = 1; i <= clickCount; ++i) {
            MouseUtils.pressed(component, x, y, modifiers, buttons, i);
            MouseUtils.released(component, x, y, modifiers, buttons, i);
            MouseUtils.clicked(component, x, y, modifiers, buttons, i);
        }
    }

    public static Map<String, Object> getCursor(Component component) {
        Cursor cursor = component.getCursor();
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (cursor.getType() == -1) {
            Field image = null;
            try {
                image = cursor.getClass().getSuperclass().getDeclaredField("image");
            }
            catch (Exception ignore) {
                try {
                    image = cursor.getClass().getSuperclass().getSuperclass().getDeclaredField("image");
                }
                catch (NoSuchFieldException e) {
                    e.printStackTrace();
                }
            }
            try {
                if (image != null) {
                    image.setAccessible(true);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    ImageIO.write((RenderedImage)((BufferedImage)image.get(cursor)), "png", baos);
                    byte[] bytesOut = baos.toByteArray();
                    BASE64Encoder base64Encoder = new BASE64Encoder();
                    String cursorImage = base64Encoder.encode(bytesOut);
                    cursorImage = cursorImage.replaceAll("\\s", "");
                    data.put("customCursor", cursorImage);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        } else if (cursor.getType() >= 0 && cursor.getType() < CURSOR_MAP.length) {
            data.put("cursor", CURSOR_MAP[cursor.getType()]);
        } else {
            data.put("cursor", cursor.getName());
        }
        return data;
    }

    static {
        MouseUtils.CURSOR_MAP[0] = "default";
        MouseUtils.CURSOR_MAP[1] = "crosshair";
        MouseUtils.CURSOR_MAP[2] = "text";
        MouseUtils.CURSOR_MAP[3] = "wait";
        MouseUtils.CURSOR_MAP[4] = "sw-resize";
        MouseUtils.CURSOR_MAP[5] = "se-resize";
        MouseUtils.CURSOR_MAP[6] = "nw-resize";
        MouseUtils.CURSOR_MAP[7] = "ne-resize";
        MouseUtils.CURSOR_MAP[8] = "n-resize";
        MouseUtils.CURSOR_MAP[9] = "s-resize";
        MouseUtils.CURSOR_MAP[10] = "w-resize";
        MouseUtils.CURSOR_MAP[11] = "e-resize";
        MouseUtils.CURSOR_MAP[12] = "pointer";
        MouseUtils.CURSOR_MAP[13] = "move";
    }
}

