/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jcp.handlers.tableHandlers;

import com.mathworks.matlabserver.jcp.handlers.tableHandlers.JTableHandler;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class ScrollPaneTableHandler
extends JTableHandler
implements TableModelListener {
    @Override
    protected JTable getTable(Component component) {
        return (JTable)((JScrollPane)component).getViewport().getComponent(0);
    }

    @Override
    protected void setTableHeaderAndBorderProperties(Map<String, Object> tableProperties) {
        super.setTableHeaderAndBorderProperties(tableProperties);
        JViewport rowViewport = ((JScrollPane)this.component).getRowHeader();
        if (rowViewport != null && rowViewport.getComponentCount() > 0) {
            JTable currentRowHeader = (JTable)rowViewport.getComponent(0);
            if (currentRowHeader != this.rowHeader) {
                if (this.rowHeader != null) {
                    this.rowHeader.getModel().removeTableModelListener(this);
                }
                this.rowHeader = currentRowHeader;
                this.rowHeader.getModel().addTableModelListener(this);
            }
            TableModel rowModel = this.rowHeader.getModel();
            ArrayList<String> rows = new ArrayList<String>(rowModel.getRowCount());
            for (int i = 0; i < rowModel.getRowCount(); ++i) {
                rows.add(rowModel.getValueAt(i, 0).toString());
            }
            tableProperties.put("rows", rows);
            tableProperties.put("rowHeaderWidth", this.rowHeader.getColumnModel().getColumn(0).getWidth());
            tableProperties.put("showRowHeaders", rowViewport.isVisible());
        } else {
            tableProperties.put("rows", new ArrayList());
            tableProperties.put("rowHeaderWidth", 0);
            tableProperties.put("showRowHeaders", false);
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.markDirty();
    }
}

