/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jcp.handlers.containerHandlers;

import com.mathworks.matlabserver.jcp.handlers.Handler;
import com.mathworks.matlabserver.jcp.handlers.containerHandlers.AbstractTabContainerHandler;
import com.mathworks.matlabserver.jcp.utils.ObservableRepaintManager;
import com.mathworks.matlabserver.jcp.utils.RepaintListener;
import com.mathworks.peermodel.PeerNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JTabbedPaneHandler
extends AbstractTabContainerHandler
implements RepaintListener {
    private float[] color = new float[3];
    private JTabbedPane tabbedPane = null;
    private ChangeListener selectionChangeListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            JTabbedPaneHandler.this.markDirty();
        }
    };

    @Override
    protected void setSelectedIndex(int tabId) {
        this.tabbedPane.setSelectedIndex(tabId);
    }

    @Override
    protected int getSelectedIndex() {
        return this.tabbedPane.getSelectedIndex();
    }

    @Override
    protected Map<String, Object> doGetProperties(Component component) {
        Map<String, Object> props = super.doGetProperties(component);
        props.put("insets", ((JTabbedPane)component).getInsets());
        Border border = ((JTabbedPane)component).getBorder();
        if (border != null && border instanceof LineBorder) {
            Color lineColor = ((LineBorder)border).getLineColor();
            props.put("borderType", "LineBorder");
            props.put("borderColor", lineColor.getRGBColorComponents(this.color));
            props.put("borderWidth", ((LineBorder)border).getThickness());
        }
        return props;
    }

    @Override
    public void handle(Handler parentHandler, Component component, PeerNode parent) {
        this.tabbedPane = (JTabbedPane)component;
        super.handle(parentHandler, component, parent);
    }

    @Override
    protected void doAddChild(Component child, PeerNode peerNode, Container container) {
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            if (this.tabbedPane.getComponentAt(i) != child) continue;
            super.doAddChild(child, peerNode, container);
        }
    }

    @Override
    protected int getChildContentPaneProperties(Component child, Container container, Map<String, Object> tabProps) {
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            if (this.tabbedPane.getComponentAt(i) != child) continue;
            this.getChildProps(tabProps, i);
            return i;
        }
        return 0;
    }

    private void getChildProps(Map<String, Object> tabProps, int i) {
        tabProps.put("title", this.tabbedPane.getTitleAt(i));
        String tooltip = this.tabbedPane.getToolTipTextAt(i);
        if (tooltip != null) {
            tabProps.put("tooltip", tooltip);
        }
        tabProps.put("enabled", this.tabbedPane.isEnabledAt(i));
    }

    @Override
    protected void getChildContentPaneProperties(int i, Container container, Map<String, Object> tabProps) {
        if (i >= 0 && i < this.tabbedPane.getTabCount()) {
            this.getChildProps(tabProps, i);
        }
    }

    @Override
    protected void addEventListeners() {
        super.addEventListeners();
        this.tabbedPane.getModel().addChangeListener(this.selectionChangeListener);
        ObservableRepaintManager.getInstance().addRepaintListener(this.tabbedPane, this);
    }

    @Override
    protected void removeEventListeners() {
        super.removeEventListeners();
        this.tabbedPane.getModel().removeChangeListener(this.selectionChangeListener);
        ObservableRepaintManager.getInstance().removeRepaintListener(this.tabbedPane, this);
    }

    @Override
    public void componentRepainted(JComponent component) {
        this.markDirty();
    }
}

