/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jcp.handlers.componentHandlers;

import com.mathworks.matlabserver.jcp.handlers.Handler;
import com.mathworks.matlabserver.jcp.handlers.componentHandlers.AbstractTextComponentHandler;
import com.mathworks.mwt.MWTextField;
import com.mathworks.peermodel.PeerNode;
import com.mathworks.peermodel.events.Event;
import com.mathworks.peermodel.events.Observer;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.Map;
import javax.swing.SwingUtilities;

public class MWTextFieldHandler
extends AbstractTextComponentHandler
implements TextListener {
    private MWTextField textField;
    private Observer peerEventObserver = new Observer(){

        public void handle(Event event) {
            String type = event.getData().get("type").toString();
            String text = event.getData().get("value").toString();
            if (type.equals("textboxCommit")) {
                this.textboxCommit(text);
            } else if (type.equals("onBlur")) {
                this.onBlur(text);
            }
        }

        private void textboxCommit(final String text) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MWTextFieldHandler.this.textField.setText(text);
                    MWTextFieldHandler.this.textField.fireAction();
                }
            });
        }

        private void onBlur(final String text) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MWTextFieldHandler.this.textField.setText(text);
                    MWTextFieldHandler.this.textField.fireAction();
                    MWTextFieldHandler.this.component.transferFocus();
                }
            });
        }
    };

    @Override
    public String getType() {
        return "TextBox";
    }

    @Override
    public void handle(Handler parentHandler, Component component, PeerNode parentNode, Container parentContainer) {
        this.textField = (MWTextField)component;
        super.handle(parentHandler, component, parentNode, parentContainer);
    }

    @Override
    protected Map<String, Object> doGetProperties(Component component) {
        Map<String, Object> props = super.doGetProperties(component);
        props.put("editable", this.textField.isEditable());
        props.put("background", new int[]{255, 255, 255});
        return props;
    }

    @Override
    protected void addEventListeners() {
        super.addEventListeners();
        this.textField.addTextListener((TextListener)this);
    }

    @Override
    protected void removeEventListeners() {
        super.removeEventListeners();
        this.textField.removeTextListener((TextListener)this);
    }

    @Override
    protected void addPeerNodeListeners() {
        super.addPeerNodeListeners();
        this.peerNode.addEventListener("peerEvent", this.peerEventObserver);
    }

    @Override
    protected void removePeerNodeListeners() {
        super.removePeerNodeListeners();
        this.peerNode.removeEventListener("peerEvent", this.peerEventObserver);
    }

    @Override
    public void textValueChanged(TextEvent e) {
        this.markDirty();
    }
}

