/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jcp.handlers.componentHandlers;

import com.mathworks.matlabserver.jcp.handlers.componentHandlers.AbstractComponentHandler;
import com.mathworks.peermodel.events.Event;
import com.mathworks.peermodel.events.Observer;
import java.awt.Component;
import java.util.Map;
import javax.swing.BoundedRangeModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class AbstractBoundedRangeHandler
extends AbstractComponentHandler
implements ChangeListener {
    public static final String VERTICAL = "vertical";
    public static final String HORIZONTAL = "horizontal";
    private Observer propSetObserver = new Observer(){

        public void handle(final Event event) {
            if (AbstractBoundedRangeHandler.this.updatingPeerNode) {
                return;
            }
            if (event.getData().get("key").equals("value")) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Object newValue = event.getData().get("newValue");
                        if (!(newValue instanceof Double)) {
                            throw new IllegalArgumentException("New value should be a double");
                        }
                        AbstractBoundedRangeHandler.this.setValue(((Double)newValue).intValue());
                    }
                });
            }
        }
    };

    @Override
    protected Map<String, Object> doGetProperties(Component component) {
        Map<String, Object> props = super.doGetProperties(component);
        props.put("min", this.getMin(component));
        props.put("max", this.getMax(component));
        props.put("value", this.getValue(component));
        props.put("extent", this.getExtent(component));
        props.put("orientation", this.getOrientation(component));
        return props;
    }

    protected int getMin(Component component) {
        return this.getModel(component).getMinimum();
    }

    protected int getMax(Component component) {
        return this.getModel(component).getMaximum();
    }

    protected double getValue(Component component) {
        return this.getModel(component).getValue();
    }

    protected void setValue(double newValue) {
        this.getModel(this.component).setValue((int)newValue);
    }

    protected int getExtent(Component component) {
        return this.getModel(component).getExtent();
    }

    protected abstract String getOrientation(Component var1);

    protected abstract BoundedRangeModel getModel(Component var1);

    @Override
    protected void addEventListeners() {
        super.addEventListeners();
        this.getModel(this.component).addChangeListener(this);
    }

    @Override
    protected void removeEventListeners() {
        super.removeEventListeners();
        this.getModel(this.component).removeChangeListener(this);
    }

    @Override
    protected void addPeerNodeListeners() {
        super.addPeerNodeListeners();
        this.peerNode.addEventListener("propertySet", this.propSetObserver);
    }

    @Override
    protected void removePeerNodeListeners() {
        super.removePeerNodeListeners();
        this.peerNode.removeEventListener("propertySet", this.propSetObserver);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.markDirty();
    }
}

