/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jcp.handlers;

import com.mathworks.matlabserver.jcp.handlers.Handler;
import com.mathworks.matlabserver.jcp.handlers.HandlerFactory;
import com.mathworks.matlabserver.jcp.handlers.HandlerVisitor;
import com.mathworks.matlabserver.jcp.handlers.windowHandlers.AbstractWindowHandler;
import com.mathworks.matlabserver.jcp.listeners.ClipboardListener;
import com.mathworks.matlabserver.jcp.utils.WindowUtils;
import com.mathworks.peermodel.PeerModelManager;
import com.mathworks.peermodel.PeerNode;
import com.mathworks.peermodel.events.Event;
import com.mathworks.peermodel.events.Observer;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.FocusManager;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;

public class RootHandler
implements AWTEventListener {
    private static final Toolkit toolkit = Toolkit.getDefaultToolkit();
    private static Clipboard clipboard;
    private static ClipboardListener clipboardListener;
    ConcurrentHashMap<Window, Handler> windowHandlers = new ConcurrentHashMap();
    Set<Window> openWindows = new HashSet<Window>();
    Set<Window> visibleWindows = new HashSet<Window>();
    Set<Window> loadingWindows = new HashSet<Window>();
    private static RootHandler instance;
    private Handler currentWindowHandler;
    private PeerModelManager manager;
    private PeerNode rootNode;
    private Object originator = new Object();
    private int maxGuis = 6;
    private Observer rootListener = new Observer(){

        public void handle(Event event) {
            if (RootHandler.this.shouldProcess(event)) {
                Handler handler;
                String key = event.getData().get("key").toString();
                if (key.equals("selectedChild") && (handler = RootHandler.this.getHandlerById((String)event.getTarget().getProperty("selectedChild"))) != null) {
                    Component component = handler.getComponent();
                    component.requestFocus();
                }
                if (key.equals("screenWidth") || key.equals("screenHeight")) {
                    RootHandler.this.resizeWindows();
                }
            }
        }
    };
    private ComponentAdapter componentAdapter = new ComponentAdapter(){

        @Override
        public void componentShown(ComponentEvent e) {
            RootHandler.this.handleWindowShown((Window)e.getSource());
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            RootHandler.this.handleWindowHidden((Window)e.getSource());
        }
    };

    private boolean shouldProcess(Event event) {
        return event.getOriginator() != this.originator;
    }

    public RootHandler(PeerModelManager manager) {
        this.manager = manager;
    }

    public void start() {
        this.stop();
        try {
            clipboardListener = new ClipboardListener(this.manager);
            clipboard = toolkit.getSystemClipboard();
            clipboard.addFlavorListener(clipboardListener);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        this.rootNode = this.manager.setRoot("root", this.getProperties());
        this.rootNode.addEventListener("propertySet", this.rootListener);
        toolkit.addAWTEventListener(this, 64L);
        instance = this;
        for (Window existingWindow : Window.getWindows()) {
            if (!existingWindow.isDisplayable()) continue;
            this.handleWindowOpened(existingWindow);
        }
    }

    public void stop() {
        toolkit.removeAWTEventListener(this);
        try {
            clipboard.removeFlavorListener(clipboardListener);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        this.cleanUpHandlers();
        for (Window window : this.openWindows) {
            window.removeComponentListener(this.componentAdapter);
        }
        this.openWindows.clear();
        this.visibleWindows.clear();
        if (this.manager.hasRoot()) {
            this.manager.getRoot().destroy();
        }
        if (this.rootNode != null) {
            this.rootNode.destroy();
        }
        instance = null;
    }

    public static void setMaxGuis(int newMaxGuis) {
        if (instance != null) {
            RootHandler.instance.maxGuis = newMaxGuis;
        }
    }

    public static int getMaxGuis() {
        return instance != null ? RootHandler.instance.maxGuis : 0;
    }

    private void updateProperties() {
        this.updateCurrentWindowHandler();
        this.rootNode.setProperties(this.getProperties(), this.originator);
    }

    private Map<String, Object> getProperties() {
        Map<String, Object> props = clipboardListener.getClipboardProperties();
        props.put("enableTooltips", ToolTipManager.sharedInstance().isEnabled());
        if (this.currentWindowHandler != null) {
            props.put("selectedChild", this.currentWindowHandler.getPeerNode().getId());
        } else {
            props.put("selectedChild", "");
        }
        ArrayList<Map<String, Object>> openGuis = new ArrayList<Map<String, Object>>();
        for (Window window : this.windowHandlers.keySet()) {
            openGuis.add(this.getOpenGuiInfo(window));
        }
        for (Window window : this.visibleWindows) {
            if (this.windowHandlers.keySet().contains(window)) continue;
            openGuis.add(this.getOpenGuiInfo(window));
        }
        props.put("openGuis", openGuis);
        return props;
    }

    private Map<String, Object> getOpenGuiInfo(Window window) {
        HashMap<String, Object> gui = new HashMap<String, Object>();
        if (window instanceof JFrame) {
            gui.put("title", ((JFrame)window).getTitle());
        } else if (window instanceof JDialog) {
            gui.put("title", ((JDialog)window).getTitle());
        } else {
            gui.put("title", "");
        }
        if (this.windowHandlers.keySet().contains(window) || this.loadingWindows.contains(window)) {
            gui.put("isLoaded", true);
        } else {
            gui.put("isLoaded", false);
        }
        if (this.windowHandlers.keySet().contains(window)) {
            gui.put("id", this.windowHandlers.get(window).getPeerNode().getId());
        }
        return gui;
    }

    public static Handler getCurrentWindowHandler() {
        if (instance != null) {
            return RootHandler.instance.currentWindowHandler;
        }
        return null;
    }

    public Handler getHandlerById(String id) {
        for (Handler handler : this.windowHandlers.values()) {
            if (handler.getPeerNode() == null || !handler.getPeerNode().getId().equals(id)) continue;
            return handler;
        }
        return null;
    }

    @Override
    public void eventDispatched(AWTEvent e) {
        if (!(e.getSource() instanceof Window) || !this.shouldHandle((Window)e.getSource())) {
            return;
        }
        Window source = (Window)e.getSource();
        switch (e.getID()) {
            case 200: {
                this.handleWindowOpened(source);
                break;
            }
            case 202: {
                this.handleWindowClosed(source);
                break;
            }
            case 205: {
                this.handleWindowActivated(source);
                break;
            }
            case 206: {
                break;
            }
            case 201: {
                break;
            }
            case 203: {
                this.handleWindowIconified(source);
                break;
            }
            case 204: {
                this.handleWindowDeIconified(source);
            }
        }
    }

    private void handleWindowOpened(Window window) {
        this.openWindows.add(window);
        window.addComponentListener(this.componentAdapter);
        if (window.isVisible()) {
            this.createWindowHandler(window);
        } else {
            this.updateProperties();
        }
    }

    private void handleWindowShown(Window window) {
        this.createWindowHandler(window);
    }

    private void handleWindowActivated(Window window) {
        this.createWindowHandler(window);
    }

    private void handleWindowHidden(Window window) {
        this.destroyWindowHandler(window);
    }

    private void handleWindowClosed(Window window) {
        window.removeComponentListener(this.componentAdapter);
        this.openWindows.remove(window);
        this.destroyWindowHandler(window);
    }

    private void handleWindowIconified(Window window) {
        if (this.windowHandlers.containsKey(window)) {
            this.windowHandlers.get(window).getPeerNode().setProperty("minimized", (Object)true);
        }
    }

    private void handleWindowDeIconified(Window window) {
        if (this.windowHandlers.containsKey(window)) {
            this.windowHandlers.get(window).getPeerNode().setProperty("minimized", (Object)false);
        }
    }

    private synchronized void updateCurrentWindowHandler() {
        Handler windowHandler;
        Window window = FocusManager.getCurrentManager().getActiveWindow();
        if (window != null && this.windowHandlers.containsKey(window) && (windowHandler = this.windowHandlers.get(window)) != null && windowHandler.getPeerNode() != null) {
            this.currentWindowHandler = windowHandler;
        }
        if (this.windowHandlers.isEmpty()) {
            this.currentWindowHandler = null;
        }
    }

    private synchronized void createWindowHandler(final Window window) {
        if (this.shouldHandle(window)) {
            this.visibleWindows.add(window);
            if (this.loadingWindows.size() + this.windowHandlers.size() < this.maxGuis && !this.windowHandlers.containsKey(window) && !this.loadingWindows.contains(window)) {
                this.loadingWindows.add(window);
                SwingUtilities.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        RootHandler rootHandler = RootHandler.this;
                        synchronized (rootHandler) {
                            try {
                                if (!RootHandler.this.windowHandlers.containsKey(window) && RootHandler.this.rootNode != null) {
                                    Handler windowHandler = HandlerFactory.getHandler(window);
                                    windowHandler.handle(null, window, RootHandler.this.rootNode);
                                    RootHandler.this.windowHandlers.put(window, windowHandler);
                                    if (WindowUtils.isModal(window)) {
                                        RootHandler.this.currentWindowHandler = windowHandler;
                                    }
                                    RootHandler.this.updateProperties();
                                }
                            }
                            finally {
                                RootHandler.this.loadingWindows.remove(window);
                            }
                        }
                    }
                });
            } else {
                this.updateProperties();
            }
        }
    }

    private synchronized void destroyWindowHandler(Window window) {
        if (this.windowHandlers.containsKey(window)) {
            Handler windowHandler = this.windowHandlers.remove(window);
            windowHandler.destroy();
        }
        this.visibleWindows.remove(window);
        this.createWindowHandlerIfNecessary();
        this.updateProperties();
    }

    private void createWindowHandlerIfNecessary() {
        if (this.visibleWindows.size() > this.loadingWindows.size() + this.windowHandlers.size() && this.loadingWindows.size() + this.windowHandlers.size() < this.maxGuis) {
            Window[] windows = this.visibleWindows.toArray(new Window[this.visibleWindows.size()]);
            Arrays.sort(windows, new Comparator<Window>(){

                @Override
                public int compare(Window o1, Window o2) {
                    if (o1.getName() != null && o2.getName() != null) {
                        return o1.getName().compareTo(o2.getName());
                    }
                    return 0;
                }
            });
            for (Window openWindow : windows) {
                if (this.windowHandlers.keySet().contains(openWindow)) continue;
                this.createWindowHandler(openWindow);
                return;
            }
        }
    }

    private boolean shouldHandle(Component window) {
        if (window.getName() != null && window.getName().equals("MainDesktopFrame")) {
            return false;
        }
        if (!(window instanceof JFrame || window instanceof JDialog || window instanceof JPopupMenu)) {
            return false;
        }
        return !(window instanceof Frame) || ((Frame)window).getTitle() == null || !((Frame)window).getTitle().equals("Figure");
    }

    public void cleanUpHandlers() {
        for (Window window : this.windowHandlers.keySet()) {
            try {
                this.destroyWindowHandler(window);
            }
            catch (Exception exception) {}
        }
        this.windowHandlers.clear();
    }

    public void resizeWindows() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (Handler handler : RootHandler.this.windowHandlers.values()) {
                    if (!(handler instanceof AbstractWindowHandler)) continue;
                    ((AbstractWindowHandler)handler).resize();
                }
            }
        });
    }

    public static void cleanupHandler(Window window, Handler handler) {
        if (window != null && instance != null) {
            RootHandler.instance.openWindows.remove(window);
            instance.destroyWindowHandler(window);
        } else {
            handler.destroy();
        }
    }

    public static void accept(HandlerVisitor visitor) {
        if (instance != null) {
            for (Handler handler : RootHandler.instance.windowHandlers.values()) {
                handler.accept(visitor);
            }
        }
    }

    public static void acceptPostOrder(HandlerVisitor visitor) {
        if (instance != null) {
            for (Handler handler : RootHandler.instance.windowHandlers.values()) {
                handler.acceptPostOrder(visitor);
            }
        }
    }

    public static void accept(HandlerVisitor.Cancellable visitor) {
        if (instance != null) {
            for (Handler handler : RootHandler.instance.windowHandlers.values()) {
                handler.accept(visitor);
            }
        }
    }

    public static void acceptPostOrder(HandlerVisitor.Cancellable visitor) {
        if (instance != null) {
            for (Handler handler : RootHandler.instance.windowHandlers.values()) {
                handler.acceptPostOrder(visitor);
            }
        }
    }

    public static String getDomIdByComponent(final Component component) {
        final Handler[] handler = new Handler[1];
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    handler[0] = RootHandler.getHandlerByComponent(component);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        if (handler[0] != null && handler[0].getPeerNode() != null) {
            return "mgg_" + handler[0].getPeerNode().getId();
        }
        return null;
    }

    public static Handler getHandlerByComponent(final Component component) {
        final Handler[] handlers = new Handler[1];
        RootHandler.acceptPostOrder(new HandlerVisitor.Cancellable(){

            @Override
            public boolean visit(Handler handler) {
                if (handler.ownsComponent(component) || SwingUtilities.isDescendingFrom(component, handler.getComponent())) {
                    handlers[0] = handler;
                    return true;
                }
                return false;
            }
        });
        return handlers[0];
    }

    public static Handler getHandlerByNodeId(final String id) {
        final Handler[] result = new Handler[1];
        RootHandler.accept(new HandlerVisitor.Cancellable(){

            @Override
            public boolean visit(Handler handler) {
                if (handler.getPeerNode().getId().equals(id)) {
                    result[0] = handler;
                    return true;
                }
                return false;
            }
        });
        return result[0];
    }

    public static Handler[] getHandlersByType(final String type) {
        final ArrayList result = new ArrayList();
        RootHandler.accept(new HandlerVisitor(){

            @Override
            public void visit(Handler handler) {
                if (handler.getType().equals(type)) {
                    result.add(handler);
                }
            }
        });
        return result.toArray(new Handler[result.size()]);
    }

    public static void printHandlers() {
        if (instance != null) {
            StringBuilder builder = new StringBuilder();
            for (Handler handler : RootHandler.instance.windowHandlers.values()) {
                handler.buildString(builder, 0);
            }
            System.out.print(builder.toString());
            System.out.println();
        }
    }

    public static boolean checkForDuplicates() {
        final ArrayList components = new ArrayList();
        final boolean[] multipleDetected = new boolean[]{false};
        RootHandler.accept(new HandlerVisitor(){

            @Override
            public void visit(Handler handler) {
                Component c = handler.getComponent();
                if (components.contains(c)) {
                    multipleDetected[0] = true;
                    System.out.println("Component " + c.toString() + " mapped to multiple handlers");
                } else {
                    components.add(c);
                }
            }
        });
        return multipleDetected[0];
    }

    static {
        instance = null;
    }
}

