/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jcp.filters;

import com.mathworks.matlabserver.jcp.filters.ComponentFilter;
import com.mathworks.matlabserver.jcp.filters.FilterFactory;
import com.mathworks.matlabserver.jcp.handlers.Handler;
import java.util.Map;

public abstract class HeirarchicalFilter
implements ComponentFilter {
    @Override
    public void updateAll(Handler handler, Map<String, Object> newProperties) {
        boolean lastFiltered = false;
        boolean newHandler = false;
        if (handler.getPeerNode() != null && handler.getPeerNode().hasProperty("filtered")) {
            lastFiltered = (Boolean)handler.getPeerNode().getProperty("filtered");
        } else {
            newHandler = true;
        }
        boolean newFiltered = this.isSelfFiltered(handler, newProperties) || this.isContainerFiltered(handler);
        handler.setFiltered(newFiltered);
        Handler parentHandler = handler.getParentHandler();
        if ((newFiltered != lastFiltered || newHandler) && parentHandler != null) {
            for (Handler sibling : parentHandler.getChildrenHandlers()) {
                if (sibling.equals(handler)) continue;
                FilterFactory.getInstance().getFilterRules(sibling).updateSingle(sibling);
            }
            FilterFactory.getInstance().getFilterRules(parentHandler).updateAll(parentHandler);
        }
    }

    @Override
    public void updateAll(Handler handler) {
        boolean lastFiltered = handler.isFiltered();
        boolean newFiltered = this.isSelfFiltered(handler, handler.getPeerNode().getProperties()) || this.isContainerFiltered(handler);
        handler.setFiltered(newFiltered);
        Handler parentHandler = handler.getParentHandler();
        if (newFiltered != lastFiltered && parentHandler != null) {
            for (Handler sibling : parentHandler.getChildrenHandlers()) {
                if (sibling.equals(handler)) continue;
                FilterFactory.getInstance().getFilterRules(sibling).updateSingle(sibling);
            }
            FilterFactory.getInstance().getFilterRules(parentHandler).updateAll(parentHandler);
        }
    }

    @Override
    public void updateSingle(Handler handler) {
        boolean newFiltered = this.isSelfFiltered(handler, handler.getPeerNode().getProperties()) || this.isContainerFiltered(handler);
        handler.setFiltered(newFiltered);
    }

    protected abstract boolean isSelfFiltered(Handler var1, Map<String, Object> var2);

    protected boolean isContainerFiltered(Handler handler) {
        int numUnfilteredChildren = 0;
        for (Handler child : handler.getChildrenHandlers()) {
            if (child.isFiltered()) continue;
            ++numUnfilteredChildren;
        }
        return numUnfilteredChildren == 0 && handler.getChildrenHandlers().size() > 0;
    }
}

