/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jcp.dataHandlers.cellHandlers;

import com.jidesoft.grid.LegacyEnumCellEditor;
import com.mathworks.matlabserver.jcp.dataHandlers.cellHandlers.DefaultCellHandler;
import java.awt.event.ActionEvent;
import java.lang.reflect.Method;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;

public class ListComboBoxHandler<R, C>
extends DefaultCellHandler<R, C> {
    public ListComboBoxHandler(String type) {
        super(type);
    }

    @Override
    public Map<String, Object> getProperties(JComponent component, R renderer, C cell) {
        try {
            Map<String, Object> props = super.getProperties(component, renderer, cell);
            Method modelMethod = renderer.getClass().getMethod("getModel", new Class[0]);
            ComboBoxModel model = (ComboBoxModel)modelMethod.invoke(renderer, new Object[0]);
            Object[] items = new Object[model.getSize()];
            for (int i = 0; i < items.length; ++i) {
                items[i] = model.getElementAt(i);
            }
            props.put("listValues", items);
            return props;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Object getCellValue(JComponent component, R renderer, C cell, Object value) {
        try {
            Method modelMethod = cell.getClass().getMethod("getModel", new Class[0]);
            ComboBoxModel model = (ComboBoxModel)modelMethod.invoke(cell, new Object[0]);
            return model.getSelectedItem();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public boolean setCellValue(JComponent component, R editor, C cell, Object value) {
        if (cell instanceof LegacyEnumCellEditor) {
            Object item = ((LegacyEnumCellEditor)cell).getConverter().fromString((String)value, ((LegacyEnumCellEditor)cell).getConverterContext());
            ((LegacyEnumCellEditor)cell).setCellEditorValue(item);
            ((LegacyEnumCellEditor)cell).actionPerformed(new ActionEvent(cell, 1001, ""));
            return true;
        }
        try {
            Method modelMethod = cell.getClass().getMethod("getModel", new Class[0]);
            ComboBoxModel model = (ComboBoxModel)modelMethod.invoke(cell, new Object[0]);
            model.setSelectedItem(value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

