/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jcp.contextMenus;

import com.mathworks.matlabserver.jcp.contextMenus.ContextMenuMatcher;
import com.mathworks.matlabserver.jcp.handlers.Handler;
import com.mathworks.matlabserver.jcp.handlers.HandlerFactory;
import com.mathworks.matlabserver.jcp.handlers.RootHandler;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ContextMenuManager
implements ChangeListener {
    private static volatile ContextMenuManager manager;
    private List<ContextMenuMatcher> menuMatchers = new ArrayList<ContextMenuMatcher>();
    private Handler lastMenuHandler = null;
    private ContextMenuMatcher openMatcher = null;

    ContextMenuManager() {
        MenuSelectionManager.defaultManager().addChangeListener(this);
    }

    public static synchronized ContextMenuManager getInstance() {
        if (manager == null) {
            manager = new ContextMenuManager();
        }
        return manager;
    }

    public void addContextMenuHandler(ContextMenuMatcher matcher) {
        this.menuMatchers.add(matcher);
    }

    public void removeContextMenuHandler(ContextMenuMatcher matcher) {
        this.menuMatchers.remove(matcher);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        MenuElement[] menus = ((MenuSelectionManager)e.getSource()).getSelectedPath();
        boolean openedMenu = false;
        if (menus.length > 0) {
            Component c = menus[0].getComponent();
            JPopupMenu lastMenu = null;
            if (c instanceof JPopupMenu) {
                lastMenu = (JPopupMenu)c;
            }
            while (c.getParent() != null) {
                if (!((c = c.getParent()) instanceof JPopupMenu)) continue;
                lastMenu = (JPopupMenu)c;
            }
            for (ContextMenuMatcher matcher : this.menuMatchers) {
                if (!matcher.handles(c, lastMenu)) continue;
                openedMenu = true;
                if (this.openMatcher == matcher) break;
                this.openMatcher = matcher;
                this.openedMenu(lastMenu);
                break;
            }
        }
        if (!openedMenu && this.openMatcher != null) {
            this.openMatcher = null;
        }
    }

    private void openedMenu(JPopupMenu menu) {
        Handler windowHandler;
        if (this.lastMenuHandler != null) {
            this.lastMenuHandler.destroy();
        }
        if ((windowHandler = RootHandler.getCurrentWindowHandler()) != null && menu != null) {
            this.lastMenuHandler = HandlerFactory.getHandler(menu);
            this.lastMenuHandler.handle(windowHandler, menu, windowHandler.getPeerNode());
        }
    }
}

