/*
 * Decompiled with CFR 0.152.
 */
package ice.net.pac;

import ice.debug.Debug;
import ice.net.ConnectionRoute;
import ice.net.Direct;
import ice.net.pac.ConnectionRouteNotFoundException;
import ice.net.pac.PacCallback;
import ice.net.pac.PacScripter;
import ice.net.proxy.Proxy;
import ice.net.proxy.ProxyResolver;
import ice.net.socks.Socks;
import ice.util.Defs;
import ice.util.UnsupportedOperationException;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.mozilla.javascript.JavaScriptException;

public class PacManager
implements ProxyResolver {
    private static long OEAB = Defs.sysPropertyInt((String)"ice.net.pac.proxiesRetryInterval", (int)1200000);
    private ConnectionRoute addElement = new Direct();
    private int append = 0;
    private PacCallback areProxiesEnabled;
    private PacScripter containsKey;
    private boolean countTokens = true;
    private Hashtable currentTimeMillis = new Hashtable();
    private long elementAt;

    public PacManager(URL uRL) throws IllegalArgumentException {
        try {
            this.containsKey = new PacScripter(uRL);
            Debug.trace((String)("Loaded PAC file from: " + uRL));
        }
        catch (IOException iOException) {
            Debug.trace((String)"Error loading implementation or PAC script");
        }
        catch (JavaScriptException javaScriptException) {
            Debug.trace((String)"JavaScript error in implementation or PAC script");
        }
    }

    public boolean areProxiesEnabled() {
        if (this.areProxiesEnabled != null && !this.countTokens && this.elementAt < System.currentTimeMillis() - (OEAB + (long)this.append * OEAB)) {
            if (this.areProxiesEnabled.retryProxies()) {
                this.setProxiesEnabled(true);
            } else {
                ++this.append;
            }
        }
        return this.countTokens;
    }

    public Proxy[] findProxy(String string) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public ConnectionRoute findProxyForUrl(URL uRL) throws ConnectionRouteNotFoundException, IllegalArgumentException {
        Vector vector;
        if (uRL == null) {
            throw new IllegalArgumentException("url is null");
        }
        if (this.containsKey == null || !this.areProxiesEnabled()) {
            this.addElement.setRequestedUrl(uRL);
            return this.addElement;
        }
        try {
            vector = this.OEAB(this.containsKey.findProxyForUrl(uRL));
        }
        catch (JavaScriptException javaScriptException) {
            Debug.trace((String)"JavaScript error in implementation or PAC script");
            Debug.ex((Throwable)javaScriptException);
            this.addElement.setRequestedUrl(uRL);
            return this.addElement;
        }
        int n = vector.size();
        if (n == 0) {
            throw new ConnectionRouteNotFoundException("no connection route could be found for: " + uRL);
        }
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            ConnectionRoute connectionRoute = (ConnectionRoute)vector.elementAt(n2);
            if (connectionRoute instanceof Direct) {
                bl = true;
            }
            if (connectionRoute.getStatus() != 3) {
                connectionRoute.setRequestedUrl(uRL);
                return connectionRoute;
            }
            ++n2;
        }
        if (!bl && this.areProxiesEnabled != null) {
            if (this.areProxiesEnabled.ignoreProxies()) {
                int n3 = 0;
                while (n3 < n) {
                    ((ConnectionRoute)vector.elementAt(n3)).setStatus(1);
                    ++n3;
                }
                this.setProxiesEnabled(false);
                this.addElement.setRequestedUrl(uRL);
                return this.addElement;
            }
        } else {
            int n4 = 0;
            while (n4 < n) {
                ((ConnectionRoute)vector.elementAt(n4)).setStatus(1);
                ++n4;
            }
        }
        throw new ConnectionRouteNotFoundException("no connection route could be found for: " + uRL);
    }

    public PacCallback getPacCallback() {
        return this.areProxiesEnabled;
    }

    public URL getPacLocation() {
        return this.containsKey.getPacLocation();
    }

    public void setPacCallback(PacCallback pacCallback) {
        this.areProxiesEnabled = pacCallback;
    }

    public void setPacLocation(URL uRL) throws IllegalArgumentException {
        try {
            this.containsKey.setPacLocation(uRL);
        }
        catch (IOException iOException) {
            Debug.trace((String)"Error loading implementation or PAC script");
        }
        catch (JavaScriptException javaScriptException) {
            Debug.trace((String)"JavaScript error in implementation or PAC script");
        }
    }

    void setProxiesEnabled(boolean bl) {
        this.countTokens = bl;
        if (this.areProxiesEnabled != null && !this.countTokens) {
            this.elementAt = System.currentTimeMillis();
        }
    }

    private Vector OEAB(String string) {
        Vector<ConnectionRoute> vector = new Vector<ConnectionRoute>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        int n = stringTokenizer.countTokens();
        int n2 = 0;
        while (n2 < n) {
            ConnectionRoute connectionRoute = this.addElement(stringTokenizer.nextToken());
            if (connectionRoute != null) {
                vector.addElement(connectionRoute);
            }
            ++n2;
        }
        return vector;
    }

    private ConnectionRoute addElement(String string) {
        ConnectionRoute connectionRoute = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        String string2 = stringTokenizer.nextToken();
        if (string2.equalsIgnoreCase("DIRECT")) {
            connectionRoute = this.addElement;
        } else if (string2.equalsIgnoreCase("PROXY")) {
            if (stringTokenizer.hasMoreTokens()) {
                connectionRoute = this.append(stringTokenizer.nextToken());
            }
        } else if (string2.equalsIgnoreCase("SOCKS") && stringTokenizer.hasMoreTokens()) {
            connectionRoute = this.areProxiesEnabled(stringTokenizer.nextToken());
        }
        return connectionRoute;
    }

    private Proxy append(String string) {
        Proxy proxy = null;
        if (this.currentTimeMillis.containsKey(string)) {
            proxy = (Proxy)this.currentTimeMillis.get(string);
        } else {
            int n = string.indexOf(58);
            if (n != -1) {
                try {
                    proxy = new Proxy(string.substring(0, n), Integer.parseInt(string.substring(n + 1)));
                    this.currentTimeMillis.put(string, proxy);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return proxy;
    }

    private Socks areProxiesEnabled(String string) {
        Socks socks = null;
        if (this.currentTimeMillis.containsKey(string)) {
            socks = (Socks)this.currentTimeMillis.get(string);
        } else {
            int n = string.indexOf(58);
            if (n != -1) {
                try {
                    socks = new Socks(string.substring(0, n), Integer.parseInt(string.substring(n + 1)));
                    this.currentTimeMillis.put(string, socks);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return socks;
    }
}

