/*
 * Decompiled with CFR 0.152.
 */
package ice.net;

import ice.debug.Debug;
import ice.net.AuthenticationManager;
import ice.net.CacheManager;
import ice.net.CacheManagerSettings;
import ice.net.ConnectionManager;
import ice.net.ConnectionManagerSettings;
import ice.net.CookieManager;
import ice.net.CookieManagerSettings;
import ice.net.HttpURLConnectionSettings;
import ice.net.proxy.ProxyResolver;
import ice.util.Defs;
import ice.util.Emulation;
import ice.util.alg.Comparator;
import ice.util.alg.HashArray;
import ice.util.alg.IgnoreAsciiCaseComparator;
import ice.util.memory.MemoryManager;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;

class HttpSession {
    final int VERSION_1_0 = 10;
    final int VERSION_1_1 = 11;
    int HTTPVersion = 11;
    DateFormat RFC1123Date;
    public static final String VERSION = "v1_4";
    static final String PRODUCT_NAME = "ICEhttp/v1_4";
    boolean retryBrokenConnections = HttpURLConnectionSettings.shouldDefaultRetryBrokenConnections();
    Vector acceptLanguageList = new Vector();
    int so_Timeout = ConnectionManagerSettings.getDefaultSoTimeout();
    boolean enableNagle = ConnectionManagerSettings.isDefaultNagleEnabled();
    boolean verboseRequests = Defs.sysPropertyBoolean((String)"ice.net.debug.request", (boolean)false);
    boolean verboseOutgoingRequests = Defs.sysPropertyBoolean((String)"ice.net.debug.requestheaders", (boolean)false);
    boolean reportAll = Defs.sysPropertyBoolean((String)"ice.net.debug.all", (boolean)false);
    boolean verboseHeaders = Defs.sysPropertyBoolean((String)"ice.net.debug.responseheaders", (boolean)false);
    boolean debugMode = Defs.sysPropertyBoolean((String)"ice.net.debug.proxy") | this.reportAll;
    HashArray defaultRequestProperties = new HashArray();
    boolean followRedirects = true;
    boolean isPersistent = ConnectionManagerSettings.areDefaultPersistentConnectionsEnabled();
    boolean alwaysRevalidate = CacheManagerSettings.shouldDefaultAlwaysRevalidate();
    final int RETRY_UNDEFINED = 0;
    final int RETRY_TRUE = 1;
    final int RETRY_FALSE = 2;
    final boolean CLOBBER_PERSISTENT = true;
    AuthenticationManager authManager = null;
    CacheManager cacheMgr = null;
    ConnectionManager connectionMgr = new ConnectionManager(this);
    CookieManager cookieMgr = null;
    ProxyResolver proxyResolver = null;
    MemoryManager memoryManager = null;
    int instancesInUse = 0;
    int maxInstances = 4;
    int CLEAN_INTERVAL = 10000;
    boolean useLimits = false;
    Object instancesLock = new Object();
    Object cleanLock = new Object();
    Hashtable theConnections = new Hashtable();
    long lastCleanedAt = 0L;
    int TIMEOUTVALUE = ConnectionManagerSettings.getDefaultPersistentConnectionTimeout();
    int READBUFFERSIZE = 4096;
    boolean ieCookieExpiresForgive = CookieManagerSettings.isDefaultCookieExpirationBufferEnabled();
    private static HttpSession OEAB = null;

    public static HttpSession getDefaultSession() {
        if (OEAB == null) {
            OEAB = new HttpSession();
        }
        return OEAB;
    }

    public HttpSession() {
        this.defaultRequestProperties.setComparator((Comparator)IgnoreAsciiCaseComparator.instance);
        this.acceptLanguageList.addElement(new Locale(Locale.getDefault().getLanguage(), ""));
        this.RFC1123Date = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", new Locale("en", "US"));
        this.RFC1123Date.setTimeZone(TimeZone.getTimeZone("GMT"));
        String string = HttpURLConnectionSettings.getDefaultHttpVersion();
        if (string != null) {
            if (string.equals("HTTP/1.0")) {
                this.HTTPVersion = 10;
            } else if (string.equals("HTTP/1.1")) {
                this.HTTPVersion = 11;
            }
        }
        this.defaultRequestProperties.put((Object)"Accept", (Object)"*/*");
        this.defaultRequestProperties.put((Object)"Accept-Encoding", (Object)"gzip");
        String string2 = Emulation.getEmulatedUserAgent();
        this.defaultRequestProperties.put((Object)"User-Agent", (Object)string2);
        int n = ConnectionManagerSettings.getDefaultMaxPersistentConnections();
        if (n >= 0) {
            this.useLimits = true;
            this.maxInstances = n;
        }
    }

    static {
        if (Debug.trace) {
            Debug.traceAsIs((String)"ICEhttp v1_4");
        } else if (Defs.sysPropertyBoolean((String)"ice.browser.verbose", (boolean)true)) {
            System.out.println("ICEhttp v1_4");
            System.out.println("(c) ICEsoft Technologies, Inc.");
        }
    }
}

