/*
 * Decompiled with CFR 0.152.
 */
package ice.net;

import java.io.Serializable;
import java.util.Vector;

public class HeaderMap
implements Cloneable,
Serializable {
    private Header[] headerData;
    private int size = 0;

    public HeaderMap() {
        this(10);
    }

    public HeaderMap(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("illegal capacity: " + n);
        }
        this.headerData = new Header[n];
    }

    public void clear() {
        int n = 0;
        while (n < this.size) {
            this.headerData[n] = null;
            ++n;
        }
        this.size = 0;
    }

    public Object clone() {
        try {
            HeaderMap headerMap = (HeaderMap)super.clone();
            headerMap.headerData = new Header[this.size];
            System.arraycopy(this.headerData, 0, headerMap.headerData, 0, this.size);
            return headerMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean containsFieldName(String string) {
        return this.getFieldValues(string).length > 0;
    }

    public void ensureCapacity(int n) {
        int n2 = this.headerData.length;
        if (n > n2) {
            Header[] headerArray = this.headerData;
            int n3 = n2 * 3 / 2 + 1;
            if (n3 < n) {
                n3 = n;
            }
            this.headerData = new Header[n3];
            System.arraycopy(headerArray, 0, this.headerData, 0, this.size);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof HeaderMap && this.size == ((HeaderMap)object).size) {
            int n = 0;
            while (n < this.size) {
                if (!Header.access$000(this.headerData[n]).equalsIgnoreCase(Header.access$000(((HeaderMap)object).headerData[n])) || !Header.access$100(this.headerData[n]).equals(Header.access$100(((HeaderMap)object).headerData[n]))) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public Header get(int n) {
        if (n >= 0 && n < this.size) {
            return this.headerData[n];
        }
        return null;
    }

    public String getFieldName(int n) {
        if (n >= 0 && n < this.size) {
            return Header.access$000(this.headerData[n]);
        }
        return null;
    }

    public String getFieldValue(int n) {
        if (n >= 0 && n < this.size) {
            return Header.access$100(this.headerData[n]);
        }
        return null;
    }

    public String[] getFieldValues(String string) {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while ((n = this.OEAB(string, n)) != -1) {
            vector.addElement(Header.access$100(this.headerData[n]));
            ++n;
        }
        String[] stringArray = new String[vector.size()];
        int n2 = 0;
        while (n2 < stringArray.length) {
            stringArray[n2] = (String)vector.elementAt(n2);
            ++n2;
        }
        return stringArray;
    }

    public int getSize() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void putHeader(String string, String string2) {
        if (string != null && string.trim().length() != 0 && string2 != null) {
            if (this.containsFieldName(string)) {
                String[] stringArray = this.getFieldValues(string);
                int n = 0;
                while (n < stringArray.length) {
                    if (string2.equals(stringArray[n])) {
                        return;
                    }
                    ++n;
                }
            }
            this.ensureCapacity(this.size + 1);
            this.headerData[this.size++] = new Header(this, string, string2, null);
        }
    }

    public void putHeader(String string, String string2, boolean bl) {
        if (bl && this.containsFieldName(string)) {
            this.removeHeaders(string);
        }
        this.putHeader(string, string2);
    }

    public void removeHeader(int n) {
        if (n >= 0 && n < this.size) {
            int n2 = this.size - n - 1;
            if (n2 > 0) {
                System.arraycopy(this.headerData, n + 1, this.headerData, n, n2);
            }
            this.headerData[--this.size] = null;
        }
    }

    public void removeHeaders(String string) {
        int n = 0;
        while ((n = this.OEAB(string, n)) != -1) {
            this.removeHeader(n);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("HeaderMap [");
        int n = 0;
        while (n < this.size) {
            if (n != 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append("\r\n    " + this.headerData[n]);
            ++n;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private int OEAB(String string, int n) {
        if (n >= 0 && n < this.size) {
            int n2 = n;
            while (n2 < this.size) {
                if (Header.access$000(this.headerData[n2]).equalsIgnoreCase(string)) {
                    return n2;
                }
                ++n2;
            }
        }
        return -1;
    }

    class 1 {
    }

    public class Header {
        private String OEAB;
        private String append;
        private final HeaderMap this$0;

        private Header(HeaderMap headerMap, String string, String string2) {
            this.this$0 = headerMap;
            this.OEAB = string;
            this.append = string2;
        }

        public boolean equals(Object object) {
            return object instanceof Header && this.OEAB.equals(((Header)object).OEAB) && this.append.equals(((Header)object).append) && super.equals(object);
        }

        public String getFieldName() {
            return this.OEAB;
        }

        public String getFieldValue() {
            return this.append;
        }

        public String toString() {
            return this.OEAB + ": " + this.append;
        }

        static String access$000(Header header) {
            return header.OEAB;
        }

        static String access$100(Header header) {
            return header.append;
        }

        Header(HeaderMap headerMap, String string, String string2, 1 var4_4) {
            this(headerMap, string, string2);
        }
    }
}

