/*
 * Decompiled with CFR 0.152.
 */
package ice.net;

import ice.util.Defs;
import ice.util.Settings;
import java.io.Serializable;

public class CookieManagerSettings
implements Serializable,
Settings {
    private boolean cookieExpirationBufferEnabled;
    private boolean persistPrivateCookies;

    public CookieManagerSettings() {
        this.OEAB();
    }

    public boolean equals(Object object) {
        return object instanceof CookieManagerSettings && ((CookieManagerSettings)object).cookieExpirationBufferEnabled == this.cookieExpirationBufferEnabled && ((CookieManagerSettings)object).persistPrivateCookies == this.persistPrivateCookies;
    }

    public boolean isCookieExpirationBufferEnabled() {
        return this.cookieExpirationBufferEnabled;
    }

    public static boolean isDefaultCookieExpirationBufferEnabled() {
        return Defs.sysPropertyBoolean((String)"ice.net.cookieExpirationBufferEnabled", (boolean)false);
    }

    public void resetToDefault() {
        this.OEAB();
    }

    public void setCookieExpirationBufferEnabled(boolean bl) {
        this.cookieExpirationBufferEnabled = bl;
    }

    public static void setDefaultCookieExpirationBufferEnabled(boolean bl) {
        Defs.setSystemProperty((String)"ice.net.cookieExpirationBufferEnabled", (String)new Boolean(bl).toString());
    }

    public static void setDefaultPersistPrivateCookies(boolean bl) {
        Defs.setSystemProperty((String)"ice.net.persistPrivateCookies", (String)new Boolean(bl).toString());
    }

    public void setPersistPrivateCookies(boolean bl) {
        this.persistPrivateCookies = bl;
    }

    public static boolean shouldDefaultPersistPrivateCookies() {
        return Defs.sysPropertyBoolean((String)"ice.net.persistPrivateCookies", (boolean)true);
    }

    public boolean shouldPersistPrivateCookies() {
        return this.persistPrivateCookies;
    }

    public String toString() {
        return "CookieManagerSettings [cookieExpirationBufferEnabled: " + this.cookieExpirationBufferEnabled + ", " + "persistPrivateCookies: " + this.persistPrivateCookies + "]";
    }

    private void OEAB() {
        this.cookieExpirationBufferEnabled = CookieManagerSettings.isDefaultCookieExpirationBufferEnabled();
        this.persistPrivateCookies = CookieManagerSettings.shouldDefaultPersistPrivateCookies();
    }
}

