/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xqj;

import java.io.InputStream;
import java.io.Reader;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import net.sf.saxon.javax.xml.xquery.XQConstants;
import net.sf.saxon.javax.xml.xquery.XQDynamicContext;
import net.sf.saxon.javax.xml.xquery.XQException;
import net.sf.saxon.javax.xml.xquery.XQItem;
import net.sf.saxon.javax.xml.xquery.XQItemType;
import net.sf.saxon.javax.xml.xquery.XQSequence;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.query.DynamicQueryContext;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.xqj.SaxonXQConnection;
import net.sf.saxon.xqj.SaxonXQDataFactory;
import net.sf.saxon.xqj.SaxonXQForwardSequence;
import net.sf.saxon.xqj.SaxonXQItem;
import net.sf.saxon.xqj.SaxonXQSequence;
import org.w3c.dom.Node;
import org.xml.sax.XMLReader;

public abstract class SaxonXQDynamicContext
implements XQDynamicContext {
    protected SaxonXQConnection connection;

    protected abstract DynamicQueryContext getDynamicContext();

    protected abstract void checkNotClosed() throws XQException;

    protected abstract SaxonXQDataFactory getDataFactory() throws XQException;

    public void bindAtomicValue(QName varname, String value, XQItemType type) throws XQException {
        this.checkNotClosed();
        SaxonXQItem item = (SaxonXQItem)this.getDataFactory().createItemFromAtomicValue(value, type);
        this.bindExternalVariable(varname, (ValueRepresentation)item.getItem());
    }

    public void bindBoolean(QName varname, boolean value, XQItemType type) throws XQException {
        this.checkNotClosed();
        this.bindExternalVariable(varname, (ValueRepresentation)BooleanValue.get((boolean)value));
    }

    public void bindByte(QName varname, byte value, XQItemType type) throws XQException {
        this.checkNotClosed();
        SaxonXQItem item = (SaxonXQItem)this.getDataFactory().createItemFromByte(value, type);
        this.bindExternalVariable(varname, (ValueRepresentation)item.getItem());
    }

    public void bindDocument(QName varname, InputStream value, XQItemType type) throws XQException {
        this.checkNotClosed();
        SaxonXQItem item = (SaxonXQItem)this.connection.createItemFromDocument(value, type);
        this.bindExternalVariable(varname, (ValueRepresentation)item.getItem());
    }

    public void bindDocument(QName varname, Reader value, XQItemType type) throws XQException {
        this.checkNotClosed();
        SaxonXQItem item = (SaxonXQItem)this.connection.createItemFromDocument(value, type);
        this.bindExternalVariable(varname, (ValueRepresentation)item.getItem());
    }

    public void bindDocument(QName varname, Source value, XQItemType type) throws XQException {
        this.checkNotClosed();
        SaxonXQItem item = (SaxonXQItem)this.connection.createItemFromDocument(value, type);
        this.bindExternalVariable(varname, (ValueRepresentation)item.getItem());
    }

    public void bindDocument(QName varname, String value, XQItemType type) throws XQException {
        this.checkNotClosed();
        SaxonXQItem item = (SaxonXQItem)this.connection.createItemFromDocument(value, type);
        this.bindExternalVariable(varname, (ValueRepresentation)item.getItem());
    }

    public void bindDocument(QName varname, XMLReader value, XQItemType type) throws XQException {
        this.checkNotClosed();
        SaxonXQItem item = (SaxonXQItem)this.connection.createItemFromDocument(value, type);
        this.bindExternalVariable(varname, (ValueRepresentation)item.getItem());
    }

    public void bindDocument(QName varname, XMLStreamReader value, XQItemType type) throws XQException {
        this.checkNotClosed();
        SaxonXQItem item = (SaxonXQItem)this.connection.createItemFromDocument(value, type);
        this.bindExternalVariable(varname, (ValueRepresentation)item.getItem());
    }

    public void bindDouble(QName varname, double value, XQItemType type) throws XQException {
        this.checkNotClosed();
        this.getDynamicContext().setParameterValue(this.getClarkName(varname), (ValueRepresentation)new DoubleValue(value));
    }

    public void bindFloat(QName varname, float value, XQItemType type) throws XQException {
        this.checkNotClosed();
        this.getDynamicContext().setParameterValue(this.getClarkName(varname), (ValueRepresentation)new FloatValue(value));
    }

    public void bindInt(QName varname, int value, XQItemType type) throws XQException {
        this.checkNotClosed();
        SaxonXQItem item = (SaxonXQItem)this.getDataFactory().createItemFromInt(value, type);
        this.bindExternalVariable(varname, (ValueRepresentation)item.getItem());
    }

    public void bindItem(QName varname, XQItem value) throws XQException {
        this.checkNotClosed();
        this.bindExternalVariable(varname, (ValueRepresentation)((SaxonXQItem)value).getItem());
    }

    public void bindLong(QName varname, long value, XQItemType type) throws XQException {
        this.checkNotClosed();
        SaxonXQItem item = (SaxonXQItem)this.getDataFactory().createItemFromLong(value, type);
        this.bindExternalVariable(varname, (ValueRepresentation)item.getItem());
    }

    public void bindNode(QName varname, Node value, XQItemType type) throws XQException {
        this.checkNotClosed();
        SaxonXQItem item = (SaxonXQItem)this.getDataFactory().createItemFromNode(value, type);
        this.bindExternalVariable(varname, (ValueRepresentation)item.getItem());
    }

    public void bindObject(QName varname, Object value, XQItemType type) throws XQException {
        this.checkNotClosed();
        SaxonXQItem item = (SaxonXQItem)this.getDataFactory().createItemFromObject(value, type);
        this.bindExternalVariable(varname, (ValueRepresentation)item.getItem());
    }

    public void bindSequence(QName varname, XQSequence value) throws XQException {
        block4: {
            this.checkNotClosed();
            try {
                if (value instanceof SaxonXQForwardSequence) {
                    this.getDynamicContext().setParameter(this.getClarkName(varname), (Object)((SaxonXQForwardSequence)value).getCleanIterator());
                    break block4;
                }
                if (value instanceof SaxonXQSequence) {
                    this.bindExternalVariable(varname, (ValueRepresentation)((SaxonXQSequence)value).getValue());
                    break block4;
                }
                throw new XQException("XQSequence value is not a Saxon sequence");
            }
            catch (XPathException de) {
                XQException err = new XQException(de.getMessage());
                err.initCause(de);
                throw err;
            }
        }
    }

    public void bindShort(QName varname, short value, XQItemType type) throws XQException {
        this.checkNotClosed();
        SaxonXQItem item = (SaxonXQItem)this.getDataFactory().createItemFromShort(value, type);
        this.bindExternalVariable(varname, (ValueRepresentation)item.getItem());
    }

    public void bindString(QName varname, String value, XQItemType type) throws XQException {
        this.checkNotClosed();
        SaxonXQItem item = (SaxonXQItem)this.getDataFactory().createItemFromString(value, type);
        this.bindExternalVariable(varname, (ValueRepresentation)item.getItem());
    }

    public TimeZone getImplicitTimeZone() throws XQException {
        this.checkNotClosed();
        return null;
    }

    public void setImplicitTimeZone(TimeZone implicitTimeZone) throws XQException {
        this.checkNotClosed();
    }

    private void bindExternalVariable(QName varName, ValueRepresentation value) throws XQException {
        try {
            if (varName.equals(XQConstants.CONTEXT_ITEM)) {
                this.getDynamicContext().setContextItem(Value.asItem((ValueRepresentation)value));
            } else {
                this.getDynamicContext().setParameterValue(this.getClarkName(varName), value);
            }
        }
        catch (XPathException e) {
            XQException err = new XQException(e.getMessage());
            err.initCause(e);
            throw err;
        }
    }

    private String getClarkName(QName qname) {
        String uri = qname.getNamespaceURI();
        return "{" + (uri == null ? "" : uri) + "}" + qname.getLocalPart();
    }
}

