/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene;

import com.sun.javafx.Logging;
import com.sun.javafx.Utils;
import com.sun.javafx.beans.event.AbstractNotifyListener;
import com.sun.javafx.collections.TrackableObservableList;
import com.sun.javafx.css.StyleManager;
import com.sun.javafx.cursor.CursorFrame;
import com.sun.javafx.event.EventQueue;
import com.sun.javafx.geom.PickRay;
import com.sun.javafx.geom.transform.Affine2D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.perf.PerformanceTracker;
import com.sun.javafx.robot.impl.FXRobotHelper;
import com.sun.javafx.runtime.SystemProperties;
import com.sun.javafx.scene.CSSFlags;
import com.sun.javafx.scene.SceneEventDispatcher;
import com.sun.javafx.scene.traversal.Direction;
import com.sun.javafx.scene.traversal.TraversalEngine;
import com.sun.javafx.tk.TKDragGestureListener;
import com.sun.javafx.tk.TKDragSourceListener;
import com.sun.javafx.tk.TKDropTargetListener;
import com.sun.javafx.tk.TKPulseListener;
import com.sun.javafx.tk.TKScene;
import com.sun.javafx.tk.TKSceneListener;
import com.sun.javafx.tk.TKScenePaintListener;
import com.sun.javafx.tk.TKStage;
import com.sun.javafx.tk.Toolkit;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.DefaultProperty;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventDispatchChain;
import javafx.event.EventDispatcher;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.geometry.Bounds;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.scene.Camera;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.PerspectiveCamera;
import javafx.scene.SnapshotResult;
import javafx.scene.image.WritableImage;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.GestureEvent;
import javafx.scene.input.InputMethodEvent;
import javafx.scene.input.InputMethodRequests;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.Mnemonic;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseDragEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.RotateEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.input.SwipeEvent;
import javafx.scene.input.TouchEvent;
import javafx.scene.input.TouchPoint;
import javafx.scene.input.TransferMode;
import javafx.scene.input.ZoomEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.util.Callback;
import javafx.util.Duration;

@DefaultProperty(value="root")
public class Scene
implements EventTarget {
    private double widthSetByUser = -1.0;
    private double heightSetByUser = -1.0;
    private boolean sizeInitialized = false;
    private boolean depthBuffer = false;
    private int dirtyBits;
    private static final int MIN_DIRTY_CAPACITY = 30;
    private static boolean inSynchronizer;
    private static boolean inMousePick;
    private static boolean allowPGAccess;
    private static int pgAccessCount;
    private static boolean paused;
    private static final boolean PLATFORM_DRAG_GESTURE_INITIATION = false;
    private Node[] dirtyNodes;
    private int dirtyNodesSize;
    private Set<Parent> dirtyLayoutRootsA = new LinkedHashSet<Parent>(10);
    private Set<Parent> dirtyLayoutRootsB = new LinkedHashSet<Parent>(10);
    private Set<Parent> dirtyLayoutRoots = this.dirtyLayoutRootsA;
    @Deprecated
    private TKScene impl_peer;
    ScenePulseListener scenePulseListener = new ScenePulseListener();
    private ReadOnlyObjectWrapper<Window> window;
    DnDGesture dndGesture = null;
    DragGestureListener dragGestureListener;
    private ReadOnlyDoubleWrapper x;
    private ReadOnlyDoubleWrapper y;
    private ReadOnlyDoubleWrapper width;
    private ReadOnlyDoubleWrapper height;
    private Camera pickingCamera;
    private TargetWrapper tmpTargetWrapper = new TargetWrapper();
    private ObjectProperty<Camera> camera;
    private Camera oldCamera;
    private final AbstractNotifyListener cameraChangeListener = new AbstractNotifyListener(){

        @Override
        public void invalidated(Observable observable) {
            if (Scene.this.getCamera().isDirty()) {
                Scene.this.markDirty(DirtyBits.CAMERA_DIRTY);
            }
        }
    };
    private ObjectProperty<Paint> fill;
    private ObjectProperty<Parent> root;
    Parent oldRoot;
    private static TKPulseListener snapshotPulseListener;
    private static List<Runnable> snapshotRunnableListA;
    private static List<Runnable> snapshotRunnableListB;
    private static List<Runnable> snapshotRunnableList;
    boolean initialized = false;
    private ObjectProperty<Cursor> cursor;
    private final ObservableList<String> stylesheets = new TrackableObservableList<String>(){

        @Override
        protected void onChanged(ListChangeListener.Change<String> change) {
            StyleManager.getInstance().updateStylesheets(Scene.this);
            while (change.next()) {
                if (!change.wasRemoved()) continue;
                Scene.this.getRoot().impl_cssResetInitialValues();
                break;
            }
            Scene.this.getRoot().impl_reapplyCSS();
        }
    };
    private PerformanceTracker tracker;
    private static final Object trackerMonitor;
    private MouseHandler mouseHandler;
    private ClickGenerator clickGenerator;
    private Point2D cursorScreenPos;
    private Point2D cursorScenePos;
    private final TouchGesture scrollGesture = new TouchGesture();
    private final TouchGesture zoomGesture = new TouchGesture();
    private final TouchGesture rotateGesture = new TouchGesture();
    private final TouchGesture swipeGesture = new TouchGesture();
    private TouchMap touchMap = new TouchMap();
    private TouchEvent nextTouchEvent = null;
    private TouchPoint[] touchPoints = null;
    private int touchEventSetId = 0;
    private int touchPointIndex = 0;
    private Map<Integer, EventTarget> touchTargets = new HashMap<Integer, EventTarget>();
    private KeyHandler keyHandler = null;
    private boolean focusDirty = true;
    Map traversalRegistry;
    private Node oldFocusOwner;
    private ReadOnlyObjectWrapper<Node> focusOwner = new ReadOnlyObjectWrapper<Node>((Object)this, "focusOwner"){

        @Override
        protected void invalidated() {
            PlatformLogger platformLogger;
            Node node;
            if (Scene.this.oldFocusOwner != null) {
                ((Node.FocusedProperty)Scene.this.oldFocusOwner.focusedProperty()).store(false);
            }
            if ((node = (Node)this.get()) != null) {
                ((Node.FocusedProperty)node.focusedProperty()).store(Scene.this.keyHandler.windowFocused);
                if (node != Scene.this.oldFocusOwner) {
                    node.getScene().impl_enableInputMethodEvents(node.getInputMethodRequests() != null && node.getOnInputMethodTextChanged() != null);
                }
            }
            if (Scene.this.oldFocusOwner != null) {
                ((Node.FocusedProperty)Scene.this.oldFocusOwner.focusedProperty()).notifyListeners();
            }
            if (node != null) {
                ((Node.FocusedProperty)node.focusedProperty()).notifyListeners();
            }
            if ((platformLogger = Logging.getFocusLogger()).isLoggable(500)) {
                platformLogger.fine("Changed focus from " + Scene.this.oldFocusOwner + " to " + node);
            }
            Scene.this.oldFocusOwner = node;
        }
    };
    Runnable testPulseListener = null;
    private ObjectProperty<EventDispatcher> eventDispatcher;
    private SceneEventDispatcher internalEventDispatcher;
    private ObjectProperty<EventHandler<? super ContextMenuEvent>> onContextMenuRequested;
    private ObjectProperty<EventHandler<? super MouseEvent>> onMouseClicked;
    private ObjectProperty<EventHandler<? super MouseEvent>> onMouseDragged;
    private ObjectProperty<EventHandler<? super MouseEvent>> onMouseEntered;
    private ObjectProperty<EventHandler<? super MouseEvent>> onMouseExited;
    private ObjectProperty<EventHandler<? super MouseEvent>> onMouseMoved;
    private ObjectProperty<EventHandler<? super MouseEvent>> onMousePressed;
    private ObjectProperty<EventHandler<? super MouseEvent>> onMouseReleased;
    private ObjectProperty<EventHandler<? super MouseEvent>> onDragDetected;
    private ObjectProperty<EventHandler<? super MouseDragEvent>> onMouseDragOver;
    private ObjectProperty<EventHandler<? super MouseDragEvent>> onMouseDragReleased;
    private ObjectProperty<EventHandler<? super MouseDragEvent>> onMouseDragEntered;
    private ObjectProperty<EventHandler<? super MouseDragEvent>> onMouseDragExited;
    private ObjectProperty<EventHandler<? super ScrollEvent>> onScrollStarted;
    private ObjectProperty<EventHandler<? super ScrollEvent>> onScroll;
    private ObjectProperty<EventHandler<? super ScrollEvent>> onScrollFinished;
    private ObjectProperty<EventHandler<? super RotateEvent>> onRotationStarted;
    private ObjectProperty<EventHandler<? super RotateEvent>> onRotate;
    private ObjectProperty<EventHandler<? super RotateEvent>> onRotationFinished;
    private ObjectProperty<EventHandler<? super ZoomEvent>> onZoomStarted;
    private ObjectProperty<EventHandler<? super ZoomEvent>> onZoom;
    private ObjectProperty<EventHandler<? super ZoomEvent>> onZoomFinished;
    private ObjectProperty<EventHandler<? super SwipeEvent>> onSwipeUp;
    private ObjectProperty<EventHandler<? super SwipeEvent>> onSwipeDown;
    private ObjectProperty<EventHandler<? super SwipeEvent>> onSwipeLeft;
    private ObjectProperty<EventHandler<? super SwipeEvent>> onSwipeRight;
    private ObjectProperty<EventHandler<? super TouchEvent>> onTouchPressed;
    private ObjectProperty<EventHandler<? super TouchEvent>> onTouchMoved;
    private ObjectProperty<EventHandler<? super TouchEvent>> onTouchReleased;
    private ObjectProperty<EventHandler<? super TouchEvent>> onTouchStationary;
    private ObjectProperty<EventHandler<? super DragEvent>> onDragEntered;
    private ObjectProperty<EventHandler<? super DragEvent>> onDragExited;
    private ObjectProperty<EventHandler<? super DragEvent>> onDragOver;
    private ObjectProperty<EventHandler<? super DragEvent>> onDragDropped;
    private ObjectProperty<EventHandler<? super DragEvent>> onDragDone;
    private ObjectProperty<EventHandler<? super KeyEvent>> onKeyPressed;
    private ObjectProperty<EventHandler<? super KeyEvent>> onKeyReleased;
    private ObjectProperty<EventHandler<? super KeyEvent>> onKeyTyped;
    private ObjectProperty<EventHandler<? super InputMethodEvent>> onInputMethodTextChanged;

    public Scene(Parent parent) {
        this(parent, -1.0, -1.0, Color.WHITE, false);
    }

    public Scene(Parent parent, double d, double d2) {
        this(parent, d, d2, Color.WHITE, false);
    }

    public Scene(Parent parent, Paint paint) {
        this(parent, -1.0, -1.0, paint, false);
    }

    public Scene(Parent parent, double d, double d2, Paint paint) {
        this(parent, d, d2, paint, false);
    }

    public Scene(Parent parent, double d, double d2, boolean bl) {
        this(parent, d, d2, Color.WHITE, bl);
    }

    private Scene(Parent parent, double d, double d2, Paint paint, boolean bl) {
        Toolkit.getToolkit().checkFxUserThread();
        this.setRoot(parent);
        this.init(d, d2, bl);
        this.setFill(paint);
    }

    static boolean isPGAccessAllowed() {
        return inSynchronizer || inMousePick || allowPGAccess;
    }

    @Deprecated
    public static void impl_setAllowPGAccess(boolean bl) {
        if (Utils.assertionEnabled()) {
            if (bl) {
                ++pgAccessCount;
                allowPGAccess = true;
            } else {
                if (pgAccessCount <= 0) {
                    throw new AssertionError((Object)"*** pgAccessCount underflow");
                }
                if (--pgAccessCount == 0) {
                    allowPGAccess = false;
                }
            }
        }
    }

    void addToDirtyList(Node node) {
        if ((this.dirtyNodes == null || this.dirtyNodesSize == 0) && this.impl_peer != null) {
            Toolkit.getToolkit().requestNextPulse();
        }
        if (this.dirtyNodes != null) {
            if (this.dirtyNodesSize == this.dirtyNodes.length) {
                Node[] nodeArray = new Node[this.dirtyNodesSize + (this.dirtyNodesSize >> 1)];
                System.arraycopy(this.dirtyNodes, 0, nodeArray, 0, this.dirtyNodesSize);
                this.dirtyNodes = nodeArray;
            }
            this.dirtyNodes[this.dirtyNodesSize++] = node;
        }
    }

    private void doCSSPass() {
        Parent parent = this.getRoot();
        if (parent.cssFlag != CSSFlags.CLEAN) {
            parent.impl_clearDirty(com.sun.javafx.scene.DirtyBits.NODE_CSS);
            parent.processCSS();
        }
    }

    @Deprecated
    public void addToDirtyLayoutList(Parent parent) {
        if (this.dirtyLayoutRoots.isEmpty()) {
            Toolkit.getToolkit().requestNextPulse();
        }
        this.dirtyLayoutRoots.add(parent);
    }

    void removeFromDirtyLayoutList(Parent parent) {
        this.dirtyLayoutRoots.remove(parent);
    }

    private void doLayoutPass() {
        this.layoutDirtyRoots();
        this.layoutDirtyRoots();
        if (this.dirtyLayoutRoots.size() > 0) {
            PlatformLogger platformLogger = Logging.getLayoutLogger();
            if (platformLogger.isLoggable(400)) {
                platformLogger.finer("after layout pass, " + this.dirtyLayoutRoots.size() + " layout root nodes still dirty");
            }
            Toolkit.getToolkit().requestNextPulse();
        }
    }

    private void layoutDirtyRoots() {
        if (this.dirtyLayoutRoots.size() > 0) {
            PlatformLogger platformLogger = Logging.getLayoutLogger();
            Set<Parent> set = this.dirtyLayoutRoots;
            this.dirtyLayoutRoots = this.dirtyLayoutRoots == this.dirtyLayoutRootsA ? this.dirtyLayoutRootsB : this.dirtyLayoutRootsA;
            for (Parent parent : set) {
                if (parent.getScene() != this || !parent.isNeedsLayout()) continue;
                if (platformLogger.isLoggable(500)) {
                    platformLogger.fine("<<< START >>> root = " + parent.toString());
                }
                parent.layout();
                if (!platformLogger.isLoggable(500)) continue;
                platformLogger.fine("<<<  END  >>> root = " + parent.toString());
            }
            set.clear();
        }
    }

    @Deprecated
    public TKScene impl_getPeer() {
        return this.impl_peer;
    }

    @Deprecated
    public TKPulseListener impl_getScenePulseListener() {
        if (SystemProperties.isDebug()) {
            return this.scenePulseListener;
        }
        return null;
    }

    private void setWindow(Window window) {
        this.windowPropertyImpl().set(window);
    }

    public final Window getWindow() {
        return this.window == null ? null : (Window)this.window.get();
    }

    public final ReadOnlyObjectProperty<Window> windowProperty() {
        return this.windowPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyObjectWrapper<Window> windowPropertyImpl() {
        if (this.window == null) {
            this.window = new ReadOnlyObjectWrapper<Window>(){
                private Window oldWindow;

                @Override
                protected void invalidated() {
                    Window window = (Window)this.get();
                    Scene.this.getKeyHandler().windowForSceneChanged(this.oldWindow, window);
                    if (this.oldWindow != null) {
                        Scene.this.impl_disposePeer();
                    }
                    if (window != null) {
                        Scene.this.impl_initPeer();
                    }
                    this.oldWindow = window;
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "window";
                }
            };
        }
        return this.window;
    }

    @Deprecated
    public void impl_setWindow(Window window) {
        this.setWindow(window);
        if (this.impl_peer != null) {
            this.impl_peer.markDirty();
        }
    }

    @Deprecated
    public void impl_initPeer() {
        if (this.impl_peer != null) {
            return;
        }
        PerformanceTracker.logEvent("Scene.initPeer started");
        Toolkit toolkit = Toolkit.getToolkit();
        if (this.getWindow() == null) {
            return;
        }
        TKStage tKStage = this.getWindow().impl_getPeer();
        if (tKStage == null) {
            return;
        }
        Scene.impl_setAllowPGAccess(true);
        this.impl_peer = tKStage.createTKScene(this.isDepthBuffer());
        PerformanceTracker.logEvent("Scene.initPeer TKScene created");
        this.impl_peer.setTKSceneListener(new ScenePeerListener());
        this.impl_peer.setTKScenePaintListener(new ScenePeerPaintListener());
        this.impl_peer.setScene(this);
        PerformanceTracker.logEvent("Scene.initPeer TKScene set");
        this.impl_peer.setRoot(this.getRoot().impl_getPGNode());
        this.impl_peer.setFillPaint(this.getFill() == null ? null : toolkit.getPaint(this.getFill()));
        this.impl_peer.setCamera(this.getCamera() == null ? null : this.getCamera().getPlatformCamera());
        this.pickingCamera = this.getCamera();
        Scene.impl_setAllowPGAccess(false);
        PerformanceTracker.logEvent("Scene.initPeer TKScene initialized");
        toolkit.addSceneTkPulseListener(this.scenePulseListener);
        toolkit.enableDrop(this.impl_peer, new DropTargetListener());
        toolkit.installInputMethodRequests(this.impl_peer, new InputMethodRequestsDelegate());
        PerformanceTracker.logEvent("Scene.initPeer finished");
    }

    @Deprecated
    public void impl_disposePeer() {
        if (this.impl_peer == null) {
            return;
        }
        Toolkit toolkit = Toolkit.getToolkit();
        toolkit.removeSceneTkPulseListener(this.scenePulseListener);
        this.impl_peer.setScene(null);
        this.impl_peer = null;
    }

    private final void setX(double d) {
        this.xPropertyImpl().set(d);
    }

    public final double getX() {
        return this.x == null ? 0.0 : this.x.get();
    }

    public final ReadOnlyDoubleProperty xProperty() {
        return this.xPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyDoubleWrapper xPropertyImpl() {
        if (this.x == null) {
            this.x = new ReadOnlyDoubleWrapper(this, "x");
        }
        return this.x;
    }

    private final void setY(double d) {
        this.yPropertyImpl().set(d);
    }

    public final double getY() {
        return this.y == null ? 0.0 : this.y.get();
    }

    public final ReadOnlyDoubleProperty yProperty() {
        return this.yPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyDoubleWrapper yPropertyImpl() {
        if (this.y == null) {
            this.y = new ReadOnlyDoubleWrapper(this, "y");
        }
        return this.y;
    }

    private final void setWidth(double d) {
        this.widthPropertyImpl().set(d);
    }

    public final double getWidth() {
        return this.width == null ? 0.0 : this.width.get();
    }

    public final ReadOnlyDoubleProperty widthProperty() {
        return this.widthPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyDoubleWrapper widthPropertyImpl() {
        if (this.width == null) {
            this.width = new ReadOnlyDoubleWrapper(){

                @Override
                protected void invalidated() {
                    Parent parent = Scene.this.getRoot();
                    if (parent.isResizable()) {
                        parent.resize(this.get() - parent.getLayoutX() - parent.getTranslateX(), parent.getLayoutBounds().getHeight());
                    }
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "width";
                }
            };
        }
        return this.width;
    }

    private final void setHeight(double d) {
        this.heightPropertyImpl().set(d);
    }

    public final double getHeight() {
        return this.height == null ? 0.0 : this.height.get();
    }

    public final ReadOnlyDoubleProperty heightProperty() {
        return this.heightPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyDoubleWrapper heightPropertyImpl() {
        if (this.height == null) {
            this.height = new ReadOnlyDoubleWrapper(){

                @Override
                protected void invalidated() {
                    Parent parent = Scene.this.getRoot();
                    if (parent.isResizable()) {
                        parent.resize(parent.getLayoutBounds().getWidth(), this.get() - parent.getLayoutY() - parent.getTranslateY());
                    }
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "height";
                }
            };
        }
        return this.height;
    }

    public final void setCamera(Camera camera) {
        this.cameraProperty().set(camera);
    }

    public final Camera getCamera() {
        return this.camera == null ? null : (Camera)this.camera.get();
    }

    public final ObjectProperty<Camera> cameraProperty() {
        if (this.camera == null) {
            this.camera = new ObjectPropertyBase<Camera>(){

                @Override
                protected void invalidated() {
                    if (Scene.this.oldCamera != null) {
                        Scene.this.oldCamera.dirtyProperty().removeListener(Scene.this.cameraChangeListener.getWeakListener());
                    }
                    Scene.this.oldCamera = (Camera)this.get();
                    if (this.get() != null) {
                        ((Camera)this.get()).dirtyProperty().addListener(Scene.this.cameraChangeListener.getWeakListener());
                    }
                    Scene.this.markDirty(DirtyBits.CAMERA_DIRTY);
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "camera";
                }
            };
        }
        return this.camera;
    }

    public final void setFill(Paint paint) {
        this.fillProperty().set(paint);
    }

    public final Paint getFill() {
        return this.fill == null ? Color.WHITE : (Paint)this.fill.get();
    }

    public final ObjectProperty<Paint> fillProperty() {
        if (this.fill == null) {
            this.fill = new ObjectPropertyBase<Paint>((Paint)Color.WHITE){

                @Override
                protected void invalidated() {
                    Scene.this.markDirty(DirtyBits.FILL_DIRTY);
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "fill";
                }
            };
        }
        return this.fill;
    }

    public final void setRoot(Parent parent) {
        this.rootProperty().set(parent);
    }

    public final Parent getRoot() {
        return this.root == null ? null : (Parent)this.root.get();
    }

    public final ObjectProperty<Parent> rootProperty() {
        if (this.root == null) {
            this.root = new ObjectPropertyBase<Parent>(){

                private void forceUnbind() {
                    System.err.println("Unbinding illegal root.");
                    this.unbind();
                }

                @Override
                protected void invalidated() {
                    Parent parent = (Parent)this.get();
                    if (parent == null) {
                        if (this.isBound()) {
                            this.forceUnbind();
                        }
                        throw new NullPointerException("Scene's root cannot be null");
                    }
                    if (parent.getParent() != null) {
                        if (this.isBound()) {
                            this.forceUnbind();
                        }
                        throw new IllegalArgumentException(parent + "is already inside a scene-graph and cannot be set as root");
                    }
                    if (parent.getClipParent() != null) {
                        if (this.isBound()) {
                            this.forceUnbind();
                        }
                        throw new IllegalArgumentException(parent + "is set as a clip on another node, so cannot be set as root");
                    }
                    if (parent.isSceneRoot() && parent.getScene() != Scene.this) {
                        if (this.isBound()) {
                            this.forceUnbind();
                        }
                        throw new IllegalArgumentException(parent + "is already set as root of another scene");
                    }
                    if (Scene.this.oldRoot != null) {
                        Scene.this.oldRoot.setScene(null);
                        Scene.this.oldRoot.setImpl_traversalEngine(null);
                    }
                    Scene.this.oldRoot = parent;
                    if (parent.getImpl_traversalEngine() == null) {
                        parent.setImpl_traversalEngine(new TraversalEngine(parent, true));
                    }
                    parent.getStyleClass().add(0, "root");
                    parent.setScene(Scene.this);
                    Scene.this.markDirty(DirtyBits.ROOT_DIRTY);
                    parent.resize(Scene.this.getWidth(), Scene.this.getHeight());
                    parent.requestLayout();
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "root";
                }
            };
        }
        return this.root;
    }

    @Deprecated
    public Object renderToImage(Object object) {
        return this.renderToImage(object, 1.0f);
    }

    @Deprecated
    public Object renderToImage(Object object, float f) {
        if (!paused) {
            Toolkit.getToolkit().checkFxUserThread();
        }
        return this.doSnapshot(null, f).impl_getPlatformImage();
    }

    private void doLayoutPassWithoutPulse(int n) {
        for (int i = 0; this.dirtyLayoutRoots.size() > 0 && i != n; ++i) {
            this.layoutDirtyRoots();
        }
    }

    void setNeedsRepaint() {
        if (this.impl_peer != null) {
            this.impl_peer.entireSceneNeedsRepaint();
        }
    }

    void doCSSLayoutSyncForSnapshot(Node node) {
        if (!this.sizeInitialized) {
            this.preferredSize();
        } else {
            this.doCSSPass();
        }
        this.doLayoutPassWithoutPulse(3);
        if (!paused) {
            this.scenePulseListener.synchronizeSceneNodes();
        }
    }

    static WritableImage doSnapshot(Scene scene, double d, double d2, double d3, double d4, Node node, BaseTransform baseTransform, boolean bl, Paint paint, Camera camera, WritableImage writableImage) {
        Toolkit toolkit = Toolkit.getToolkit();
        Toolkit.ImageRenderingContext imageRenderingContext = new Toolkit.ImageRenderingContext();
        int n = (int)Math.floor(d);
        int n2 = (int)Math.floor(d2);
        int n3 = (int)Math.ceil(d + d3);
        int n4 = (int)Math.ceil(d2 + d4);
        int n5 = Math.max(n3 - n, 1);
        int n6 = Math.max(n4 - n2, 1);
        if (writableImage == null) {
            writableImage = new WritableImage(n5, n6);
        } else {
            n5 = (int)writableImage.getWidth();
            n6 = (int)writableImage.getHeight();
        }
        Scene.impl_setAllowPGAccess(true);
        imageRenderingContext.x = n;
        imageRenderingContext.y = n2;
        imageRenderingContext.width = n5;
        imageRenderingContext.height = n6;
        imageRenderingContext.transform = baseTransform;
        imageRenderingContext.depthBuffer = bl;
        imageRenderingContext.root = node.impl_getPGNode();
        Object object = imageRenderingContext.platformPaint = paint == null ? null : toolkit.getPaint(paint);
        if (camera != null) {
            camera.update();
            imageRenderingContext.camera = camera.getPlatformCamera();
        } else {
            imageRenderingContext.camera = null;
        }
        Toolkit.WritableImageAccessor writableImageAccessor = Toolkit.getWritableImageAccessor();
        imageRenderingContext.platformImage = writableImageAccessor.getTkImageLoader(writableImage);
        Scene.impl_setAllowPGAccess(false);
        Object object2 = toolkit.renderToImage(imageRenderingContext);
        writableImageAccessor.loadTkImage(writableImage, object2);
        if (scene != null && scene.impl_peer != null) {
            scene.setNeedsRepaint();
        }
        return writableImage;
    }

    private WritableImage doSnapshot(WritableImage writableImage, float f) {
        this.doCSSLayoutSyncForSnapshot(this.getRoot());
        double d = this.getWidth();
        double d2 = this.getHeight();
        BaseTransform baseTransform = BaseTransform.IDENTITY_TRANSFORM;
        if (f != 1.0f) {
            Affine2D affine2D = new Affine2D();
            affine2D.scale(f, f);
            baseTransform = affine2D;
            d *= (double)f;
            d2 *= (double)f;
        }
        return Scene.doSnapshot(this, 0.0, 0.0, d, d2, this.getRoot(), baseTransform, this.isDepthBuffer(), this.getFill(), this.getCamera(), writableImage);
    }

    static void addSnapshotRunnable(Runnable runnable) {
        Toolkit.getToolkit().checkFxUserThread();
        if (snapshotPulseListener == null) {
            snapshotRunnableListA = new ArrayList<Runnable>();
            snapshotRunnableListB = new ArrayList<Runnable>();
            snapshotRunnableList = snapshotRunnableListA;
            snapshotPulseListener = new TKPulseListener(){

                @Override
                public void pulse() {
                    if (snapshotRunnableList.size() > 0) {
                        List list = snapshotRunnableList;
                        if (snapshotRunnableList == snapshotRunnableListA) {
                            snapshotRunnableList = snapshotRunnableListB;
                        } else {
                            snapshotRunnableList = snapshotRunnableListA;
                        }
                        for (Runnable runnable : list) {
                            try {
                                runnable.run();
                            }
                            catch (Throwable throwable) {
                                System.err.println("Exception in snapshot runnable");
                                throwable.printStackTrace(System.err);
                            }
                        }
                        list.clear();
                    }
                }
            };
            Toolkit.getToolkit().addPostSceneTkPulseListener(snapshotPulseListener);
        }
        snapshotRunnableList.add(runnable);
        Toolkit.getToolkit().requestNextPulse();
    }

    public WritableImage snapshot(WritableImage writableImage) {
        if (!paused) {
            Toolkit.getToolkit().checkFxUserThread();
        }
        return this.doSnapshot(writableImage, 1.0f);
    }

    public void snapshot(Callback<SnapshotResult, Void> callback, WritableImage writableImage) {
        Toolkit.getToolkit().checkFxUserThread();
        if (callback == null) {
            throw new NullPointerException("The callback must not be null");
        }
        final Callback<SnapshotResult, Void> callback2 = callback;
        final WritableImage writableImage2 = writableImage;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                WritableImage writableImage = Scene.this.doSnapshot(writableImage2, 1.0f);
                SnapshotResult snapshotResult = new SnapshotResult(writableImage, Scene.this, null);
                try {
                    Void void_ = (Void)callback2.call(snapshotResult);
                }
                catch (Throwable throwable) {
                    System.err.println("Exception in snapshot callback");
                    throwable.printStackTrace(System.err);
                }
            }
        };
        Scene.addSnapshotRunnable(runnable);
    }

    public final void setCursor(Cursor cursor) {
        this.cursorProperty().set(cursor);
    }

    public final Cursor getCursor() {
        return this.cursor == null ? null : (Cursor)this.cursor.get();
    }

    public final ObjectProperty<Cursor> cursorProperty() {
        if (this.cursor == null) {
            this.cursor = new SimpleObjectProperty<Cursor>(this, "cursor");
        }
        return this.cursor;
    }

    public Node lookup(String string) {
        return this.getRoot().lookup(string);
    }

    public final ObservableList<String> getStylesheets() {
        return this.stylesheets;
    }

    public final boolean isDepthBuffer() {
        return this.depthBuffer;
    }

    private void init(double d, double d2, boolean bl) {
        if (d >= 0.0) {
            this.widthSetByUser = d;
            this.setWidth((float)d);
        }
        if (d2 >= 0.0) {
            this.heightSetByUser = d2;
            this.setHeight((float)d2);
        }
        this.sizeInitialized = this.widthSetByUser >= 0.0 && this.heightSetByUser >= 0.0;
        this.depthBuffer = bl;
        this.init();
    }

    private void init() {
        if (PerformanceTracker.isLoggingEnabled()) {
            PerformanceTracker.logEvent("Scene.init for [" + this + "]");
        }
        this.mouseHandler = new MouseHandler();
        this.clickGenerator = new ClickGenerator();
        this.initialized = true;
        if (PerformanceTracker.isLoggingEnabled()) {
            PerformanceTracker.logEvent("Scene.init for [" + this + "] - finished");
        }
    }

    private void preferredSize() {
        Parent parent = this.getRoot();
        this.doCSSPass();
        boolean bl = false;
        boolean bl2 = false;
        double d = this.widthSetByUser;
        double d2 = this.heightSetByUser;
        if (this.widthSetByUser < 0.0) {
            d = parent.prefWidth(this.heightSetByUser >= 0.0 ? this.heightSetByUser : -1.0);
            d = parent.boundedSize(d, parent.minWidth(this.heightSetByUser >= 0.0 ? this.heightSetByUser : -1.0), parent.maxWidth(this.heightSetByUser >= 0.0 ? this.heightSetByUser : -1.0));
            bl = true;
        }
        if (this.heightSetByUser < 0.0) {
            d2 = parent.prefHeight(this.widthSetByUser >= 0.0 ? this.widthSetByUser : -1.0);
            d2 = parent.boundedSize(d2, parent.minHeight(this.widthSetByUser >= 0.0 ? this.widthSetByUser : -1.0), parent.maxHeight(this.widthSetByUser >= 0.0 ? this.widthSetByUser : -1.0));
            bl2 = true;
        }
        if (parent.getContentBias() == Orientation.HORIZONTAL) {
            if (this.heightSetByUser < 0.0) {
                d2 = parent.boundedSize(parent.prefHeight(d), parent.minHeight(d), parent.maxHeight(d));
                bl2 = true;
            }
        } else if (parent.getContentBias() == Orientation.VERTICAL && this.widthSetByUser < 0.0) {
            d = parent.boundedSize(parent.prefWidth(d2), parent.minWidth(d2), parent.maxWidth(d2));
            bl = true;
        }
        parent.resize(d, d2);
        this.doLayoutPass();
        if (bl) {
            this.setWidth(parent.isResizable() ? parent.getLayoutX() + parent.getTranslateX() + parent.getLayoutBounds().getWidth() : parent.getBoundsInParent().getMaxX());
        } else {
            this.setWidth(this.widthSetByUser);
        }
        if (bl2) {
            this.setHeight(parent.isResizable() ? parent.getLayoutY() + parent.getTranslateY() + parent.getLayoutBounds().getHeight() : parent.getBoundsInParent().getMaxY());
        } else {
            this.setHeight(this.heightSetByUser);
        }
        this.sizeInitialized = this.getWidth() > 0.0 && this.getHeight() > 0.0;
        PerformanceTracker.logEvent("Scene preferred bounds computation complete");
    }

    @Deprecated
    public void impl_preferredSize() {
        this.preferredSize();
    }

    @Deprecated
    public void impl_processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getEventType() == MouseEvent.MOUSE_CLICKED) {
            return;
        }
        this.mouseHandler.process(mouseEvent);
    }

    private void processMenuEvent(double d, double d2, double d3, double d4, boolean bl) {
        Object object;
        Object object2;
        if (!bl) {
            inMousePick = true;
        }
        if (bl) {
            object2 = this.getFocusOwner();
            double d5 = d3 - d;
            double d6 = d4 - d2;
            if (object2 != null) {
                Bounds bounds = ((Node)object2).localToScene(((Node)object2).getBoundsInLocal());
                d = bounds.getMinX() + bounds.getWidth() / 4.0;
                d2 = bounds.getMinY() + bounds.getHeight() / 2.0;
                object = object2;
            } else {
                d = this.getWidth() / 4.0;
                d2 = this.getWidth() / 2.0;
                object = this;
            }
            d3 = d + d5;
            d4 = d2 + d6;
        } else {
            object = this.pick(d, d2);
        }
        if (object != null) {
            object2 = ContextMenuEvent.impl_contextEvent(d, d2, d3, d4, bl, ContextMenuEvent.CONTEXT_MENU_REQUESTED);
            Event.fireEvent((EventTarget)object, (Event)object2);
        }
        if (!bl) {
            inMousePick = false;
        }
    }

    private void processGestureEvent(GestureEvent gestureEvent, TouchGesture touchGesture) {
        EventTarget eventTarget = null;
        inMousePick = true;
        if (gestureEvent.getEventType() == ZoomEvent.ZOOM_STARTED || gestureEvent.getEventType() == RotateEvent.ROTATION_STARTED || gestureEvent.getEventType() == ScrollEvent.SCROLL_STARTED) {
            touchGesture.target = null;
            touchGesture.finished = false;
        }
        eventTarget = touchGesture.target != null && (!touchGesture.finished || gestureEvent.isInertia()) ? touchGesture.target : this.pick(gestureEvent.getX(), gestureEvent.getY());
        if (gestureEvent.getEventType() == ZoomEvent.ZOOM_STARTED || gestureEvent.getEventType() == RotateEvent.ROTATION_STARTED || gestureEvent.getEventType() == ScrollEvent.SCROLL_STARTED) {
            touchGesture.target = eventTarget;
        }
        if (gestureEvent.getEventType() != ZoomEvent.ZOOM_FINISHED && gestureEvent.getEventType() != RotateEvent.ROTATION_FINISHED && gestureEvent.getEventType() != ScrollEvent.SCROLL_FINISHED && !gestureEvent.isInertia()) {
            touchGesture.sceneCoords = new Point2D(gestureEvent.getSceneX(), gestureEvent.getSceneY());
            touchGesture.screenCoords = new Point2D(gestureEvent.getScreenX(), gestureEvent.getScreenY());
        }
        if (eventTarget != null) {
            Event.fireEvent(eventTarget, gestureEvent);
        }
        if (gestureEvent.getEventType() == ZoomEvent.ZOOM_FINISHED || gestureEvent.getEventType() == RotateEvent.ROTATION_FINISHED || gestureEvent.getEventType() == ScrollEvent.SCROLL_FINISHED) {
            touchGesture.finished = true;
        }
        inMousePick = false;
    }

    /*
     * WARNING - void declaration
     */
    private void processTouchEvent(TouchEvent touchEvent, TouchPoint[] touchPointArray) {
        Object object;
        inMousePick = true;
        for (TouchPoint touchPoint : touchPointArray) {
            void var7_10;
            EventTarget eventTarget = this.touchTargets.get(touchPoint.getId());
            if (eventTarget == null) {
                EventTarget eventTarget2 = this.pick(touchPoint.getX(), touchPoint.getY());
            } else {
                touchPoint.grab(eventTarget);
            }
            if (touchPoint.getState() == TouchPoint.State.PRESSED) {
                touchPoint.grab((EventTarget)var7_10);
                this.touchTargets.put(touchPoint.getId(), (EventTarget)var7_10);
            } else if (touchPoint.getState() == TouchPoint.State.RELEASED) {
                this.touchTargets.remove(touchPoint.getId());
            }
            touchPoint.impl_setTarget((EventTarget)var7_10);
        }
        ++this.touchEventSetId;
        List<TouchPoint> list = Arrays.asList(touchPointArray);
        for (TouchPoint touchPoint : touchPointArray) {
            if (touchPoint.getTarget() == null) continue;
            object = null;
            switch (touchPoint.getState()) {
                case MOVED: {
                    object = TouchEvent.TOUCH_MOVED;
                    break;
                }
                case PRESSED: {
                    object = TouchEvent.TOUCH_PRESSED;
                    break;
                }
                case RELEASED: {
                    object = TouchEvent.TOUCH_RELEASED;
                    break;
                }
                case STATIONARY: {
                    object = TouchEvent.TOUCH_STATIONARY;
                }
            }
            for (TouchPoint touchPoint2 : touchPointArray) {
                touchPoint2.impl_reset();
            }
            TouchEvent touchEvent2 = TouchEvent.impl_touchEvent((EventType<? extends TouchEvent>)object, touchPoint, list, this.touchEventSetId, touchEvent.isShiftDown(), touchEvent.isControlDown(), touchEvent.isAltDown(), touchEvent.isMetaDown());
            Event.fireEvent(touchPoint.getTarget(), touchEvent2);
        }
        for (TouchPoint touchPoint : touchPointArray) {
            object = touchPoint.getGrabbed();
            if (object != null) {
                this.touchTargets.put(touchPoint.getId(), (EventTarget)object);
            }
            if (object != null && touchPoint.getState() != TouchPoint.State.RELEASED) continue;
            this.touchTargets.remove(touchPoint.getId());
        }
        inMousePick = false;
    }

    Node test_pick(double d, double d2) {
        inMousePick = true;
        Node node = this.mouseHandler.pickNode(d, d2);
        inMousePick = false;
        return node;
    }

    private EventTarget pick(double d, double d2) {
        this.pick(this.tmpTargetWrapper, d, d2);
        return this.tmpTargetWrapper.getEventTarget();
    }

    private void pick(TargetWrapper targetWrapper, double d, double d2) {
        Object object;
        Node node = null;
        if (this.pickingCamera instanceof PerspectiveCamera) {
            object = new PickRay();
            this.impl_peer.computePickRay((float)d, (float)d2, (PickRay)object);
            node = this.mouseHandler.pickNode((PickRay)object);
        } else {
            node = this.mouseHandler.pickNode(d, d2);
        }
        if (node != null) {
            targetWrapper.setNode(node);
        } else if (d >= 0.0 && d2 >= 0.0 && d <= this.getWidth() && d2 <= this.getHeight()) {
            object = this.getWindow();
            if (object instanceof Stage && ((Stage)object).getStyle() == StageStyle.TRANSPARENT && this.getFill() == null) {
                targetWrapper.clear();
            }
            targetWrapper.setScene(this);
        } else {
            targetWrapper.clear();
        }
    }

    private KeyHandler getKeyHandler() {
        if (this.keyHandler == null) {
            this.keyHandler = new KeyHandler();
        }
        return this.keyHandler;
    }

    final void setFocusDirty(boolean bl) {
        if (!this.focusDirty) {
            Toolkit.getToolkit().requestNextPulse();
        }
        this.focusDirty = bl;
    }

    final boolean isFocusDirty() {
        return this.focusDirty;
    }

    private TraversalEngine lookupTraversalEngine(Node node) {
        for (Parent parent = node.getParent(); parent != null; parent = parent.getParent()) {
            if (parent.getImpl_traversalEngine() == null) continue;
            return parent.getImpl_traversalEngine();
        }
        return this.getRoot().getImpl_traversalEngine();
    }

    void registerTraversable(Node node) {
        TraversalEngine traversalEngine = this.lookupTraversalEngine(node);
        if (traversalEngine != null) {
            if (this.traversalRegistry == null) {
                this.traversalRegistry = new HashMap();
            }
            this.traversalRegistry.put(node, traversalEngine);
            traversalEngine.reg(node);
        }
    }

    void unregisterTraversable(Node node) {
        TraversalEngine traversalEngine = (TraversalEngine)this.traversalRegistry.remove(node);
        if (traversalEngine != null) {
            traversalEngine.unreg(node);
        }
    }

    void traverse(Node node, Direction direction) {
        if (this.traversalRegistry != null) {
            TraversalEngine traversalEngine = (TraversalEngine)this.traversalRegistry.get(node);
            if (traversalEngine == null) {
                traversalEngine = this.lookupTraversalEngine(node);
            }
            traversalEngine.trav(node, direction);
        }
    }

    private void focusInitial() {
        this.getRoot().getImpl_traversalEngine().getTopLeftFocusableNode();
    }

    private void focusIneligible(Node node) {
        this.traverse(node, Direction.NEXT);
    }

    @Deprecated
    public void impl_processKeyEvent(KeyEvent keyEvent) {
        if (this.dndGesture != null && !this.dndGesture.processKey(keyEvent)) {
            this.dndGesture = null;
        }
        this.getKeyHandler().process(keyEvent);
        if (!keyEvent.isConsumed() && keyEvent.getCode() == KeyCode.DIGIT8 && keyEvent.getEventType() == KeyEvent.KEY_PRESSED && keyEvent.isControlDown() && keyEvent.isShiftDown()) {
            try {
                Class<?> clazz = Class.forName("com.javafx.experiments.scenicview.ScenicView");
                Class[] classArray = new Class[]{Scene.class};
                Method method = clazz.getDeclaredMethod("show", classArray);
                method.invoke(null, this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void requestFocus(Node node) {
        this.getKeyHandler().requestFocus(node);
    }

    public final Node getFocusOwner() {
        return (Node)this.focusOwner.get();
    }

    public final ReadOnlyObjectProperty<Node> focusOwnerProperty() {
        return this.focusOwner.getReadOnlyProperty();
    }

    void focusCleanup() {
        this.scenePulseListener.focusCleanup();
    }

    private void processInputMethodEvent(InputMethodEvent inputMethodEvent) {
        Node node = this.getFocusOwner();
        if (node != null) {
            node.fireEvent(inputMethodEvent);
        }
    }

    @Deprecated
    public void impl_enableInputMethodEvents(boolean bl) {
        if (this.impl_peer != null) {
            this.impl_peer.enableInputMethodEvents(bl);
        }
    }

    boolean isQuiescent() {
        return !this.isFocusDirty() && this.getRoot().cssFlag == CSSFlags.CLEAN && this.dirtyLayoutRoots.isEmpty();
    }

    private void markDirty(DirtyBits dirtyBits) {
        this.setDirty(dirtyBits);
        if (this.impl_peer != null) {
            Toolkit.getToolkit().requestNextPulse();
        }
    }

    private void setDirty(DirtyBits dirtyBits) {
        this.dirtyBits |= dirtyBits.getMask();
    }

    private boolean isDirty(DirtyBits dirtyBits) {
        return (this.dirtyBits & dirtyBits.getMask()) != 0;
    }

    private boolean isDirtyEmpty() {
        return this.dirtyBits == 0;
    }

    private void clearDirty() {
        this.dirtyBits = 0;
    }

    public final void setEventDispatcher(EventDispatcher eventDispatcher) {
        this.eventDispatcherProperty().set(eventDispatcher);
    }

    public final EventDispatcher getEventDispatcher() {
        return (EventDispatcher)this.eventDispatcherProperty().get();
    }

    public final ObjectProperty<EventDispatcher> eventDispatcherProperty() {
        this.initializeInternalEventDispatcher();
        return this.eventDispatcher;
    }

    public final <T extends Event> void addEventHandler(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        this.getInternalEventDispatcher().getEventHandlerManager().addEventHandler(eventType, eventHandler);
    }

    public final <T extends Event> void removeEventHandler(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        this.getInternalEventDispatcher().getEventHandlerManager().removeEventHandler(eventType, eventHandler);
    }

    public final <T extends Event> void addEventFilter(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        this.getInternalEventDispatcher().getEventHandlerManager().addEventFilter(eventType, eventHandler);
    }

    public final <T extends Event> void removeEventFilter(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        this.getInternalEventDispatcher().getEventHandlerManager().removeEventFilter(eventType, eventHandler);
    }

    protected final <T extends Event> void setEventHandler(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        this.getInternalEventDispatcher().getEventHandlerManager().setEventHandler(eventType, eventHandler);
    }

    private SceneEventDispatcher getInternalEventDispatcher() {
        this.initializeInternalEventDispatcher();
        return this.internalEventDispatcher;
    }

    private void initializeInternalEventDispatcher() {
        if (this.internalEventDispatcher == null) {
            this.internalEventDispatcher = this.createInternalEventDispatcher();
            this.eventDispatcher = new SimpleObjectProperty<SceneEventDispatcher>(this, "eventDispatcher", this.internalEventDispatcher);
        }
    }

    private SceneEventDispatcher createInternalEventDispatcher() {
        return new SceneEventDispatcher(this);
    }

    public void addMnemonic(Mnemonic mnemonic) {
        this.getInternalEventDispatcher().getKeyboardShortcutsHandler().addMnemonic(mnemonic);
    }

    public void removeMnemonic(Mnemonic mnemonic) {
        this.getInternalEventDispatcher().getKeyboardShortcutsHandler().removeMnemonic(mnemonic);
    }

    public ObservableMap<KeyCombination, ObservableList<Mnemonic>> getMnemonics() {
        return this.getInternalEventDispatcher().getKeyboardShortcutsHandler().getMnemonics();
    }

    public ObservableMap<KeyCombination, Runnable> getAccelerators() {
        return this.getInternalEventDispatcher().getKeyboardShortcutsHandler().getAccelerators();
    }

    @Override
    public EventDispatchChain buildEventDispatchChain(EventDispatchChain eventDispatchChain) {
        if (this.eventDispatcher != null) {
            eventDispatchChain = eventDispatchChain.prepend((EventDispatcher)this.eventDispatcher.get());
        }
        if (this.getWindow() != null) {
            eventDispatchChain = this.getWindow().buildEventDispatchChain(eventDispatchChain);
        }
        return eventDispatchChain;
    }

    public final void setOnContextMenuRequested(EventHandler<? super ContextMenuEvent> eventHandler) {
        this.onContextMenuRequestedProperty().set(eventHandler);
    }

    public final EventHandler<? super ContextMenuEvent> getOnContextMenuRequested() {
        return this.onContextMenuRequested == null ? null : (EventHandler)this.onContextMenuRequested.get();
    }

    public final ObjectProperty<EventHandler<? super ContextMenuEvent>> onContextMenuRequestedProperty() {
        if (this.onContextMenuRequested == null) {
            this.onContextMenuRequested = new ObjectPropertyBase<EventHandler<? super ContextMenuEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(ContextMenuEvent.CONTEXT_MENU_REQUESTED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onContextMenuRequested";
                }
            };
        }
        return this.onContextMenuRequested;
    }

    public final void setOnMouseClicked(EventHandler<? super MouseEvent> eventHandler) {
        this.onMouseClickedProperty().set(eventHandler);
    }

    public final EventHandler<? super MouseEvent> getOnMouseClicked() {
        return this.onMouseClicked == null ? null : (EventHandler)this.onMouseClicked.get();
    }

    public final ObjectProperty<EventHandler<? super MouseEvent>> onMouseClickedProperty() {
        if (this.onMouseClicked == null) {
            this.onMouseClicked = new ObjectPropertyBase<EventHandler<? super MouseEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onMouseClicked";
                }
            };
        }
        return this.onMouseClicked;
    }

    public final void setOnMouseDragged(EventHandler<? super MouseEvent> eventHandler) {
        this.onMouseDraggedProperty().set(eventHandler);
    }

    public final EventHandler<? super MouseEvent> getOnMouseDragged() {
        return this.onMouseDragged == null ? null : (EventHandler)this.onMouseDragged.get();
    }

    public final ObjectProperty<EventHandler<? super MouseEvent>> onMouseDraggedProperty() {
        if (this.onMouseDragged == null) {
            this.onMouseDragged = new ObjectPropertyBase<EventHandler<? super MouseEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(MouseEvent.MOUSE_DRAGGED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onMouseDragged";
                }
            };
        }
        return this.onMouseDragged;
    }

    public final void setOnMouseEntered(EventHandler<? super MouseEvent> eventHandler) {
        this.onMouseEnteredProperty().set(eventHandler);
    }

    public final EventHandler<? super MouseEvent> getOnMouseEntered() {
        return this.onMouseEntered == null ? null : (EventHandler)this.onMouseEntered.get();
    }

    public final ObjectProperty<EventHandler<? super MouseEvent>> onMouseEnteredProperty() {
        if (this.onMouseEntered == null) {
            this.onMouseEntered = new ObjectPropertyBase<EventHandler<? super MouseEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(MouseEvent.MOUSE_ENTERED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onMouseEntered";
                }
            };
        }
        return this.onMouseEntered;
    }

    public final void setOnMouseExited(EventHandler<? super MouseEvent> eventHandler) {
        this.onMouseExitedProperty().set(eventHandler);
    }

    public final EventHandler<? super MouseEvent> getOnMouseExited() {
        return this.onMouseExited == null ? null : (EventHandler)this.onMouseExited.get();
    }

    public final ObjectProperty<EventHandler<? super MouseEvent>> onMouseExitedProperty() {
        if (this.onMouseExited == null) {
            this.onMouseExited = new ObjectPropertyBase<EventHandler<? super MouseEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(MouseEvent.MOUSE_EXITED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onMouseExited";
                }
            };
        }
        return this.onMouseExited;
    }

    public final void setOnMouseMoved(EventHandler<? super MouseEvent> eventHandler) {
        this.onMouseMovedProperty().set(eventHandler);
    }

    public final EventHandler<? super MouseEvent> getOnMouseMoved() {
        return this.onMouseMoved == null ? null : (EventHandler)this.onMouseMoved.get();
    }

    public final ObjectProperty<EventHandler<? super MouseEvent>> onMouseMovedProperty() {
        if (this.onMouseMoved == null) {
            this.onMouseMoved = new ObjectPropertyBase<EventHandler<? super MouseEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(MouseEvent.MOUSE_MOVED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onMouseMoved";
                }
            };
        }
        return this.onMouseMoved;
    }

    public final void setOnMousePressed(EventHandler<? super MouseEvent> eventHandler) {
        this.onMousePressedProperty().set(eventHandler);
    }

    public final EventHandler<? super MouseEvent> getOnMousePressed() {
        return this.onMousePressed == null ? null : (EventHandler)this.onMousePressed.get();
    }

    public final ObjectProperty<EventHandler<? super MouseEvent>> onMousePressedProperty() {
        if (this.onMousePressed == null) {
            this.onMousePressed = new ObjectPropertyBase<EventHandler<? super MouseEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(MouseEvent.MOUSE_PRESSED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onMousePressed";
                }
            };
        }
        return this.onMousePressed;
    }

    public final void setOnMouseReleased(EventHandler<? super MouseEvent> eventHandler) {
        this.onMouseReleasedProperty().set(eventHandler);
    }

    public final EventHandler<? super MouseEvent> getOnMouseReleased() {
        return this.onMouseReleased == null ? null : (EventHandler)this.onMouseReleased.get();
    }

    public final ObjectProperty<EventHandler<? super MouseEvent>> onMouseReleasedProperty() {
        if (this.onMouseReleased == null) {
            this.onMouseReleased = new ObjectPropertyBase<EventHandler<? super MouseEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(MouseEvent.MOUSE_RELEASED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onMouseReleased";
                }
            };
        }
        return this.onMouseReleased;
    }

    public final void setOnDragDetected(EventHandler<? super MouseEvent> eventHandler) {
        this.onDragDetectedProperty().set(eventHandler);
    }

    public final EventHandler<? super MouseEvent> getOnDragDetected() {
        return this.onDragDetected == null ? null : (EventHandler)this.onDragDetected.get();
    }

    public final ObjectProperty<EventHandler<? super MouseEvent>> onDragDetectedProperty() {
        if (this.onDragDetected == null) {
            this.onDragDetected = new ObjectPropertyBase<EventHandler<? super MouseEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(MouseEvent.DRAG_DETECTED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onDragDetected";
                }
            };
        }
        return this.onDragDetected;
    }

    public final void setOnMouseDragOver(EventHandler<? super MouseDragEvent> eventHandler) {
        this.onMouseDragOverProperty().set(eventHandler);
    }

    public final EventHandler<? super MouseDragEvent> getOnMouseDragOver() {
        return this.onMouseDragOver == null ? null : (EventHandler)this.onMouseDragOver.get();
    }

    public final ObjectProperty<EventHandler<? super MouseDragEvent>> onMouseDragOverProperty() {
        if (this.onMouseDragOver == null) {
            this.onMouseDragOver = new ObjectPropertyBase<EventHandler<? super MouseDragEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(MouseDragEvent.MOUSE_DRAG_OVER, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onMouseDragOver";
                }
            };
        }
        return this.onMouseDragOver;
    }

    public final void setOnMouseDragReleased(EventHandler<? super MouseDragEvent> eventHandler) {
        this.onMouseDragReleasedProperty().set(eventHandler);
    }

    public final EventHandler<? super MouseDragEvent> getOnMouseDragReleased() {
        return this.onMouseDragReleased == null ? null : (EventHandler)this.onMouseDragReleased.get();
    }

    public final ObjectProperty<EventHandler<? super MouseDragEvent>> onMouseDragReleasedProperty() {
        if (this.onMouseDragReleased == null) {
            this.onMouseDragReleased = new ObjectPropertyBase<EventHandler<? super MouseDragEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(MouseDragEvent.MOUSE_DRAG_RELEASED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onMouseDragReleased";
                }
            };
        }
        return this.onMouseDragReleased;
    }

    public final void setOnMouseDragEntered(EventHandler<? super MouseDragEvent> eventHandler) {
        this.onMouseDragEnteredProperty().set(eventHandler);
    }

    public final EventHandler<? super MouseDragEvent> getOnMouseDragEntered() {
        return this.onMouseDragEntered == null ? null : (EventHandler)this.onMouseDragEntered.get();
    }

    public final ObjectProperty<EventHandler<? super MouseDragEvent>> onMouseDragEnteredProperty() {
        if (this.onMouseDragEntered == null) {
            this.onMouseDragEntered = new ObjectPropertyBase<EventHandler<? super MouseDragEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(MouseDragEvent.MOUSE_DRAG_ENTERED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onMouseDragEntered";
                }
            };
        }
        return this.onMouseDragEntered;
    }

    public final void setOnMouseDragExited(EventHandler<? super MouseDragEvent> eventHandler) {
        this.onMouseDragExitedProperty().set(eventHandler);
    }

    public final EventHandler<? super MouseDragEvent> getOnMouseDragExited() {
        return this.onMouseDragExited == null ? null : (EventHandler)this.onMouseDragExited.get();
    }

    public final ObjectProperty<EventHandler<? super MouseDragEvent>> onMouseDragExitedProperty() {
        if (this.onMouseDragExited == null) {
            this.onMouseDragExited = new ObjectPropertyBase<EventHandler<? super MouseDragEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(MouseDragEvent.MOUSE_DRAG_EXITED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onMouseDragExited";
                }
            };
        }
        return this.onMouseDragExited;
    }

    public final void setOnScrollStarted(EventHandler<? super ScrollEvent> eventHandler) {
        this.onScrollStartedProperty().set(eventHandler);
    }

    public final EventHandler<? super ScrollEvent> getOnScrollStarted() {
        return this.onScrollStarted == null ? null : (EventHandler)this.onScrollStarted.get();
    }

    public final ObjectProperty<EventHandler<? super ScrollEvent>> onScrollStartedProperty() {
        if (this.onScrollStarted == null) {
            this.onScrollStarted = new ObjectPropertyBase<EventHandler<? super ScrollEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(ScrollEvent.SCROLL_STARTED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onScrollStarted";
                }
            };
        }
        return this.onScrollStarted;
    }

    public final void setOnScroll(EventHandler<? super ScrollEvent> eventHandler) {
        this.onScrollProperty().set(eventHandler);
    }

    public final EventHandler<? super ScrollEvent> getOnScroll() {
        return this.onScroll == null ? null : (EventHandler)this.onScroll.get();
    }

    public final ObjectProperty<EventHandler<? super ScrollEvent>> onScrollProperty() {
        if (this.onScroll == null) {
            this.onScroll = new ObjectPropertyBase<EventHandler<? super ScrollEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(ScrollEvent.SCROLL, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onScroll";
                }
            };
        }
        return this.onScroll;
    }

    public final void setOnScrollFinished(EventHandler<? super ScrollEvent> eventHandler) {
        this.onScrollFinishedProperty().set(eventHandler);
    }

    public final EventHandler<? super ScrollEvent> getOnScrollFinished() {
        return this.onScrollFinished == null ? null : (EventHandler)this.onScrollFinished.get();
    }

    public final ObjectProperty<EventHandler<? super ScrollEvent>> onScrollFinishedProperty() {
        if (this.onScrollFinished == null) {
            this.onScrollFinished = new ObjectPropertyBase<EventHandler<? super ScrollEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(ScrollEvent.SCROLL_FINISHED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onScrollFinished";
                }
            };
        }
        return this.onScrollFinished;
    }

    public final void setOnRotationStarted(EventHandler<? super RotateEvent> eventHandler) {
        this.onRotationStartedProperty().set(eventHandler);
    }

    public final EventHandler<? super RotateEvent> getOnRotationStarted() {
        return this.onRotationStarted == null ? null : (EventHandler)this.onRotationStarted.get();
    }

    public final ObjectProperty<EventHandler<? super RotateEvent>> onRotationStartedProperty() {
        if (this.onRotationStarted == null) {
            this.onRotationStarted = new ObjectPropertyBase<EventHandler<? super RotateEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(RotateEvent.ROTATION_STARTED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onRotationStarted";
                }
            };
        }
        return this.onRotationStarted;
    }

    public final void setOnRotate(EventHandler<? super RotateEvent> eventHandler) {
        this.onRotateProperty().set(eventHandler);
    }

    public final EventHandler<? super RotateEvent> getOnRotate() {
        return this.onRotate == null ? null : (EventHandler)this.onRotate.get();
    }

    public final ObjectProperty<EventHandler<? super RotateEvent>> onRotateProperty() {
        if (this.onRotate == null) {
            this.onRotate = new ObjectPropertyBase<EventHandler<? super RotateEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(RotateEvent.ROTATE, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onRotate";
                }
            };
        }
        return this.onRotate;
    }

    public final void setOnRotationFinished(EventHandler<? super RotateEvent> eventHandler) {
        this.onRotationFinishedProperty().set(eventHandler);
    }

    public final EventHandler<? super RotateEvent> getOnRotationFinished() {
        return this.onRotationFinished == null ? null : (EventHandler)this.onRotationFinished.get();
    }

    public final ObjectProperty<EventHandler<? super RotateEvent>> onRotationFinishedProperty() {
        if (this.onRotationFinished == null) {
            this.onRotationFinished = new ObjectPropertyBase<EventHandler<? super RotateEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(RotateEvent.ROTATION_FINISHED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onRotationFinished";
                }
            };
        }
        return this.onRotationFinished;
    }

    public final void setOnZoomStarted(EventHandler<? super ZoomEvent> eventHandler) {
        this.onZoomStartedProperty().set(eventHandler);
    }

    public final EventHandler<? super ZoomEvent> getOnZoomStarted() {
        return this.onZoomStarted == null ? null : (EventHandler)this.onZoomStarted.get();
    }

    public final ObjectProperty<EventHandler<? super ZoomEvent>> onZoomStartedProperty() {
        if (this.onZoomStarted == null) {
            this.onZoomStarted = new ObjectPropertyBase<EventHandler<? super ZoomEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(ZoomEvent.ZOOM_STARTED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onZoomStarted";
                }
            };
        }
        return this.onZoomStarted;
    }

    public final void setOnZoom(EventHandler<? super ZoomEvent> eventHandler) {
        this.onZoomProperty().set(eventHandler);
    }

    public final EventHandler<? super ZoomEvent> getOnZoom() {
        return this.onZoom == null ? null : (EventHandler)this.onZoom.get();
    }

    public final ObjectProperty<EventHandler<? super ZoomEvent>> onZoomProperty() {
        if (this.onZoom == null) {
            this.onZoom = new ObjectPropertyBase<EventHandler<? super ZoomEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(ZoomEvent.ZOOM, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onZoom";
                }
            };
        }
        return this.onZoom;
    }

    public final void setOnZoomFinished(EventHandler<? super ZoomEvent> eventHandler) {
        this.onZoomFinishedProperty().set(eventHandler);
    }

    public final EventHandler<? super ZoomEvent> getOnZoomFinished() {
        return this.onZoomFinished == null ? null : (EventHandler)this.onZoomFinished.get();
    }

    public final ObjectProperty<EventHandler<? super ZoomEvent>> onZoomFinishedProperty() {
        if (this.onZoomFinished == null) {
            this.onZoomFinished = new ObjectPropertyBase<EventHandler<? super ZoomEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(ZoomEvent.ZOOM_FINISHED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onZoomFinished";
                }
            };
        }
        return this.onZoomFinished;
    }

    public final void setOnSwipeUp(EventHandler<? super SwipeEvent> eventHandler) {
        this.onSwipeUpProperty().set(eventHandler);
    }

    public final EventHandler<? super SwipeEvent> getOnSwipeUp() {
        return this.onSwipeUp == null ? null : (EventHandler)this.onSwipeUp.get();
    }

    public final ObjectProperty<EventHandler<? super SwipeEvent>> onSwipeUpProperty() {
        if (this.onSwipeUp == null) {
            this.onSwipeUp = new ObjectPropertyBase<EventHandler<? super SwipeEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(SwipeEvent.SWIPE_UP, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onSwipeUp";
                }
            };
        }
        return this.onSwipeUp;
    }

    public final void setOnSwipeDown(EventHandler<? super SwipeEvent> eventHandler) {
        this.onSwipeDownProperty().set(eventHandler);
    }

    public final EventHandler<? super SwipeEvent> getOnSwipeDown() {
        return this.onSwipeDown == null ? null : (EventHandler)this.onSwipeDown.get();
    }

    public final ObjectProperty<EventHandler<? super SwipeEvent>> onSwipeDownProperty() {
        if (this.onSwipeDown == null) {
            this.onSwipeDown = new ObjectPropertyBase<EventHandler<? super SwipeEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(SwipeEvent.SWIPE_DOWN, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onSwipeDown";
                }
            };
        }
        return this.onSwipeDown;
    }

    public final void setOnSwipeLeft(EventHandler<? super SwipeEvent> eventHandler) {
        this.onSwipeLeftProperty().set(eventHandler);
    }

    public final EventHandler<? super SwipeEvent> getOnSwipeLeft() {
        return this.onSwipeLeft == null ? null : (EventHandler)this.onSwipeLeft.get();
    }

    public final ObjectProperty<EventHandler<? super SwipeEvent>> onSwipeLeftProperty() {
        if (this.onSwipeLeft == null) {
            this.onSwipeLeft = new ObjectPropertyBase<EventHandler<? super SwipeEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(SwipeEvent.SWIPE_LEFT, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onSwipeLeft";
                }
            };
        }
        return this.onSwipeLeft;
    }

    public final void setOnSwipeRight(EventHandler<? super SwipeEvent> eventHandler) {
        this.onSwipeRightProperty().set(eventHandler);
    }

    public final EventHandler<? super SwipeEvent> getOnSwipeRight() {
        return this.onSwipeRight == null ? null : (EventHandler)this.onSwipeRight.get();
    }

    public final ObjectProperty<EventHandler<? super SwipeEvent>> onSwipeRightProperty() {
        if (this.onSwipeRight == null) {
            this.onSwipeRight = new ObjectPropertyBase<EventHandler<? super SwipeEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(SwipeEvent.SWIPE_RIGHT, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onSwipeRight";
                }
            };
        }
        return this.onSwipeRight;
    }

    public final void setOnTouchPressed(EventHandler<? super TouchEvent> eventHandler) {
        this.onTouchPressedProperty().set(eventHandler);
    }

    public final EventHandler<? super TouchEvent> getOnTouchPressed() {
        return this.onTouchPressed == null ? null : (EventHandler)this.onTouchPressed.get();
    }

    public final ObjectProperty<EventHandler<? super TouchEvent>> onTouchPressedProperty() {
        if (this.onTouchPressed == null) {
            this.onTouchPressed = new ObjectPropertyBase<EventHandler<? super TouchEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(TouchEvent.TOUCH_PRESSED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onTouchPressed";
                }
            };
        }
        return this.onTouchPressed;
    }

    public final void setOnTouchMoved(EventHandler<? super TouchEvent> eventHandler) {
        this.onTouchMovedProperty().set(eventHandler);
    }

    public final EventHandler<? super TouchEvent> getOnTouchMoved() {
        return this.onTouchMoved == null ? null : (EventHandler)this.onTouchMoved.get();
    }

    public final ObjectProperty<EventHandler<? super TouchEvent>> onTouchMovedProperty() {
        if (this.onTouchMoved == null) {
            this.onTouchMoved = new ObjectPropertyBase<EventHandler<? super TouchEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(TouchEvent.TOUCH_MOVED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onTouchMoved";
                }
            };
        }
        return this.onTouchMoved;
    }

    public final void setOnTouchReleased(EventHandler<? super TouchEvent> eventHandler) {
        this.onTouchReleasedProperty().set(eventHandler);
    }

    public final EventHandler<? super TouchEvent> getOnTouchReleased() {
        return this.onTouchReleased == null ? null : (EventHandler)this.onTouchReleased.get();
    }

    public final ObjectProperty<EventHandler<? super TouchEvent>> onTouchReleasedProperty() {
        if (this.onTouchReleased == null) {
            this.onTouchReleased = new ObjectPropertyBase<EventHandler<? super TouchEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(TouchEvent.TOUCH_RELEASED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onTouchReleased";
                }
            };
        }
        return this.onTouchReleased;
    }

    public final void setOnTouchStationary(EventHandler<? super TouchEvent> eventHandler) {
        this.onTouchStationaryProperty().set(eventHandler);
    }

    public final EventHandler<? super TouchEvent> getOnTouchStationary() {
        return this.onTouchStationary == null ? null : (EventHandler)this.onTouchStationary.get();
    }

    public final ObjectProperty<EventHandler<? super TouchEvent>> onTouchStationaryProperty() {
        if (this.onTouchStationary == null) {
            this.onTouchStationary = new ObjectPropertyBase<EventHandler<? super TouchEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(TouchEvent.TOUCH_STATIONARY, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onTouchStationary";
                }
            };
        }
        return this.onTouchStationary;
    }

    public final void setOnDragEntered(EventHandler<? super DragEvent> eventHandler) {
        this.onDragEnteredProperty().set(eventHandler);
    }

    public final EventHandler<? super DragEvent> getOnDragEntered() {
        return this.onDragEntered == null ? null : (EventHandler)this.onDragEntered.get();
    }

    public final ObjectProperty<EventHandler<? super DragEvent>> onDragEnteredProperty() {
        if (this.onDragEntered == null) {
            this.onDragEntered = new ObjectPropertyBase<EventHandler<? super DragEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(DragEvent.DRAG_ENTERED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onDragEntered";
                }
            };
        }
        return this.onDragEntered;
    }

    public final void setOnDragExited(EventHandler<? super DragEvent> eventHandler) {
        this.onDragExitedProperty().set(eventHandler);
    }

    public final EventHandler<? super DragEvent> getOnDragExited() {
        return this.onDragExited == null ? null : (EventHandler)this.onDragExited.get();
    }

    public final ObjectProperty<EventHandler<? super DragEvent>> onDragExitedProperty() {
        if (this.onDragExited == null) {
            this.onDragExited = new ObjectPropertyBase<EventHandler<? super DragEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(DragEvent.DRAG_EXITED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onDragExited";
                }
            };
        }
        return this.onDragExited;
    }

    public final void setOnDragOver(EventHandler<? super DragEvent> eventHandler) {
        this.onDragOverProperty().set(eventHandler);
    }

    public final EventHandler<? super DragEvent> getOnDragOver() {
        return this.onDragOver == null ? null : (EventHandler)this.onDragOver.get();
    }

    public final ObjectProperty<EventHandler<? super DragEvent>> onDragOverProperty() {
        if (this.onDragOver == null) {
            this.onDragOver = new ObjectPropertyBase<EventHandler<? super DragEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(DragEvent.DRAG_OVER, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onDragOver";
                }
            };
        }
        return this.onDragOver;
    }

    public final void setOnDragDropped(EventHandler<? super DragEvent> eventHandler) {
        this.onDragDroppedProperty().set(eventHandler);
    }

    public final EventHandler<? super DragEvent> getOnDragDropped() {
        return this.onDragDropped == null ? null : (EventHandler)this.onDragDropped.get();
    }

    public final ObjectProperty<EventHandler<? super DragEvent>> onDragDroppedProperty() {
        if (this.onDragDropped == null) {
            this.onDragDropped = new ObjectPropertyBase<EventHandler<? super DragEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(DragEvent.DRAG_DROPPED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onDragDropped";
                }
            };
        }
        return this.onDragDropped;
    }

    public final void setOnDragDone(EventHandler<? super DragEvent> eventHandler) {
        this.onDragDoneProperty().set(eventHandler);
    }

    public final EventHandler<? super DragEvent> getOnDragDone() {
        return this.onDragDone == null ? null : (EventHandler)this.onDragDone.get();
    }

    public final ObjectProperty<EventHandler<? super DragEvent>> onDragDoneProperty() {
        if (this.onDragDone == null) {
            this.onDragDone = new ObjectPropertyBase<EventHandler<? super DragEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(DragEvent.DRAG_DONE, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onDragDone";
                }
            };
        }
        return this.onDragDone;
    }

    public Dragboard startDragAndDrop(TransferMode ... transferModeArray) {
        return this.startDragAndDrop(this, transferModeArray);
    }

    public void startFullDrag() {
        this.startFullDrag(this);
    }

    Dragboard startDragAndDrop(EventTarget eventTarget, TransferMode ... transferModeArray) {
        if (this.dndGesture.dragDetected != DragDetectedState.PROCESSING) {
            throw new IllegalStateException("Cannot start drag and drop outside of DRAG_DETECTED event handler");
        }
        if (this.dndGesture != null) {
            EnumSet<TransferMode> enumSet = EnumSet.noneOf(TransferMode.class);
            for (TransferMode transferMode : transferModeArray) {
                enumSet.add(transferMode);
            }
            return this.dndGesture.startDrag(eventTarget, enumSet);
        }
        throw new IllegalStateException("Cannot start drag and drop when mouse button is not pressed");
    }

    void startFullDrag(EventTarget eventTarget) {
        if (this.dndGesture.dragDetected != DragDetectedState.PROCESSING) {
            throw new IllegalStateException("Cannot start full drag outside of DRAG_DETECTED event handler");
        }
        if (this.dndGesture != null) {
            this.dndGesture.startFullPDR(eventTarget);
            return;
        }
        throw new IllegalStateException("Cannot start full drag when mouse button is not pressed");
    }

    public final void setOnKeyPressed(EventHandler<? super KeyEvent> eventHandler) {
        this.onKeyPressedProperty().set(eventHandler);
    }

    public final EventHandler<? super KeyEvent> getOnKeyPressed() {
        return this.onKeyPressed == null ? null : (EventHandler)this.onKeyPressed.get();
    }

    public final ObjectProperty<EventHandler<? super KeyEvent>> onKeyPressedProperty() {
        if (this.onKeyPressed == null) {
            this.onKeyPressed = new ObjectPropertyBase<EventHandler<? super KeyEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(KeyEvent.KEY_PRESSED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onKeyPressed";
                }
            };
        }
        return this.onKeyPressed;
    }

    public final void setOnKeyReleased(EventHandler<? super KeyEvent> eventHandler) {
        this.onKeyReleasedProperty().set(eventHandler);
    }

    public final EventHandler<? super KeyEvent> getOnKeyReleased() {
        return this.onKeyReleased == null ? null : (EventHandler)this.onKeyReleased.get();
    }

    public final ObjectProperty<EventHandler<? super KeyEvent>> onKeyReleasedProperty() {
        if (this.onKeyReleased == null) {
            this.onKeyReleased = new ObjectPropertyBase<EventHandler<? super KeyEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(KeyEvent.KEY_RELEASED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onKeyReleased";
                }
            };
        }
        return this.onKeyReleased;
    }

    public final void setOnKeyTyped(EventHandler<? super KeyEvent> eventHandler) {
        this.onKeyTypedProperty().set(eventHandler);
    }

    public final EventHandler<? super KeyEvent> getOnKeyTyped() {
        return this.onKeyTyped == null ? null : (EventHandler)this.onKeyTyped.get();
    }

    public final ObjectProperty<EventHandler<? super KeyEvent>> onKeyTypedProperty() {
        if (this.onKeyTyped == null) {
            this.onKeyTyped = new ObjectPropertyBase<EventHandler<? super KeyEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(KeyEvent.KEY_TYPED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onKeyTyped";
                }
            };
        }
        return this.onKeyTyped;
    }

    public final void setOnInputMethodTextChanged(EventHandler<? super InputMethodEvent> eventHandler) {
        this.onInputMethodTextChangedProperty().set(eventHandler);
    }

    public final EventHandler<? super InputMethodEvent> getOnInputMethodTextChanged() {
        return this.onInputMethodTextChanged == null ? null : (EventHandler)this.onInputMethodTextChanged.get();
    }

    public final ObjectProperty<EventHandler<? super InputMethodEvent>> onInputMethodTextChangedProperty() {
        if (this.onInputMethodTextChanged == null) {
            this.onInputMethodTextChanged = new ObjectPropertyBase<EventHandler<? super InputMethodEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(InputMethodEvent.INPUT_METHOD_TEXT_CHANGED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onInputMethodTextChanged";
                }
            };
        }
        return this.onInputMethodTextChanged;
    }

    static /* synthetic */ Node[] access$3002(Scene scene, Node[] nodeArray) {
        scene.dirtyNodes = nodeArray;
        return nodeArray;
    }

    static /* synthetic */ TouchPoint[] access$5502(Scene scene, TouchPoint[] touchPointArray) {
        scene.touchPoints = touchPointArray;
        return touchPointArray;
    }

    static {
        PerformanceTracker.setSceneAccessor(new PerformanceTracker.SceneAccessor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPerfTracker(Scene scene, PerformanceTracker performanceTracker) {
                Object object = trackerMonitor;
                synchronized (object) {
                    scene.tracker = performanceTracker;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PerformanceTracker getPerfTracker(Scene scene) {
                Object object = trackerMonitor;
                synchronized (object) {
                    return scene.tracker;
                }
            }
        });
        FXRobotHelper.setSceneAccessor(new FXRobotHelper.FXRobotSceneAccessor(){

            @Override
            public void processKeyEvent(Scene scene, KeyEvent keyEvent) {
                scene.impl_processKeyEvent(keyEvent);
            }

            @Override
            public void processMouseEvent(Scene scene, MouseEvent mouseEvent) {
                scene.impl_processMouseEvent(mouseEvent);
            }

            @Override
            public void processScrollEvent(Scene scene, ScrollEvent scrollEvent) {
                scene.processGestureEvent(scrollEvent, scene.scrollGesture);
            }

            @Override
            public ObservableList<Node> getChildren(Parent parent) {
                return parent.getChildren();
            }

            @Override
            public Object renderToImage(Scene scene, Object object) {
                return scene.renderToImage(object);
            }
        });
        Toolkit.setSceneAccessor(new Toolkit.SceneAccessor(){

            @Override
            public void setPaused(boolean bl) {
                paused = bl;
            }
        });
        inSynchronizer = false;
        inMousePick = false;
        allowPGAccess = false;
        pgAccessCount = 0;
        paused = false;
        snapshotPulseListener = null;
        trackerMonitor = new Object();
    }

    private static class TargetWrapper {
        private Scene scene;
        private Node node;

        private TargetWrapper() {
        }

        public void fillHierarchy(List<EventTarget> list) {
            list.clear();
            for (Node node = this.node; node != null; node = node.getParent()) {
                list.add(node);
            }
            if (this.scene != null) {
                list.add(this.scene);
            }
        }

        public EventTarget getEventTarget() {
            return this.node != null ? this.node : this.scene;
        }

        public Cursor getCursor() {
            Cursor cursor = null;
            if (this.node != null) {
                cursor = this.node.getCursor();
                for (Parent parent = this.node.getParent(); cursor == null && parent != null; parent = parent.getParent()) {
                    cursor = parent.getCursor();
                }
            }
            return cursor;
        }

        public void clear() {
            this.set(null, null);
        }

        public void setScene(Scene scene) {
            this.set(null, scene);
        }

        public void setNode(Node node) {
            this.set(node, node.getScene());
        }

        public void copy(TargetWrapper targetWrapper) {
            this.node = targetWrapper.node;
            this.scene = targetWrapper.scene;
        }

        private void set(Node node, Scene scene) {
            this.node = node;
            this.scene = scene;
        }
    }

    private static class TouchMap {
        private static final int FAST_THRESHOLD = 10;
        int[] fastMap = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        Map<Long, Integer> slowMap = new HashMap<Long, Integer>();
        List<Integer> order = new LinkedList<Integer>();
        List<Long> removed = new ArrayList<Long>(10);
        int counter = 0;
        int active = 0;

        private TouchMap() {
        }

        public int add(long l) {
            ++this.counter;
            ++this.active;
            if (l < 10L) {
                this.fastMap[(int)l] = this.counter;
            } else {
                this.slowMap.put(l, this.counter);
            }
            this.order.add(this.counter);
            return this.counter;
        }

        public void remove(long l) {
            this.removed.add(l);
        }

        public int get(long l) {
            if (l < 10L) {
                int n = this.fastMap[(int)l];
                if (n == 0) {
                    throw new RuntimeException("Platform reported wrong touch point ID");
                }
                return n;
            }
            try {
                return this.slowMap.get(l);
            }
            catch (NullPointerException nullPointerException) {
                throw new RuntimeException("Platform reported wrong touch point ID");
            }
        }

        public int getOrder(int n) {
            return this.order.indexOf(n);
        }

        public boolean cleanup() {
            for (long l : this.removed) {
                --this.active;
                this.order.remove((Object)this.get(l));
                if (l < 10L) {
                    this.fastMap[(int)l] = 0;
                } else {
                    this.slowMap.remove(l);
                }
                if (this.active != 0) continue;
                this.counter = 0;
            }
            this.removed.clear();
            return this.active == 0;
        }
    }

    class InputMethodRequestsDelegate
    implements InputMethodRequests {
        InputMethodRequestsDelegate() {
        }

        @Override
        public Point2D getTextLocation(int n) {
            InputMethodRequests inputMethodRequests = this.getClientRequests();
            if (inputMethodRequests != null) {
                return inputMethodRequests.getTextLocation(n);
            }
            return new Point2D(0.0, 0.0);
        }

        @Override
        public int getLocationOffset(int n, int n2) {
            InputMethodRequests inputMethodRequests = this.getClientRequests();
            if (inputMethodRequests != null) {
                return inputMethodRequests.getLocationOffset(n, n2);
            }
            return 0;
        }

        @Override
        public void cancelLatestCommittedText() {
            InputMethodRequests inputMethodRequests = this.getClientRequests();
            if (inputMethodRequests != null) {
                inputMethodRequests.cancelLatestCommittedText();
            }
        }

        @Override
        public String getSelectedText() {
            InputMethodRequests inputMethodRequests = this.getClientRequests();
            if (inputMethodRequests != null) {
                return inputMethodRequests.getSelectedText();
            }
            return null;
        }

        private InputMethodRequests getClientRequests() {
            Node node = Scene.this.getFocusOwner();
            if (node != null) {
                return node.getInputMethodRequests();
            }
            return null;
        }
    }

    class KeyHandler {
        private boolean windowFocused;
        private final InvalidationListener sceneWindowFocusedListener = new InvalidationListener(){

            @Override
            public void invalidated(Observable observable) {
                KeyHandler.this.setWindowFocused(((ReadOnlyBooleanProperty)observable).get());
            }
        };

        KeyHandler() {
        }

        private void setFocusOwner(Node node) {
            Scene.this.focusOwner.set(node);
        }

        protected boolean isWindowFocused() {
            return this.windowFocused;
        }

        protected void setWindowFocused(boolean bl) {
            this.windowFocused = bl;
            if (Scene.this.getFocusOwner() != null) {
                Scene.this.getFocusOwner().setFocused(this.windowFocused);
            }
        }

        private void windowForSceneChanged(Window window, Window window2) {
            if (window != null) {
                window.focusedProperty().removeListener(this.sceneWindowFocusedListener);
            }
            if (window2 != null) {
                window2.focusedProperty().addListener(this.sceneWindowFocusedListener);
                this.setWindowFocused(window2.isFocused());
            } else {
                this.setWindowFocused(false);
            }
        }

        private void process(KeyEvent keyEvent) {
            Node node = Scene.this.getFocusOwner();
            EventTarget eventTarget = node != null ? node : Scene.this;
            Event.fireEvent(eventTarget, keyEvent);
        }

        private void requestFocus(Node node) {
            if (Scene.this.getFocusOwner() == node || node != null && !node.isCanReceiveFocus()) {
                return;
            }
            this.setFocusOwner(node);
            if (Scene.this.getFocusOwner() != null && Scene.this.impl_peer != null) {
                Scene.this.impl_peer.requestFocus();
            }
        }
    }

    class MouseHandler {
        private TargetWrapper pdrEventTarget = new TargetWrapper();
        private boolean pdrInProgress = false;
        private boolean fullPDREntered = false;
        private EventTarget currentEventTarget = null;
        private MouseEvent lastEvent;
        private boolean hover = false;
        private boolean primaryButtonDown = false;
        private boolean secondaryButtonDown = false;
        private boolean middleButtonDown = false;
        private EventTarget fullPDRSource = null;
        private TargetWrapper fullPDRTmpTargetWrapper = new TargetWrapper();
        private final List<EventTarget> pdrEventTargets = new ArrayList<EventTarget>();
        private final List<EventTarget> currentEventTargets = new ArrayList<EventTarget>();
        private final List<EventTarget> newEventTargets = new ArrayList<EventTarget>();
        private final List<EventTarget> fullPDRCurrentEventTargets = new ArrayList<EventTarget>();
        private final List<EventTarget> fullPDRNewEventTargets = new ArrayList<EventTarget>();
        private EventTarget fullPDRCurrentTarget = null;
        private Cursor currCursor;
        private CursorFrame currCursorFrame;
        private EventQueue queue = new EventQueue();
        private Runnable pickProcess = new Runnable(){

            @Override
            public void run() {
                MouseHandler.this.process(MouseHandler.this.lastEvent, true);
            }
        };

        MouseHandler() {
        }

        private void pulse() {
            if (this.hover && this.lastEvent != null) {
                Platform.runLater(this.pickProcess);
            }
        }

        private void process(MouseEvent mouseEvent) {
            this.process(mouseEvent, false);
        }

        private void clearPDREventTargets() {
            this.pdrInProgress = false;
            this.currentEventTarget = this.currentEventTargets.size() > 0 ? this.currentEventTargets.get(0) : null;
            this.pdrEventTarget.clear();
        }

        public void enterFullPDR(EventTarget eventTarget) {
            this.fullPDREntered = true;
            this.fullPDRSource = eventTarget;
            this.fullPDRCurrentTarget = null;
            this.fullPDRCurrentEventTargets.clear();
        }

        public void exitFullPDR(MouseEvent mouseEvent) {
            if (!this.fullPDREntered) {
                return;
            }
            this.fullPDREntered = false;
            for (int i = this.fullPDRCurrentEventTargets.size() - 1; i >= 0; --i) {
                EventTarget eventTarget = this.fullPDRCurrentEventTargets.get(i);
                Event.fireEvent(eventTarget, MouseDragEvent.impl_copy(eventTarget, eventTarget, this.fullPDRSource, mouseEvent, MouseDragEvent.MOUSE_DRAG_EXITED_TARGET));
            }
            this.fullPDRSource = null;
            this.fullPDRCurrentEventTargets.clear();
            this.fullPDRCurrentTarget = null;
        }

        private void handleEnterExit(MouseEvent mouseEvent, TargetWrapper targetWrapper) {
            if (targetWrapper.getEventTarget() != this.currentEventTarget || mouseEvent.getEventType() == MouseEvent.MOUSE_EXITED) {
                EventTarget eventTarget;
                if (mouseEvent.getEventType() == MouseEvent.MOUSE_EXITED) {
                    this.newEventTargets.clear();
                } else {
                    targetWrapper.fillHierarchy(this.newEventTargets);
                }
                int n = this.newEventTargets.size();
                int n2 = this.currentEventTargets.size() - 1;
                int n3 = n - 1;
                int n4 = this.pdrEventTargets.size() - 1;
                while (n2 >= 0 && n3 >= 0 && this.currentEventTargets.get(n2) == this.newEventTargets.get(n3)) {
                    --n2;
                    --n3;
                    --n4;
                }
                int n5 = n4;
                while (n2 >= 0) {
                    eventTarget = this.currentEventTargets.get(n2);
                    if (this.pdrInProgress && (n4 < 0 || eventTarget != this.pdrEventTargets.get(n4))) break;
                    this.queue.postEvent(MouseEvent.impl_copy(eventTarget, eventTarget, mouseEvent, MouseEvent.MOUSE_EXITED_TARGET));
                    --n2;
                    --n4;
                }
                n4 = n5;
                while (n3 >= 0) {
                    eventTarget = this.newEventTargets.get(n3);
                    if (this.pdrInProgress && (n4 < 0 || eventTarget != this.pdrEventTargets.get(n4))) break;
                    this.queue.postEvent(MouseEvent.impl_copy(eventTarget, eventTarget, mouseEvent, MouseEvent.MOUSE_ENTERED_TARGET));
                    --n3;
                    --n4;
                }
                this.currentEventTarget = targetWrapper.getEventTarget();
                this.currentEventTargets.clear();
                ++n3;
                while (n3 < n) {
                    this.currentEventTargets.add(this.newEventTargets.get(n3));
                    ++n3;
                }
            }
            this.queue.fire();
        }

        private void process(MouseEvent mouseEvent, boolean bl) {
            Toolkit.getToolkit().checkFxUserThread();
            inMousePick = true;
            Scene.this.cursorScreenPos = new Point2D(mouseEvent.getScreenX(), mouseEvent.getScreenY());
            Scene.this.cursorScenePos = new Point2D(mouseEvent.getSceneX(), mouseEvent.getSceneY());
            boolean bl2 = false;
            if (!bl) {
                if (mouseEvent.getEventType() == MouseEvent.MOUSE_PRESSED) {
                    if (!(this.primaryButtonDown || this.secondaryButtonDown || this.middleButtonDown)) {
                        bl2 = true;
                        Scene.this.dndGesture = new DnDGesture();
                        this.clearPDREventTargets();
                    }
                } else if (mouseEvent.getEventType() == MouseEvent.MOUSE_MOVED) {
                    this.clearPDREventTargets();
                } else if (mouseEvent.getEventType() == MouseEvent.MOUSE_ENTERED) {
                    this.hover = true;
                } else if (mouseEvent.getEventType() == MouseEvent.MOUSE_EXITED) {
                    this.hover = false;
                }
                this.primaryButtonDown = mouseEvent.isPrimaryButtonDown();
                this.secondaryButtonDown = mouseEvent.isSecondaryButtonDown();
                this.middleButtonDown = mouseEvent.isMiddleButtonDown();
            }
            if (mouseEvent.getEventType() != MouseEvent.MOUSE_EXITED) {
                Scene.this.pick(Scene.this.tmpTargetWrapper, mouseEvent.getX(), mouseEvent.getY());
            } else {
                Scene.this.tmpTargetWrapper.clear();
            }
            TargetWrapper targetWrapper = this.pdrInProgress ? this.pdrEventTarget : Scene.this.tmpTargetWrapper;
            if (bl2) {
                this.pdrEventTarget.copy(targetWrapper);
                this.pdrEventTarget.fillHierarchy(this.pdrEventTargets);
            }
            if (!bl) {
                Scene.this.clickGenerator.preProcess(mouseEvent);
            }
            this.handleEnterExit(mouseEvent, Scene.this.tmpTargetWrapper);
            Cursor cursor = targetWrapper.getCursor();
            if (Scene.this.dndGesture != null) {
                Scene.this.dndGesture.processDragDetection(mouseEvent);
            }
            if (this.fullPDREntered && mouseEvent.getEventType() == MouseEvent.MOUSE_RELEASED) {
                this.processFullPDR(mouseEvent, bl);
            }
            if (targetWrapper.getEventTarget() != null && mouseEvent.getEventType() != MouseEvent.MOUSE_ENTERED && mouseEvent.getEventType() != MouseEvent.MOUSE_EXITED && !bl) {
                Event.fireEvent(targetWrapper.getEventTarget(), mouseEvent);
            }
            if (this.fullPDREntered && mouseEvent.getEventType() != MouseEvent.MOUSE_RELEASED) {
                this.processFullPDR(mouseEvent, bl);
            }
            if (!bl) {
                Scene.this.clickGenerator.postProcess(mouseEvent, targetWrapper, Scene.this.tmpTargetWrapper);
            }
            if (!bl && Scene.this.dndGesture != null && !Scene.this.dndGesture.process(mouseEvent, targetWrapper.getEventTarget())) {
                Scene.this.dndGesture = null;
            }
            if (cursor == null && this.hover) {
                cursor = Scene.this.getCursor();
            }
            this.updateCursor(cursor);
            this.updateCursorFrame();
            if (bl2) {
                this.pdrInProgress = true;
            }
            if (this.pdrInProgress && !this.primaryButtonDown && !this.secondaryButtonDown && !this.middleButtonDown) {
                this.clearPDREventTargets();
                this.exitFullPDR(mouseEvent);
                this.handleEnterExit(mouseEvent, Scene.this.tmpTargetWrapper);
            }
            this.lastEvent = mouseEvent;
            inMousePick = false;
        }

        private void processFullPDR(MouseEvent mouseEvent, boolean bl) {
            Scene.this.pick(this.fullPDRTmpTargetWrapper, mouseEvent.getX(), mouseEvent.getY());
            EventTarget eventTarget = this.fullPDRTmpTargetWrapper.getEventTarget();
            if (eventTarget != this.fullPDRCurrentTarget) {
                EventTarget eventTarget2;
                int n;
                this.fullPDRTmpTargetWrapper.fillHierarchy(this.fullPDRNewEventTargets);
                int n2 = this.fullPDRNewEventTargets.size();
                int n3 = this.fullPDRCurrentEventTargets.size() - 1;
                for (n = n2 - 1; n3 >= 0 && n >= 0 && this.fullPDRCurrentEventTargets.get(n3) == this.fullPDRNewEventTargets.get(n); --n3, --n) {
                }
                while (n3 >= 0) {
                    eventTarget2 = this.fullPDRCurrentEventTargets.get(n3);
                    Event.fireEvent(eventTarget2, MouseDragEvent.impl_copy(eventTarget2, eventTarget2, this.fullPDRSource, mouseEvent, MouseDragEvent.MOUSE_DRAG_EXITED_TARGET));
                    --n3;
                }
                while (n >= 0) {
                    eventTarget2 = this.fullPDRNewEventTargets.get(n);
                    Event.fireEvent(eventTarget2, MouseDragEvent.impl_copy(eventTarget2, eventTarget2, this.fullPDRSource, mouseEvent, MouseDragEvent.MOUSE_DRAG_ENTERED_TARGET));
                    --n;
                }
                this.fullPDRCurrentTarget = eventTarget;
                this.fullPDRCurrentEventTargets.clear();
                this.fullPDRCurrentEventTargets.addAll(this.fullPDRNewEventTargets);
            }
            if (eventTarget != null && !bl) {
                if (mouseEvent.getEventType() == MouseEvent.MOUSE_DRAGGED) {
                    Event.fireEvent(eventTarget, MouseDragEvent.impl_copy(eventTarget, eventTarget, this.fullPDRSource, mouseEvent, MouseDragEvent.MOUSE_DRAG_OVER));
                }
                if (mouseEvent.getEventType() == MouseEvent.MOUSE_RELEASED) {
                    Event.fireEvent(eventTarget, MouseDragEvent.impl_copy(eventTarget, eventTarget, this.fullPDRSource, mouseEvent, MouseDragEvent.MOUSE_DRAG_RELEASED));
                }
            }
        }

        private void updateCursor(Cursor cursor) {
            if (this.currCursor != cursor) {
                if (this.currCursor != null) {
                    this.currCursor.deactivate();
                }
                if (cursor != null) {
                    cursor.activate();
                }
                this.currCursor = cursor;
            }
        }

        public void updateCursorFrame() {
            CursorFrame cursorFrame;
            CursorFrame cursorFrame2 = cursorFrame = this.currCursor != null ? this.currCursor.getCurrentFrame() : Cursor.DEFAULT.getCurrentFrame();
            if (this.currCursorFrame != cursorFrame) {
                if (Scene.this.impl_peer != null) {
                    Scene.this.impl_peer.setCursor(cursorFrame);
                }
                this.currCursorFrame = cursorFrame;
            }
        }

        private Node pickNode(double d, double d2) {
            return Scene.this.getRoot().impl_pickNode(d, d2);
        }

        private Node pickNode(PickRay pickRay) {
            return Scene.this.getRoot().impl_pickNode(pickRay);
        }
    }

    static class ClickGenerator {
        private ClickCounter lastPress = null;
        private Map<MouseButton, ClickCounter> counters = new EnumMap<MouseButton, ClickCounter>(MouseButton.class);
        private List<EventTarget> pressedTargets = new ArrayList<EventTarget>();
        private List<EventTarget> releasedTargets = new ArrayList<EventTarget>();

        public ClickGenerator() {
            for (MouseButton mouseButton : MouseButton.values()) {
                if (mouseButton == MouseButton.NONE) continue;
                this.counters.put(mouseButton, new ClickCounter());
            }
        }

        private void preProcess(MouseEvent mouseEvent) {
            boolean bl;
            for (ClickCounter clickCounter : this.counters.values()) {
                clickCounter.moved(mouseEvent.getSceneX(), mouseEvent.getSceneY());
            }
            ClickCounter clickCounter = this.counters.get((Object)mouseEvent.getButton());
            boolean bl2 = bl = this.lastPress != null ? this.lastPress.isStill() : false;
            if (mouseEvent.getEventType() == MouseEvent.MOUSE_PRESSED) {
                if (!mouseEvent.isPrimaryButtonDown()) {
                    this.counters.get((Object)MouseButton.PRIMARY).clear();
                }
                if (!mouseEvent.isSecondaryButtonDown()) {
                    this.counters.get((Object)MouseButton.SECONDARY).clear();
                }
                if (!mouseEvent.isMiddleButtonDown()) {
                    this.counters.get((Object)MouseButton.MIDDLE).clear();
                }
                clickCounter.applyOut();
                clickCounter.inc();
                clickCounter.start(mouseEvent.getSceneX(), mouseEvent.getSceneY());
                this.lastPress = clickCounter;
            }
            mouseEvent.impl_setClickParams(clickCounter != null && mouseEvent.getEventType() != MouseEvent.MOUSE_MOVED ? clickCounter.get() : 0, bl);
        }

        private void postProcess(MouseEvent mouseEvent, TargetWrapper targetWrapper, TargetWrapper targetWrapper2) {
            if (mouseEvent.getEventType() == MouseEvent.MOUSE_RELEASED) {
                ClickCounter clickCounter = this.counters.get((Object)mouseEvent.getButton());
                targetWrapper.fillHierarchy(this.pressedTargets);
                targetWrapper2.fillHierarchy(this.releasedTargets);
                int n = this.pressedTargets.size() - 1;
                EventTarget eventTarget = null;
                for (int i = this.releasedTargets.size() - 1; n >= 0 && i >= 0 && this.pressedTargets.get(n) == this.releasedTargets.get(i); --n, --i) {
                    eventTarget = this.pressedTargets.get(n);
                }
                if (eventTarget != null) {
                    MouseEvent mouseEvent2 = MouseEvent.impl_copy(null, eventTarget, mouseEvent, MouseEvent.MOUSE_CLICKED);
                    mouseEvent2.impl_setClickParams(clickCounter.get(), this.lastPress.isStill());
                    Event.fireEvent(eventTarget, mouseEvent2);
                }
            }
        }
    }

    static class ClickCounter {
        Toolkit toolkit = Toolkit.getToolkit();
        private int count;
        private boolean out;
        private boolean still;
        private Timeline timeout;
        private double pressedX;
        private double pressedY;

        ClickCounter() {
        }

        private void inc() {
            ++this.count;
        }

        private int get() {
            return this.count;
        }

        private boolean isStill() {
            return this.still;
        }

        private void clear() {
            this.count = 0;
            this.stopTimeout();
        }

        private void out() {
            this.out = true;
            this.stopTimeout();
        }

        private void applyOut() {
            if (this.out) {
                this.clear();
            }
            this.out = false;
        }

        private void moved(double d, double d2) {
            if (Math.abs(d - this.pressedX) > (double)this.toolkit.getMultiClickMaxX() || Math.abs(d2 - this.pressedY) > (double)this.toolkit.getMultiClickMaxY()) {
                this.out();
                this.still = false;
            }
        }

        private void start(double d, double d2) {
            this.pressedX = d;
            this.pressedY = d2;
            this.out = false;
            if (this.timeout != null) {
                this.timeout.stop();
            }
            this.timeout = new Timeline();
            this.timeout.getKeyFrames().add(new KeyFrame(new Duration(this.toolkit.getMultiClickTime()), new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent actionEvent) {
                    ClickCounter.this.out = true;
                    ClickCounter.this.timeout = null;
                }
            }, new KeyValue[0]));
            this.timeout.play();
            this.still = true;
        }

        private void stopTimeout() {
            if (this.timeout != null) {
                this.timeout.stop();
                this.timeout = null;
            }
        }
    }

    class DragSourceListener
    implements TKDragSourceListener {
        DragSourceListener() {
        }

        @Override
        public void dropActionChanged(Object object) {
        }

        @Override
        public void dragDropEnd(Object object) {
            if (Scene.this.dndGesture != null) {
                Scene.this.dndGesture.processDropEnd(Toolkit.getToolkit().convertDragSourceEventToFX(object, Scene.this.dndGesture.dragboard));
                Scene.this.dndGesture = null;
            }
        }
    }

    private static enum DragDetectedState {
        NOT_YET,
        PROCESSING,
        DONE;

    }

    class DnDGesture {
        private final double hysteresisSizeX = Toolkit.getToolkit().getMultiClickMaxX();
        private final double hysteresisSizeY = Toolkit.getToolkit().getMultiClickMaxY();
        private EventTarget source = null;
        private Set<TransferMode> sourceTransferModes = null;
        private TransferMode acceptedTransferMode = null;
        private Dragboard dragboard = null;
        private EventTarget potentialTarget = null;
        private EventTarget target = null;
        private DragDetectedState dragDetected = DragDetectedState.NOT_YET;
        private double pressedX;
        private double pressedY;
        private List<EventTarget> currentTargets = new ArrayList<EventTarget>();
        private List<EventTarget> newTargets = new ArrayList<EventTarget>();
        private EventTarget fullPDRSource = null;

        DnDGesture() {
        }

        private void fireEvent(EventTarget eventTarget, Event event) {
            if (eventTarget != null) {
                Event.fireEvent(eventTarget, event);
            }
        }

        private void processingDragDetected() {
            this.dragDetected = DragDetectedState.PROCESSING;
        }

        private void dragDetectedProcessed() {
            boolean bl;
            this.dragDetected = DragDetectedState.DONE;
            boolean bl2 = bl = this.dragboard != null && this.dragboard.impl_contentPut();
            if (bl) {
                Toolkit.getToolkit().startDrag(Scene.this.impl_peer, this.sourceTransferModes, new DragSourceListener(), this.dragboard);
            } else if (this.fullPDRSource != null) {
                Scene.this.mouseHandler.enterFullPDR(this.fullPDRSource);
            }
            this.fullPDRSource = null;
        }

        private void processDragDetection(MouseEvent mouseEvent) {
            if (this.dragDetected != DragDetectedState.NOT_YET) {
                mouseEvent.setDragDetect(false);
                return;
            }
            if (mouseEvent.getEventType() == MouseEvent.MOUSE_PRESSED) {
                this.pressedX = mouseEvent.getSceneX();
                this.pressedY = mouseEvent.getSceneY();
                mouseEvent.setDragDetect(false);
            } else if (mouseEvent.getEventType() == MouseEvent.MOUSE_DRAGGED) {
                double d = Math.abs(mouseEvent.getSceneX() - this.pressedX);
                double d2 = Math.abs(mouseEvent.getSceneY() - this.pressedY);
                mouseEvent.setDragDetect(d > this.hysteresisSizeX || d2 > this.hysteresisSizeY);
            }
        }

        private boolean process(MouseEvent mouseEvent, EventTarget eventTarget) {
            boolean bl = true;
            if (this.dragDetected != DragDetectedState.DONE && (mouseEvent.getEventType() == MouseEvent.MOUSE_PRESSED || mouseEvent.getEventType() == MouseEvent.MOUSE_DRAGGED) && mouseEvent.isDragDetect()) {
                this.processingDragDetected();
                if (eventTarget != null) {
                    MouseEvent mouseEvent2 = MouseEvent.impl_copy(mouseEvent.getSource(), eventTarget, mouseEvent, MouseEvent.DRAG_DETECTED);
                    this.fireEvent(eventTarget, mouseEvent2);
                }
                this.dragDetectedProcessed();
            }
            if (mouseEvent.getEventType() == MouseEvent.MOUSE_RELEASED) {
                bl = false;
            }
            return bl;
        }

        private boolean processRecognized(EventTarget eventTarget, DragEvent dragEvent) {
            MouseEvent mouseEvent = MouseEvent.impl_mouseEvent(dragEvent.getX(), dragEvent.getY(), dragEvent.getSceneX(), dragEvent.getScreenY(), MouseButton.PRIMARY, 1, false, false, false, false, false, true, false, false, false, MouseEvent.DRAG_DETECTED);
            this.processingDragDetected();
            this.fireEvent(eventTarget, mouseEvent);
            this.dragDetectedProcessed();
            boolean bl = this.dragboard != null && !this.dragboard.getContentTypes().isEmpty();
            return bl;
        }

        private void processDropEnd(DragEvent dragEvent) {
            if (this.source == null) {
                System.out.println("Scene.DnDGesture.processDropEnd() - UNEXPECTD - source is NULL");
                return;
            }
            dragEvent = DragEvent.impl_copy(dragEvent.getSource(), this.source, (Object)this.source, (Object)this.target, dragEvent, DragEvent.DRAG_DONE);
            Event.fireEvent(this.source, dragEvent);
            Scene.this.tmpTargetWrapper.clear();
            this.handleExitEnter(dragEvent, Scene.this.tmpTargetWrapper);
            Toolkit.getToolkit().stopDrag(this.dragboard);
        }

        private TransferMode processTargetEnterOver(DragEvent dragEvent) {
            Scene.this.pick(Scene.this.tmpTargetWrapper, dragEvent.getX(), dragEvent.getY());
            EventTarget eventTarget = Scene.this.tmpTargetWrapper.getEventTarget();
            if (this.dragboard == null) {
                this.dragboard = this.createDragboard(dragEvent);
            }
            dragEvent = DragEvent.impl_copy(dragEvent.getSource(), eventTarget, (Object)this.source, (Object)this.potentialTarget, this.dragboard, dragEvent);
            this.handleExitEnter(dragEvent, Scene.this.tmpTargetWrapper);
            dragEvent = DragEvent.impl_copy(dragEvent.getSource(), eventTarget, (Object)this.source, (Object)this.potentialTarget, dragEvent, DragEvent.DRAG_OVER);
            this.fireEvent(eventTarget, dragEvent);
            Object object = dragEvent.impl_getAcceptingObject();
            this.potentialTarget = object instanceof EventTarget ? (EventTarget)object : null;
            this.acceptedTransferMode = dragEvent.getAcceptedTransferMode();
            return this.acceptedTransferMode;
        }

        private void processTargetActionChanged(DragEvent dragEvent) {
        }

        private void processTargetExit(DragEvent dragEvent) {
            if (this.currentTargets.size() > 0) {
                this.potentialTarget = null;
                Scene.this.tmpTargetWrapper.clear();
                this.handleExitEnter(dragEvent, Scene.this.tmpTargetWrapper);
            }
        }

        private TransferMode processTargetDrop(DragEvent dragEvent) {
            Scene.this.pick(Scene.this.tmpTargetWrapper, dragEvent.getX(), dragEvent.getY());
            EventTarget eventTarget = Scene.this.tmpTargetWrapper.getEventTarget();
            dragEvent = DragEvent.impl_copy(dragEvent.getSource(), eventTarget, this.source, this.potentialTarget, this.acceptedTransferMode, dragEvent, DragEvent.DRAG_DROPPED);
            if (this.dragboard == null) {
                this.dragboard = this.createDragboard(dragEvent);
            }
            this.handleExitEnter(dragEvent, Scene.this.tmpTargetWrapper);
            this.fireEvent(eventTarget, dragEvent);
            Object object = dragEvent.impl_getAcceptingObject();
            this.target = this.potentialTarget = object instanceof EventTarget ? (EventTarget)object : null;
            TransferMode transferMode = dragEvent.isDropCompleted() ? dragEvent.getAcceptedTransferMode() : null;
            Scene.this.tmpTargetWrapper.clear();
            this.handleExitEnter(dragEvent, Scene.this.tmpTargetWrapper);
            return transferMode;
        }

        private void handleExitEnter(DragEvent dragEvent, TargetWrapper targetWrapper) {
            EventTarget eventTarget;
            EventTarget eventTarget2 = eventTarget = this.currentTargets.size() > 0 ? this.currentTargets.get(0) : null;
            if (targetWrapper.getEventTarget() != eventTarget) {
                EventTarget eventTarget3;
                int n;
                targetWrapper.fillHierarchy(this.newTargets);
                int n2 = this.currentTargets.size() - 1;
                for (n = this.newTargets.size() - 1; n2 >= 0 && n >= 0 && this.currentTargets.get(n2) == this.newTargets.get(n); --n2, --n) {
                }
                while (n2 >= 0) {
                    eventTarget3 = this.currentTargets.get(n2);
                    if (this.potentialTarget == eventTarget3) {
                        this.potentialTarget = null;
                    }
                    dragEvent = DragEvent.impl_copy(dragEvent.getSource(), eventTarget3, (Object)this.source, (Object)this.potentialTarget, dragEvent, DragEvent.DRAG_EXITED_TARGET);
                    Event.fireEvent(eventTarget3, dragEvent);
                    --n2;
                }
                this.potentialTarget = null;
                while (n >= 0) {
                    eventTarget3 = this.newTargets.get(n);
                    Object object = (dragEvent = DragEvent.impl_copy(dragEvent.getSource(), eventTarget3, (Object)this.source, (Object)this.potentialTarget, dragEvent, DragEvent.DRAG_ENTERED_TARGET)).impl_getAcceptingObject();
                    if (object instanceof EventTarget) {
                        this.potentialTarget = (EventTarget)object;
                    }
                    Event.fireEvent(eventTarget3, dragEvent);
                    --n;
                }
                this.currentTargets.clear();
                this.currentTargets.addAll(this.newTargets);
            }
        }

        private boolean processKey(KeyEvent keyEvent) {
            if (keyEvent.getEventType() == KeyEvent.KEY_PRESSED && keyEvent.getCode() == KeyCode.ESCAPE) {
                DragEvent dragEvent = DragEvent.impl_create(DragEvent.DRAG_DONE, this.source, this.source, this.source, null, 0.0, 0.0, 0.0, 0.0, null, this.dragboard, null);
                if (this.source != null) {
                    Event.fireEvent(this.source, dragEvent);
                }
                Scene.this.tmpTargetWrapper.clear();
                this.handleExitEnter(dragEvent, Scene.this.tmpTargetWrapper);
                return false;
            }
            return true;
        }

        private Dragboard startDrag(EventTarget eventTarget, Set<TransferMode> set) {
            if (this.dragDetected != DragDetectedState.PROCESSING) {
                throw new IllegalStateException("Cannot start drag and drop outside of DRAG_DETECTED event handler");
            }
            if (set.isEmpty()) {
                this.dragboard = null;
            } else if (this.dragboard == null) {
                this.dragboard = this.createDragboard(null);
            }
            this.source = eventTarget;
            this.potentialTarget = eventTarget;
            this.sourceTransferModes = set;
            return this.dragboard;
        }

        private void startFullPDR(EventTarget eventTarget) {
            this.fullPDRSource = eventTarget;
        }

        private Dragboard createDragboard(DragEvent dragEvent) {
            Dragboard dragboard = null;
            if (dragEvent != null && (dragboard = dragEvent.getDragboard()) != null) {
                return dragboard;
            }
            return Scene.this.impl_peer.createDragboard();
        }
    }

    class DragGestureListener
    implements TKDragGestureListener {
        DragGestureListener() {
        }

        @Override
        public void dragGestureRecognized(Object object) {
            Scene.this.dndGesture = new DnDGesture();
            DragEvent dragEvent = Toolkit.getToolkit().convertDragRecognizedEventToFX(object, null);
            EventTarget eventTarget = Scene.this.pick(dragEvent.getX(), dragEvent.getY());
            Scene.this.dndGesture.dragboard = dragEvent.impl_getPlatformDragboard();
            Scene.this.dndGesture.processRecognized(eventTarget, dragEvent);
            Scene.this.dndGesture = null;
        }
    }

    class DropTargetListener
    implements TKDropTargetListener {
        DropTargetListener() {
        }

        @Override
        public TransferMode dragEnter(Object object) {
            if (Scene.this.dndGesture == null) {
                Scene.this.dndGesture = new DnDGesture();
            }
            return Scene.this.dndGesture.processTargetEnterOver(Toolkit.getToolkit().convertDropTargetEventToFX(object, Scene.this.dndGesture.dragboard));
        }

        @Override
        public TransferMode dragOver(Object object) {
            if (Scene.this.dndGesture == null) {
                System.out.println("GOT A dragOver when dndGesture is null!");
                return null;
            }
            return Scene.this.dndGesture.processTargetEnterOver(Toolkit.getToolkit().convertDropTargetEventToFX(object, Scene.this.dndGesture.dragboard));
        }

        @Override
        public void dropActionChanged(Object object) {
            if (Scene.this.dndGesture == null) {
                System.out.println("GOT A dropActionChanged when dndGesture is null!");
            } else {
                Scene.this.dndGesture.processTargetActionChanged(Toolkit.getToolkit().convertDropTargetEventToFX(object, Scene.this.dndGesture.dragboard));
            }
        }

        @Override
        public void dragExit(Object object) {
            if (Scene.this.dndGesture == null) {
                System.out.println("GOT A dragExit when dndGesture is null!");
            } else {
                Scene.this.dndGesture.processTargetExit(Toolkit.getToolkit().convertDropTargetEventToFX(object, Scene.this.dndGesture.dragboard));
                if (Scene.this.dndGesture.source == null) {
                    Scene.this.dndGesture = null;
                }
            }
        }

        @Override
        public TransferMode drop(Object object) {
            if (Scene.this.dndGesture == null) {
                System.out.println("GOT A drop when dndGesture is null!");
                return null;
            }
            TransferMode transferMode = Scene.this.dndGesture.processTargetDrop(Toolkit.getToolkit().convertDropTargetEventToFX(object, Scene.this.dndGesture.dragboard));
            if (Scene.this.dndGesture.source == null) {
                Scene.this.dndGesture = null;
            }
            return transferMode;
        }
    }

    private class ScenePeerPaintListener
    implements TKScenePaintListener {
        private ScenePeerPaintListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void frameRendered() {
            Object object = trackerMonitor;
            synchronized (object) {
                if (Scene.this.tracker != null) {
                    Scene.this.tracker.frameRendered();
                }
            }
        }
    }

    class ScenePeerListener
    implements TKSceneListener {
        ScenePeerListener() {
        }

        @Override
        public void changedLocation(float f, float f2) {
            if ((double)f != Scene.this.getX()) {
                Scene.this.setX(f);
            }
            if ((double)f2 != Scene.this.getY()) {
                Scene.this.setY(f2);
            }
        }

        @Override
        public void changedSize(float f, float f2) {
            if ((double)f != Scene.this.getWidth()) {
                Scene.this.setWidth(f);
            }
            if ((double)f2 != Scene.this.getHeight()) {
                Scene.this.setHeight(f2);
            }
        }

        @Override
        public void mouseEvent(Object object) {
            Scene.this.impl_processMouseEvent(Toolkit.getToolkit().convertMouseEventToFX(object));
        }

        @Override
        public void keyEvent(Object object) {
            Scene.this.impl_processKeyEvent(Toolkit.getToolkit().convertKeyEventToFX(object));
        }

        @Override
        public void inputMethodEvent(Object object) {
            Scene.this.processInputMethodEvent(Toolkit.getToolkit().convertInputMethodEventToFX(object));
        }

        @Override
        public void menuEvent(double d, double d2, double d3, double d4, boolean bl) {
            Scene.this.processMenuEvent(d, d2, d3, d4, bl);
        }

        @Override
        public void scrollEvent(EventType<ScrollEvent> eventType, double d, double d2, double d3, double d4, double d5, double d6, int n, int n2, int n3, int n4, int n5, double d7, double d8, double d9, double d10, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
            double d11;
            ScrollEvent.HorizontalTextScrollUnits horizontalTextScrollUnits = n2 > 0 ? ScrollEvent.HorizontalTextScrollUnits.CHARACTERS : ScrollEvent.HorizontalTextScrollUnits.NONE;
            double d12 = d11 = n2 < 0 ? 0.0 : (double)n2 * d;
            ScrollEvent.VerticalTextScrollUnits verticalTextScrollUnits = n3 > 0 ? ScrollEvent.VerticalTextScrollUnits.LINES : (n3 < 0 ? ScrollEvent.VerticalTextScrollUnits.PAGES : ScrollEvent.VerticalTextScrollUnits.NONE);
            double d13 = n3 < 0 ? d2 : (double)n3 * d2;
            d5 = n4 > 0 && n2 >= 0 ? (double)Math.round(d5 * (double)n2 / (double)n4) : d5;
            double d14 = d6 = n5 > 0 && n3 >= 0 ? (double)Math.round(d6 * (double)n3 / (double)n5) : d6;
            if (eventType == ScrollEvent.SCROLL_FINISHED) {
                d7 = ((Scene)Scene.this).scrollGesture.sceneCoords.getX();
                d8 = ((Scene)Scene.this).scrollGesture.sceneCoords.getY();
                d9 = ((Scene)Scene.this).scrollGesture.screenCoords.getX();
                d10 = ((Scene)Scene.this).scrollGesture.screenCoords.getY();
            } else if (Double.isNaN(d7) || Double.isNaN(d8) || Double.isNaN(d9) || Double.isNaN(d10)) {
                if (Scene.this.cursorScenePos == null || Scene.this.cursorScreenPos == null) {
                    return;
                }
                d7 = Scene.this.cursorScenePos.getX();
                d8 = Scene.this.cursorScenePos.getY();
                d9 = Scene.this.cursorScreenPos.getX();
                d10 = Scene.this.cursorScreenPos.getY();
            }
            Scene.this.processGestureEvent(ScrollEvent.impl_scrollEvent(eventType, d * d5, d2 * d6, d3 * d5, d4 * d6, horizontalTextScrollUnits, d11, verticalTextScrollUnits, d13, n, d7, d8, d9, d10, bl, bl2, bl3, bl4, bl5, bl6), Scene.this.scrollGesture);
        }

        @Override
        public void zoomEvent(EventType<ZoomEvent> eventType, double d, double d2, double d3, double d4, double d5, double d6, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
            if (eventType == ZoomEvent.ZOOM_FINISHED) {
                d3 = ((Scene)Scene.this).zoomGesture.sceneCoords.getX();
                d4 = ((Scene)Scene.this).zoomGesture.sceneCoords.getY();
                d5 = ((Scene)Scene.this).zoomGesture.screenCoords.getX();
                d6 = ((Scene)Scene.this).zoomGesture.screenCoords.getY();
            } else if (Double.isNaN(d3) || Double.isNaN(d4) || Double.isNaN(d5) || Double.isNaN(d6)) {
                if (Scene.this.cursorScenePos == null || Scene.this.cursorScreenPos == null) {
                    return;
                }
                d3 = Scene.this.cursorScenePos.getX();
                d4 = Scene.this.cursorScenePos.getY();
                d5 = Scene.this.cursorScreenPos.getX();
                d6 = Scene.this.cursorScreenPos.getY();
            }
            Scene.this.processGestureEvent(ZoomEvent.impl_zoomEvent(eventType, d, d2, d3, d4, d5, d6, bl, bl2, bl3, bl4, bl5, bl6), Scene.this.zoomGesture);
        }

        @Override
        public void rotateEvent(EventType<RotateEvent> eventType, double d, double d2, double d3, double d4, double d5, double d6, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
            if (eventType == RotateEvent.ROTATION_FINISHED) {
                d3 = ((Scene)Scene.this).rotateGesture.sceneCoords.getX();
                d4 = ((Scene)Scene.this).rotateGesture.sceneCoords.getY();
                d5 = ((Scene)Scene.this).rotateGesture.screenCoords.getX();
                d6 = ((Scene)Scene.this).rotateGesture.screenCoords.getY();
            } else if (Double.isNaN(d3) || Double.isNaN(d4) || Double.isNaN(d5) || Double.isNaN(d6)) {
                if (Scene.this.cursorScenePos == null || Scene.this.cursorScreenPos == null) {
                    return;
                }
                d3 = Scene.this.cursorScenePos.getX();
                d4 = Scene.this.cursorScenePos.getY();
                d5 = Scene.this.cursorScreenPos.getX();
                d6 = Scene.this.cursorScreenPos.getY();
            }
            Scene.this.processGestureEvent(RotateEvent.impl_rotateEvent(eventType, d, d2, d3, d4, d5, d6, bl, bl2, bl3, bl4, bl5, bl6), Scene.this.rotateGesture);
        }

        @Override
        public void swipeEvent(EventType<SwipeEvent> eventType, int n, double d, double d2, double d3, double d4, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
            if (Double.isNaN(d) || Double.isNaN(d2) || Double.isNaN(d3) || Double.isNaN(d4)) {
                if (Scene.this.cursorScenePos == null || Scene.this.cursorScreenPos == null) {
                    return;
                }
                d = Scene.this.cursorScenePos.getX();
                d2 = Scene.this.cursorScenePos.getY();
                d3 = Scene.this.cursorScreenPos.getX();
                d4 = Scene.this.cursorScreenPos.getY();
            }
            Scene.this.processGestureEvent(SwipeEvent.impl_swipeEvent(eventType, n, d, d2, d3, d4, bl, bl2, bl3, bl4, bl5), Scene.this.swipeGesture);
        }

        @Override
        public void touchEventBegin(long l, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
            Scene.this.nextTouchEvent = TouchEvent.impl_touchEvent(TouchEvent.ANY, null, null, 0, bl2, bl3, bl4, bl5);
            Scene.this.nextTouchEvent.impl_setDirect(bl);
            if (Scene.this.touchPoints == null || Scene.this.touchPoints.length != n) {
                Scene.access$5502(Scene.this, new TouchPoint[n]);
            }
            Scene.this.touchPointIndex = 0;
        }

        @Override
        public void touchEventNext(TouchPoint.State state, long l, int n, int n2, int n3, int n4) {
            int n5;
            Scene.this.touchPointIndex++;
            int n6 = n5 = state == TouchPoint.State.PRESSED ? Scene.this.touchMap.add(l) : Scene.this.touchMap.get(l);
            if (state == TouchPoint.State.RELEASED) {
                Scene.this.touchMap.remove(l);
            }
            int n7 = Scene.this.touchMap.getOrder(n5);
            if (!Scene.this.nextTouchEvent.impl_isDirect()) {
                n7 = Scene.this.touchPointIndex - 1;
            }
            if (n7 >= Scene.this.touchPoints.length) {
                throw new RuntimeException("Too many touch points reported");
            }
            ((Scene)Scene.this).touchPoints[n7] = TouchPoint.impl_touchPoint(n5, state, n, n2, n3, n4);
        }

        @Override
        public void touchEventEnd() {
            if (Scene.this.touchPointIndex != Scene.this.touchPoints.length) {
                throw new RuntimeException("Wrong number of touch points reported");
            }
            if (Scene.this.nextTouchEvent.impl_isDirect()) {
                Scene.this.processTouchEvent(Scene.this.nextTouchEvent, Scene.this.touchPoints);
            }
            if (Scene.this.touchMap.cleanup()) {
                Scene.this.touchEventSetId = 0;
            }
        }
    }

    class ScenePulseListener
    implements TKPulseListener {
        private boolean firstPulse = true;

        ScenePulseListener() {
        }

        private void synchronizeSceneNodes() {
            Toolkit.getToolkit().checkFxUserThread();
            inSynchronizer = true;
            if (Scene.this.dirtyNodes == null) {
                this.syncAll(Scene.this.getRoot());
                Scene.access$3002(Scene.this, new Node[30]);
            } else {
                for (int i = 0; i < Scene.this.dirtyNodesSize; ++i) {
                    Node node = Scene.this.dirtyNodes[i];
                    ((Scene)Scene.this).dirtyNodes[i] = null;
                    if (node.getScene() != Scene.this) continue;
                    node.impl_syncPGNode();
                }
                Scene.this.dirtyNodesSize = 0;
            }
            inSynchronizer = false;
        }

        private int syncAll(Node node) {
            node.impl_syncPGNode();
            int n = 1;
            if (node instanceof Parent) {
                Parent parent = (Parent)node;
                int n2 = parent.getChildren().size();
                for (int i = 0; i < n2; ++i) {
                    Node node2 = (Node)parent.getChildren().get(i);
                    if (node2 == null) continue;
                    n += this.syncAll(node2);
                }
            }
            if (node.getClip() != null) {
                n += this.syncAll(node.getClip());
            }
            return n;
        }

        private void synchronizeSceneProperties() {
            inSynchronizer = true;
            if (Scene.this.isDirty(DirtyBits.ROOT_DIRTY)) {
                Scene.this.impl_peer.setRoot(Scene.this.getRoot().impl_getPGNode());
            }
            if (Scene.this.isDirty(DirtyBits.FILL_DIRTY)) {
                Toolkit toolkit = Toolkit.getToolkit();
                Scene.this.impl_peer.setFillPaint(Scene.this.getFill() == null ? null : toolkit.getPaint(Scene.this.getFill()));
            }
            if (Scene.this.isDirty(DirtyBits.CAMERA_DIRTY)) {
                if (Scene.this.getCamera() != null) {
                    Scene.this.getCamera().update();
                    Scene.this.impl_peer.setCamera(Scene.this.getCamera().getPlatformCamera());
                    Scene.this.pickingCamera = Scene.this.getCamera();
                } else {
                    Scene.this.impl_peer.setCamera(null);
                    Scene.this.pickingCamera = null;
                }
            }
            Scene.this.clearDirty();
            inSynchronizer = false;
        }

        private void focusCleanup() {
            if (Scene.this.isFocusDirty()) {
                Node node = Scene.this.getFocusOwner();
                if (node == null) {
                    Scene.this.focusInitial();
                } else if (node.getScene() != Scene.this) {
                    Scene.this.requestFocus(null);
                    Scene.this.focusInitial();
                } else if (!node.isCanReceiveFocus()) {
                    Scene.this.requestFocus(null);
                    Scene.this.focusIneligible(node);
                }
                Scene.this.setFocusDirty(false);
            }
        }

        @Override
        public void pulse() {
            boolean bl;
            if (Scene.this.tracker != null) {
                Scene.this.tracker.pulse();
            }
            if (this.firstPulse) {
                PerformanceTracker.logEvent("Scene - first repaint");
            }
            Scene.this.doCSSPass();
            Scene.this.doLayoutPass();
            boolean bl2 = bl = Scene.this.dirtyNodes == null || Scene.this.dirtyNodesSize != 0 || !Scene.this.isDirtyEmpty();
            if (bl) {
                this.synchronizeSceneProperties();
                this.synchronizeSceneNodes();
                Scene.this.mouseHandler.pulse();
                if (Scene.this.impl_peer != null) {
                    Scene.this.impl_peer.markDirty();
                }
            }
            Scene.this.mouseHandler.updateCursorFrame();
            this.focusCleanup();
            if (this.firstPulse) {
                if (PerformanceTracker.isLoggingEnabled()) {
                    PerformanceTracker.logEvent("Scene - first repaint - layout complete");
                    AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            if (System.getProperty("sun.perflog.fx.firstpaintflush") != null) {
                                PerformanceTracker.outputLog();
                            }
                            return null;
                        }
                    });
                }
                this.firstPulse = false;
            }
            if (Scene.this.testPulseListener != null) {
                Scene.this.testPulseListener.run();
            }
        }
    }

    private static enum DirtyBits {
        FILL_DIRTY,
        ROOT_DIRTY,
        CAMERA_DIRTY;

        private int mask = 1 << this.ordinal();

        public final int getMask() {
            return this.mask;
        }
    }

    private static class TouchGesture {
        EventTarget target;
        Point2D sceneCoords;
        Point2D screenCoords;
        boolean finished;

        private TouchGesture() {
        }
    }
}

