/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.javafx.cursor.CursorFrame;
import com.sun.javafx.embed.AbstractEvents;
import com.sun.javafx.embed.EmbeddedSceneDragStartListenerInterface;
import com.sun.javafx.embed.EmbeddedSceneDropTargetInterface;
import com.sun.javafx.embed.EmbeddedSceneInterface;
import com.sun.javafx.embed.HostInterface;
import com.sun.javafx.scene.traversal.Direction;
import com.sun.javafx.sg.PGNode;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.tk.quantum.AbstractPainter;
import com.sun.javafx.tk.quantum.EmbeddedPainter;
import com.sun.javafx.tk.quantum.EmbeddedSceneDnD;
import com.sun.javafx.tk.quantum.GlassScene;
import com.sun.javafx.tk.quantum.PaintCollector;
import com.sun.javafx.tk.quantum.PaintRenderJob;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.render.ToolkitInterface;
import java.nio.IntBuffer;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javafx.application.Platform;
import javafx.event.EventType;
import javafx.scene.input.Dragboard;
import javafx.scene.input.InputEvent;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;

public class EmbeddedScene
extends GlassScene
implements EmbeddedSceneInterface {
    private AbstractPainter painter;
    private PaintRenderJob paintRenderJob;
    protected Lock sizeLock = new ReentrantLock();
    protected IntBuffer textureBits;
    protected HostInterface host;
    protected boolean needsReset = true;
    protected int width;
    protected int height;
    private final EmbeddedSceneDnD dndDelegate = new EmbeddedSceneDnD(this);

    public EmbeddedScene(HostInterface hostInterface) {
        this(hostInterface, false);
    }

    public EmbeddedScene(HostInterface hostInterface, boolean bl) {
        super(PrismSettings.verbose, bl);
        this.host = hostInterface;
        this.host.setEmbeddedScene(this);
        PaintCollector paintCollector = PaintCollector.getInstance();
        this.painter = new EmbeddedPainter(this);
        this.paintRenderJob = new PaintRenderJob(this, paintCollector.getRendered(), (Runnable)((Object)this.painter));
    }

    @Override
    protected boolean isSynchronous() {
        return false;
    }

    @Override
    public void setRoot(PGNode pGNode) {
        super.setRoot(pGNode);
        this.painter.setRoot((NGNode)pGNode);
    }

    @Override
    public void markDirty() {
        super.markDirty();
        this.host.repaint();
    }

    @Override
    public Dragboard createDragboard() {
        return this.dndDelegate.createDragboard();
    }

    @Override
    public void enableInputMethodEvents(boolean bl) {
        if (this.verbose) {
            System.err.println("EmbeddedScene.enableInputMethodEvents " + bl);
        }
    }

    @Override
    void stageVisible(boolean bl) {
        if (!bl) {
            this.host.setEmbeddedScene(null);
            this.host = null;
        }
        super.stageVisible(bl);
    }

    @Override
    public void repaint() {
        Toolkit toolkit = Toolkit.getToolkit();
        ToolkitInterface toolkitInterface = (ToolkitInterface)((Object)toolkit);
        toolkitInterface.addRenderJob(this.paintRenderJob);
    }

    @Override
    public boolean traverseOut(Direction direction) {
        if (direction == Direction.NEXT) {
            return this.host.traverseFocusOut(true);
        }
        if (direction == Direction.PREVIOUS) {
            return this.host.traverseFocusOut(false);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSize(final int n, final int n2) {
        this.sizeLock.lock();
        try {
            this.width = n;
            this.height = n2;
            this.needsReset = true;
        }
        finally {
            this.sizeLock.unlock();
        }
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                if (EmbeddedScene.this.sceneListener != null) {
                    EmbeddedScene.this.sceneListener.changedSize(n, n2);
                }
            }
        });
        this.entireSceneNeedsRepaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getPixels(IntBuffer intBuffer, int n, int n2) {
        this.sizeLock.lock();
        try {
            if (this.textureBits == null || this.needsReset || this.width != n || this.height != n2) {
                boolean bl = false;
                return bl;
            }
            intBuffer.rewind();
            this.textureBits.rewind();
            intBuffer.put(this.textureBits);
            boolean bl = true;
            return bl;
        }
        finally {
            this.sizeLock.unlock();
        }
    }

    @Override
    public void mouseEvent(final int n, final int n2, final boolean bl, final boolean bl2, final boolean bl3, final int n3, final int n4, final int n5, final int n6, final int n7, final boolean bl4, final boolean bl5, final boolean bl6, final boolean bl7, final int n8, final boolean bl8) {
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                if (EmbeddedScene.this.sceneListener != null) {
                    EventType<? extends InputEvent> eventType = AbstractEvents.mouseIDToFXEventID(n);
                    if (eventType == ScrollEvent.SCROLL) {
                        EmbeddedScene.this.sceneListener.scrollEvent(ScrollEvent.SCROLL, 0.0, -n8, 0.0, 0.0, 40.0, 40.0, 0, 0, 0, 0, 0, n4, n5, n6, n7, bl4, bl5, bl6, bl7, false, false);
                    } else {
                        MouseEvent mouseEvent = MouseEvent.impl_mouseEvent(n4, n5, n6, n7, AbstractEvents.mouseButtonToFXMouseButton(n2), n3, bl4, bl5, bl6, bl7, bl8, bl, bl2, bl3, false, eventType);
                        EmbeddedScene.this.sceneListener.mouseEvent(mouseEvent);
                    }
                }
            }
        });
    }

    @Override
    public void menuEvent(final int n, final int n2, final int n3, final int n4, final boolean bl) {
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                if (EmbeddedScene.this.sceneListener != null) {
                    EmbeddedScene.this.sceneListener.menuEvent(n, n2, n3, n4, bl);
                }
            }
        });
    }

    @Override
    public void keyEvent(final int n, final int n2, final char[] cArray, final int n3) {
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                if (EmbeddedScene.this.sceneListener != null) {
                    String string = n == 2 ? new String(cArray) : Character.toString((char)n2);
                    String string2 = new String(cArray);
                    boolean bl = (n3 & 1) != 0;
                    boolean bl2 = (n3 & 2) != 0;
                    boolean bl3 = (n3 & 4) != 0;
                    boolean bl4 = (n3 & 8) != 0;
                    KeyEvent keyEvent = KeyEvent.impl_keyEvent(null, string, string2, n2, bl, bl2, bl3, bl4, AbstractEvents.keyIDToFXEventType(n));
                    EmbeddedScene.this.sceneListener.keyEvent(keyEvent);
                }
            }
        });
    }

    @Override
    public void setCursor(Object object) {
        super.setCursor(object);
        this.host.setCursor((CursorFrame)object);
    }

    @Override
    public void setDragStartListener(EmbeddedSceneDragStartListenerInterface embeddedSceneDragStartListenerInterface) {
        this.dndDelegate.setDragStartListener(embeddedSceneDragStartListenerInterface);
    }

    @Override
    public EmbeddedSceneDropTargetInterface createDropTarget() {
        return this.dndDelegate.createDropTarget();
    }
}

