/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.mahalo;

import com.sun.jini.mahalo.JobException;
import com.sun.jini.mahalo.JobNotStartedException;
import com.sun.jini.mahalo.PartialResultException;
import com.sun.jini.mahalo.TxnManagerImpl;
import com.sun.jini.mahalo.UnknownTaskException;
import com.sun.jini.thread.TaskManager;
import com.sun.jini.thread.WakeupManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Job {
    private TaskManager pool;
    private WakeupManager wm;
    private int pending = -1;
    Object[] results;
    int[] attempts;
    private Map tasks = new HashMap();
    static final Logger logger = TxnManagerImpl.participantLogger;

    public Job(TaskManager taskManager, WakeupManager wakeupManager) {
        this.wm = wakeupManager;
        this.pool = taskManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean performWork(TaskManager.Task task, Object object) throws JobException {
        Integer n = null;
        Map map = this.tasks;
        synchronized (map) {
            n = (Integer)this.tasks.get(task);
        }
        if (n == null) {
            throw new UnknownTaskException();
        }
        int n2 = n;
        Object object2 = this.attempts;
        synchronized (this.attempts) {
            int n3 = n2;
            this.attempts[n3] = this.attempts[n3] + 1;
            // ** MonitorExit[var5_7 /* !! */ ] (shouldn't be in output)
            object2 = this.doWork(task, object);
            if (object2 == null) {
                return false;
            }
            try {
                this.reportDone(task, object2);
            }
            catch (UnknownTaskException unknownTaskException) {
            }
            catch (PartialResultException partialResultException) {
            }
            catch (JobException jobException) {
                // empty catch block
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int attempt(TaskManager.Task task) throws JobException {
        Integer n = null;
        Map map = this.tasks;
        synchronized (map) {
            n = (Integer)this.tasks.get(task);
        }
        if (n == null) {
            throw new UnknownTaskException();
        }
        int n2 = n;
        int[] nArray = this.attempts;
        synchronized (this.attempts) {
            // ** MonitorExit[var4_6] (shouldn't be in output)
            return this.attempts[n2];
        }
    }

    abstract Object doWork(TaskManager.Task var1, Object var2) throws JobException;

    abstract TaskManager.Task[] createTasks();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleTasks() {
        TaskManager.Task[] taskArray = this.createTasks();
        if (taskArray != null) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "Job:scheduleTasks with {0} tasks", new Integer(taskArray.length));
            }
            this.results = new Object[taskArray.length];
            this.attempts = new int[taskArray.length];
            this.setPending(taskArray.length);
            for (int i = 0; i < taskArray.length; ++i) {
                Map map = this.tasks;
                synchronized (map) {
                    this.tasks.put(taskArray[i], new Integer(i));
                    this.pool.add(taskArray[i]);
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, "Job:scheduleTasks added {0} to thread pool", taskArray[i]);
                    }
                    this.attempts[i] = 0;
                    continue;
                }
            }
        }
    }

    private synchronized void awaitPending(long l) {
        if (this.pending < 0) {
            return;
        }
        if (this.pending == 0) {
            return;
        }
        try {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "Job:awaitPending waiting for {0} items", new Integer(this.pending));
            }
            if (l == Long.MAX_VALUE) {
                while (this.pending > 0) {
                    this.wait();
                    if (!logger.isLoggable(Level.FINEST)) continue;
                    logger.log(Level.FINEST, "Job:awaitPending awoken");
                }
            } else {
                long l2;
                long l3 = l2 = System.currentTimeMillis();
                while (this.pending > 0 && l3 - l2 < l) {
                    this.wait(l - (l3 - l2));
                    l3 = System.currentTimeMillis();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private synchronized void setPending(int n) {
        this.pending = n;
        if (this.pending <= 0) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "Job:setPending notifying, pending = {0}", new Integer(this.pending));
            }
            this.notifyAll();
        }
    }

    private synchronized void decrementPending() {
        --this.pending;
        if (this.pending <= 0) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "Job:decrementPending notifying, pending = {0}", new Integer(this.pending));
            }
            this.notifyAll();
        }
    }

    protected TaskManager getPool() {
        return this.pool;
    }

    protected WakeupManager getMgr() {
        return this.wm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportDone(TaskManager.Task task, Object object) throws JobException {
        if (object == null) {
            throw new NullPointerException("param must be non-null");
        }
        if (task == null) {
            throw new NullPointerException("task must be non-null");
        }
        Integer n = null;
        Object[] objectArray = this.tasks;
        synchronized (this.tasks) {
            n = (Integer)this.tasks.get(task);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (n == null) {
                throw new UnknownTaskException();
            }
            objectArray = this.results;
            synchronized (this.results) {
                if (this.results[n] == null) {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, "Job:reportDone who = {0}, param = {1}", new Object[]{task, object});
                    }
                } else {
                    throw new PartialResultException("result already set");
                }
                this.results[n.intValue()] = object;
                this.decrementPending();
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCompleted(long l) throws JobException {
        this.awaitPending(l);
        Job job = this;
        synchronized (job) {
            if (this.pending == 0) {
                return true;
            }
            if (this.pending < 0) {
                throw new JobNotStartedException("No jobs started");
            }
            return false;
        }
    }

    abstract Object computeResult() throws JobException;

    public void stop() {
        Set set = this.tasks.keySet();
        Object[] objectArray = set.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            TaskManager.Task task = (TaskManager.Task)objectArray[i];
            this.pool.remove(task);
        }
        this.tasks = new HashMap();
        this.setPending(-1);
        this.results = null;
    }
}

