/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.parallel.util.concurrent;

import com.mathworks.toolbox.parallel.util.concurrent.Predicate;
import com.mathworks.toolbox.parallel.util.concurrent.ReentrantLock;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;

public final class SignalingAtomicBoolean {
    private final ReentrantLock fLock = new ReentrantLock();
    private final Condition fBecomeTrue = this.fLock.newPredicateCondition(new Predicate(){

        @Override
        public boolean test() {
            return SignalingAtomicBoolean.this.fValue;
        }
    });
    private final Condition fBecomeFalse = this.fLock.newPredicateCondition(new Predicate(){

        @Override
        public boolean test() {
            return !SignalingAtomicBoolean.this.fValue;
        }
    });
    private boolean fValue = false;

    public SignalingAtomicBoolean() {
    }

    public SignalingAtomicBoolean(boolean bl) {
        this.fValue = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean get() {
        this.fLock.lock();
        try {
            boolean bl = this.fValue;
            return bl;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compareAndSet(boolean bl, boolean bl2) {
        this.fLock.lock();
        try {
            boolean bl3;
            boolean bl4 = bl3 = this.fValue == bl;
            if (bl3) {
                this.set(bl2);
            }
            boolean bl5 = bl3;
            return bl5;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(boolean bl) {
        this.fLock.lock();
        try {
            if (this.fValue != bl) {
                this.fValue = bl;
                this.getCondition(bl).signalAll();
            }
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getAndSet(boolean bl) {
        this.fLock.lock();
        try {
            boolean bl2 = this.fValue;
            this.set(bl);
            boolean bl3 = bl2;
            return bl3;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitValue(boolean bl) throws InterruptedException {
        this.fLock.lock();
        try {
            this.getCondition(bl).await();
        }
        finally {
            this.fLock.unlock();
        }
    }

    public void awaitTrue() throws InterruptedException {
        this.awaitValue(true);
    }

    public void awaitFalse() throws InterruptedException {
        this.awaitValue(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean awaitValue(boolean bl, long l, TimeUnit timeUnit) throws InterruptedException {
        this.fLock.lock();
        try {
            boolean bl2 = this.getCondition(bl).await(l, timeUnit);
            return bl2;
        }
        finally {
            this.fLock.unlock();
        }
    }

    public boolean awaitTrue(long l, TimeUnit timeUnit) throws InterruptedException {
        return this.awaitValue(true, l, timeUnit);
    }

    public boolean awaitFalse(long l, TimeUnit timeUnit) throws InterruptedException {
        return this.awaitValue(false, l, timeUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        this.fLock.lock();
        try {
            String string = Boolean.toString(this.fValue);
            return string;
        }
        finally {
            this.fLock.unlock();
        }
    }

    private Condition getCondition(boolean bl) {
        if (bl) {
            return this.fBecomeTrue;
        }
        return this.fBecomeFalse;
    }
}

