/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.beans.editors;

import com.mathworks.beans.editors.FontPicker;
import com.mathworks.beans.editors.IntrospectableFont;
import com.mathworks.beans.editors.MWPropertyEditorSupport;
import java.awt.Component;
import java.awt.Font;
import java.awt.Image;
import javax.swing.ImageIcon;

public class FontEditor
extends MWPropertyEditorSupport {
    private static Image sIcon = null;
    private FontPicker fPicker;

    @Override
    public String getAsText() {
        String string = " ";
        IntrospectableFont introspectableFont = (IntrospectableFont)this.getIntrospectableValue();
        if (introspectableFont != null) {
            string = introspectableFont.getName();
            string = string + ", " + introspectableFont.getSize() + " point";
            if (introspectableFont.isBold()) {
                string = string + ", bold";
            }
            if (introspectableFont.isItalic()) {
                string = string + ", italic";
            }
        }
        return string;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        Font font;
        if (this.fPicker == null) {
            this.fPicker = new FontPicker(null, true);
        }
        if ((font = (Font)this.getValue()) == null) {
            font = new Font("Dialog", 0, 12);
        }
        this.fPicker.setSelectedFont(font);
        return this.fPicker;
    }

    @Override
    public Image getIcon() {
        if (sIcon == null) {
            sIcon = new ImageIcon(this.getClass().getResource("resources/FontIcon.gif")).getImage();
        }
        return sIcon;
    }

    @Override
    public boolean canExpand() {
        return true;
    }

    @Override
    public Object getIntrospectableValue() {
        IntrospectableFont introspectableFont = null;
        if (this.getValue() != null) {
            introspectableFont = new IntrospectableFont((Font)this.getValue());
        }
        return introspectableFont;
    }

    @Override
    public void setIntrospectableValue(Object object) {
        if (!(object instanceof IntrospectableFont)) {
            if (object instanceof String) {
                throw new IllegalArgumentException((String)object);
            }
            throw new IllegalArgumentException();
        }
        IntrospectableFont introspectableFont = (IntrospectableFont)object;
        this.setValue(introspectableFont.fontValue());
    }

    @Override
    public boolean canApply() {
        return true;
    }

    @Override
    public void apply() {
        Font font = this.fPicker != null ? this.fPicker.getSelectedFont() : null;
        this.setValue(font);
    }
}

